/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ManagedThreadPoolExecutor
extends ThreadPoolExecutor {
    private volatile boolean isStopped = true;
    private final ReentrantLock pauseLock = new ReentrantLock();
    private final Condition unpaused = this.pauseLock.newCondition();

    public ManagedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.pauseLock.lock();
        try {
            while (this.isStopped) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void start() {
        this.pauseLock.lock();
        try {
            this.isStopped = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void stop() {
        this.pauseLock.lock();
        try {
            this.isStopped = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public boolean isRunning() {
        return !this.isStopped;
    }
}

