/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;

public class LoggingPreconditions {
    private final Logger logger;

    public LoggingPreconditions(Logger logger) {
        this.logger = logger;
    }

    public void checkNotNull(Object o, String errorMessage, Object ... messageParams) {
        if (o == null) {
            this.logAndThrow(NullPointerException::new, errorMessage, messageParams);
        }
    }

    public void checkArgument(boolean expression, String errorMessage, Object ... messageParams) {
        if (!expression) {
            this.logAndThrow(IllegalArgumentException::new, errorMessage, messageParams);
        }
    }

    public void checkState(boolean expression, String errorMessage, Object ... messageParams) {
        if (!expression) {
            this.logAndThrow(IllegalStateException::new, errorMessage, messageParams);
        }
    }

    public <T> T wrapInUnchecked(Exception exception, BiFunction<String, Exception, RuntimeException> uncheckedWrapper, String errorMessage, Object ... messageParams) {
        this.logAndThrow(msg -> (RuntimeException)uncheckedWrapper.apply((String)msg, exception), errorMessage, messageParams);
        return null;
    }

    public void logAndThrow(Function<String, RuntimeException> exceptionCreator, String errorMessage, Object ... messageParams) {
        String msg = String.format(errorMessage, messageParams);
        this.logger.error(msg);
        throw exceptionCreator.apply(msg);
    }
}

