/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import com.google.common.eventbus.EventBus;
import com.google.inject.Binder;
import com.google.inject.Injector;
import id.onyx.obdp.server.events.listeners.alerts.AlertAggregateListener;
import id.onyx.obdp.server.events.listeners.alerts.AlertLifecycleListener;
import id.onyx.obdp.server.events.listeners.alerts.AlertMaintenanceModeListener;
import id.onyx.obdp.server.events.listeners.alerts.AlertReceivedListener;
import id.onyx.obdp.server.events.listeners.alerts.AlertServiceStateListener;
import id.onyx.obdp.server.events.listeners.alerts.AlertStateChangedListener;
import id.onyx.obdp.server.events.listeners.services.ServiceUpdateListener;
import id.onyx.obdp.server.events.listeners.upgrade.DistributeRepositoriesActionListener;
import id.onyx.obdp.server.events.listeners.upgrade.HostVersionOutOfSyncListener;
import id.onyx.obdp.server.events.listeners.upgrade.UpgradeUpdateListener;
import id.onyx.obdp.server.events.publishers.AlertEventPublisher;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import java.lang.reflect.Field;

public class EventBusSynchronizer {
    public static void synchronizeAmbariEventPublisher(Binder binder) {
        EventBus synchronizedBus = new EventBus();
        OBDPEventPublisher ambariEventPublisher = new OBDPEventPublisher();
        EventBusSynchronizer.replaceEventBus(OBDPEventPublisher.class, ambariEventPublisher, synchronizedBus);
        binder.bind(OBDPEventPublisher.class).toInstance((Object)ambariEventPublisher);
    }

    public static EventBus synchronizeAmbariEventPublisher(Injector injector) {
        EventBus synchronizedBus = new EventBus();
        OBDPEventPublisher publisher = (OBDPEventPublisher)injector.getInstance(OBDPEventPublisher.class);
        EventBusSynchronizer.replaceEventBus(OBDPEventPublisher.class, publisher, synchronizedBus);
        EventBusSynchronizer.registerAmbariListeners(injector, synchronizedBus);
        return synchronizedBus;
    }

    public static EventBus synchronizeAlertEventPublisher(Injector injector) {
        EventBus synchronizedBus = new EventBus();
        AlertEventPublisher publisher = (AlertEventPublisher)injector.getInstance(AlertEventPublisher.class);
        EventBusSynchronizer.replaceEventBus(AlertEventPublisher.class, publisher, synchronizedBus);
        EventBusSynchronizer.registerAlertListeners(injector, synchronizedBus);
        return synchronizedBus;
    }

    public static void synchronizeSTOMPUpdatePublisher(Injector injector) {
        EventBus agentEventBus = new EventBus();
        EventBus apiEventBus = new EventBus();
        STOMPUpdatePublisher publisher = (STOMPUpdatePublisher)injector.getInstance(STOMPUpdatePublisher.class);
        EventBusSynchronizer.replaceSTOMPEventBuses(STOMPUpdatePublisher.class, publisher, agentEventBus, apiEventBus);
        EventBusSynchronizer.registerSTOMPApiListeners(injector, apiEventBus);
    }

    private static void registerAmbariListeners(Injector injector, EventBus synchronizedBus) {
        synchronizedBus.register(injector.getInstance(AlertMaintenanceModeListener.class));
        synchronizedBus.register(injector.getInstance(AlertLifecycleListener.class));
        synchronizedBus.register(injector.getInstance(AlertServiceStateListener.class));
        synchronizedBus.register(injector.getInstance(DistributeRepositoriesActionListener.class));
        synchronizedBus.register(injector.getInstance(HostVersionOutOfSyncListener.class));
    }

    private static void registerAlertListeners(Injector injector, EventBus synchronizedBus) {
        synchronizedBus.register(injector.getInstance(AlertAggregateListener.class));
        synchronizedBus.register(injector.getInstance(AlertReceivedListener.class));
        synchronizedBus.register(injector.getInstance(AlertStateChangedListener.class));
    }

    private static void registerSTOMPApiListeners(Injector injector, EventBus synchronizedBus) {
        synchronizedBus.register(injector.getInstance(ServiceUpdateListener.class));
        synchronizedBus.register(injector.getInstance(UpgradeUpdateListener.class));
    }

    private static void replaceEventBus(Class<?> eventPublisherClass, Object instance, EventBus eventBus) {
        try {
            Field field = eventPublisherClass.getDeclaredField("m_eventBus");
            field.setAccessible(true);
            field.set(instance, eventBus);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void replaceSTOMPEventBuses(Class<?> eventPublisherClass, Object instance, EventBus agentEventBus, EventBus apiEventBus) {
        try {
            Field agentEventBusField = eventPublisherClass.getDeclaredField("agentEventBus");
            agentEventBusField.setAccessible(true);
            agentEventBusField.set(instance, agentEventBus);
            Field apiEventBusField = eventPublisherClass.getDeclaredField("apiEventBus");
            apiEventBusField.setAccessible(true);
            apiEventBusField.set(instance, apiEventBus);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

