/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    public static final String ALLOWED_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssz";

    public static String convertToReadableTime(Long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date(timestamp));
    }

    public static Long convertToTimestamp(String time, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Date date = dateFormat.parse(time);
            return date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date convertToDate(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(ALLOWED_DATE_FORMAT);
        return sdf.parse(date);
    }

    public static String convertDateToString(Date date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(ALLOWED_DATE_FORMAT);
        return sdf.format(date);
    }

    public static Long getDateDifferenceInMinutes(Date oldTime) {
        long diff = Math.abs(oldTime.getTime() - new Date().getTime());
        return diff / 60000L % 60L;
    }

    public static boolean isFutureTime(Date time) {
        Date now = new Date();
        return time.after(now);
    }

    public static Date getDateSpecifiedTimeAgo(String periodString) {
        String pattern = "((\\d+)([hdwmy]))";
        Pattern findPattern = Pattern.compile(pattern);
        Pattern matchPattern = Pattern.compile(pattern + "+");
        HashMap<String, Integer> qualifierToConstant = new HashMap<String, Integer>(){
            {
                this.put("h", 10);
                this.put("d", 5);
                this.put("w", 3);
                this.put("m", 2);
                this.put("y", 1);
            }
        };
        if (!matchPattern.matcher(periodString).matches()) {
            throw new IllegalArgumentException(String.format("Invalid string for indicating period %s", periodString));
        }
        Calendar calendar = Calendar.getInstance();
        Matcher m = findPattern.matcher(periodString);
        while (m.find()) {
            int amount = Integer.parseInt(m.group(2));
            int unit = (Integer)qualifierToConstant.get(m.group(3));
            calendar.add(unit, -amount);
        }
        return calendar.getTime();
    }
}

