/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog280
extends AbstractUpgradeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog280.class);
    private static final String REQUEST_SCHEDULE_TABLE_NAME = "requestschedule";
    protected static final String HOST_COMPONENT_STATE_TABLE = "hostcomponentstate";
    private static final String REQUEST_SCHEDULE_BATCH_TOLERATION_LIMIT_PER_BATCH_COLUMN_NAME = "batch_toleration_limit_per_batch";
    private static final String REQUEST_SCHEDULE_PAUSE_AFTER_FIRST_BATCH_COLUMN_NAME = "pause_after_first_batch";
    protected static final String LAST_LIVE_STATE_COLUMN = "last_live_state";
    private static final String UPGRADE_TABLE = "upgrade";
    private static final String UPGRADE_PACK_STACK_ID = "upgrade_pack_stack_id";
    protected static final String OBDP_CONFIGURATION_TABLE = "ambari_configuration";
    protected static final String OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN = "property_value";

    @Inject
    public UpgradeCatalog280(Injector injector) {
        super(injector);
    }

    @Override
    public String getSourceVersion() {
        return "2.7.2";
    }

    @Override
    public String getTargetVersion() {
        return "2.8.0";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
        this.removeLastValidState();
        this.addColumnsToRequestScheduleTable();
        this.addColumnsToUpgradeTable();
        this.modifyPropertyValueColumnInAmbariConfigurationTable();
    }

    private void modifyPropertyValueColumnInAmbariConfigurationTable() throws SQLException {
        this.dbAccessor.alterColumn(OBDP_CONFIGURATION_TABLE, new DBAccessor.DBColumnInfo(OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN, String.class, (Integer)4000, null, false));
        LOG.info("Altered {}.{} to NOT NULL and extended its length to 4000", (Object)OBDP_CONFIGURATION_TABLE, (Object)OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN);
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
    }

    protected void addColumnsToRequestScheduleTable() throws SQLException {
        this.dbAccessor.addColumn(REQUEST_SCHEDULE_TABLE_NAME, new DBAccessor.DBColumnInfo(REQUEST_SCHEDULE_BATCH_TOLERATION_LIMIT_PER_BATCH_COLUMN_NAME, Short.class, null, null, true));
        this.dbAccessor.addColumn(REQUEST_SCHEDULE_TABLE_NAME, new DBAccessor.DBColumnInfo(REQUEST_SCHEDULE_PAUSE_AFTER_FIRST_BATCH_COLUMN_NAME, Boolean.class, null, null, true));
    }

    protected void addColumnsToUpgradeTable() throws SQLException {
        this.dbAccessor.addColumn(UPGRADE_TABLE, new DBAccessor.DBColumnInfo(UPGRADE_PACK_STACK_ID, String.class, (Integer)255, (Object)"", false));
    }

    protected void removeLastValidState() throws SQLException {
        this.dbAccessor.dropColumn(HOST_COMPONENT_STATE_TABLE, LAST_LIVE_STATE_COLUMN);
    }
}

