/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog276
extends AbstractUpgradeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog276.class);

    @Inject
    public UpgradeCatalog276(Injector injector) {
        super(injector);
    }

    @Override
    public String getSourceVersion() {
        return "2.7.5";
    }

    @Override
    public String getTargetVersion() {
        return "2.7.6";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
        LOG.debug("UpgradeCatalog276 executing DML Updates.");
        this.fixNativeLibrariesPathsForMR2AndTez();
    }

    protected void fixNativeLibrariesPathsForMR2AndTez() throws OBDPException {
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null) {
            String oldNativePath = "/usr/hdp/${hdp.version}/hadoop/lib/native:/usr/hdp/${hdp.version}/hadoop/lib/native/Linux-{{architecture}}-64";
            String fixedNativePath = "/usr/hdp/current/hadoop-client/lib/native:/usr/hdp/current/hadoop-client/lib/native/Linux-{{architecture}}-64";
            Map<String, Cluster> clusterMap = clusters.getClusters();
            if (clusterMap != null && !clusterMap.isEmpty()) {
                for (Cluster cluster : clusterMap.values()) {
                    Set<String> installedServices = cluster.getServices().keySet();
                    if (installedServices.contains("TEZ")) {
                        this.updateConfigGroupNativePaths("tez-site", new HashSet<String>(Arrays.asList("tez.am.launch.env", "tez.task.launch.env")), oldNativePath, fixedNativePath, cluster);
                    }
                    if (!installedServices.contains("MAPREDUCE2")) continue;
                    this.updateConfigGroupNativePaths("mapred-site", new HashSet<String>(Arrays.asList("mapreduce.admin.user.env")), oldNativePath, fixedNativePath, cluster);
                }
            }
        }
    }

    private void updateConfigGroupNativePaths(String configGroupName, Set<String> configsToChange, String replaceFrom, String replaceTo, Cluster cluster) throws OBDPException {
        Config targetConfig = cluster.getDesiredConfigByType(configGroupName);
        if (targetConfig != null) {
            HashMap<String, String> newProperty = new HashMap<String, String>();
            for (String configName : configsToChange) {
                String configValue = targetConfig.getProperties().get(configName);
                if (configValue == null || !configValue.contains(replaceFrom)) continue;
                String newConfigValue = configValue.replace(replaceFrom, replaceTo);
                LOG.info("Native path will be updated for '{}' property of '{}' config type, from '{}' to '{}'", new Object[]{configName, configGroupName, configValue, newConfigValue});
                newProperty.put(configName, newConfigValue);
            }
            if (!newProperty.isEmpty()) {
                this.updateConfigurationPropertiesForCluster(cluster, configGroupName, newProperty, true, false);
            }
        }
    }
}

