/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.dao.BlueprintDAO;
import id.onyx.obdp.server.orm.entities.BlueprintConfigEntity;
import id.onyx.obdp.server.orm.entities.BlueprintEntity;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog275
extends AbstractUpgradeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog275.class);
    static final Gson GSON = new Gson();

    @Inject
    public UpgradeCatalog275(Injector injector) {
        super(injector);
    }

    @Override
    public String getSourceVersion() {
        return "2.7.4";
    }

    @Override
    public String getTargetVersion() {
        return "2.7.5";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
        LOG.debug("UpgradeCatalog275 executing Pre-DML Updates.");
        this.removeDfsHAInitial();
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
        LOG.debug("UpgradeCatalog275 executing DML Updates.");
        this.addNewConfigurationsFromXml();
    }

    protected void removeDfsHAInitial() {
        BlueprintDAO blueprintDAO = (BlueprintDAO)this.injector.getInstance(BlueprintDAO.class);
        List<BlueprintEntity> blueprintEntityList = blueprintDAO.findAll();
        ArrayList<BlueprintEntity> changedBlueprints = new ArrayList<BlueprintEntity>();
        for (BlueprintEntity blueprintEntity : blueprintEntityList) {
            boolean changed = false;
            Collection<BlueprintConfigEntity> blueprintConfigurations = blueprintEntity.getConfigurations();
            for (BlueprintConfigEntity blueprintConfigEntity : blueprintConfigurations) {
                if (!blueprintConfigEntity.getType().equals("hadoop-env")) continue;
                String configData = blueprintConfigEntity.getConfigData();
                Map typeProperties = (Map)GSON.fromJson(configData, Map.class);
                typeProperties.remove("dfs_ha_initial_namenode_standby");
                typeProperties.remove("dfs_ha_initial_namenode_active");
                blueprintConfigEntity.setConfigData(GSON.toJson((Object)typeProperties));
                changed = true;
            }
            if (!changed) continue;
            changedBlueprints.add(blueprintEntity);
        }
        for (BlueprintEntity blueprintEntity : changedBlueprints) {
            blueprintDAO.merge(blueprintEntity);
        }
    }
}

