/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.entities.OBDPConfigurationEntity;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import jakarta.persistence.Table;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog274
extends AbstractUpgradeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog274.class);
    static final String OBDP_CONFIGURATION_TABLE = OBDPConfigurationEntity.class.getAnnotation(Table.class).name();
    static final String OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN = "property_value";
    static final Integer OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN_LEN = 4000;

    @Inject
    public UpgradeCatalog274(Injector injector) {
        super(injector);
    }

    @Override
    public String getSourceVersion() {
        return "2.7.2";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
        this.upgradeConfigurationTableValueMaxSize();
    }

    @Override
    public String getTargetVersion() {
        return "2.7.4";
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
    }

    private void upgradeConfigurationTableValueMaxSize() throws SQLException {
        DBAccessor.DBColumnInfo propertyColumn = this.dbAccessor.getColumnInfo(OBDP_CONFIGURATION_TABLE, OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN);
        if (propertyColumn != null && propertyColumn.getType() != null && propertyColumn.getLength() < OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN_LEN) {
            LOG.info("Updating column max size to {} for {}.{}", new Object[]{OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN_LEN, OBDP_CONFIGURATION_TABLE, OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN});
            propertyColumn.setLength(OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN_LEN);
            this.dbAccessor.alterColumn(OBDP_CONFIGURATION_TABLE, propertyColumn);
        }
    }
}

