/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.BlueprintProvisioningState;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import java.sql.SQLException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog272
extends AbstractUpgradeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog272.class);
    private static final String LDAP_CONFIGURATION_WRONG_COLLISION_BEHAVIOR_PROPERTY_NAME = "ambari.ldap.advance.collision_behavior";
    private static final String LDAP_CONFIGURATION_CORRECT_COLLISION_BEHAVIOR_PROPERTY_NAME = "ambari.ldap.advanced.collision_behavior";
    static final String RENAME_COLLISION_BEHAVIOR_PROPERTY_SQL = String.format("UPDATE %s SET %s = '%s' WHERE %s = '%s' AND %s = '%s'", "ambari_configuration", "property_name", "ambari.ldap.advanced.collision_behavior", "category_name", OBDPServerConfigurationCategory.LDAP_CONFIGURATION.getCategoryName(), "property_name", "ambari.ldap.advance.collision_behavior");
    protected static final String HOST_COMPONENT_DESIRED_STATE_TABLE = "hostcomponentdesiredstate";
    protected static final String CLUSTERS_TABLE = "clusters";
    protected static final String BLUEPRINT_PROVISIONING_STATE_COLUMN = "blueprint_provisioning_state";

    @Inject
    public UpgradeCatalog272(Injector injector) {
        super(injector);
    }

    @Override
    public String getSourceVersion() {
        return "2.7.1";
    }

    @Override
    public String getTargetVersion() {
        return "2.7.2";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
        this.moveBlueprintProvisioningState();
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
        this.renameLdapSynchCollisionBehaviorValue();
        this.createRoleAuthorizations();
    }

    protected int renameLdapSynchCollisionBehaviorValue() throws SQLException {
        int numberOfRecordsRenamed = 0;
        if (this.dbAccessor.tableExists("ambari_configuration")) {
            LOG.debug("Executing: {}", (Object)RENAME_COLLISION_BEHAVIOR_PROPERTY_SQL);
            numberOfRecordsRenamed = this.dbAccessor.executeUpdate(RENAME_COLLISION_BEHAVIOR_PROPERTY_SQL);
            LOG.info("Renamed {} {} with incorrect LDAP configuration property name", (Object)numberOfRecordsRenamed, (Object)(1 >= numberOfRecordsRenamed ? "record" : "records"));
        } else {
            LOG.info("{} table does not exists; nothing to update", (Object)"ambari_configuration");
        }
        return numberOfRecordsRenamed;
    }

    protected void createRoleAuthorizations() throws SQLException {
        this.addRoleAuthorization(RoleAuthorization.OBDP_VIEW_STATUS_INFO.getId(), "View status information", Collections.singleton("OBDP.ADMINISTRATOR:OBDP"));
        LOG.info("Added new role authorization {}", (Object)RoleAuthorization.OBDP_VIEW_STATUS_INFO.getId());
        this.addRoleAuthorization(RoleAuthorization.CLUSTER_MANAGE_WIDGETS.getId(), "Manage widgets", Sets.newHashSet((Object[])new String[]{"OBDP.ADMINISTRATOR:OBDP", "CLUSTER.ADMINISTRATOR:CLUSTER", "CLUSTER.OPERATOR:CLUSTER"}));
        LOG.info("Added new role authorization {}", (Object)RoleAuthorization.CLUSTER_MANAGE_WIDGETS.getId());
    }

    protected void moveBlueprintProvisioningState() throws SQLException {
        this.dbAccessor.dropColumn(CLUSTERS_TABLE, BLUEPRINT_PROVISIONING_STATE_COLUMN);
        this.dbAccessor.addColumn(HOST_COMPONENT_DESIRED_STATE_TABLE, new DBAccessor.DBColumnInfo(BLUEPRINT_PROVISIONING_STATE_COLUMN, String.class, (Integer)255, (Object)BlueprintProvisioningState.NONE, true));
    }
}

