/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ServiceComponentNotFoundException;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ConfigGroupEntity;
import id.onyx.obdp.server.orm.entities.UpgradeHistoryEntity;
import id.onyx.obdp.server.state.BlueprintProvisioningState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog271
extends AbstractUpgradeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog271.class);
    private static final String SOLR_NEW_LOG4J2_XML = "<Configuration>\n  <Appenders>\n\n    <Console name=\"STDOUT\" target=\"SYSTEM_OUT\">\n      <PatternLayout>\n        <Pattern>\n          %d{ISO8601} [%t] %-5p [%X{collection} %X{shard} %X{replica} %X{core}] %C (%F:%L) - %m%n\n        </Pattern>\n      </PatternLayout>\n    </Console>\n\n    <RollingFile\n        name=\"RollingFile\"\n        fileName=\"{{infra_solr_log_dir}}/solr.log\"\n        filePattern=\"{{infra_solr_log_dir}}/solr.log.%i\" >\n      <PatternLayout>\n        <Pattern>\n          %d{ISO8601} [%t] %-5p [%X{collection} %X{shard} %X{replica} %X{core}] %C (%F:%L) - %m%n\n        </Pattern>\n      </PatternLayout>\n      <Policies>\n        <OnStartupTriggeringPolicy />\n        <SizeBasedTriggeringPolicy size=\"{{infra_log_maxfilesize}} MB\"/>\n      </Policies>\n      <DefaultRolloverStrategy max=\"{{infra_log_maxbackupindex}}\"/>\n    </RollingFile>\n\n    <RollingFile\n        name=\"SlowFile\"\n        fileName=\"{{infra_solr_log_dir}}/solr_slow_requests.log\"\n        filePattern=\"{{infra_solr_log_dir}}/solr_slow_requests.log.%i\" >\n      <PatternLayout>\n        <Pattern>\n          %d{ISO8601} [%t] %-5p [%X{collection} %X{shard} %X{replica} %X{core}] %C (%F:%L) - %m%n\n        </Pattern>\n      </PatternLayout>\n      <Policies>\n        <OnStartupTriggeringPolicy />\n        <SizeBasedTriggeringPolicy size=\"{{infra_log_maxfilesize}} MB\"/>\n      </Policies>\n      <DefaultRolloverStrategy max=\"{{infra_log_maxbackupindex}}\"/>\n    </RollingFile>\n\n  </Appenders>\n  <Loggers>\n    <Logger name=\"org.apache.hadoop\" level=\"warn\"/>\n    <Logger name=\"org.apache.solr.update.LoggingInfoStream\" level=\"off\"/>\n    <Logger name=\"org.apache.zookeeper\" level=\"warn\"/>\n    <Logger name=\"org.apache.solr.core.SolrCore.SlowRequest\" level=\"warn\" additivity=\"false\">\n      <AppenderRef ref=\"SlowFile\"/>\n    </Logger>\n\n    <Root level=\"warn\">\n      <AppenderRef ref=\"RollingFile\"/>\n      <!-- <AppenderRef ref=\"STDOUT\"/> -->\n    </Root>\n  </Loggers>\n</Configuration>";
    private static final String SERVICE_CONFIG_MAPPING_TABLE = "serviceconfigmapping";
    private static final String CLUSTER_CONFIG_TABLE = "clusterconfig";
    protected static final String CLUSTERS_TABLE = "clusters";
    protected static final String CLUSTERS_BLUEPRINT_PROVISIONING_STATE_COLUMN = "blueprint_provisioning_state";
    @Inject
    DaoUtils daoUtils;

    @Inject
    public UpgradeCatalog271(Injector injector) {
        super(injector);
        this.daoUtils = (DaoUtils)injector.getInstance(DaoUtils.class);
    }

    @Override
    public String getTargetVersion() {
        return "2.7.1";
    }

    @Override
    public String getSourceVersion() {
        return "2.7.0";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
        this.addBlueprintProvisioningState();
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
        this.addNewConfigurationsFromXml();
        this.updateRangerLogDirConfigs();
        this.updateRangerKmsDbUrl();
        this.renameAmbariInfraService();
        this.removeLogSearchPatternConfigs();
        this.updateSolrConfigurations();
        this.updateTimelineReaderAddress();
    }

    protected void updateRangerLogDirConfigs() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = clusters.getClusters()) != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                Set<String> installedServices = cluster.getServices().keySet();
                if (!installedServices.contains("RANGER")) continue;
                Config rangerEnvConfig = cluster.getDesiredConfigByType("ranger-env");
                Config rangerAdminSiteConfig = cluster.getDesiredConfigByType("ranger-admin-site");
                Config rangerUgsyncSiteConfig = cluster.getDesiredConfigByType("ranger-ugsync-site");
                if (rangerEnvConfig == null) continue;
                String rangerAdminLogDir = rangerEnvConfig.getProperties().get("ranger_admin_log_dir");
                String rangerUsersyncLogDir = rangerEnvConfig.getProperties().get("ranger_usersync_log_dir");
                if (rangerAdminLogDir != null && rangerAdminSiteConfig != null) {
                    HashMap<String, String> newProperty = new HashMap<String, String>();
                    newProperty.put("ranger.logs.base.dir", rangerAdminLogDir);
                    this.updateConfigurationPropertiesForCluster(cluster, "ranger-admin-site", newProperty, true, false);
                }
                if (rangerUsersyncLogDir != null && rangerUgsyncSiteConfig != null && rangerUgsyncSiteConfig.getProperties().containsKey("ranger.usersync.logdir")) {
                    HashMap<String, String> updateProperty = new HashMap<String, String>();
                    updateProperty.put("ranger.usersync.logdir", rangerUsersyncLogDir);
                    this.updateConfigurationPropertiesForCluster(cluster, "ranger-ugsync-site", updateProperty, true, false);
                }
                HashSet removeProperties = Sets.newHashSet((Object[])new String[]{"ranger_admin_log_dir", "ranger_usersync_log_dir"});
                this.removeConfigurationPropertiesFromCluster(cluster, "ranger-env", removeProperties);
            }
        }
    }

    protected void updateRangerKmsDbUrl() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = clusters.getClusters()) != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                Pattern pattern;
                Matcher matcher;
                String rangerKmsDbUrl;
                Set<String> installedServices = cluster.getServices().keySet();
                if (!installedServices.contains("RANGER_KMS")) continue;
                Config rangerKmsPropertiesConfig = cluster.getDesiredConfigByType("kms-properties");
                Config rangerKmsEnvConfig = cluster.getDesiredConfigByType("kms-env");
                Config rangerKmsDbksConfig = cluster.getDesiredConfigByType("dbks-site");
                if (rangerKmsPropertiesConfig == null) continue;
                String dbFlavor = rangerKmsPropertiesConfig.getProperties().get("DB_FLAVOR");
                String dbHost = rangerKmsPropertiesConfig.getProperties().get("db_host");
                Object rangerKmsRootDbUrl = "";
                if (dbFlavor == null || dbHost == null) continue;
                String port = "";
                if (rangerKmsDbksConfig != null && (rangerKmsDbUrl = rangerKmsDbksConfig.getProperties().get("ranger.ks.jpa.jdbc.url")) != null && (matcher = (pattern = Pattern.compile("(:[0-9]+)")).matcher(rangerKmsDbUrl)).find()) {
                    port = matcher.group();
                }
                if ("MYSQL".equalsIgnoreCase(dbFlavor)) {
                    rangerKmsRootDbUrl = "jdbc:mysql://" + dbHost + (!port.equalsIgnoreCase("") ? port : ":3306");
                } else if ("ORACLE".equalsIgnoreCase(dbFlavor)) {
                    rangerKmsRootDbUrl = "jdbc:oracle:thin:@//" + dbHost + (!port.equalsIgnoreCase("") ? port : ":1521");
                } else if ("POSTGRES".equalsIgnoreCase(dbFlavor)) {
                    rangerKmsRootDbUrl = "jdbc:postgresql://" + dbHost + (!port.equalsIgnoreCase("") ? port : ":5432") + "/postgres";
                } else if ("MSSQL".equalsIgnoreCase(dbFlavor)) {
                    rangerKmsRootDbUrl = "jdbc:sqlserver://" + dbHost + (!port.equalsIgnoreCase("") ? port : ":1433");
                } else if ("SQLA".equalsIgnoreCase(dbFlavor)) {
                    rangerKmsRootDbUrl = "jdbc:sqlanywhere:host=" + dbHost + (!port.equalsIgnoreCase("") ? port : ":2638") + ";";
                }
                HashMap<String, String> newProperty = new HashMap<String, String>();
                newProperty.put("ranger_kms_privelege_user_jdbc_url", (String)rangerKmsRootDbUrl);
                if (rangerKmsEnvConfig == null) continue;
                this.updateConfigurationPropertiesForCluster(cluster, "kms-env", newProperty, true, false);
            }
        }
    }

    protected void updateTimelineReaderAddress() throws OBDPException {
        Clusters clusters = ((OBDPManagementController)this.injector.getInstance(OBDPManagementController.class)).getClusters();
        if (clusters == null || clusters.getClusters() == null) {
            return;
        }
        for (Cluster cluster : clusters.getClusters().values()) {
            Set<String> installedServices = cluster.getServices().keySet();
            if (!installedServices.contains("YARN") || !cluster.getService("YARN").getServiceComponents().keySet().contains("TIMELINE_READER")) continue;
            String timelineReaderHost = this.hostNameOf(cluster, "YARN", "TIMELINE_READER").orElse("localhost");
            this.updateProperty(cluster, "yarn-site", "yarn.timeline-service.reader.webapp.address", timelineReaderHost + ":8198");
            this.updateProperty(cluster, "yarn-site", "yarn.timeline-service.reader.webapp.https.address", timelineReaderHost + ":8199");
        }
    }

    private void updateProperty(Cluster cluster, String configType, String propertyName, String newValue) throws OBDPException {
        Config config = cluster.getDesiredConfigByType(configType);
        if (config == null) {
            return;
        }
        String oldValue = config.getProperties().get(propertyName);
        if (oldValue != null) {
            HashMap<String, String> newProperty = new HashMap<String, String>();
            newProperty.put(propertyName, newValue);
            this.updateConfigurationPropertiesForCluster(cluster, configType, newProperty, true, false);
        }
    }

    private Optional<String> hostNameOf(Cluster cluster, String serviceName, String componentName) throws OBDPException {
        try {
            ServiceComponent component = cluster.getService(serviceName).getServiceComponent(componentName);
            Set<String> hosts = component.getServiceComponentHosts().keySet();
            return hosts.isEmpty() ? Optional.empty() : Optional.of(hosts.iterator().next());
        }
        catch (ServiceComponentNotFoundException | ServiceNotFoundException e) {
            return Optional.empty();
        }
    }

    protected void renameAmbariInfraService() {
        LOG.info("Renaming service AMBARI_INFRA to AMBARI_INFRA_SOLR in config group records");
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters == null) {
            return;
        }
        Map<String, Cluster> clusterMap = clusters.getClusters();
        if (MapUtils.isEmpty(clusterMap)) {
            return;
        }
        EntityManager entityManager = (EntityManager)this.getEntityManagerProvider().get();
        this.executeInTransaction(() -> {
            TypedQuery serviceConfigUpdate = entityManager.createQuery("UPDATE ConfigGroupEntity SET serviceName = :newServiceName WHERE serviceName = :oldServiceName", ConfigGroupEntity.class);
            serviceConfigUpdate.setParameter("newServiceName", (Object)"AMBARI_INFRA_SOLR");
            serviceConfigUpdate.setParameter("oldServiceName", (Object)"AMBARI_INFRA");
            serviceConfigUpdate.executeUpdate();
        });
        this.executeInTransaction(() -> {
            TypedQuery serviceConfigUpdate = entityManager.createQuery("UPDATE ConfigGroupEntity SET tag = :newServiceName WHERE tag = :oldServiceName", ConfigGroupEntity.class);
            serviceConfigUpdate.setParameter("newServiceName", (Object)"AMBARI_INFRA_SOLR");
            serviceConfigUpdate.setParameter("oldServiceName", (Object)"AMBARI_INFRA");
            serviceConfigUpdate.executeUpdate();
        });
        this.executeInTransaction(() -> {
            TypedQuery upgradeHistoryUpdate = entityManager.createQuery("UPDATE UpgradeHistoryEntity SET serviceName = :newServiceName WHERE serviceName = :oldServiceName", UpgradeHistoryEntity.class);
            upgradeHistoryUpdate.setParameter("newServiceName", (Object)"AMBARI_INFRA_SOLR");
            upgradeHistoryUpdate.setParameter("oldServiceName", (Object)"AMBARI_INFRA");
            upgradeHistoryUpdate.executeUpdate();
        });
        entityManager.getEntityManagerFactory().getCache().evictAll();
        clusters.invalidateAllClusters();
    }

    protected void removeLogSearchPatternConfigs() throws SQLException {
        DBAccessor dba = this.dbAccessor != null ? this.dbAccessor : (DBAccessor)this.injector.getInstance(DBAccessor.class);
        String configSuffix = "-logsearch-conf";
        String serviceConfigMappingRemoveSQL = String.format("DELETE FROM %s WHERE config_id IN (SELECT config_id from %s where type_name like '%%%s')", SERVICE_CONFIG_MAPPING_TABLE, CLUSTER_CONFIG_TABLE, configSuffix);
        String clusterConfigRemoveSQL = String.format("DELETE FROM %s WHERE type_name like '%%%s'", CLUSTER_CONFIG_TABLE, configSuffix);
        dba.executeQuery(serviceConfigMappingRemoveSQL);
        dba.executeQuery(clusterConfigRemoveSQL);
    }

    protected void addBlueprintProvisioningState() throws SQLException {
        this.dbAccessor.addColumn(CLUSTERS_TABLE, new DBAccessor.DBColumnInfo(CLUSTERS_BLUEPRINT_PROVISIONING_STATE_COLUMN, String.class, (Integer)255, (Object)BlueprintProvisioningState.NONE, true));
    }

    protected void updateSolrConfigurations() throws OBDPException {
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters == null) {
            return;
        }
        Map<String, Cluster> clusterMap = clusters.getClusters();
        if (clusterMap == null || clusterMap.isEmpty()) {
            return;
        }
        for (Cluster cluster : clusterMap.values()) {
            this.updateConfig(cluster, "logsearch-service_logs-solrconfig", content -> this.updateLuceneMatchVersion((String)content, "7.4.0"));
            this.updateConfig(cluster, "logsearch-audit_logs-solrconfig", content -> this.updateLuceneMatchVersion((String)content, "7.4.0"));
            this.updateConfig(cluster, "infra-solr-log4j", content -> SOLR_NEW_LOG4J2_XML);
        }
    }

    private void updateConfig(Cluster cluster, String configType, Function<String, String> contentUpdater) throws OBDPException {
        Config config = cluster.getDesiredConfigByType(configType);
        if (config == null) {
            return;
        }
        if (config.getProperties() == null || !config.getProperties().containsKey("content")) {
            return;
        }
        String content = config.getProperties().get("content");
        content = contentUpdater.apply(content);
        this.updateConfigurationPropertiesForCluster(cluster, configType, Collections.singletonMap("content", content), true, true);
    }

    private String updateLuceneMatchVersion(String content, String newLuceneMatchVersion) {
        return content.replaceAll("<luceneMatchVersion>.*</luceneMatchVersion>", "<luceneMatchVersion>" + newLuceneMatchVersion + "</luceneMatchVersion>");
    }
}

