/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.collections.PredicateUtils;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.dao.ArtifactDAO;
import id.onyx.obdp.server.orm.dao.ClusterServiceDAO;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.HostComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.dao.HostComponentStateDAO;
import id.onyx.obdp.server.orm.dao.OBDPConfigurationDAO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.dao.ServiceComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.dao.ServiceDesiredStateDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.orm.entities.ArtifactEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntityPK;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.orm.entities.ServiceDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.serveraction.kerberos.PrepareKerberosIdentitiesServerAction;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosConfigurationDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog270
extends AbstractUpgradeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog270.class);
    protected static final String STAGE_TABLE = "stage";
    protected static final String STAGE_STATUS_COLUMN = "status";
    protected static final String STAGE_DISPLAY_STATUS_COLUMN = "display_status";
    protected static final String REQUEST_TABLE = "request";
    protected static final String REQUEST_DISPLAY_STATUS_COLUMN = "display_status";
    protected static final String REQUEST_USER_NAME_COLUMN = "user_name";
    protected static final String HOST_ROLE_COMMAND_TABLE = "host_role_command";
    protected static final String HRC_OPS_DISPLAY_NAME_COLUMN = "ops_display_name";
    protected static final String COMPONENT_DESIRED_STATE_TABLE = "hostcomponentdesiredstate";
    protected static final String COMPONENT_STATE_TABLE = "hostcomponentstate";
    protected static final String COMPONENT_LAST_STATE_COLUMN = "last_live_state";
    protected static final String SERVICE_DESIRED_STATE_TABLE = "servicedesiredstate";
    protected static final String SECURITY_STATE_COLUMN = "security_state";
    protected static final String AMBARI_SEQUENCES_TABLE = "ambari_sequences";
    protected static final String AMBARI_SEQUENCES_SEQUENCE_NAME_COLUMN = "sequence_name";
    protected static final String AMBARI_SEQUENCES_SEQUENCE_VALUE_COLUMN = "sequence_value";
    protected static final String OBDP_CONFIGURATION_TABLE = "ambari_configuration";
    protected static final String OBDP_CONFIGURATION_CATEGORY_NAME_COLUMN = "category_name";
    protected static final String OBDP_CONFIGURATION_PROPERTY_NAME_COLUMN = "property_name";
    protected static final String OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN = "property_value";
    protected static final String USER_AUTHENTICATION_TABLE = "user_authentication";
    protected static final String USER_AUTHENTICATION_USER_AUTHENTICATION_ID_COLUMN = "user_authentication_id";
    protected static final String USER_AUTHENTICATION_USER_ID_COLUMN = "user_id";
    protected static final String USER_AUTHENTICATION_AUTHENTICATION_TYPE_COLUMN = "authentication_type";
    protected static final String USER_AUTHENTICATION_AUTHENTICATION_KEY_COLUMN = "authentication_key";
    protected static final String USER_AUTHENTICATION_CREATE_TIME_COLUMN = "create_time";
    protected static final String USER_AUTHENTICATION_UPDATE_TIME_COLUMN = "update_time";
    protected static final String USER_AUTHENTICATION_PRIMARY_KEY = "PK_user_authentication";
    protected static final String USER_AUTHENTICATION_USER_AUTHENTICATION_USER_ID_INDEX = "IDX_user_authentication_user_id";
    protected static final String USER_AUTHENTICATION_USER_AUTHENTICATION_USERS_FOREIGN_KEY = "FK_user_authentication_users";
    protected static final String USERS_TABLE = "users";
    protected static final String USERS_USER_ID_COLUMN = "user_id";
    protected static final String USERS_PRINCIPAL_ID_COLUMN = "principal_id";
    protected static final String USERS_USER_TYPE_COLUMN = "user_type";
    protected static final String USERS_USER_PASSWORD_COLUMN = "user_password";
    protected static final String USERS_CREATE_TIME_COLUMN = "create_time";
    protected static final String USERS_LDAP_USER_COLUMN = "ldap_user";
    protected static final String USERS_CONSECUTIVE_FAILURES_COLUMN = "consecutive_failures";
    protected static final String USERS_USER_NAME_COLUMN = "user_name";
    protected static final String USERS_DISPLAY_NAME_COLUMN = "display_name";
    protected static final String USERS_LOCAL_USERNAME_COLUMN = "local_username";
    protected static final String USERS_VERSION_COLUMN = "version";
    protected static final String UNIQUE_USERS_0_INDEX = "UNQ_users_0";
    protected static final String MEMBERS_TABLE = "members";
    protected static final String MEMBERS_MEMBER_ID_COLUMN = "member_id";
    protected static final String MEMBERS_GROUP_ID_COLUMN = "group_id";
    protected static final String MEMBERS_USER_ID_COLUMN = "user_id";
    protected static final String ADMINPRIVILEGE_TABLE = "adminprivilege";
    protected static final String ADMINPRIVILEGE_PRIVILEGE_ID_COLUMN = "privilege_id";
    protected static final String ADMINPRIVILEGE_PERMISSION_ID_COLUMN = "permission_id";
    protected static final String ADMINPRIVILEGE_RESOURCE_ID_COLUMN = "resource_id";
    protected static final String ADMINPRIVILEGE_PRINCIPAL_ID_COLUMN = "principal_id";
    protected static final String KERBEROS_KEYTAB_TABLE = "kerberos_keytab";
    protected static final String KERBEROS_KEYTAB_PRINCIPAL_TABLE = "kerberos_keytab_principal";
    protected static final String KKP_MAPPING_SERVICE_TABLE = "kkp_mapping_service";
    protected static final String KEYTAB_PATH_FIELD = "keytab_path";
    protected static final String OWNER_NAME_FIELD = "owner_name";
    protected static final String OWNER_ACCESS_FIELD = "owner_access";
    protected static final String GROUP_NAME_FIELD = "group_name";
    protected static final String GROUP_ACCESS_FIELD = "group_access";
    protected static final String IS_AMBARI_KEYTAB_FIELD = "is_ambari_keytab";
    protected static final String WRITE_AMBARI_JAAS_FIELD = "write_ambari_jaas";
    protected static final String PK_KERBEROS_KEYTAB = "PK_kerberos_keytab";
    protected static final String KKP_ID_COLUMN = "kkp_id";
    protected static final String PRINCIPAL_NAME_COLUMN = "principal_name";
    protected static final String IS_DISTRIBUTED_COLUMN = "is_distributed";
    protected static final String PK_KKP = "PK_kkp";
    protected static final String UNI_KKP = "UNI_kkp";
    protected static final String SERVICE_NAME_COLUMN = "service_name";
    protected static final String COMPONENT_NAME_COLUMN = "component_name";
    protected static final String PK_KKP_MAPPING_SERVICE = "PK_kkp_mapping_service";
    protected static final String FK_KKP_KEYTAB_PATH = "FK_kkp_keytab_path";
    protected static final String FK_KKP_HOST_ID = "FK_kkp_host_id";
    protected static final String FK_KKP_PRINCIPAL_NAME = "FK_kkp_principal_name";
    protected static final String HOSTS_TABLE = "hosts";
    protected static final String KERBEROS_PRINCIPAL_TABLE = "kerberos_principal";
    protected static final String FK_KKP_SERVICE_PRINCIPAL = "FK_kkp_service_principal";
    protected static final String KKP_ID_SEQ_NAME = "kkp_id_seq";
    protected static final String KERBEROS_PRINCIPAL_HOST_TABLE = "kerberos_principal_host";
    protected static final String HOST_ID_COLUMN = "host_id";
    protected static final String REPO_OS_TABLE = "repo_os";
    protected static final String REPO_OS_ID_COLUMN = "id";
    protected static final String REPO_OS_REPO_VERSION_ID_COLUMN = "repo_version_id";
    protected static final String REPO_OS_FAMILY_COLUMN = "family";
    protected static final String REPO_OS_AMBARI_MANAGED_COLUMN = "ambari_managed";
    protected static final String REPO_OS_PRIMARY_KEY = "PK_repo_os_id";
    protected static final String REPO_OS_FOREIGN_KEY = "FK_repo_os_id_repo_version_id";
    protected static final String REPO_DEFINITION_TABLE = "repo_definition";
    protected static final String REPO_DEFINITION_ID_COLUMN = "id";
    protected static final String REPO_DEFINITION_REPO_OS_ID_COLUMN = "repo_os_id";
    protected static final String REPO_DEFINITION_REPO_NAME_COLUMN = "repo_name";
    protected static final String REPO_DEFINITION_REPO_ID_COLUMN = "repo_id";
    protected static final String REPO_DEFINITION_BASE_URL_COLUMN = "base_url";
    protected static final String REPO_DEFINITION_DISTRIBUTION_COLUMN = "distribution";
    protected static final String REPO_DEFINITION_COMPONENTS_COLUMN = "components";
    protected static final String REPO_DEFINITION_UNIQUE_REPO_COLUMN = "unique_repo";
    protected static final String REPO_DEFINITION_MIRRORS_COLUMN = "mirrors";
    protected static final String REPO_DEFINITION_PRIMARY_KEY = "PK_repo_definition_id";
    protected static final String REPO_DEFINITION_FOREIGN_KEY = "FK_repo_definition_repo_os_id";
    protected static final String REPO_TAGS_TABLE = "repo_tags";
    protected static final String REPO_TAGS_REPO_DEFINITION_ID_COLUMN = "repo_definition_id";
    protected static final String REPO_TAGS_TAG_COLUMN = "tag";
    protected static final String REPO_TAGS_FOREIGN_KEY = "FK_repo_tag_definition_id";
    protected static final String REPO_APPLICABLE_SERVICES_TABLE = "repo_applicable_services";
    protected static final String REPO_APPLICABLE_SERVICES_REPO_DEFINITION_ID_COLUMN = "repo_definition_id";
    protected static final String REPO_APPLICABLE_SERVICES_SERVICE_NAME_COLUMN = "service_name";
    protected static final String REPO_APPLICABLE_SERVICES_FOREIGN_KEY = "FK_repo_app_service_def_id";
    protected static final String REPO_VERSION_TABLE = "repo_version";
    protected static final String REPO_VERSION_REPO_VERSION_ID_COLUMN = "repo_version_id";
    protected static final String REPO_VERSION_REPOSITORIES_COLUMN = "repositories";
    protected static final String WIDGET_TABLE = "widget";
    protected static final String WIDGET_TAG_COLUMN = "tag";
    protected static final String SERVICE_COMPONENT_DESIRED_STATE_TABLE = "servicecomponentdesiredstate";
    protected static final String HIVE_SERVICE_COMPONENT_WEBHCAT_SERVER = "WEBHCAT_SERVER";
    protected static final String CONFIGURATION_CORE_SITE = "core-site";
    protected static final String CONFIGURATION_WEBHCAT_SITE = "webhcat-site";
    protected static final String PROPERTY_HADOOP_PROXYUSER_HTTP_HOSTS = "hadoop.proxyuser.HTTP.hosts";
    protected static final String PROPERTY_TEMPLETON_HIVE_PROPERTIES = "templeton.hive.properties";
    public static final String AMBARI_INFRA_OLD_NAME = "AMBARI_INFRA";
    public static final String AMBARI_INFRA_NEW_NAME = "AMBARI_INFRA_SOLR";
    public static final String SERVICE_CONFIG_MAPPING_TABLE = "serviceconfigmapping";
    public static final String CLUSTER_CONFIG_TABLE = "clusterconfig";
    public static final String FK_HOSTCOMPONENTDESIREDSTATE_COMPONENT_NAME = "fk_hostcomponentdesiredstate_component_name";
    public static final String FK_HOSTCOMPONENTSTATE_COMPONENT_NAME = "fk_hostcomponentstate_component_name";
    public static final String FK_SERVICECOMPONENTDESIREDSTATE_SERVICE_NAME = "fk_servicecomponentdesiredstate_service_name";
    static final String YARN_SERVICE = "YARN";
    @Inject
    DaoUtils daoUtils;

    @Inject
    public UpgradeCatalog270(Injector injector) {
        super(injector);
        this.daoUtils = (DaoUtils)injector.getInstance(DaoUtils.class);
    }

    @Override
    public String getTargetVersion() {
        return "2.7.0";
    }

    @Override
    public String getSourceVersion() {
        return "2.6.2";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
        this.dropBrokenFKs();
        this.updateStageTable();
        this.updateRequestTable();
        this.addOpsDisplayNameColumnToHostRoleCommand();
        this.removeSecurityState();
        this.addAmbariConfigurationTable();
        this.addHostComponentLastStateTable();
        this.upgradeUserTables();
        this.upgradeKerberosTables();
        this.upgradeRepoTables();
        this.upgradeWidgetTable();
    }

    protected void upgradeUserTables() throws SQLException {
        this.convertUserCreationTimeToLong();
        this.createUserAuthenticationTable();
        this.updateGroupMembershipRecords();
        this.updateAdminPrivilegeRecords();
        this.updateUsersTable();
    }

    protected void upgradeRepoTables() throws SQLException {
        this.createRepoOsTable();
        this.createRepoDefinitionTable();
        this.createRepoTagsTable();
        this.createRepoApplicableServicesTable();
        this.migrateRepoData();
        this.updateRepoVersionTable();
    }

    private void createRepoOsTable() throws SQLException {
        ArrayList<DBAccessor.DBColumnInfo> columns = new ArrayList<DBAccessor.DBColumnInfo>();
        columns.add(new DBAccessor.DBColumnInfo("id", Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo("repo_version_id", Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo(REPO_OS_FAMILY_COLUMN, String.class, (Integer)255, null, false));
        columns.add(new DBAccessor.DBColumnInfo(REPO_OS_AMBARI_MANAGED_COLUMN, Integer.class, null, (Object)1, true));
        this.dbAccessor.createTable(REPO_OS_TABLE, columns, new String[0]);
        this.dbAccessor.addPKConstraint(REPO_OS_TABLE, REPO_OS_PRIMARY_KEY, "id");
        this.dbAccessor.addFKConstraint(REPO_OS_TABLE, REPO_OS_FOREIGN_KEY, "repo_version_id", REPO_VERSION_TABLE, "repo_version_id", false);
    }

    private void createRepoDefinitionTable() throws SQLException {
        ArrayList<DBAccessor.DBColumnInfo> columns = new ArrayList<DBAccessor.DBColumnInfo>();
        columns.add(new DBAccessor.DBColumnInfo("id", Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo(REPO_DEFINITION_REPO_OS_ID_COLUMN, Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo(REPO_DEFINITION_REPO_NAME_COLUMN, String.class, (Integer)255, null, false));
        columns.add(new DBAccessor.DBColumnInfo(REPO_DEFINITION_REPO_ID_COLUMN, String.class, (Integer)255, null, false));
        columns.add(new DBAccessor.DBColumnInfo(REPO_DEFINITION_BASE_URL_COLUMN, String.class, (Integer)2048, null, true));
        columns.add(new DBAccessor.DBColumnInfo(REPO_DEFINITION_DISTRIBUTION_COLUMN, String.class, (Integer)2048, null, true));
        columns.add(new DBAccessor.DBColumnInfo(REPO_DEFINITION_COMPONENTS_COLUMN, String.class, (Integer)2048, null, true));
        columns.add(new DBAccessor.DBColumnInfo(REPO_DEFINITION_UNIQUE_REPO_COLUMN, Integer.class, (Integer)1, (Object)1, true));
        columns.add(new DBAccessor.DBColumnInfo(REPO_DEFINITION_MIRRORS_COLUMN, String.class, (Integer)2048, null, true));
        this.dbAccessor.createTable(REPO_DEFINITION_TABLE, columns, new String[0]);
        this.dbAccessor.addPKConstraint(REPO_DEFINITION_TABLE, REPO_DEFINITION_PRIMARY_KEY, "id");
        this.dbAccessor.addFKConstraint(REPO_DEFINITION_TABLE, REPO_DEFINITION_FOREIGN_KEY, REPO_DEFINITION_REPO_OS_ID_COLUMN, REPO_OS_TABLE, "id", false);
    }

    private void createRepoTagsTable() throws SQLException {
        ArrayList<DBAccessor.DBColumnInfo> columns = new ArrayList<DBAccessor.DBColumnInfo>();
        columns.add(new DBAccessor.DBColumnInfo("repo_definition_id", Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo("tag", String.class, (Integer)255, null, false));
        this.dbAccessor.createTable(REPO_TAGS_TABLE, columns, new String[0]);
        this.dbAccessor.addFKConstraint(REPO_TAGS_TABLE, REPO_TAGS_FOREIGN_KEY, "repo_definition_id", REPO_DEFINITION_TABLE, "id", false);
    }

    private void createRepoApplicableServicesTable() throws SQLException {
        ArrayList<DBAccessor.DBColumnInfo> columns = new ArrayList<DBAccessor.DBColumnInfo>();
        columns.add(new DBAccessor.DBColumnInfo("repo_definition_id", Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo("service_name", String.class, (Integer)255, null, false));
        this.dbAccessor.createTable(REPO_APPLICABLE_SERVICES_TABLE, columns, new String[0]);
        this.dbAccessor.addFKConstraint(REPO_APPLICABLE_SERVICES_TABLE, REPO_APPLICABLE_SERVICES_FOREIGN_KEY, "repo_definition_id", REPO_DEFINITION_TABLE, "id", false);
    }

    private void migrateRepoData() throws SQLException {
        if (this.dbAccessor.tableHasColumn(REPO_VERSION_TABLE, REPO_VERSION_REPOSITORIES_COLUMN)) {
            int repoOsId = 0;
            int repoDefinitionId = 0;
            Map<Long, String> repoVersionData = this.dbAccessor.getKeyToStringColumnMap(REPO_VERSION_TABLE, "repo_version_id", REPO_VERSION_REPOSITORIES_COLUMN, null, null, true);
            if (repoVersionData != null) {
                for (Map.Entry<Long, String> entry : repoVersionData.entrySet()) {
                    JsonArray rootJson;
                    Long repoVersionId = entry.getKey();
                    String repositoriesJson = entry.getValue();
                    if (StringUtils.isEmpty((String)repositoriesJson) || (rootJson = new JsonParser().parse(repositoriesJson).getAsJsonArray()) == null) continue;
                    for (JsonElement rootElement : rootJson) {
                        JsonObject rootObject = rootElement.getAsJsonObject();
                        if (rootObject == null) continue;
                        JsonPrimitive osType = rootObject.getAsJsonPrimitive("OperatingSystems/os_type");
                        JsonPrimitive ambariManaged = rootObject.getAsJsonPrimitive("OperatingSystems/ambari_managed_repositories");
                        String isAmbariManaged = ambariManaged == null ? "1" : (ambariManaged.getAsBoolean() ? "1" : "0");
                        JsonArray repositories = rootObject.getAsJsonArray(REPO_VERSION_REPOSITORIES_COLUMN);
                        this.dbAccessor.insertRowIfMissing(REPO_OS_TABLE, new String[]{"id", "repo_version_id", REPO_OS_AMBARI_MANAGED_COLUMN, REPO_OS_FAMILY_COLUMN}, new String[]{String.valueOf(++repoOsId), String.valueOf(repoVersionId), isAmbariManaged, this.getFormattedJSONPrimitiveString(osType)}, false);
                        if (repositories == null) continue;
                        for (JsonElement repositoryElement : repositories) {
                            JsonObject repositoryObject = repositoryElement.getAsJsonObject();
                            if (repositoryObject == null) continue;
                            JsonPrimitive repoId = repositoryObject.getAsJsonPrimitive("Repositories/repo_id");
                            JsonPrimitive repoName = repositoryObject.getAsJsonPrimitive("Repositories/repo_name");
                            JsonPrimitive baseUrl = repositoryObject.getAsJsonPrimitive("Repositories/base_url");
                            JsonArray tags = repositoryObject.getAsJsonArray("Repositories/tags");
                            this.dbAccessor.insertRowIfMissing(REPO_DEFINITION_TABLE, new String[]{"id", REPO_DEFINITION_REPO_OS_ID_COLUMN, REPO_DEFINITION_REPO_NAME_COLUMN, REPO_DEFINITION_REPO_ID_COLUMN, REPO_DEFINITION_BASE_URL_COLUMN}, new String[]{String.valueOf(++repoDefinitionId), String.valueOf(repoOsId), this.getFormattedJSONPrimitiveString(repoName), this.getFormattedJSONPrimitiveString(repoId), this.getFormattedJSONPrimitiveString(baseUrl)}, false);
                            if (tags == null) continue;
                            for (JsonElement tagsElement : tags) {
                                JsonPrimitive tag = tagsElement.getAsJsonPrimitive();
                                if (tag == null) continue;
                                this.dbAccessor.insertRowIfMissing(REPO_TAGS_TABLE, new String[]{"repo_definition_id", "tag"}, new String[]{String.valueOf(repoDefinitionId), this.getFormattedJSONPrimitiveString(tag)}, false);
                            }
                        }
                    }
                }
            }
            this.dbAccessor.insertRowIfMissing(AMBARI_SEQUENCES_TABLE, new String[]{AMBARI_SEQUENCES_SEQUENCE_NAME_COLUMN, AMBARI_SEQUENCES_SEQUENCE_VALUE_COLUMN}, new String[]{"'repo_os_id_seq'", String.valueOf(++repoOsId)}, false);
            this.dbAccessor.insertRowIfMissing(AMBARI_SEQUENCES_TABLE, new String[]{AMBARI_SEQUENCES_SEQUENCE_NAME_COLUMN, AMBARI_SEQUENCES_SEQUENCE_VALUE_COLUMN}, new String[]{"'repo_definition_id_seq'", String.valueOf(++repoDefinitionId)}, false);
        }
    }

    private String getFormattedJSONPrimitiveString(JsonPrimitive jsonValue) {
        return jsonValue == null ? null : String.format("'%s'", jsonValue.getAsString());
    }

    private void updateRepoVersionTable() throws SQLException {
        this.dbAccessor.dropColumn(REPO_VERSION_TABLE, REPO_VERSION_REPOSITORIES_COLUMN);
    }

    private void convertUserCreationTimeToLong() throws SQLException {
        if (!this.isUserCreationTimeMigrated()) {
            LOG.info("Converting user creation times...");
            String temporaryColumnName = "create_time_numeric";
            if (!this.dbAccessor.tableHasColumn(USERS_TABLE, "create_time_numeric")) {
                DBAccessor.DBColumnInfo tempColumnInfo = new DBAccessor.DBColumnInfo("create_time_numeric", Long.class);
                this.dbAccessor.addColumn(USERS_TABLE, tempColumnInfo);
            }
            if (this.dbAccessor.tableHasColumn(USERS_TABLE, "create_time")) {
                Map<Integer, Timestamp> currentUserCreateTimes = this.fetchCurrentUserCreateTimesNotYetMigrated("create_time_numeric");
                for (Map.Entry<Integer, Timestamp> currentUserCreateTime : currentUserCreateTimes.entrySet()) {
                    this.dbAccessor.updateTable(USERS_TABLE, "create_time_numeric", currentUserCreateTime.getValue().getTime(), "WHERE user_id=" + currentUserCreateTime.getKey());
                }
                this.dbAccessor.dropColumn(USERS_TABLE, "create_time");
            }
            DBAccessor.DBColumnInfo usersCreateTimeColumnInfo = new DBAccessor.DBColumnInfo("create_time", Long.class, null, null, false);
            this.dbAccessor.renameColumn(USERS_TABLE, "create_time_numeric", usersCreateTimeColumnInfo);
            LOG.info("Converted user creation times");
        } else {
            LOG.info("Already converted user creation timestamps to EPOCH representation");
        }
    }

    private boolean isUserCreationTimeMigrated() throws SQLException {
        int columnType = this.dbAccessor.getColumnType(USERS_TABLE, "create_time");
        LOG.info("users.create_time's type = " + columnType);
        return columnType != 91 && columnType != 93;
    }

    private Map<Integer, Timestamp> fetchCurrentUserCreateTimesNotYetMigrated(String temporaryColumnName) throws SQLException {
        HashMap<Integer, Timestamp> currentUserCreateTimes = new HashMap<Integer, Timestamp>();
        try (PreparedStatement pstmt = this.dbAccessor.getConnection().prepareStatement("SELECT user_id, create_time FROM users WHERE " + temporaryColumnName + " IS NULL ORDER BY user_id");
             ResultSet rs = pstmt.executeQuery();){
            while (rs.next()) {
                currentUserCreateTimes.put(rs.getInt(1), rs.getTimestamp(2) == null ? new Timestamp(System.currentTimeMillis()) : rs.getTimestamp(2));
            }
        }
        return currentUserCreateTimes;
    }

    private void createUserAuthenticationTable() throws SQLException {
        if (!this.usersTableUpgraded()) {
            String temporaryTable = "user_authentication_tmp";
            ArrayList<DBAccessor.DBColumnInfo> columns = new ArrayList<DBAccessor.DBColumnInfo>();
            columns.add(new DBAccessor.DBColumnInfo(USER_AUTHENTICATION_USER_AUTHENTICATION_ID_COLUMN, Long.class, null, null, false));
            columns.add(new DBAccessor.DBColumnInfo("user_id", Integer.class, null, null, false));
            columns.add(new DBAccessor.DBColumnInfo(USER_AUTHENTICATION_AUTHENTICATION_TYPE_COLUMN, String.class, (Integer)50, null, false));
            columns.add(new DBAccessor.DBColumnInfo(USER_AUTHENTICATION_AUTHENTICATION_KEY_COLUMN, String.class, (Integer)2048, null, true));
            columns.add(new DBAccessor.DBColumnInfo("create_time", Long.class, null, null, true));
            columns.add(new DBAccessor.DBColumnInfo(USER_AUTHENTICATION_UPDATE_TIME_COLUMN, Long.class, null, null, true));
            this.dbAccessor.dropTable("user_authentication_tmp");
            this.dbAccessor.createTable("user_authentication_tmp", columns, new String[0]);
            this.dbAccessor.executeUpdate("insert into user_authentication_tmp(user_authentication_id, user_id, authentication_type, authentication_key, create_time, update_time) select distinct  u.user_id,  t.min_user_id,  u.user_type,  u.user_password,  u.create_time,  u.create_time from users u inner join   (select     lower(user_name) as user_name,     min(user_id) as min_user_id    from users    group by lower(user_name)) t on (lower(u.user_name) = lower(t.user_name))");
            this.dbAccessor.executeUpdate("update user_authentication_tmp set authentication_key=null where authentication_type!='" + UserAuthenticationType.LOCAL.name() + "'");
            this.dbAccessor.createTable(USER_AUTHENTICATION_TABLE, columns, new String[0]);
            this.dbAccessor.addPKConstraint(USER_AUTHENTICATION_TABLE, USER_AUTHENTICATION_PRIMARY_KEY, USER_AUTHENTICATION_USER_AUTHENTICATION_ID_COLUMN);
            this.dbAccessor.addFKConstraint(USER_AUTHENTICATION_TABLE, USER_AUTHENTICATION_USER_AUTHENTICATION_USERS_FOREIGN_KEY, "user_id", USERS_TABLE, "user_id", false);
            this.dbAccessor.executeUpdate("insert into user_authentication(user_authentication_id, user_id, authentication_type, authentication_key, create_time, update_time) select user_authentication_id, user_id, authentication_type, authentication_key, create_time, update_time from user_authentication_tmp");
            this.dbAccessor.dropTable("user_authentication_tmp");
        }
    }

    private boolean usersTableUpgraded() {
        try {
            this.dbAccessor.getColumnType(USERS_TABLE, USERS_USER_TYPE_COLUMN);
            return false;
        }
        catch (SQLException e) {
            return true;
        }
    }

    private void updateUsersTable() throws SQLException {
        this.dbAccessor.executeUpdate("delete from users where user_id not in (select user_id from user_authentication)");
        this.dbAccessor.dropUniqueConstraint(USERS_TABLE, UNIQUE_USERS_0_INDEX);
        this.dbAccessor.dropColumn(USERS_TABLE, USERS_USER_TYPE_COLUMN);
        this.dbAccessor.dropColumn(USERS_TABLE, USERS_LDAP_USER_COLUMN);
        this.dbAccessor.dropColumn(USERS_TABLE, USERS_USER_PASSWORD_COLUMN);
        this.dbAccessor.addColumn(USERS_TABLE, new DBAccessor.DBColumnInfo(USERS_CONSECUTIVE_FAILURES_COLUMN, Integer.class, null, (Object)0, false));
        this.dbAccessor.addColumn(USERS_TABLE, new DBAccessor.DBColumnInfo(USERS_DISPLAY_NAME_COLUMN, String.class, (Integer)255, null, true));
        this.dbAccessor.addColumn(USERS_TABLE, new DBAccessor.DBColumnInfo(USERS_LOCAL_USERNAME_COLUMN, String.class, (Integer)255, null, true));
        this.dbAccessor.addColumn(USERS_TABLE, new DBAccessor.DBColumnInfo(USERS_VERSION_COLUMN, Long.class, null, (Object)0, false));
        this.dbAccessor.executeUpdate("update users set display_name=user_name, local_username= lower(user_name), user_name= lower(user_name)");
        this.dbAccessor.alterColumn(USERS_TABLE, new DBAccessor.DBColumnInfo(USERS_DISPLAY_NAME_COLUMN, String.class, (Integer)255, null, false));
        this.dbAccessor.alterColumn(USERS_TABLE, new DBAccessor.DBColumnInfo(USERS_LOCAL_USERNAME_COLUMN, String.class, (Integer)255, null, false));
        this.dbAccessor.addUniqueConstraint(USERS_TABLE, UNIQUE_USERS_0_INDEX, "user_name");
    }

    private void updateGroupMembershipRecords() throws SQLException {
        String temporaryTable = "members_tmp";
        this.dbAccessor.dropTable("members_tmp");
        ArrayList<DBAccessor.DBColumnInfo> columns = new ArrayList<DBAccessor.DBColumnInfo>();
        columns.add(new DBAccessor.DBColumnInfo(MEMBERS_MEMBER_ID_COLUMN, Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo("user_id", Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo(MEMBERS_GROUP_ID_COLUMN, Long.class, null, null, false));
        this.dbAccessor.createTable("members_tmp", columns, new String[0]);
        this.dbAccessor.executeUpdate("insert into members_tmp (member_id, user_id, group_id)  select    m.member_id,    u.min_user_id,    m.group_id  from members m inner join    (      select        iu.user_name,        iu.user_id,        t.min_user_id      from users iu inner join        (          select           lower(user_name) as user_name,            min(user_id) as min_user_id          from users          group by lower(user_name)        ) t on (lower(t.user_name) = lower(iu.user_name))    ) u on (m.user_id = u.user_id)");
        this.dbAccessor.truncateTable(MEMBERS_TABLE);
        this.dbAccessor.executeUpdate("insert into members (member_id, user_id, group_id)  select     min(member_id),    user_id,    group_id  from members_tmp  group by user_id, group_id");
        this.dbAccessor.dropTable("members_tmp");
    }

    private void updateAdminPrivilegeRecords() throws SQLException {
        String temporaryTable = "adminprivilege_tmp";
        this.dbAccessor.dropTable("adminprivilege_tmp");
        ArrayList<DBAccessor.DBColumnInfo> columns = new ArrayList<DBAccessor.DBColumnInfo>();
        columns.add(new DBAccessor.DBColumnInfo(ADMINPRIVILEGE_PRIVILEGE_ID_COLUMN, Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo(ADMINPRIVILEGE_PERMISSION_ID_COLUMN, Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo(ADMINPRIVILEGE_RESOURCE_ID_COLUMN, Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo("principal_id", Long.class, null, null, false));
        this.dbAccessor.createTable("adminprivilege_tmp", columns, new String[0]);
        this.dbAccessor.executeUpdate("insert into adminprivilege_tmp (privilege_id, permission_id, resource_id, principal_id)  select    ap.privilege_id,    ap.permission_id,    ap.resource_id,    ap.principal_id  from adminprivilege ap  where ap.principal_id not in        (          select principal_id          from users        )  union  select    ap.privilege_id,    ap.permission_id,    ap.resource_id,    t.new_principal_id  from adminprivilege ap inner join    (      select        u.user_id,        u.user_name,        u.principal_id as new_principal_id,        t1.principal_id as orig_principal_id      from users u inner join        (          select            u1.user_name,            u1.principal_id,            t2.min_user_id          from users u1 inner join            (              select                lower(user_name) as user_name,                min(user_id) as min_user_id              from users              group by lower(user_name)            ) t2 on (lower(u1.user_name) = lower(t2.user_name))        ) t1 on (u.user_id = t1.min_user_id)    ) t on (ap.principal_id = t.orig_principal_id)");
        this.dbAccessor.truncateTable(ADMINPRIVILEGE_TABLE);
        this.dbAccessor.executeUpdate("insert into adminprivilege (privilege_id, permission_id, resource_id, principal_id)  select     min(privilege_id),    permission_id,    resource_id,    principal_id  from adminprivilege_tmp  group by permission_id, resource_id, principal_id");
        this.dbAccessor.dropTable("adminprivilege_tmp");
    }

    private void dropBrokenFKs() throws SQLException {
        this.dbAccessor.dropFKConstraint(COMPONENT_DESIRED_STATE_TABLE, FK_HOSTCOMPONENTDESIREDSTATE_COMPONENT_NAME);
        this.dbAccessor.dropFKConstraint(COMPONENT_STATE_TABLE, FK_HOSTCOMPONENTSTATE_COMPONENT_NAME);
        this.dbAccessor.dropFKConstraint(SERVICE_COMPONENT_DESIRED_STATE_TABLE, FK_SERVICECOMPONENTDESIREDSTATE_SERVICE_NAME);
    }

    protected void updateStageTable() throws SQLException {
        this.dbAccessor.addColumn(STAGE_TABLE, new DBAccessor.DBColumnInfo(STAGE_STATUS_COLUMN, String.class, (Integer)255, (Object)HostRoleStatus.PENDING, false));
        this.dbAccessor.addColumn(STAGE_TABLE, new DBAccessor.DBColumnInfo("display_status", String.class, (Integer)255, (Object)HostRoleStatus.PENDING, false));
        this.dbAccessor.addColumn(REQUEST_TABLE, new DBAccessor.DBColumnInfo("display_status", String.class, (Integer)255, (Object)HostRoleStatus.PENDING, false));
    }

    protected void updateRequestTable() throws SQLException {
        this.dbAccessor.addColumn(REQUEST_TABLE, new DBAccessor.DBColumnInfo("user_name", String.class, (Integer)255));
    }

    protected void upgradeWidgetTable() throws SQLException {
        this.dbAccessor.addColumn(WIDGET_TABLE, new DBAccessor.DBColumnInfo("tag", String.class, (Integer)255));
    }

    protected void addAmbariConfigurationTable() throws SQLException {
        ArrayList<DBAccessor.DBColumnInfo> columns = new ArrayList<DBAccessor.DBColumnInfo>();
        columns.add(new DBAccessor.DBColumnInfo(OBDP_CONFIGURATION_CATEGORY_NAME_COLUMN, String.class, (Integer)100, null, false));
        columns.add(new DBAccessor.DBColumnInfo(OBDP_CONFIGURATION_PROPERTY_NAME_COLUMN, String.class, (Integer)100, null, false));
        columns.add(new DBAccessor.DBColumnInfo(OBDP_CONFIGURATION_PROPERTY_VALUE_COLUMN, String.class, (Integer)2048, null, true));
        this.dbAccessor.createTable(OBDP_CONFIGURATION_TABLE, columns, new String[0]);
        this.dbAccessor.addPKConstraint(OBDP_CONFIGURATION_TABLE, "PK_ambari_configuration", OBDP_CONFIGURATION_CATEGORY_NAME_COLUMN, OBDP_CONFIGURATION_PROPERTY_NAME_COLUMN);
    }

    protected void addHostComponentLastStateTable() throws SQLException {
        this.dbAccessor.addColumn(COMPONENT_STATE_TABLE, new DBAccessor.DBColumnInfo(COMPONENT_LAST_STATE_COLUMN, String.class, (Integer)255, (Object)State.UNKNOWN, true));
    }

    protected void upgradeKerberosTables() throws SQLException {
        ArrayList<DBAccessor.DBColumnInfo> kerberosKeytabColumns = new ArrayList<DBAccessor.DBColumnInfo>();
        kerberosKeytabColumns.add(new DBAccessor.DBColumnInfo(KEYTAB_PATH_FIELD, String.class, (Integer)255, null, false));
        kerberosKeytabColumns.add(new DBAccessor.DBColumnInfo(OWNER_NAME_FIELD, String.class, (Integer)255, null, true));
        kerberosKeytabColumns.add(new DBAccessor.DBColumnInfo(OWNER_ACCESS_FIELD, String.class, (Integer)255, null, true));
        kerberosKeytabColumns.add(new DBAccessor.DBColumnInfo(GROUP_NAME_FIELD, String.class, (Integer)255, null, true));
        kerberosKeytabColumns.add(new DBAccessor.DBColumnInfo(GROUP_ACCESS_FIELD, String.class, (Integer)255, null, true));
        kerberosKeytabColumns.add(new DBAccessor.DBColumnInfo(IS_AMBARI_KEYTAB_FIELD, Integer.class, null, (Object)0, false));
        kerberosKeytabColumns.add(new DBAccessor.DBColumnInfo(WRITE_AMBARI_JAAS_FIELD, Integer.class, null, (Object)0, false));
        this.dbAccessor.createTable(KERBEROS_KEYTAB_TABLE, kerberosKeytabColumns, new String[0]);
        this.dbAccessor.addPKConstraint(KERBEROS_KEYTAB_TABLE, PK_KERBEROS_KEYTAB, KEYTAB_PATH_FIELD);
        ArrayList<DBAccessor.DBColumnInfo> kkpColumns = new ArrayList<DBAccessor.DBColumnInfo>();
        kkpColumns.add(new DBAccessor.DBColumnInfo(KKP_ID_COLUMN, Long.class, null, (Object)0L, false));
        kkpColumns.add(new DBAccessor.DBColumnInfo(KEYTAB_PATH_FIELD, String.class, (Integer)255, null, false));
        kkpColumns.add(new DBAccessor.DBColumnInfo(PRINCIPAL_NAME_COLUMN, String.class, (Integer)255, null, false));
        kkpColumns.add(new DBAccessor.DBColumnInfo(HOST_ID_COLUMN, Long.class, null, null, true));
        kkpColumns.add(new DBAccessor.DBColumnInfo(IS_DISTRIBUTED_COLUMN, Integer.class, null, (Object)0, false));
        this.dbAccessor.createTable(KERBEROS_KEYTAB_PRINCIPAL_TABLE, kkpColumns, new String[0]);
        this.dbAccessor.addPKConstraint(KERBEROS_KEYTAB_PRINCIPAL_TABLE, PK_KKP, KKP_ID_COLUMN);
        this.dbAccessor.addUniqueConstraint(KERBEROS_KEYTAB_PRINCIPAL_TABLE, UNI_KKP, KEYTAB_PATH_FIELD, PRINCIPAL_NAME_COLUMN, HOST_ID_COLUMN);
        ArrayList<DBAccessor.DBColumnInfo> kkpMappingColumns = new ArrayList<DBAccessor.DBColumnInfo>();
        kkpMappingColumns.add(new DBAccessor.DBColumnInfo(KKP_ID_COLUMN, Long.class, null, (Object)0L, false));
        kkpMappingColumns.add(new DBAccessor.DBColumnInfo("service_name", String.class, (Integer)255, null, false));
        kkpMappingColumns.add(new DBAccessor.DBColumnInfo(COMPONENT_NAME_COLUMN, String.class, (Integer)255, null, false));
        this.dbAccessor.createTable(KKP_MAPPING_SERVICE_TABLE, kkpMappingColumns, new String[0]);
        this.dbAccessor.addPKConstraint(KKP_MAPPING_SERVICE_TABLE, PK_KKP_MAPPING_SERVICE, KKP_ID_COLUMN, "service_name", COMPONENT_NAME_COLUMN);
        this.dbAccessor.addFKConstraint(KERBEROS_KEYTAB_PRINCIPAL_TABLE, FK_KKP_KEYTAB_PATH, KEYTAB_PATH_FIELD, KERBEROS_KEYTAB_TABLE, KEYTAB_PATH_FIELD, false);
        this.dbAccessor.addFKConstraint(KERBEROS_KEYTAB_PRINCIPAL_TABLE, FK_KKP_HOST_ID, HOST_ID_COLUMN, HOSTS_TABLE, HOST_ID_COLUMN, false);
        this.dbAccessor.addFKConstraint(KERBEROS_KEYTAB_PRINCIPAL_TABLE, FK_KKP_PRINCIPAL_NAME, PRINCIPAL_NAME_COLUMN, KERBEROS_PRINCIPAL_TABLE, PRINCIPAL_NAME_COLUMN, false);
        this.dbAccessor.addFKConstraint(KKP_MAPPING_SERVICE_TABLE, FK_KKP_SERVICE_PRINCIPAL, KKP_ID_COLUMN, KERBEROS_KEYTAB_PRINCIPAL_TABLE, KKP_ID_COLUMN, false);
        this.addSequence(KKP_ID_SEQ_NAME, 0L, false);
        this.dbAccessor.dropTable(KERBEROS_PRINCIPAL_HOST_TABLE);
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
        this.renameAmbariInfra();
        this.updateKerberosDescriptorArtifacts();
        this.addNewConfigurationsFromXml();
        this.showHcatDeletedUserMessage();
        this.setStatusOfStagesAndRequests();
        this.updateLogSearchConfigs();
        this.updateKerberosConfigurations();
        this.moveAmbariPropertiesToAmbariConfiguration();
        this.createRoleAuthorizations();
        this.addUserAuthenticationSequence();
        this.updateSolrConfigurations();
        this.updateAmsConfigs();
        this.updateStormConfigs();
        this.clearHadoopMetrics2Content();
    }

    protected void renameAmbariInfra() {
        LOG.info("Renaming service AMBARI_INFRA to AMBARI_INFRA_SOLR");
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters == null) {
            return;
        }
        Map<String, Cluster> clusterMap = clusters.getClusters();
        if (MapUtils.isEmpty(clusterMap)) {
            return;
        }
        EntityManager entityManager = (EntityManager)this.getEntityManagerProvider().get();
        ClusterServiceDAO clusterServiceDAO = (ClusterServiceDAO)this.injector.getInstance(ClusterServiceDAO.class);
        HostComponentStateDAO hostComponentStateDAO = (HostComponentStateDAO)this.injector.getInstance(HostComponentStateDAO.class);
        HostComponentDesiredStateDAO hostComponentDesiredStateDAO = (HostComponentDesiredStateDAO)this.injector.getInstance(HostComponentDesiredStateDAO.class);
        ServiceDesiredStateDAO serviceDesiredStateDAO = (ServiceDesiredStateDAO)this.injector.getInstance(ServiceDesiredStateDAO.class);
        ServiceComponentDesiredStateDAO serviceComponentDesiredStateDAO = (ServiceComponentDesiredStateDAO)this.injector.getInstance(ServiceComponentDesiredStateDAO.class);
        for (Cluster cluster : clusterMap.values()) {
            ClusterServiceEntityPK clusterServiceEntityPK = new ClusterServiceEntityPK();
            clusterServiceEntityPK.setClusterId(cluster.getClusterId());
            clusterServiceEntityPK.setServiceName(AMBARI_INFRA_OLD_NAME);
            ClusterServiceEntity clusterServiceEntity = clusterServiceDAO.findByPK(clusterServiceEntityPK);
            if (clusterServiceEntity == null) continue;
            ArrayList<ServiceComponentDesiredStateEntity> serviceComponentDesiredStateEntities = new ArrayList<ServiceComponentDesiredStateEntity>(clusterServiceEntity.getServiceComponentDesiredStateEntities());
            ServiceDesiredStateEntity serviceDesiredStateEntity = clusterServiceEntity.getServiceDesiredStateEntity();
            List<HostComponentStateEntity> hostComponentStateEntities = hostComponentStateDAO.findByService(AMBARI_INFRA_OLD_NAME);
            ArrayList<HostComponentDesiredStateEntity> hostComponentDesiredStateEntities = new ArrayList<HostComponentDesiredStateEntity>();
            for (ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity : clusterServiceEntity.getServiceComponentDesiredStateEntities()) {
                hostComponentDesiredStateEntities.addAll(hostComponentDesiredStateDAO.findByIndex(cluster.getClusterId(), AMBARI_INFRA_OLD_NAME, serviceComponentDesiredStateEntity.getComponentName()));
            }
            for (HostComponentStateEntity hostComponentStateEntity : hostComponentStateEntities) {
                hostComponentStateDAO.remove(hostComponentStateEntity);
                entityManager.detach((Object)hostComponentStateEntity);
                hostComponentStateEntity.setServiceName(AMBARI_INFRA_NEW_NAME);
            }
            for (HostComponentDesiredStateEntity hostComponentDesiredStateEntity : hostComponentDesiredStateEntities) {
                hostComponentDesiredStateDAO.remove(hostComponentDesiredStateEntity);
                entityManager.detach((Object)hostComponentDesiredStateEntity);
                hostComponentDesiredStateEntity.setServiceName(AMBARI_INFRA_NEW_NAME);
                if (!"INFRA_SOLR".equals(hostComponentDesiredStateEntity.getComponentName())) continue;
                hostComponentDesiredStateEntity.setRestartRequired(true);
            }
            clusterServiceEntity.getServiceComponentDesiredStateEntities().clear();
            for (ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity : serviceComponentDesiredStateEntities) {
                serviceComponentDesiredStateDAO.remove(serviceComponentDesiredStateEntity);
                entityManager.detach((Object)serviceComponentDesiredStateEntity);
                serviceComponentDesiredStateEntity.setServiceName(AMBARI_INFRA_NEW_NAME);
            }
            if (serviceDesiredStateEntity != null) {
                clusterServiceEntity.setServiceDesiredStateEntity(null);
                serviceDesiredStateDAO.remove(serviceDesiredStateEntity);
                entityManager.detach((Object)serviceDesiredStateEntity);
                serviceDesiredStateEntity.setServiceName(AMBARI_INFRA_NEW_NAME);
            }
            clusterServiceDAO.remove(clusterServiceEntity);
            entityManager.detach((Object)clusterServiceEntity);
            clusterServiceEntity.setServiceName(AMBARI_INFRA_NEW_NAME);
            clusterServiceEntity.setServiceDesiredStateEntity(serviceDesiredStateEntity);
            clusterServiceDAO.create(clusterServiceEntity);
            for (ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity : serviceComponentDesiredStateEntities) {
                serviceComponentDesiredStateDAO.create(serviceComponentDesiredStateEntity);
            }
            for (HostComponentStateEntity hostComponentStateEntity : hostComponentStateEntities) {
                hostComponentStateDAO.create(hostComponentStateEntity);
            }
            for (HostComponentDesiredStateEntity hostComponentDesiredStateEntity : hostComponentDesiredStateEntities) {
                hostComponentDesiredStateDAO.create(hostComponentDesiredStateEntity);
            }
        }
        this.executeInTransaction(() -> {
            TypedQuery serviceConfigUpdate = entityManager.createQuery("UPDATE ServiceConfigEntity SET serviceName = :newServiceName WHERE serviceName = :oldServiceName", ServiceConfigEntity.class);
            serviceConfigUpdate.setParameter("newServiceName", (Object)AMBARI_INFRA_NEW_NAME);
            serviceConfigUpdate.setParameter("oldServiceName", (Object)AMBARI_INFRA_OLD_NAME);
            serviceConfigUpdate.executeUpdate();
        });
        this.executeInTransaction(() -> {
            for (Cluster cluster : clusterMap.values()) {
                TypedQuery alertDefinitionUpdate = entityManager.createQuery("UPDATE AlertDefinitionEntity SET serviceName = :newServiceName WHERE serviceName = :oldServiceName AND clusterId = :clusterId", AlertDefinitionEntity.class);
                alertDefinitionUpdate.setParameter("clusterId", (Object)cluster.getClusterId());
                alertDefinitionUpdate.setParameter("newServiceName", (Object)AMBARI_INFRA_NEW_NAME);
                alertDefinitionUpdate.setParameter("oldServiceName", (Object)AMBARI_INFRA_OLD_NAME);
                alertDefinitionUpdate.executeUpdate();
            }
        });
        this.executeInTransaction(() -> {
            TypedQuery alertGroupUpdate = entityManager.createQuery("UPDATE AlertGroupEntity SET serviceName = :newServiceName, groupName = :newServiceName WHERE serviceName = :oldServiceName", AlertGroupEntity.class);
            alertGroupUpdate.setParameter("newServiceName", (Object)AMBARI_INFRA_NEW_NAME);
            alertGroupUpdate.setParameter("oldServiceName", (Object)AMBARI_INFRA_OLD_NAME);
            alertGroupUpdate.executeUpdate();
        });
        this.executeInTransaction(() -> {
            TypedQuery alertHistoryUpdate = entityManager.createQuery("UPDATE AlertHistoryEntity SET serviceName = :newServiceName WHERE serviceName = :oldServiceName", AlertHistoryEntity.class);
            alertHistoryUpdate.setParameter("newServiceName", (Object)AMBARI_INFRA_NEW_NAME);
            alertHistoryUpdate.setParameter("oldServiceName", (Object)AMBARI_INFRA_OLD_NAME);
            alertHistoryUpdate.executeUpdate();
        });
        entityManager.getEntityManagerFactory().getCache().evictAll();
        clusters.invalidateAllClusters();
    }

    @Override
    protected void updateKerberosDescriptorArtifact(ArtifactDAO artifactDAO, ArtifactEntity artifactEntity) throws OBDPException {
        if (artifactEntity == null) {
            return;
        }
        Map<String, Object> data = artifactEntity.getArtifactData();
        if (data == null) {
            return;
        }
        KerberosDescriptor kerberosDescriptor = new KerberosDescriptorFactory().createInstance(data);
        if (kerberosDescriptor == null) {
            return;
        }
        boolean updateInfraKerberosDescriptor = this.updateInfraKerberosDescriptor(kerberosDescriptor);
        boolean updateWebHCatHostKerberosDescriptor = this.updateWebHCatHostKerberosDescriptor(kerberosDescriptor);
        boolean updateYarnKerberosDescriptor = this.updateYarnKerberosDescriptor(kerberosDescriptor);
        if (updateInfraKerberosDescriptor || updateWebHCatHostKerberosDescriptor || updateYarnKerberosDescriptor) {
            artifactEntity.setArtifactData(kerberosDescriptor.toMap());
            artifactDAO.merge(artifactEntity);
        }
    }

    private boolean updateYarnKerberosDescriptor(KerberosDescriptor kerberosDescriptor) {
        Map<String, String> coreSiteProperties;
        KerberosConfigurationDescriptor coreSiteConfiguration;
        boolean updated = false;
        KerberosServiceDescriptor yarnServiceDescriptor = kerberosDescriptor.getServices().get(YARN_SERVICE);
        if (yarnServiceDescriptor != null && (coreSiteConfiguration = yarnServiceDescriptor.getConfiguration(CONFIGURATION_CORE_SITE)) != null && (coreSiteProperties = coreSiteConfiguration.getProperties()) != null) {
            for (Map.Entry<String, String> entry : coreSiteProperties.entrySet()) {
                String newValue;
                String value = entry.getValue();
                if (!value.contains("rm_host") || (newValue = value.replaceAll("rm_host", "resourcemanager_hosts")).equals(value)) continue;
                updated = true;
                entry.setValue(newValue);
            }
            if (updated) {
                coreSiteConfiguration.setProperties(coreSiteProperties);
            }
        }
        return updated;
    }

    private boolean updateInfraKerberosDescriptor(KerberosDescriptor kerberosDescriptor) {
        boolean updated = false;
        Map<String, KerberosServiceDescriptor> services = kerberosDescriptor.getServices();
        KerberosServiceDescriptor ambariInfraService = services.get(AMBARI_INFRA_OLD_NAME);
        if (ambariInfraService != null) {
            ambariInfraService.setName(AMBARI_INFRA_NEW_NAME);
            services.remove(AMBARI_INFRA_OLD_NAME);
            services.put(AMBARI_INFRA_NEW_NAME, ambariInfraService);
            kerberosDescriptor.setServices(services);
            for (KerberosServiceDescriptor serviceDescriptor : kerberosDescriptor.getServices().values()) {
                this.updateKerberosIdentities(serviceDescriptor);
                if (!MapUtils.isNotEmpty(serviceDescriptor.getComponents())) continue;
                for (KerberosComponentDescriptor componentDescriptor : serviceDescriptor.getComponents().values()) {
                    this.updateKerberosIdentities(componentDescriptor);
                }
            }
            updated = true;
        }
        return updated;
    }

    private boolean updateWebHCatHostKerberosDescriptor(KerberosDescriptor kerberosDescriptor) {
        KerberosComponentDescriptor webhcatServer;
        boolean updated = false;
        KerberosServiceDescriptor hiveService = kerberosDescriptor.getServices().get("HIVE");
        if (hiveService != null && (webhcatServer = hiveService.getComponent(HIVE_SERVICE_COMPONENT_WEBHCAT_SERVER)) != null) {
            String currentTempletonHiveProperties;
            KerberosConfigurationDescriptor webhcatSiteConfiguration;
            String currentHadoopProxyuserHttpHosts;
            KerberosConfigurationDescriptor coreSiteConfiguration = webhcatServer.getConfiguration(CONFIGURATION_CORE_SITE);
            if (coreSiteConfiguration != null && StringUtils.isNotBlank((String)(currentHadoopProxyuserHttpHosts = coreSiteConfiguration.getProperty(PROPERTY_HADOOP_PROXYUSER_HTTP_HOSTS)))) {
                LOG.info("Updating hadoop.proxyuser.HTTP.hosts...");
                String newValue = currentHadoopProxyuserHttpHosts.replace("webhcat_server_host|", "webhcat_server_hosts|");
                newValue = newValue.replace("\\\\,", "\\,");
                coreSiteConfiguration.putProperty(PROPERTY_HADOOP_PROXYUSER_HTTP_HOSTS, newValue);
                updated = true;
            }
            if ((webhcatSiteConfiguration = webhcatServer.getConfiguration(CONFIGURATION_WEBHCAT_SITE)) != null && StringUtils.isNotBlank((String)(currentTempletonHiveProperties = webhcatSiteConfiguration.getProperty(PROPERTY_TEMPLETON_HIVE_PROPERTIES)))) {
                LOG.info("Updating templeton.hive.properties...");
                String newValue = currentTempletonHiveProperties.replace("hive_metastore_host|", "hive_metastore_hosts|");
                newValue = newValue.replace("\\\\,", "\\,");
                webhcatSiteConfiguration.putProperty(PROPERTY_TEMPLETON_HIVE_PROPERTIES, newValue);
                updated = true;
            }
        }
        return updated;
    }

    protected void addUserAuthenticationSequence() throws SQLException {
        long maxUserAuthenticationId = this.fetchMaxId(USER_AUTHENTICATION_TABLE, USER_AUTHENTICATION_USER_AUTHENTICATION_ID_COLUMN);
        LOG.info("Maximum user authentication ID = " + maxUserAuthenticationId);
        this.addSequence("user_authentication_id_seq", maxUserAuthenticationId + 1L, false);
    }

    protected void createRoleAuthorizations() throws SQLException {
        this.addRoleAuthorization("OBDP.MANAGE_CONFIGURATION", "Manage ambari configuration", Collections.singleton("OBDP.ADMINISTRATOR:OBDP"));
    }

    protected void showHcatDeletedUserMessage() {
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null) {
            Map<String, Cluster> clusterMap = this.getCheckedClusterMap(clusters);
            for (Cluster cluster : clusterMap.values()) {
                String hcatUser;
                Map<String, String> hiveEnvProperties;
                String webhcatUser;
                Config hiveEnvConfig = cluster.getDesiredConfigByType("hive-env");
                if (hiveEnvConfig == null || StringUtils.equals((String)(webhcatUser = (hiveEnvProperties = hiveEnvConfig.getProperties()).get("webhcat_user")), (String)(hcatUser = hiveEnvProperties.get("hcat_user")))) continue;
                System.out.print("WARNING: In hive-env config, webhcat and hcat user are different. In current ambari release (3.0.0), hcat user was removed from stack, so potentially you could have some problems.");
                LOG.warn("In hive-env config, webhcat and hcat user are different. In current ambari release (3.0.0), hcat user was removed from stack, so potentially you could have some problems.");
            }
        }
    }

    protected void setStatusOfStagesAndRequests() {
        this.executeInTransaction(new Runnable(){

            @Override
            public void run() {
                try {
                    RequestDAO requestDAO = (RequestDAO)UpgradeCatalog270.this.injector.getInstance(RequestDAO.class);
                    StageFactory stageFactory = (StageFactory)UpgradeCatalog270.this.injector.getInstance(StageFactory.class);
                    EntityManager em = (EntityManager)UpgradeCatalog270.this.getEntityManagerProvider().get();
                    List<RequestEntity> requestEntities = requestDAO.findAll();
                    for (RequestEntity requestEntity : requestEntities) {
                        Collection<StageEntity> stageEntities = requestEntity.getStages();
                        ArrayList<HostRoleStatus> stageDisplayStatuses = new ArrayList<HostRoleStatus>();
                        ArrayList<HostRoleStatus> stageStatuses = new ArrayList<HostRoleStatus>();
                        for (StageEntity stageEntity : stageEntities) {
                            Stage stage = stageFactory.createExisting(stageEntity);
                            List<HostRoleCommand> hostRoleCommands = stage.getOrderedHostRoleCommands();
                            Map<HostRoleStatus, Integer> statusCount = CalculatedStatus.calculateStatusCountsForTasks(hostRoleCommands);
                            HostRoleStatus stageDisplayStatus = CalculatedStatus.calculateSummaryDisplayStatus(statusCount, hostRoleCommands.size(), stage.isSkippable());
                            HostRoleStatus stageStatus = CalculatedStatus.calculateStageStatus(hostRoleCommands, statusCount, stage.getSuccessFactors(), stage.isSkippable());
                            stageEntity.setStatus(stageStatus);
                            stageStatuses.add(stageStatus);
                            stageEntity.setDisplayStatus(stageDisplayStatus);
                            stageDisplayStatuses.add(stageDisplayStatus);
                            em.merge((Object)stageEntity);
                        }
                        HostRoleStatus requestStatus = CalculatedStatus.getOverallStatusForRequest(stageStatuses);
                        requestEntity.setStatus(requestStatus);
                        HostRoleStatus requestDisplayStatus = CalculatedStatus.getOverallDisplayStatusForRequest(stageDisplayStatuses);
                        requestEntity.setDisplayStatus(requestDisplayStatus);
                        em.merge((Object)requestEntity);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Setting status for stages and Requests threw exception. ", (Throwable)e);
                }
            }
        });
    }

    private void addOpsDisplayNameColumnToHostRoleCommand() throws SQLException {
        this.dbAccessor.addColumn(HOST_ROLE_COMMAND_TABLE, new DBAccessor.DBColumnInfo(HRC_OPS_DISPLAY_NAME_COLUMN, String.class, (Integer)255, null, true));
    }

    private void removeSecurityState() throws SQLException {
        this.dbAccessor.dropColumn(COMPONENT_DESIRED_STATE_TABLE, SECURITY_STATE_COLUMN);
        this.dbAccessor.dropColumn(COMPONENT_STATE_TABLE, SECURITY_STATE_COLUMN);
        this.dbAccessor.dropColumn(SERVICE_DESIRED_STATE_TABLE, SECURITY_STATE_COLUMN);
    }

    protected void updateLogSearchConfigs() throws OBDPException, SQLException {
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null) {
            Map<String, Cluster> clusterMap = clusters.getClusters();
            ConfigHelper configHelper = (ConfigHelper)this.injector.getInstance(ConfigHelper.class);
            if (clusterMap != null && !clusterMap.isEmpty()) {
                for (Cluster cluster : clusterMap.values()) {
                    String content;
                    Config logSearchLog4jProperties;
                    String content2;
                    Config logFeederLog4jProperties;
                    Config logSearchEnv = cluster.getDesiredConfigByType("logsearch-env");
                    String oldProtocolProperty = null;
                    String oldPortProperty = null;
                    if (logSearchEnv != null) {
                        oldPortProperty = logSearchEnv.getProperties().get("logsearch_ui_port");
                        oldProtocolProperty = logSearchEnv.getProperties().get("logsearch_ui_protocol");
                    }
                    Config logSearchProperties = cluster.getDesiredConfigByType("logsearch-properties");
                    Config logFeederProperties = cluster.getDesiredConfigByType("logfeeder-properties");
                    if (logSearchProperties != null && logFeederProperties != null) {
                        configHelper.createConfigType(cluster, cluster.getDesiredStackVersion(), ambariManagementController, "logsearch-common-properties", Collections.emptyMap(), "ambari-upgrade", String.format("Updated logsearch-common-properties during Ambari Upgrade from %s to %s", this.getSourceVersion(), this.getTargetVersion()));
                        String defaultLogLevels = logSearchProperties.getProperties().get("logsearch.logfeeder.include.default.level");
                        HashSet removeProperties = Sets.newHashSet((Object[])new String[]{"logsearch.logfeeder.include.default.level"});
                        this.removeConfigurationPropertiesFromCluster(cluster, "logsearch-properties", removeProperties);
                        HashMap<String, String> newLogSearchProperties = new HashMap<String, String>();
                        if (oldProtocolProperty != null) {
                            newLogSearchProperties.put("logsearch.protocol", oldProtocolProperty);
                        }
                        if (oldPortProperty != null) {
                            newLogSearchProperties.put("logsearch.http.port", oldPortProperty);
                            newLogSearchProperties.put("logsearch.https.port", oldPortProperty);
                        }
                        if (!newLogSearchProperties.isEmpty()) {
                            this.updateConfigurationPropertiesForCluster(cluster, "logsearch-properties", newLogSearchProperties, true, true);
                        }
                        HashMap<String, String> newLogfeederProperties = new HashMap<String, String>();
                        newLogfeederProperties.put("logfeeder.include.default.level", defaultLogLevels);
                        this.updateConfigurationPropertiesForCluster(cluster, "logfeeder-properties", newLogfeederProperties, true, true);
                    }
                    if ((logFeederLog4jProperties = cluster.getDesiredConfigByType("logfeeder-log4j")) != null && (content2 = logFeederLog4jProperties.getProperties().get("content")).contains("<!DOCTYPE log4j:configuration SYSTEM \"log4j.dtd\">")) {
                        content2 = content2.replace("<!DOCTYPE log4j:configuration SYSTEM \"log4j.dtd\">", "<!DOCTYPE log4j:configuration SYSTEM \"http://logging.apache.org/log4j/1.2/apidocs/org/apache/log4j/xml/doc-files/log4j.dtd\">");
                        this.updateConfigurationPropertiesForCluster(cluster, "logfeeder-log4j", Collections.singletonMap("content", content2), true, true);
                    }
                    if ((logSearchLog4jProperties = cluster.getDesiredConfigByType("logsearch-log4j")) != null && (content = logSearchLog4jProperties.getProperties().get("content")).contains("<!DOCTYPE log4j:configuration SYSTEM \"log4j.dtd\">")) {
                        content = content.replace("<!DOCTYPE log4j:configuration SYSTEM \"log4j.dtd\">", "<!DOCTYPE log4j:configuration SYSTEM \"http://logging.apache.org/log4j/1.2/apidocs/org/apache/log4j/xml/doc-files/log4j.dtd\">");
                        this.updateConfigurationPropertiesForCluster(cluster, "logsearch-log4j", Collections.singletonMap("content", content), true, true);
                    }
                    this.removeAdminHandlersFrom(cluster, "logsearch-service_logs-solrconfig");
                    this.removeAdminHandlersFrom(cluster, "logsearch-audit_logs-solrconfig");
                    Config logFeederOutputConfig = cluster.getDesiredConfigByType("logfeeder-output-config");
                    if (logFeederOutputConfig != null) {
                        String content3 = logFeederOutputConfig.getProperties().get("content");
                        content3 = content3.replace("      \"collection\":\"{{logsearch_solr_collection_service_logs}}\",\n      \"number_of_shards\": \"{{logsearch_collection_service_logs_numshards}}\",\n      \"splits_interval_mins\": \"{{logsearch_service_logs_split_interval_mins}}\",\n", "      \"type\": \"service\",\n");
                        content3 = content3.replace("      \"collection\":\"{{logsearch_solr_collection_audit_logs}}\",\n      \"number_of_shards\": \"{{logsearch_collection_audit_logs_numshards}}\",\n      \"splits_interval_mins\": \"{{logsearch_audit_logs_split_interval_mins}}\",\n", "      \"type\": \"audit\",\n");
                        this.updateConfigurationPropertiesForCluster(cluster, "logfeeder-output-config", Collections.singletonMap("content", content3), true, true);
                    }
                    DBAccessor dba = this.dbAccessor != null ? this.dbAccessor : (DBAccessor)this.injector.getInstance(DBAccessor.class);
                    this.removeLogSearchPatternConfigs(dba);
                }
            }
        }
    }

    private void removeLogSearchPatternConfigs(DBAccessor dbAccessor) throws SQLException {
        String configSuffix = "-logsearch-conf";
        String serviceConfigMappingRemoveSQL = String.format("DELETE FROM %s WHERE config_id IN (SELECT config_id from %s where type_name like '%%%s')", SERVICE_CONFIG_MAPPING_TABLE, CLUSTER_CONFIG_TABLE, configSuffix);
        String clusterConfigRemoveSQL = String.format("DELETE FROM %s WHERE type_name like '%%%s'", CLUSTER_CONFIG_TABLE, configSuffix);
        dbAccessor.executeQuery(serviceConfigMappingRemoveSQL);
        dbAccessor.executeQuery(clusterConfigRemoveSQL);
    }

    private void removeAdminHandlersFrom(Cluster cluster, String configType) throws OBDPException {
        String content;
        Config logSearchServiceLogsConfig = cluster.getDesiredConfigByType(configType);
        if (logSearchServiceLogsConfig != null && (content = logSearchServiceLogsConfig.getProperties().get("content")).contains("class=\"solr.admin.AdminHandlers\"")) {
            content = this.removeAdminHandlers(content);
            this.updateConfigurationPropertiesForCluster(cluster, configType, Collections.singletonMap("content", content), true, true);
        }
    }

    protected String removeAdminHandlers(String content) {
        return content.replaceAll("(?s)<requestHandler\\s+name=\"/admin/\"\\s+class=\"solr.admin.AdminHandlers\"\\s*/>", "");
    }

    private void updateKerberosIdentities(AbstractKerberosDescriptorContainer descriptorContainer) {
        if (descriptorContainer.getIdentities() == null) {
            return;
        }
        descriptorContainer.getIdentities().stream().filter(identityDescriptor -> identityDescriptor.getReference() != null && identityDescriptor.getReference().contains(AMBARI_INFRA_OLD_NAME)).forEach(identityDescriptor -> identityDescriptor.setReference(identityDescriptor.getReference().replace(AMBARI_INFRA_OLD_NAME, AMBARI_INFRA_NEW_NAME)));
        descriptorContainer.getIdentities().stream().filter(identityDescriptor -> identityDescriptor.getWhen() != null).collect(Collectors.toList()).forEach(identityDescriptor -> {
            List serviceList;
            Map<String, Object> whenMap = identityDescriptor.getWhen().toMap();
            if (whenMap.containsKey("contains") && (serviceList = (List)whenMap.get("contains")).contains(AMBARI_INFRA_OLD_NAME)) {
                serviceList.remove(AMBARI_INFRA_OLD_NAME);
                serviceList.add(AMBARI_INFRA_NEW_NAME);
                identityDescriptor.setWhen(PredicateUtils.fromMap(whenMap));
            }
        });
    }

    protected PrepareKerberosIdentitiesServerAction getPrepareIdentityServerAction() {
        return new PrepareKerberosIdentitiesServerAction();
    }

    protected void updateKerberosConfigurations() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && !MapUtils.isEmpty(clusterMap = clusters.getClusters())) {
            for (final Cluster cluster : clusterMap.values()) {
                Map<String, String> properties;
                final Config config = cluster.getDesiredConfigByType("kerberos-env");
                if (config != null && (properties = config.getProperties()).containsKey("group")) {
                    this.updateConfigurationPropertiesForCluster(cluster, "kerberos-env", Collections.singletonMap("ipa_user_group", properties.get("group")), Collections.singleton("group"), true, false);
                }
                if (config == null) continue;
                final PrepareKerberosIdentitiesServerAction prepareIdentities = this.getPrepareIdentityServerAction();
                ExecutionCommand executionCommand = new ExecutionCommand();
                executionCommand.setCommandParams((Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("default_realm", config.getProperties().get("realm"));
                    }
                });
                prepareIdentities.setExecutionCommand(executionCommand);
                this.injector.injectMembers((Object)prepareIdentities);
                KerberosHelper kerberosHelper = (KerberosHelper)this.injector.getInstance(KerberosHelper.class);
                ((OBDPServer)this.injector.getInstance(OBDPServer.class)).performStaticInjection();
                OBDPServer.setController((OBDPManagementController)this.injector.getInstance(OBDPManagementController.class));
                final KerberosDescriptor kerberosDescriptor = kerberosHelper.getKerberosDescriptor(cluster, false);
                final HashMap kerberosConfigurations = new HashMap();
                final HashMap propertiesToIgnore = new HashMap();
                final List<ServiceComponentHost> schToProcess = kerberosHelper.getServiceComponentHostsToProcess(cluster, kerberosDescriptor, null, null);
                final Map<String, Map<String, String>> configurations = kerberosHelper.calculateConfigurations(cluster, null, kerberosDescriptor, false, false, null);
                final boolean includeAmbariIdentity = true;
                final String dataDirectory = kerberosHelper.createTemporaryDirectory().getAbsolutePath();
                try {
                    this.executeInTransaction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                prepareIdentities.processServiceComponentHosts(cluster, kerberosDescriptor, schToProcess, null, dataDirectory, configurations, kerberosConfigurations, includeAmbariIdentity, propertiesToIgnore);
                            }
                            catch (OBDPException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    throw new OBDPException("Failed to upgrade kerberos tables", (Throwable)e);
                }
            }
        }
    }

    protected void moveAmbariPropertiesToAmbariConfiguration() throws OBDPException {
        LOG.info("Moving LDAP and SSO related properties from obdp.properties to obdp_configuration DB table...");
        OBDPConfigurationDAO ambariConfigurationDAO = (OBDPConfigurationDAO)this.injector.getInstance(OBDPConfigurationDAO.class);
        HashMap propertiesToBeMoved = new HashMap();
        Map<OBDPServerConfigurationKey, String> configurationMap = this.getAmbariConfigurationMap();
        configurationMap.forEach((key, oldPropertyName) -> {
            String propertyValue = this.configuration.getProperty((String)oldPropertyName);
            if (propertyValue != null) {
                if (OBDPServerConfigurationKey.SERVER_HOST == key || OBDPServerConfigurationKey.SECONDARY_SERVER_HOST == key) {
                    HostAndPort hostAndPort = HostAndPort.fromString((String)propertyValue);
                    OBDPServerConfigurationKey keyToBesaved = OBDPServerConfigurationKey.SERVER_HOST == key ? OBDPServerConfigurationKey.SERVER_HOST : OBDPServerConfigurationKey.SECONDARY_SERVER_HOST;
                    this.populateConfigurationToBeMoved(propertiesToBeMoved, (String)oldPropertyName, keyToBesaved, hostAndPort.getHost());
                    keyToBesaved = OBDPServerConfigurationKey.SERVER_HOST == key ? OBDPServerConfigurationKey.SERVER_PORT : OBDPServerConfigurationKey.SECONDARY_SERVER_PORT;
                    this.populateConfigurationToBeMoved(propertiesToBeMoved, (String)oldPropertyName, keyToBesaved, String.valueOf(hostAndPort.getPort()));
                } else if (OBDPServerConfigurationKey.SSO_PROVIDER_CERTIFICATE == key) {
                    StringBuilder contentBuilder = new StringBuilder();
                    try (Stream<String> stream = Files.lines(Paths.get(propertyValue, new String[0]), StandardCharsets.UTF_8);){
                        stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
                    }
                    catch (IOException e) {
                        LOG.error(String.format("Failed to read the SSO provider's certificate file, %s: %s", propertyValue, e.getMessage()), (Throwable)e);
                    }
                    this.populateConfigurationToBeMoved(propertiesToBeMoved, (String)oldPropertyName, (OBDPServerConfigurationKey)((Object)key), contentBuilder.toString());
                } else if (OBDPServerConfigurationKey.SSO_AUTHENTICATION_ENABLED == key) {
                    this.populateConfigurationToBeMoved(propertiesToBeMoved, (String)oldPropertyName, (OBDPServerConfigurationKey)((Object)key), propertyValue);
                    if ("true".equalsIgnoreCase(propertyValue)) {
                        this.populateConfigurationToBeMoved(propertiesToBeMoved, null, OBDPServerConfigurationKey.SSO_MANAGE_SERVICES, "true");
                        this.populateConfigurationToBeMoved(propertiesToBeMoved, null, OBDPServerConfigurationKey.SSO_ENABLED_SERVICES, "OBDP");
                    }
                } else if (OBDPServerConfigurationKey.LDAP_ENABLED == key) {
                    this.populateConfigurationToBeMoved(propertiesToBeMoved, (String)oldPropertyName, (OBDPServerConfigurationKey)((Object)key), propertyValue);
                    if ("true".equalsIgnoreCase(propertyValue)) {
                        this.populateConfigurationToBeMoved(propertiesToBeMoved, null, OBDPServerConfigurationKey.AMBARI_MANAGES_LDAP_CONFIGURATION, "true");
                        this.populateConfigurationToBeMoved(propertiesToBeMoved, null, OBDPServerConfigurationKey.LDAP_ENABLED_SERVICES, "OBDP");
                    }
                } else {
                    this.populateConfigurationToBeMoved(propertiesToBeMoved, (String)oldPropertyName, (OBDPServerConfigurationKey)((Object)key), propertyValue);
                }
            }
        });
        if (propertiesToBeMoved.isEmpty()) {
            LOG.info("There are no properties to be moved from obdp.properties to the Ambari DB; moved 0 elements");
        } else {
            for (Map.Entry entry : propertiesToBeMoved.entrySet()) {
                Map properties = (Map)entry.getValue();
                if (properties == null) continue;
                String categoryName = ((OBDPServerConfigurationCategory)((Object)entry.getKey())).getCategoryName();
                ambariConfigurationDAO.reconcileCategory(categoryName, (Map)entry.getValue(), false);
                LOG.info("Moved {} properties to the {} Ambari Configuration category", (Object)properties.size(), (Object)categoryName);
            }
            this.configuration.removePropertiesFromAmbariProperties(configurationMap.values());
        }
    }

    private void populateConfigurationToBeMoved(Map<OBDPServerConfigurationCategory, Map<String, String>> propertiesToBeSaved, String oldPropertyName, OBDPServerConfigurationKey key, String value) {
        OBDPServerConfigurationCategory category = key.getConfigurationCategory();
        String newPropertyName = key.key();
        Map categoryProperties = propertiesToBeSaved.computeIfAbsent(category, k -> new HashMap());
        categoryProperties.put(newPropertyName, value);
        if (oldPropertyName != null) {
            LOG.info("Upgrading '{}' to '{}'", (Object)oldPropertyName, (Object)newPropertyName);
        }
    }

    private Map<OBDPServerConfigurationKey, String> getAmbariConfigurationMap() {
        HashMap<OBDPServerConfigurationKey, String> map = new HashMap<OBDPServerConfigurationKey, String>();
        map.put(OBDPServerConfigurationKey.LDAP_ENABLED, "ambari.ldap.isConfigured");
        map.put(OBDPServerConfigurationKey.SERVER_HOST, "authentication.ldap.primaryUrl");
        map.put(OBDPServerConfigurationKey.SECONDARY_SERVER_HOST, "authentication.ldap.secondaryUrl");
        map.put(OBDPServerConfigurationKey.USE_SSL, "authentication.ldap.useSSL");
        map.put(OBDPServerConfigurationKey.ANONYMOUS_BIND, "authentication.ldap.bindAnonymously");
        map.put(OBDPServerConfigurationKey.BIND_DN, "authentication.ldap.managerDn");
        map.put(OBDPServerConfigurationKey.BIND_PASSWORD, "authentication.ldap.managerPassword");
        map.put(OBDPServerConfigurationKey.DN_ATTRIBUTE, "authentication.ldap.dnAttribute");
        map.put(OBDPServerConfigurationKey.USER_OBJECT_CLASS, "authentication.ldap.userObjectClass");
        map.put(OBDPServerConfigurationKey.USER_NAME_ATTRIBUTE, "authentication.ldap.usernameAttribute");
        map.put(OBDPServerConfigurationKey.USER_SEARCH_BASE, "authentication.ldap.baseDn");
        map.put(OBDPServerConfigurationKey.USER_BASE, "authentication.ldap.userBase");
        map.put(OBDPServerConfigurationKey.GROUP_OBJECT_CLASS, "authentication.ldap.groupObjectClass");
        map.put(OBDPServerConfigurationKey.GROUP_NAME_ATTRIBUTE, "authentication.ldap.groupNamingAttr");
        map.put(OBDPServerConfigurationKey.GROUP_MEMBER_ATTRIBUTE, "authentication.ldap.groupMembershipAttr");
        map.put(OBDPServerConfigurationKey.GROUP_SEARCH_BASE, "authentication.ldap.baseDn");
        map.put(OBDPServerConfigurationKey.GROUP_BASE, "authentication.ldap.groupBase");
        map.put(OBDPServerConfigurationKey.USER_SEARCH_FILTER, "authentication.ldap.userSearchFilter");
        map.put(OBDPServerConfigurationKey.USER_MEMBER_REPLACE_PATTERN, "authentication.ldap.sync.userMemberReplacePattern");
        map.put(OBDPServerConfigurationKey.USER_MEMBER_FILTER, "authentication.ldap.sync.userMemberFilter");
        map.put(OBDPServerConfigurationKey.ALTERNATE_USER_SEARCH_ENABLED, "authentication.ldap.alternateUserSearchEnabled");
        map.put(OBDPServerConfigurationKey.ALTERNATE_USER_SEARCH_FILTER, "authentication.ldap.alternateUserSearchFilter");
        map.put(OBDPServerConfigurationKey.GROUP_SEARCH_FILTER, "authorization.ldap.groupSearchFilter");
        map.put(OBDPServerConfigurationKey.GROUP_MEMBER_REPLACE_PATTERN, "authentication.ldap.sync.groupMemberReplacePattern");
        map.put(OBDPServerConfigurationKey.GROUP_MEMBER_FILTER, "authentication.ldap.sync.groupMemberFilter");
        map.put(OBDPServerConfigurationKey.GROUP_MAPPING_RULES, "authorization.ldap.adminGroupMappingRules");
        map.put(OBDPServerConfigurationKey.FORCE_LOWERCASE_USERNAMES, "authentication.ldap.username.forceLowercase");
        map.put(OBDPServerConfigurationKey.REFERRAL_HANDLING, "authentication.ldap.referral");
        map.put(OBDPServerConfigurationKey.PAGINATION_ENABLED, "authentication.ldap.pagination.enabled");
        map.put(OBDPServerConfigurationKey.COLLISION_BEHAVIOR, "ldap.sync.username.collision.behavior");
        map.put(OBDPServerConfigurationKey.DISABLE_ENDPOINT_IDENTIFICATION, "ldap.sync.disable.endpoint.identification");
        map.put(OBDPServerConfigurationKey.SSO_PROVIDER_URL, "authentication.jwt.providerUrl");
        map.put(OBDPServerConfigurationKey.SSO_PROVIDER_CERTIFICATE, "authentication.jwt.publicKey");
        map.put(OBDPServerConfigurationKey.SSO_PROVIDER_ORIGINAL_URL_PARAM_NAME, "authentication.jwt.originalUrlParamName");
        map.put(OBDPServerConfigurationKey.SSO_AUTHENTICATION_ENABLED, "authentication.jwt.enabled");
        map.put(OBDPServerConfigurationKey.SSO_JWT_AUDIENCES, "authentication.jwt.audiences");
        map.put(OBDPServerConfigurationKey.SSO_JWT_COOKIE_NAME, "authentication.jwt.cookieName");
        return map;
    }

    protected void updateSolrConfigurations() throws OBDPException {
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters == null) {
            return;
        }
        Map<String, Cluster> clusterMap = clusters.getClusters();
        if (clusterMap == null || clusterMap.isEmpty()) {
            return;
        }
        for (Cluster cluster : clusterMap.values()) {
            this.updateConfig(cluster, "logsearch-service_logs-solrconfig", content -> {
                content = this.updateLuceneMatchVersion((String)content, "7.3.1");
                return this.updateMergeFactor((String)content, "logsearch_service_logs_merge_factor");
            });
            this.updateConfig(cluster, "logsearch-audit_logs-solrconfig", content -> {
                content = this.updateLuceneMatchVersion((String)content, "7.3.1");
                return this.updateMergeFactor((String)content, "logsearch_audit_logs_merge_factor");
            });
            this.updateConfig(cluster, "ranger-solr-configuration", content -> {
                content = this.updateLuceneMatchVersion((String)content, "6.6.0");
                return this.updateMergeFactor((String)content, "ranger_audit_logs_merge_factor");
            });
            this.updateConfig(cluster, "atlas-solrconfig", content -> this.updateLuceneMatchVersion((String)content, "6.6.0"));
            this.updateConfig(cluster, "infra-solr-env", this::updateInfraSolrEnv);
            this.updateConfig(cluster, "infra-solr-security-json", content -> content.replace("id.onyx.obdp.infra.security.InfraRuleBasedAuthorizationPlugin", "org.apache.solr.security.InfraRuleBasedAuthorizationPlugin"));
        }
    }

    private void updateConfig(Cluster cluster, String configType, Function<String, String> contentUpdater) throws OBDPException {
        Config config = cluster.getDesiredConfigByType(configType);
        if (config == null) {
            return;
        }
        if (config.getProperties() == null || !config.getProperties().containsKey("content")) {
            return;
        }
        String content = config.getProperties().get("content");
        content = contentUpdater.apply(content);
        this.updateConfigurationPropertiesForCluster(cluster, configType, Collections.singletonMap("content", content), true, true);
    }

    protected String updateLuceneMatchVersion(String content, String newLuceneMatchVersion) {
        return content.replaceAll("<luceneMatchVersion>.*</luceneMatchVersion>", "<luceneMatchVersion>" + newLuceneMatchVersion + "</luceneMatchVersion>");
    }

    protected String updateMergeFactor(String content, String variableName) {
        return content.replaceAll("<mergeFactor>\\{\\{" + variableName + "\\}\\}</mergeFactor>", "<mergePolicyFactory class=\"org.apache.solr.index.TieredMergePolicyFactory\">\n      <int name=\"maxMergeAtOnce\">{{" + variableName + "}}</int>\n      <int name=\"segmentsPerTier\">{{" + variableName + "}}</int>\n    </mergePolicyFactory>");
    }

    protected String updateInfraSolrEnv(String content) {
        return content.replaceAll("SOLR_KERB_NAME_RULES=\".*\"", "").replaceAll("#*SOLR_HOST=\".*\"", "SOLR_HOST=`hostname -f`").replaceAll("SOLR_AUTHENTICATION_CLIENT_CONFIGURER=\".*\"", "SOLR_AUTH_TYPE=\"kerberos\"");
    }

    protected void updateAmsConfigs() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = clusters.getClusters()) != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                Map<String, String> oldAmsSite;
                HashMap<String, String> newProperties = new HashMap<String, String>();
                LOG.info("Updating ams-site:timeline.metrics.service.default.result.limit to 5760");
                newProperties.put("timeline.metrics.service.default.result.limit", "5760");
                Config config = cluster.getDesiredConfigByType("ams-site");
                if (config != null && MapUtils.isNotEmpty(oldAmsSite = config.getProperties())) {
                    String topnDownsamplerMetricPatternsKey;
                    if (oldAmsSite.containsKey("timeline.container-metrics.ttl")) {
                        try {
                            int oldTtl = Integer.parseInt(oldAmsSite.get("timeline.container-metrics.ttl"));
                            if (oldTtl > 1209600) {
                                LOG.info("Updating ams-site:timeline.container-metrics.ttl to 1209600");
                                newProperties.put("timeline.container-metrics.ttl", "1209600");
                            }
                        }
                        catch (Exception e) {
                            LOG.warn("Error updating Container metrics TTL for ams-site (AMBARI_METRICS)");
                        }
                    }
                    if (oldAmsSite.containsKey(topnDownsamplerMetricPatternsKey = "timeline.metrics.downsampler.topn.metric.patterns") && StringUtils.isNotEmpty((String)oldAmsSite.get(topnDownsamplerMetricPatternsKey))) {
                        LOG.info("Updating ams-site:timeline.metrics.downsampler.topn.metric.patterns to empty.");
                        newProperties.put(topnDownsamplerMetricPatternsKey, "");
                    }
                }
                LOG.info("Removing ams-site host and aggregate cluster split points.");
                HashSet removeProperties = Sets.newHashSet((Object[])new String[]{"timeline.metrics.host.aggregate.splitpoints", "timeline.metrics.cluster.aggregate.splitpoints"});
                this.updateConfigurationPropertiesForCluster(cluster, "ams-site", newProperties, removeProperties, true, true);
                HashMap<String, String> newAmsHbaseSiteProperties = new HashMap<String, String>();
                Config amsHBasiteSiteConfig = cluster.getDesiredConfigByType("ams-hbase-site");
                if (amsHBasiteSiteConfig == null) continue;
                Map<String, String> oldAmsHBaseSite = amsHBasiteSiteConfig.getProperties();
                if (MapUtils.isNotEmpty(oldAmsHBaseSite) && oldAmsHBaseSite.containsKey("hbase.snapshot.enabled")) {
                    try {
                        Boolean hbaseSnapshotEnabled = Boolean.valueOf(oldAmsHBaseSite.get("hbase.snapshot.enabled"));
                        if (!hbaseSnapshotEnabled.booleanValue()) {
                            LOG.info("Updating ams-hbase-site:hbase.snapshot.enabled to true");
                            newAmsHbaseSiteProperties.put("hbase.snapshot.enabled", "true");
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Error updating ams-hbase-site:hbase.snapshot.enabled (AMBARI_METRICS)");
                    }
                }
                this.updateConfigurationPropertiesForCluster(cluster, "ams-hbase-site", newAmsHbaseSiteProperties, true, true);
            }
        }
    }

    protected void updateStormConfigs() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = clusters.getClusters()) != null && !clusterMap.isEmpty()) {
            HashSet removeProperties = Sets.newHashSet((Object[])new String[]{"_storm.thrift.nonsecure.transport", "_storm.thrift.secure.transport"});
            String stormSecurityClassKey = "storm.thrift.transport";
            String stormSecurityClassValue = "org.apache.storm.security.auth.SimpleTransportPlugin";
            String stormSite = "storm-site";
            for (Cluster cluster : clusterMap.values()) {
                Map<String, String> stormSiteProperties;
                Config config = cluster.getDesiredConfigByType(stormSite);
                if (config == null || !(stormSiteProperties = config.getProperties()).containsKey(stormSecurityClassKey)) continue;
                LOG.info("Updating " + stormSecurityClassKey);
                if (cluster.getSecurityType() == SecurityType.KERBEROS) {
                    stormSecurityClassValue = "org.apache.storm.security.auth.kerberos.KerberosSaslTransportPlugin";
                }
                Map<String, String> updateProperty = Collections.singletonMap(stormSecurityClassKey, stormSecurityClassValue);
                this.updateConfigurationPropertiesForCluster(cluster, stormSite, updateProperty, removeProperties, true, false);
            }
        }
    }

    protected void clearHadoopMetrics2Content() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = clusters.getClusters()) != null && !clusterMap.isEmpty()) {
            String hadoopMetrics2ContentProperty = "content";
            String hadoopMetrics2ContentValue = "";
            String hadoopMetrics2ConfigType = "hadoop-metrics2.properties";
            for (Cluster cluster : clusterMap.values()) {
                Map<String, String> hadoopMetrics2Configs;
                Config config = cluster.getDesiredConfigByType(hadoopMetrics2ConfigType);
                if (config == null || !(hadoopMetrics2Configs = config.getProperties()).containsKey(hadoopMetrics2ContentProperty)) continue;
                LOG.info("Updating " + hadoopMetrics2ContentProperty);
                Map<String, String> updateProperty = Collections.singletonMap(hadoopMetrics2ContentProperty, hadoopMetrics2ContentValue);
                this.updateConfigurationPropertiesForCluster(cluster, hadoopMetrics2ConfigType, updateProperty, Collections.EMPTY_SET, true, false);
            }
        }
    }
}

