/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import java.sql.SQLException;
import java.util.Map;

public class UpgradeCatalog262
extends AbstractUpgradeCatalog {
    private static final String HOST_REQUEST_TABLE = "topology_host_request";
    private static final String STATUS_COLUMN = "status";
    private static final String STATUS_MESSAGE_COLUMN = "status_message";

    @Inject
    public UpgradeCatalog262(Injector injector) {
        super(injector);
    }

    @Override
    public String getSourceVersion() {
        return "2.6.1";
    }

    @Override
    public String getTargetVersion() {
        return "2.6.2";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
        this.addHostRequestStatusColumn();
    }

    private void addHostRequestStatusColumn() throws SQLException {
        this.dbAccessor.addColumn(HOST_REQUEST_TABLE, new DBAccessor.DBColumnInfo(STATUS_COLUMN, String.class, (Integer)255, null, true));
        this.dbAccessor.addColumn(HOST_REQUEST_TABLE, new DBAccessor.DBColumnInfo(STATUS_MESSAGE_COLUMN, String.class, (Integer)1024, null, true));
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
        this.fixDesiredStack();
    }

    private void fixDesiredStack() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = this.getCheckedClusterMap(clusters)) != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                StackId currentStack;
                StackId desiredStack = cluster.getDesiredStackVersion();
                if (desiredStack.equals(currentStack = cluster.getCurrentStackVersion())) continue;
                cluster.setDesiredStackVersion(currentStack);
            }
        }
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
    }
}

