/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog261
extends AbstractUpgradeCatalog {
    private static final String CORE_SITE = "core-site";
    private static final String COMPRESSION_CODECS_PROPERTY = "io.compression.codecs";
    private static final String COMPRESSION_CODECS_LZO = "com.hadoop.compression.lzo";
    private static final String LZO_ENABLED_JSON_KEY = "lzo_enabled";
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog261.class);

    @Inject
    public UpgradeCatalog261(Injector injector) {
        super(injector);
    }

    @Override
    public String getSourceVersion() {
        return "2.6.0";
    }

    @Override
    public String getTargetVersion() {
        return "2.6.1";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
        this.getUpgradeJsonOutput().put(LZO_ENABLED_JSON_KEY, this.isLzoEnabled().toString());
    }

    protected Boolean isLzoEnabled() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = this.getCheckedClusterMap(clusters)) != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                String compressionCodecs;
                Map<String, String> coreSiteProperties;
                Config coreSite = cluster.getDesiredConfigByType(CORE_SITE);
                if (coreSite == null || !(coreSiteProperties = coreSite.getProperties()).containsKey(COMPRESSION_CODECS_PROPERTY) || !(compressionCodecs = coreSiteProperties.get(COMPRESSION_CODECS_PROPERTY)).contains(COMPRESSION_CODECS_LZO)) continue;
                return true;
            }
        }
        return false;
    }
}

