/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.dao.ArtifactDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.ArtifactEntity;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosKeytabDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosPrincipalDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog260
extends AbstractUpgradeCatalog {
    public static final String CLUSTER_CONFIG_MAPPING_TABLE = "clusterconfigmapping";
    public static final String CLUSTER_VERSION_TABLE = "cluster_version";
    public static final String CLUSTER_ID_COLUMN = "cluster_id";
    public static final String STATE_COLUMN = "state";
    public static final String CREATE_TIMESTAMP_COLUMN = "create_timestamp";
    public static final String VERSION_TAG_COLUMN = "version_tag";
    public static final String TYPE_NAME_COLUMN = "type_name";
    public static final String CLUSTER_CONFIG_TABLE = "clusterconfig";
    public static final String SELECTED_COLUMN = "selected";
    public static final String SERVICE_DELETED_COLUMN = "service_deleted";
    public static final String UNMAPPED_COLUMN = "unmapped";
    public static final String SELECTED_TIMESTAMP_COLUMN = "selected_timestamp";
    public static final String SERVICE_COMPONENT_DESIRED_STATE_TABLE = "servicecomponentdesiredstate";
    public static final String DESIRED_STACK_ID_COLUMN = "desired_stack_id";
    public static final String DESIRED_VERSION_COLUMN = "desired_version";
    public static final String DESIRED_REPO_VERSION_ID_COLUMN = "desired_repo_version_id";
    public static final String REPO_STATE_COLUMN = "repo_state";
    public static final String FK_SCDS_DESIRED_STACK_ID = "FK_scds_desired_stack_id";
    public static final String FK_SERVICECOMPONENTDESIREDSTATE_DESIRED_STACK_ID = "FK_servicecomponentdesiredstate_desired_stack_id";
    public static final String FK_SCDS_DESIRED_REPO_ID = "FK_scds_desired_repo_id";
    public static final String REPO_VERSION_TABLE = "repo_version";
    public static final String REPO_VERSION_ID_COLUMN = "repo_version_id";
    public static final String REPO_VERSION_RESOLVED_COLUMN = "resolved";
    public static final String REPO_VERSION_HIDDEN_COLUMN = "hidden";
    public static final String REPO_VERSION_LEGACY_COLUMN = "legacy";
    public static final String HOST_COMPONENT_DESIRED_STATE_TABLE = "hostcomponentdesiredstate";
    public static final String FK_HCDS_DESIRED_STACK_ID = "FK_hcds_desired_stack_id";
    public static final String HOST_COMPONENT_STATE_TABLE = "hostcomponentstate";
    public static final String CURRENT_STACK_ID_COLUMN = "current_stack_id";
    public static final String FK_HCS_CURRENT_STACK_ID = "FK_hcs_current_stack_id";
    public static final String HOST_VERSION_TABLE = "host_version";
    public static final String UQ_HOST_REPO = "UQ_host_repo";
    public static final String HOST_ID_COLUMN = "host_id";
    public static final String SERVICE_DESIRED_STATE_TABLE = "servicedesiredstate";
    public static final String FK_SDS_DESIRED_STACK_ID = "FK_sds_desired_stack_id";
    public static final String FK_REPO_VERSION_ID = "FK_repo_version_id";
    public static final String CLUSTERS_TABLE = "clusters";
    public static final String UPGRADE_TABLE = "upgrade";
    public static final String UPGRADE_GROUP_TABLE = "upgrade_group";
    public static final String UPGRADE_ITEM_TABLE = "upgrade_item";
    public static final String FROM_REPO_VERSION_ID_COLUMN = "from_repo_version_id";
    public static final String TO_REPO_VERSION_ID_COLUMN = "to_repo_version_id";
    public static final String ORCHESTRATION_COLUMN = "orchestration";
    public static final String ALLOW_REVERT_COLUMN = "revert_allowed";
    public static final String FK_UPGRADE_FROM_REPO_ID = "FK_upgrade_from_repo_id";
    public static final String FK_UPGRADE_TO_REPO_ID = "FK_upgrade_to_repo_id";
    public static final String FK_UPGRADE_REPO_VERSION_ID = "FK_upgrade_repo_version_id";
    public static final String UPGRADE_ITEM_ITEM_TEXT = "item_text";
    public static final String SERVICE_COMPONENT_HISTORY_TABLE = "servicecomponent_history";
    public static final String UPGRADE_HISTORY_TABLE = "upgrade_history";
    public static final String ID_COLUMN = "id";
    public static final String UPGRADE_ID_COLUMN = "upgrade_id";
    public static final String SERVICE_NAME_COLUMN = "service_name";
    public static final String COMPONENT_NAME_COLUMN = "component_name";
    public static final String TARGET_REPO_VERSION_ID_COLUMN = "target_repo_version_id";
    public static final String PK_UPGRADE_HIST = "PK_upgrade_hist";
    public static final String FK_UPGRADE_HIST_UPGRADE_ID = "FK_upgrade_hist_upgrade_id";
    public static final String FK_UPGRADE_HIST_FROM_REPO = "FK_upgrade_hist_from_repo";
    public static final String FK_UPGRADE_HIST_TARGET_REPO = "FK_upgrade_hist_target_repo";
    public static final String UQ_UPGRADE_HIST = "UQ_upgrade_hist";
    public static final String SERVICE_CONFIG_MAPPING_TABLE = "serviceconfigmapping";
    public static final String SERVICE_COMPONENT_DESIRED_STATE = "servicecomponentdesiredstate";
    public static final String HOST_COMPONENT_DESIRED_STATE = "hostcomponentdesiredstate";
    public static final String HOST_COMPONENT_STATE = "hostcomponentstate";
    private static final String CORE_SITE = "core-site";
    public static final String AMS_SSL_CLIENT = "ams-ssl-client";
    public static final String METRIC_TRUSTSTORE_ALIAS = "ssl.client.truststore.alias";
    private static final String HIVE_INTERACTIVE_SITE = "hive-interactive-site";
    public static final String HIVE_LLAP_DAEMON_KEYTAB_FILE = "hive.llap.daemon.keytab.file";
    public static final String HIVE_LLAP_ZK_SM_KEYTAB_FILE = "hive.llap.zk.sm.keytab.file";
    public static final String HIVE_LLAP_TASK_KEYTAB_FILE = "hive.llap.task.keytab.file";
    public static final String HIVE_SERVER_KERBEROS_PREFIX = "/HIVE/HIVE_SERVER/";
    public static final String YARN_LLAP_ZK_HIVE_KERBEROS_IDENTITY = "llap_zk_hive";
    public static final String YARN_LLAP_TASK_HIVE_KERBEROS_IDENTITY = "llap_task_hive";
    public static final String HIVE_SERVER_HIVE_KERBEROS_IDENTITY = "hive_server_hive";
    private List<String> yarnKerberosDescUpdatedList = new ArrayList<String>();
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog260.class);
    public static final String STANDARD = "STANDARD";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String CURRENT = "CURRENT";
    public static final String SELECTED = "1";
    public static final String VIEWURL_TABLE = "viewurl";
    public static final String VIEWINSTANCE_TABLE = "viewinstance";
    public static final String PK_VIEWURL = "PK_viewurl";
    public static final String URL_ID_COLUMN = "url_id";
    public static final String STALE_POSTGRESS_VIEWURL_PKEY = "viewurl_pkey";
    public static final String USERS_TABLE = "users";
    public static final String STALE_POSTGRESS_USERS_LDAP_USER_KEY = "users_ldap_user_key";
    public static final String SHORT_URL_COLUMN = "short_url";
    public static final String FK_INSTANCE_URL_ID = "FK_instance_url_id";
    public static final String FK_SERVICEDESIREDSTATE_DESIRED_STACK_ID = "FK_servicedesiredstate_desired_stack_id";
    public static final String FK_HOSTCOMPONENTDESIREDSTATE_DESIRED_STACK_ID = "FK_hostcomponentdesiredstate_desired_stack_id";
    public static final String FK_HOSTCOMPONENTSTATE_CURRENT_STACK_ID = "FK_hostcomponentstate_current_stack_id";
    public static final String FK_UPGRADE_FROM_REPO_VERSION_ID = "FK_upgrade_from_repo_version_id";
    public static final String FK_UPGRADE_TO_REPO_VERSION_ID = "FK_upgrade_to_repo_version_id";

    @Inject
    public UpgradeCatalog260(Injector injector) {
        super(injector);
    }

    @Override
    public String getSourceVersion() {
        return "2.5.2";
    }

    @Override
    public String getTargetVersion() {
        return "2.6.0";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
        Integer currentVersionID = this.getCurrentVersionID();
        this.dropBrokenFK();
        this.updateServiceComponentDesiredStateTable(currentVersionID);
        this.updateServiceDesiredStateTable(currentVersionID);
        this.addSelectedCollumsToClusterconfigTable();
        this.updateHostComponentDesiredStateTable();
        this.updateHostComponentStateTable();
        this.dropStaleTables();
        this.updateUpgradeTable();
        this.createUpgradeHistoryTable();
        this.updateRepositoryVersionTable();
        this.renameServiceDeletedColumn();
        this.addLegacyColumn();
        this.expandUpgradeItemItemTextColumn();
        this.addViewUrlPKConstraint();
        this.removeStaleConstraints();
    }

    private void dropBrokenFK() throws SQLException {
        this.dbAccessor.dropFKConstraint(UPGRADE_TABLE, FK_UPGRADE_FROM_REPO_VERSION_ID);
        this.dbAccessor.dropFKConstraint(UPGRADE_TABLE, FK_UPGRADE_TO_REPO_VERSION_ID);
        this.dbAccessor.dropFKConstraint("servicecomponentdesiredstate", FK_SERVICECOMPONENTDESIREDSTATE_DESIRED_STACK_ID);
        this.dbAccessor.dropFKConstraint(SERVICE_DESIRED_STATE_TABLE, FK_SERVICEDESIREDSTATE_DESIRED_STACK_ID);
        this.dbAccessor.dropFKConstraint("hostcomponentdesiredstate", FK_HOSTCOMPONENTDESIREDSTATE_DESIRED_STACK_ID);
        this.dbAccessor.dropFKConstraint("hostcomponentstate", FK_HOSTCOMPONENTSTATE_CURRENT_STACK_ID);
    }

    private void addViewUrlPKConstraint() throws SQLException {
        this.dbAccessor.dropFKConstraint(VIEWINSTANCE_TABLE, FK_INSTANCE_URL_ID);
        this.dbAccessor.dropPKConstraint(VIEWURL_TABLE, STALE_POSTGRESS_VIEWURL_PKEY);
        this.dbAccessor.addPKConstraint(VIEWURL_TABLE, PK_VIEWURL, URL_ID_COLUMN);
        this.dbAccessor.addFKConstraint(VIEWINSTANCE_TABLE, FK_INSTANCE_URL_ID, SHORT_URL_COLUMN, VIEWURL_TABLE, URL_ID_COLUMN, false);
    }

    private void removeStaleConstraints() throws SQLException {
        this.dbAccessor.dropUniqueConstraint(USERS_TABLE, STALE_POSTGRESS_USERS_LDAP_USER_KEY);
    }

    private void expandUpgradeItemItemTextColumn() throws SQLException {
        this.dbAccessor.changeColumnType(UPGRADE_ITEM_TABLE, UPGRADE_ITEM_ITEM_TEXT, String.class, char[].class);
    }

    private void addLegacyColumn() throws OBDPException, SQLException {
        Boolean isLegacyColumnExists = this.dbAccessor.tableHasColumn(REPO_VERSION_TABLE, REPO_VERSION_LEGACY_COLUMN);
        if (!isLegacyColumnExists.booleanValue()) {
            DBAccessor.DBColumnInfo legacyColumn = new DBAccessor.DBColumnInfo(REPO_VERSION_LEGACY_COLUMN, Short.class, null, (Object)1, false);
            this.dbAccessor.addColumn(REPO_VERSION_TABLE, legacyColumn);
            legacyColumn.setDefaultValue(0);
            this.dbAccessor.alterColumn(REPO_VERSION_TABLE, legacyColumn);
        }
    }

    private void renameServiceDeletedColumn() throws OBDPException, SQLException {
        if (this.dbAccessor.tableHasColumn(CLUSTER_CONFIG_TABLE, SERVICE_DELETED_COLUMN)) {
            this.dbAccessor.renameColumn(CLUSTER_CONFIG_TABLE, SERVICE_DELETED_COLUMN, new DBAccessor.DBColumnInfo(UNMAPPED_COLUMN, Short.class, null, (Object)0, false));
        }
    }

    private void setUnmappedForOrphanedConfigs() {
        this.executeInTransaction(new Runnable(){

            @Override
            public void run() {
                EntityManager entityManager = (EntityManager)UpgradeCatalog260.this.getEntityManagerProvider().get();
                TypedQuery query = entityManager.createNamedQuery("ClusterConfigEntity.findNotMappedClusterConfigsToService", ClusterConfigEntity.class);
                List notMappedConfigs = query.getResultList();
                if (notMappedConfigs != null) {
                    for (ClusterConfigEntity clusterConfigEntity : notMappedConfigs) {
                        clusterConfigEntity.setUnmapped(true);
                        entityManager.merge((Object)clusterConfigEntity);
                    }
                }
            }
        });
    }

    private void createUpgradeHistoryTable() throws SQLException {
        ArrayList<DBAccessor.DBColumnInfo> columns = new ArrayList<DBAccessor.DBColumnInfo>();
        columns.add(new DBAccessor.DBColumnInfo(ID_COLUMN, Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo(UPGRADE_ID_COLUMN, Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo(SERVICE_NAME_COLUMN, String.class, (Integer)255, null, false));
        columns.add(new DBAccessor.DBColumnInfo(COMPONENT_NAME_COLUMN, String.class, (Integer)255, null, false));
        columns.add(new DBAccessor.DBColumnInfo(FROM_REPO_VERSION_ID_COLUMN, Long.class, null, null, false));
        columns.add(new DBAccessor.DBColumnInfo(TARGET_REPO_VERSION_ID_COLUMN, Long.class, null, null, false));
        this.dbAccessor.createTable(UPGRADE_HISTORY_TABLE, columns, new String[0]);
        this.dbAccessor.addPKConstraint(UPGRADE_HISTORY_TABLE, PK_UPGRADE_HIST, ID_COLUMN);
        this.dbAccessor.addFKConstraint(UPGRADE_HISTORY_TABLE, FK_UPGRADE_HIST_UPGRADE_ID, UPGRADE_ID_COLUMN, UPGRADE_TABLE, UPGRADE_ID_COLUMN, false);
        this.dbAccessor.addFKConstraint(UPGRADE_HISTORY_TABLE, FK_UPGRADE_HIST_FROM_REPO, FROM_REPO_VERSION_ID_COLUMN, REPO_VERSION_TABLE, REPO_VERSION_ID_COLUMN, false);
        this.dbAccessor.addFKConstraint(UPGRADE_HISTORY_TABLE, FK_UPGRADE_HIST_TARGET_REPO, TARGET_REPO_VERSION_ID_COLUMN, REPO_VERSION_TABLE, REPO_VERSION_ID_COLUMN, false);
        this.dbAccessor.addUniqueConstraint(UPGRADE_HISTORY_TABLE, UQ_UPGRADE_HIST, UPGRADE_ID_COLUMN, COMPONENT_NAME_COLUMN, SERVICE_NAME_COLUMN);
        this.addSequence("upgrade_history_id_seq", 0L, false);
    }

    private void updateUpgradeTable() throws SQLException {
        this.dbAccessor.clearTableColumn(CLUSTERS_TABLE, UPGRADE_ID_COLUMN, null);
        this.dbAccessor.clearTable(UPGRADE_ITEM_TABLE);
        this.dbAccessor.clearTable(UPGRADE_GROUP_TABLE);
        this.dbAccessor.clearTable(UPGRADE_TABLE);
        this.dbAccessor.dropFKConstraint(UPGRADE_TABLE, FK_UPGRADE_FROM_REPO_ID);
        this.dbAccessor.dropFKConstraint(UPGRADE_TABLE, FK_UPGRADE_TO_REPO_ID);
        this.dbAccessor.dropColumn(UPGRADE_TABLE, FROM_REPO_VERSION_ID_COLUMN);
        this.dbAccessor.dropColumn(UPGRADE_TABLE, TO_REPO_VERSION_ID_COLUMN);
        this.dbAccessor.addColumn(UPGRADE_TABLE, new DBAccessor.DBColumnInfo(REPO_VERSION_ID_COLUMN, Long.class, null, null, false));
        this.dbAccessor.addColumn(UPGRADE_TABLE, new DBAccessor.DBColumnInfo(ORCHESTRATION_COLUMN, String.class, (Integer)255, (Object)STANDARD, false));
        this.dbAccessor.addColumn(UPGRADE_TABLE, new DBAccessor.DBColumnInfo(ALLOW_REVERT_COLUMN, Short.class, null, (Object)0, false));
        this.dbAccessor.addFKConstraint(UPGRADE_TABLE, FK_UPGRADE_REPO_VERSION_ID, REPO_VERSION_ID_COLUMN, REPO_VERSION_TABLE, REPO_VERSION_ID_COLUMN, false);
    }

    private void updateServiceDesiredStateTable(Integer currentRepoID) throws SQLException {
        this.dbAccessor.addColumn(SERVICE_DESIRED_STATE_TABLE, new DBAccessor.DBColumnInfo(DESIRED_REPO_VERSION_ID_COLUMN, Long.class, null, (Object)currentRepoID, false));
        this.dbAccessor.alterColumn(SERVICE_DESIRED_STATE_TABLE, new DBAccessor.DBColumnInfo(DESIRED_REPO_VERSION_ID_COLUMN, Long.class, null, null, false));
        this.dbAccessor.addFKConstraint(SERVICE_DESIRED_STATE_TABLE, FK_REPO_VERSION_ID, DESIRED_REPO_VERSION_ID_COLUMN, REPO_VERSION_TABLE, REPO_VERSION_ID_COLUMN, false);
        this.dbAccessor.dropFKConstraint(SERVICE_DESIRED_STATE_TABLE, FK_SDS_DESIRED_STACK_ID);
        this.dbAccessor.dropColumn(SERVICE_DESIRED_STATE_TABLE, DESIRED_STACK_ID_COLUMN);
    }

    private void dropStaleTables() throws SQLException {
        this.dbAccessor.dropTable(CLUSTER_CONFIG_MAPPING_TABLE);
        this.dbAccessor.dropTable(CLUSTER_VERSION_TABLE);
        this.dbAccessor.dropTable(SERVICE_COMPONENT_HISTORY_TABLE);
    }

    private void addSelectedCollumsToClusterconfigTable() throws SQLException {
        DBAccessor.DBColumnInfo selectedColumnInfo = new DBAccessor.DBColumnInfo(SELECTED_COLUMN, Short.class, null, (Object)0, false);
        DBAccessor.DBColumnInfo selectedmappingColumnInfo = new DBAccessor.DBColumnInfo(SELECTED_COLUMN, Integer.class, null, (Object)0, false);
        DBAccessor.DBColumnInfo selectedTimestampColumnInfo = new DBAccessor.DBColumnInfo(SELECTED_TIMESTAMP_COLUMN, Long.class, null, (Object)0, false);
        DBAccessor.DBColumnInfo createTimestampColumnInfo = new DBAccessor.DBColumnInfo(CREATE_TIMESTAMP_COLUMN, Long.class, null, null, false);
        this.dbAccessor.copyColumnToAnotherTable(CLUSTER_CONFIG_MAPPING_TABLE, selectedmappingColumnInfo, CLUSTER_ID_COLUMN, TYPE_NAME_COLUMN, VERSION_TAG_COLUMN, CLUSTER_CONFIG_TABLE, selectedColumnInfo, CLUSTER_ID_COLUMN, TYPE_NAME_COLUMN, VERSION_TAG_COLUMN, SELECTED_COLUMN, SELECTED, 0);
        this.dbAccessor.copyColumnToAnotherTable(CLUSTER_CONFIG_MAPPING_TABLE, createTimestampColumnInfo, CLUSTER_ID_COLUMN, TYPE_NAME_COLUMN, VERSION_TAG_COLUMN, CLUSTER_CONFIG_TABLE, selectedTimestampColumnInfo, CLUSTER_ID_COLUMN, TYPE_NAME_COLUMN, VERSION_TAG_COLUMN, SELECTED_COLUMN, SELECTED, 0);
    }

    private void updateServiceComponentDesiredStateTable(Integer currentRepoID) throws SQLException {
        this.dbAccessor.addColumn("servicecomponentdesiredstate", new DBAccessor.DBColumnInfo(DESIRED_REPO_VERSION_ID_COLUMN, Long.class, null, (Object)currentRepoID, false));
        this.dbAccessor.alterColumn("servicecomponentdesiredstate", new DBAccessor.DBColumnInfo(DESIRED_REPO_VERSION_ID_COLUMN, Long.class, null, null, false));
        this.dbAccessor.addColumn("servicecomponentdesiredstate", new DBAccessor.DBColumnInfo(REPO_STATE_COLUMN, String.class, (Integer)255, (Object)CURRENT, false));
        this.dbAccessor.alterColumn("servicecomponentdesiredstate", new DBAccessor.DBColumnInfo(REPO_STATE_COLUMN, String.class, (Integer)255, (Object)NOT_REQUIRED, false));
        this.dbAccessor.addFKConstraint("servicecomponentdesiredstate", FK_SCDS_DESIRED_REPO_ID, DESIRED_REPO_VERSION_ID_COLUMN, REPO_VERSION_TABLE, REPO_VERSION_ID_COLUMN, false);
        this.dbAccessor.dropFKConstraint("servicecomponentdesiredstate", FK_SCDS_DESIRED_STACK_ID);
        this.dbAccessor.dropColumn("servicecomponentdesiredstate", DESIRED_STACK_ID_COLUMN);
        this.dbAccessor.dropColumn("servicecomponentdesiredstate", DESIRED_VERSION_COLUMN);
    }

    private void updateHostComponentDesiredStateTable() throws SQLException {
        this.dbAccessor.dropFKConstraint("hostcomponentdesiredstate", FK_HCDS_DESIRED_STACK_ID);
        this.dbAccessor.dropColumn("hostcomponentdesiredstate", DESIRED_STACK_ID_COLUMN);
    }

    private void updateHostComponentStateTable() throws SQLException {
        this.dbAccessor.dropFKConstraint("hostcomponentstate", FK_HCS_CURRENT_STACK_ID);
        this.dbAccessor.dropColumn("hostcomponentstate", CURRENT_STACK_ID_COLUMN);
    }

    private void updateRepositoryVersionTable() throws SQLException {
        this.dbAccessor.addColumn(REPO_VERSION_TABLE, new DBAccessor.DBColumnInfo(REPO_VERSION_HIDDEN_COLUMN, Short.class, null, (Object)0, false));
        this.dbAccessor.addColumn(REPO_VERSION_TABLE, new DBAccessor.DBColumnInfo(REPO_VERSION_RESOLVED_COLUMN, Short.class, null, (Object)0, false));
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
        this.removeSupersetFromDruid();
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
        this.addNewConfigurationsFromXml();
        this.setUnmappedForOrphanedConfigs();
        this.ensureZeppelinProxyUserConfigs();
        this.updateKerberosDescriptorArtifacts();
        this.updateAmsConfigs();
        this.updateHiveConfigs();
        this.updateHDFSWidgetDefinition();
        this.updateExistingRepositoriesToBeResolved();
    }

    public Integer getCurrentVersionID() throws OBDPException, SQLException {
        if (!this.dbAccessor.tableExists(CLUSTER_VERSION_TABLE)) {
            return null;
        }
        List<Integer> currentVersionList = this.dbAccessor.getIntColumnValues(CLUSTER_VERSION_TABLE, REPO_VERSION_ID_COLUMN, new String[]{STATE_COLUMN}, new String[]{CURRENT}, false);
        if (currentVersionList.isEmpty()) {
            List<Integer> allVersionList = this.dbAccessor.getIntColumnValues(CLUSTER_VERSION_TABLE, REPO_VERSION_ID_COLUMN, null, null, false);
            if (allVersionList.isEmpty()) {
                return null;
            }
            throw new OBDPException("Unable to find any CURRENT repositories.");
        }
        if (currentVersionList.size() != 1) {
            throw new OBDPException("The following repositories were found to be CURRENT: ".concat(StringUtils.join(currentVersionList, (String)",")));
        }
        return currentVersionList.get(0);
    }

    protected void removeSupersetFromDruid() throws SQLException {
        this.removeComponent("DRUID_SUPERSET", "druid-superset");
    }

    private void removeComponent(String componentName, String configPrefix) throws SQLException {
        String serviceConfigMappingRemoveSQL = String.format("DELETE FROM %s WHERE config_id IN (SELECT config_id from %s where type_name like '%s%%')", SERVICE_CONFIG_MAPPING_TABLE, CLUSTER_CONFIG_TABLE, configPrefix);
        String supersetConfigRemoveSQL = String.format("DELETE FROM %s WHERE type_name like '%s%%'", CLUSTER_CONFIG_TABLE, configPrefix);
        String hostComponentDesiredStateRemoveSQL = String.format("DELETE FROM %s WHERE component_name = '%s'", "hostcomponentdesiredstate", componentName);
        String hostComponentStateRemoveSQL = String.format("DELETE FROM %s WHERE component_name = '%s'", "hostcomponentstate", componentName);
        String serviceComponentDesiredStateRemoveSQL = String.format("DELETE FROM %s WHERE component_name = '%s'", "servicecomponentdesiredstate", componentName);
        this.dbAccessor.executeQuery(serviceConfigMappingRemoveSQL);
        this.dbAccessor.executeQuery(supersetConfigRemoveSQL);
        this.dbAccessor.executeQuery(hostComponentDesiredStateRemoveSQL);
        this.dbAccessor.executeQuery(hostComponentStateRemoveSQL);
        this.dbAccessor.executeQuery(serviceComponentDesiredStateRemoveSQL);
    }

    void ensureZeppelinProxyUserConfigs() throws OBDPException {
        Clusters clusters = (Clusters)this.injector.getInstance(Clusters.class);
        Map<String, Cluster> clusterMap = this.getCheckedClusterMap(clusters);
        if (clusterMap != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                Config coreSiteConfig;
                Config zeppelinEnvConfig = cluster.getDesiredConfigByType("zeppelin-env");
                if (zeppelinEnvConfig == null) continue;
                Map<String, String> zeppelinEnvProperties = zeppelinEnvConfig.getProperties();
                String zeppelinUser = null;
                if (zeppelinEnvProperties != null) {
                    zeppelinUser = zeppelinEnvProperties.get("zeppelin_user");
                }
                if (StringUtils.isEmpty(zeppelinUser) || (coreSiteConfig = cluster.getDesiredConfigByType(CORE_SITE)) == null) continue;
                String proxyUserHostsName = String.format("hadoop.proxyuser.%s.hosts", zeppelinUser);
                String proxyUserGroupsName = String.format("hadoop.proxyuser.%s.groups", zeppelinUser);
                HashMap<String, String> proxyUserProperties = new HashMap<String, String>();
                proxyUserProperties.put(proxyUserHostsName, "*");
                proxyUserProperties.put(proxyUserGroupsName, "*");
                Map<String, String> coreSiteConfigProperties = coreSiteConfig.getProperties();
                if (coreSiteConfigProperties != null) {
                    if (coreSiteConfigProperties.containsKey(proxyUserHostsName)) {
                        proxyUserProperties.remove(proxyUserHostsName);
                    }
                    if (coreSiteConfigProperties.containsKey(proxyUserGroupsName)) {
                        proxyUserProperties.remove(proxyUserGroupsName);
                    }
                }
                if (proxyUserProperties.isEmpty()) continue;
                this.updateConfigurationPropertiesForCluster(cluster, CORE_SITE, proxyUserProperties, true, false);
            }
        }
    }

    @Override
    protected void updateKerberosDescriptorArtifact(ArtifactDAO artifactDAO, ArtifactEntity artifactEntity) throws OBDPException {
        KerberosDescriptor kerberosDescriptor;
        Map<String, Object> data;
        if (artifactEntity != null && (data = artifactEntity.getArtifactData()) != null && (kerberosDescriptor = new KerberosDescriptorFactory().createInstance(data)) != null) {
            this.fixRangerKMSKerberosDescriptor(kerberosDescriptor);
            this.fixIdentityReferences(this.getCluster(artifactEntity), kerberosDescriptor);
            this.fixYarnHsiKerberosDescriptorAndSiteConfig(this.getCluster(artifactEntity), kerberosDescriptor);
            artifactEntity.setArtifactData(kerberosDescriptor.toMap());
            artifactDAO.merge(artifactEntity);
        }
    }

    protected void fixRangerKMSKerberosDescriptor(KerberosDescriptor kerberosDescriptor) {
        KerberosServiceDescriptor rangerKmsServiceDescriptor = kerberosDescriptor.getService("RANGER_KMS");
        if (rangerKmsServiceDescriptor != null) {
            KerberosIdentityDescriptor rangerKmsComponentIdentity;
            KerberosComponentDescriptor rangerKmscomponentDescriptor;
            KerberosIdentityDescriptor rangerKmsServiceIdentity = rangerKmsServiceDescriptor.getIdentity("/smokeuser");
            if (rangerKmsServiceIdentity != null) {
                rangerKmsServiceDescriptor.removeIdentity("/smokeuser");
            }
            if ((rangerKmscomponentDescriptor = rangerKmsServiceDescriptor.getComponent("RANGER_KMS_SERVER")) != null && (rangerKmsComponentIdentity = rangerKmscomponentDescriptor.getIdentity("/smokeuser")) != null) {
                rangerKmscomponentDescriptor.removeIdentity("/smokeuser");
            }
        }
    }

    protected void fixYarnHsiKerberosDescriptorAndSiteConfig(Cluster cluster, KerberosDescriptor kerberosDescriptor) {
        LOG.info("Updating YARN's HSI Kerberos Descriptor ....");
        KerberosServiceDescriptor hiveServiceDescriptor = kerberosDescriptor.getService("HIVE");
        KerberosIdentityDescriptor hsh_identityDescriptor = null;
        KerberosPrincipalDescriptor hsh_principalDescriptor = null;
        KerberosKeytabDescriptor hsh_keytabDescriptor = null;
        if (hiveServiceDescriptor != null) {
            KerberosComponentDescriptor yarnNmKerberosDescriptor;
            KerberosServiceDescriptor yarnServiceDescriptor;
            KerberosComponentDescriptor hiveServerKerberosDescriptor = hiveServiceDescriptor.getComponent("HIVE_SERVER");
            if (hiveServerKerberosDescriptor != null && (hsh_identityDescriptor = hiveServerKerberosDescriptor.getIdentity(HIVE_SERVER_HIVE_KERBEROS_IDENTITY)) != null) {
                LOG.info("  Retrieved HIVE->HIVE_SERVER kerberos descriptor. Name = " + hsh_identityDescriptor.getName());
                hsh_principalDescriptor = hsh_identityDescriptor.getPrincipalDescriptor();
                hsh_keytabDescriptor = hsh_identityDescriptor.getKeytabDescriptor();
            }
            if (hsh_principalDescriptor != null && hsh_keytabDescriptor != null && (yarnServiceDescriptor = kerberosDescriptor.getService("YARN")) != null && (yarnNmKerberosDescriptor = yarnServiceDescriptor.getComponent("NODEMANAGER")) != null) {
                String[] identities;
                for (String identity : identities = new String[]{YARN_LLAP_ZK_HIVE_KERBEROS_IDENTITY, YARN_LLAP_TASK_HIVE_KERBEROS_IDENTITY}) {
                    KerberosIdentityDescriptor identityDescriptor = yarnNmKerberosDescriptor.getIdentity(identity);
                    KerberosPrincipalDescriptor principalDescriptor = null;
                    KerberosKeytabDescriptor keytabDescriptor = null;
                    if (identityDescriptor == null) continue;
                    LOG.info("  Retrieved YARN->NODEMANAGER kerberos descriptor to be updated. Name = " + identityDescriptor.getName());
                    principalDescriptor = identityDescriptor.getPrincipalDescriptor();
                    keytabDescriptor = identityDescriptor.getKeytabDescriptor();
                    identityDescriptor.setReference(HIVE_SERVER_KERBEROS_PREFIX + hsh_identityDescriptor.getName());
                    LOG.info("    Updated 'llap_zk_hive' identity descriptor reference = '" + identityDescriptor.getReference() + "'");
                    principalDescriptor.setValue(null);
                    LOG.info("    Updated 'llap_zk_hive' principal descriptor value = '" + principalDescriptor.getValue() + "'");
                    keytabDescriptor.setFile(null);
                    LOG.info("    Updated 'llap_zk_hive' keytab descriptor file = '" + keytabDescriptor.getFile() + "'");
                    keytabDescriptor.setOwnerName(null);
                    LOG.info("    Updated 'llap_zk_hive' keytab descriptor owner name = '" + keytabDescriptor.getOwnerName() + "'");
                    keytabDescriptor.setOwnerAccess(null);
                    LOG.info("    Updated 'llap_zk_hive' keytab descriptor owner access = '" + keytabDescriptor.getOwnerAccess() + "'");
                    keytabDescriptor.setGroupName(null);
                    LOG.info("    Updated 'llap_zk_hive' keytab descriptor group name = '" + keytabDescriptor.getGroupName() + "'");
                    keytabDescriptor.setGroupAccess(null);
                    LOG.info("    Updated 'llap_zk_hive' keytab descriptor group access = '" + keytabDescriptor.getGroupAccess() + "'");
                    String[] splits = keytabDescriptor.getConfiguration().split("/");
                    if (splits.length != 2) continue;
                    this.updateYarnKerberosDescUpdatedList(splits[1]);
                    LOG.info("    Updated 'yarnKerberosDescUpdatedList' = " + this.getYarnKerberosDescUpdatedList());
                }
            }
        }
    }

    public void updateYarnKerberosDescUpdatedList(String val) {
        this.yarnKerberosDescUpdatedList.add(val);
    }

    public List<String> getYarnKerberosDescUpdatedList() {
        return this.yarnKerberosDescUpdatedList;
    }

    protected void updateHiveConfigs() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = this.getCheckedClusterMap(clusters)) != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                Map<String, String> hsiSiteConfigProperties;
                Config hsiSiteConfig = cluster.getDesiredConfigByType(HIVE_INTERACTIVE_SITE);
                if (hsiSiteConfig == null || (hsiSiteConfigProperties = hsiSiteConfig.getProperties()) == null || !hsiSiteConfigProperties.containsKey(HIVE_LLAP_DAEMON_KEYTAB_FILE)) continue;
                String[] identities = new String[]{HIVE_LLAP_ZK_SM_KEYTAB_FILE, HIVE_LLAP_TASK_KEYTAB_FILE};
                HashMap<String, String> newProperties = new HashMap<String, String>();
                for (String identity : identities) {
                    if (!this.getYarnKerberosDescUpdatedList().contains(identity) || !hsiSiteConfigProperties.containsKey(identity)) continue;
                    newProperties.put(identity, hsiSiteConfigProperties.get(HIVE_LLAP_DAEMON_KEYTAB_FILE));
                }
                if (newProperties.size() <= 0) continue;
                try {
                    this.updateConfigurationPropertiesForCluster(cluster, HIVE_INTERACTIVE_SITE, newProperties, true, false);
                    LOG.info("Updated HSI config(s) : " + newProperties.keySet() + " with value(s) = " + newProperties.values() + " respectively.");
                }
                catch (OBDPException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void updateAmsConfigs() throws OBDPException {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = this.getCheckedClusterMap(clusters)) != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                Map<String, String> amsSslClientProperties;
                Config amsSslClient = cluster.getDesiredConfigByType(AMS_SSL_CLIENT);
                if (amsSslClient == null || !(amsSslClientProperties = amsSslClient.getProperties()).containsKey(METRIC_TRUSTSTORE_ALIAS)) continue;
                LOG.info("Removing ssl.client.truststore.alias from ams-ssl-client");
                this.removeConfigurationPropertiesFromCluster(cluster, AMS_SSL_CLIENT, Collections.singleton(METRIC_TRUSTSTORE_ALIAS));
            }
        }
    }

    protected void updateHDFSWidgetDefinition() throws OBDPException {
        LOG.info("Updating HDFS widget definition.");
        HashMap<String, List<String>> widgetMap = new HashMap<String, List<String>>();
        HashMap<String, String> sectionLayoutMap = new HashMap<String, String>();
        ArrayList<String> hdfsHeatmapWidgets = new ArrayList<String>(Arrays.asList("HDFS Bytes Read", "HDFS Bytes Written", "DataNode Process Disk I/O Utilization", "DataNode Process Network I/O Utilization"));
        widgetMap.put("HDFS_HEATMAPS", hdfsHeatmapWidgets);
        sectionLayoutMap.put("HDFS_HEATMAPS", "default_hdfs_heatmap");
        this.updateWidgetDefinitionsForService("HDFS", widgetMap, sectionLayoutMap);
    }

    private Cluster getCluster(ArtifactEntity artifactEntity) {
        Map<String, String> keys;
        if (artifactEntity != null && (keys = artifactEntity.getForeignKeys()) != null) {
            String clusterId = keys.get("cluster");
            if (StringUtils.isNumeric((String)clusterId)) {
                Clusters clusters = (Clusters)this.injector.getInstance(Clusters.class);
                try {
                    return clusters.getCluster(Long.valueOf(clusterId));
                }
                catch (OBDPException e) {
                    LOG.error(String.format("Failed to obtain cluster using cluster id %s -  %s", clusterId, e.getMessage()), (Throwable)e);
                }
            } else {
                LOG.error(String.format("Failed to obtain cluster id from artifact entity with foreign keys: %s", keys));
            }
        }
        return null;
    }

    private void fixIdentityReferences(Cluster cluster, AbstractKerberosDescriptorContainer container) throws OBDPException {
        block7: {
            Map<String, KerberosComponentDescriptor> components;
            block6: {
                List<KerberosIdentityDescriptor> identities = container.getIdentities();
                if (identities != null) {
                    for (KerberosIdentityDescriptor identity : identities) {
                        String[] parts;
                        String referencedPrincipalName;
                        KerberosPrincipalDescriptor principal;
                        String identityReference;
                        String name = identity.getName();
                        if (!StringUtils.isEmpty((String)name) && (name.startsWith("/") || name.startsWith("./"))) {
                            String[] parts2 = name.split("/");
                            String newName = this.buildName(identity.getParent(), parts2[parts2.length - 1]);
                            identity.setName(newName);
                            identity.setReference(name);
                        }
                        if (StringUtils.isEmpty((String)(identityReference = identity.getReference())) || (principal = identity.getPrincipalDescriptor()) == null) continue;
                        principal.setValue(null);
                        if (StringUtils.isEmpty((String)principal.getConfiguration()) || StringUtils.isEmpty((String)(referencedPrincipalName = this.getConfiguredPrincipalNameFromReference(cluster, container, identityReference))) || (parts = principal.getConfiguration().split("/")).length != 2) continue;
                        String type = parts[0];
                        String property = parts[1];
                        this.updateConfigurationPropertiesForCluster(cluster, type, Collections.singletonMap(property, referencedPrincipalName), true, false);
                    }
                }
                if (!(container instanceof KerberosDescriptor)) break block6;
                Map<String, KerberosServiceDescriptor> services = ((KerberosDescriptor)container).getServices();
                if (services == null) break block7;
                for (KerberosServiceDescriptor serviceDescriptor : services.values()) {
                    this.fixIdentityReferences(cluster, serviceDescriptor);
                }
                break block7;
            }
            if (container instanceof KerberosServiceDescriptor && (components = ((KerberosServiceDescriptor)container).getComponents()) != null) {
                for (KerberosComponentDescriptor componentDescriptor : components.values()) {
                    this.fixIdentityReferences(cluster, componentDescriptor);
                }
            }
        }
    }

    private String getConfiguredPrincipalNameFromReference(Cluster cluster, AbstractKerberosDescriptorContainer container, String identityReference) throws OBDPException {
        String[] parts;
        KerberosPrincipalDescriptor principal;
        KerberosIdentityDescriptor identityDescriptor = container.getReferencedIdentityDescriptor(identityReference);
        if (identityDescriptor != null && (principal = identityDescriptor.getPrincipalDescriptor()) != null && !StringUtils.isEmpty((String)principal.getConfiguration()) && (parts = principal.getConfiguration().split("/")).length == 2) {
            String type = parts[0];
            String property = parts[1];
            Config config = cluster.getDesiredConfigByType(type);
            if (config != null) {
                return config.getProperties().get(property);
            }
        }
        return null;
    }

    private String buildName(AbstractKerberosDescriptor container, String identityName) {
        if (container instanceof KerberosServiceDescriptor) {
            return container.getName().toLowerCase() + "_" + identityName;
        }
        if (container instanceof KerberosComponentDescriptor) {
            return container.getParent().getName().toLowerCase() + "_" + container.getName().toLowerCase() + "_" + identityName;
        }
        return identityName;
    }

    protected void updateExistingRepositoriesToBeResolved() throws OBDPException {
        RepositoryVersionDAO repositoryVersionDAO = (RepositoryVersionDAO)this.injector.getInstance(RepositoryVersionDAO.class);
        List repositoryVersions = repositoryVersionDAO.findAll();
        for (RepositoryVersionEntity repositoryVersion : repositoryVersions) {
            repositoryVersion.setResolved(true);
            repositoryVersionDAO.merge(repositoryVersion);
        }
    }
}

