/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.dao.ArtifactDAO;
import id.onyx.obdp.server.orm.entities.ArtifactEntity;
import id.onyx.obdp.server.serveraction.kerberos.DeconstructedPrincipal;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosConfigurationDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCatalog252
extends AbstractUpgradeCatalog {
    static final String CLUSTERCONFIG_TABLE = "clusterconfig";
    static final String SERVICE_DELETED_COLUMN = "service_deleted";
    static final String UNMAPPED_COLUMN = "unmapped";
    private static final String UPGRADE_TABLE = "upgrade";
    private static final String UPGRADE_TABLE_FROM_REPO_COLUMN = "from_repo_version_id";
    private static final String UPGRADE_TABLE_TO_REPO_COLUMN = "to_repo_version_id";
    private static final String CLUSTERS_TABLE = "clusters";
    private static final String SERVICE_COMPONENT_HISTORY_TABLE = "servicecomponent_history";
    private static final String UPGRADE_GROUP_TABLE = "upgrade_group";
    private static final String UPGRADE_ITEM_TABLE = "upgrade_item";
    private static final String UPGRADE_ID_COLUMN = "upgrade_id";
    private static final String CLUSTER_ENV = "cluster-env";
    private static final String HIVE_ENV = "hive-env";
    private static final String MARIADB_REDHAT_SUPPORT = "mariadb_redhat_support";
    private static final List<String> configTypesToEnsureSelected = Arrays.asList("spark2-javaopts-properties");
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCatalog252.class);

    @Inject
    public UpgradeCatalog252(Injector injector) {
        super(injector);
    }

    @Override
    public String getSourceVersion() {
        return "2.5.1";
    }

    @Override
    public String getTargetVersion() {
        return "2.5.2";
    }

    @Override
    protected void executeDDLUpdates() throws OBDPException, SQLException {
        this.addServiceDeletedColumnToClusterConfigTable();
        this.addRepositoryColumnsToUpgradeTable();
    }

    @Override
    protected void executePreDMLUpdates() throws OBDPException, SQLException {
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
        this.addNewConfigurationsFromXml();
        this.resetStackToolsAndFeatures();
        this.updateKerberosDescriptorArtifacts();
        this.fixLivySuperusers();
    }

    private void addServiceDeletedColumnToClusterConfigTable() throws SQLException {
        if (!this.dbAccessor.tableHasColumn(CLUSTERCONFIG_TABLE, UNMAPPED_COLUMN)) {
            this.dbAccessor.addColumn(CLUSTERCONFIG_TABLE, new DBAccessor.DBColumnInfo(SERVICE_DELETED_COLUMN, Short.class, null, (Object)0, false));
        }
    }

    private void addRepositoryColumnsToUpgradeTable() throws SQLException {
        this.dbAccessor.clearTableColumn(CLUSTERS_TABLE, UPGRADE_ID_COLUMN, null);
        this.dbAccessor.clearTable(SERVICE_COMPONENT_HISTORY_TABLE);
        this.dbAccessor.clearTable(SERVICE_COMPONENT_HISTORY_TABLE);
        this.dbAccessor.clearTable(UPGRADE_ITEM_TABLE);
        this.dbAccessor.clearTable(UPGRADE_GROUP_TABLE);
        this.dbAccessor.clearTable(UPGRADE_TABLE);
        this.dbAccessor.dropColumn(UPGRADE_TABLE, "to_version");
        this.dbAccessor.dropColumn(UPGRADE_TABLE, "from_version");
        this.dbAccessor.addColumn(UPGRADE_TABLE, new DBAccessor.DBColumnInfo(UPGRADE_TABLE_FROM_REPO_COLUMN, Long.class, null, null, false));
        this.dbAccessor.addFKConstraint(UPGRADE_TABLE, "FK_upgrade_from_repo_id", UPGRADE_TABLE_FROM_REPO_COLUMN, "repo_version", "repo_version_id", false);
        this.dbAccessor.addColumn(UPGRADE_TABLE, new DBAccessor.DBColumnInfo(UPGRADE_TABLE_TO_REPO_COLUMN, Long.class, null, null, false));
        this.dbAccessor.addFKConstraint(UPGRADE_TABLE, "FK_upgrade_to_repo_id", UPGRADE_TABLE_FROM_REPO_COLUMN, "repo_version", "repo_version_id", false);
    }

    private void resetStackToolsAndFeatures() throws OBDPException {
        HashSet propertiesToReset = Sets.newHashSet((Object[])new String[]{"stack_tools", "stack_features", "stack_root"});
        Clusters clusters = (Clusters)this.injector.getInstance(Clusters.class);
        ConfigHelper configHelper = (ConfigHelper)this.injector.getInstance(ConfigHelper.class);
        Map<String, Cluster> clusterMap = clusters.getClusters();
        for (Cluster cluster : clusterMap.values()) {
            Config clusterEnv = cluster.getDesiredConfigByType(CLUSTER_ENV);
            if (null == clusterEnv) continue;
            HashMap<String, String> newStackProperties = new HashMap<String, String>();
            Set<PropertyInfo> stackProperties = configHelper.getStackProperties(cluster);
            if (null == stackProperties) continue;
            for (PropertyInfo propertyInfo : stackProperties) {
                String stackPropertyName;
                String fileName = propertyInfo.getFilename();
                if (StringUtils.isEmpty((String)fileName) || !StringUtils.equals((String)ConfigHelper.fileNameToConfigType(fileName), (String)CLUSTER_ENV) || !propertiesToReset.contains(stackPropertyName = propertyInfo.getName())) continue;
                newStackProperties.put(stackPropertyName, propertyInfo.getValue());
            }
            this.updateConfigurationPropertiesForCluster(cluster, CLUSTER_ENV, newStackProperties, true, false);
        }
    }

    @Override
    protected void updateKerberosDescriptorArtifact(ArtifactDAO artifactDAO, ArtifactEntity artifactEntity) throws OBDPException {
        KerberosDescriptor kerberosDescriptor;
        Map<String, Object> data;
        if (artifactEntity != null && (data = artifactEntity.getArtifactData()) != null && (kerberosDescriptor = new KerberosDescriptorFactory().createInstance(data)) != null) {
            KerberosComponentDescriptor knoxGatewayKerberosDescriptor;
            KerberosServiceDescriptor knoxKerberosDescriptor;
            boolean updated = false;
            if (this.removeConfigurationSpecifications(kerberosDescriptor.getService("SPARK"), Collections.singletonMap("livy-conf", Collections.singleton("livy.superusers")))) {
                updated = true;
            }
            if (this.removeConfigurationSpecifications(kerberosDescriptor.getService("SPARK2"), Collections.singletonMap("livy2-conf", Collections.singleton("livy.superusers")))) {
                updated = true;
            }
            if ((knoxKerberosDescriptor = kerberosDescriptor.getService("KNOX")) != null && (knoxGatewayKerberosDescriptor = knoxKerberosDescriptor.getComponent("KNOX_GATEWAY")) != null) {
                HashMap<String, Collection<String>> configsToRemove = new HashMap<String, Collection<String>>();
                configsToRemove.put("oozie-site", Arrays.asList("oozie.service.ProxyUserService.proxyuser.knox.groups", "oozie.service.ProxyUserService.proxyuser.knox.hosts"));
                configsToRemove.put("webhcat-site", Arrays.asList("webhcat.proxyuser.knox.groups", "webhcat.proxyuser.knox.hosts"));
                configsToRemove.put("core-site", Arrays.asList("hadoop.proxyuser.knox.groups", "hadoop.proxyuser.knox.hosts"));
                configsToRemove.put("falcon-runtime.properties", Arrays.asList("*.falcon.service.ProxyUserService.proxyuser.knox.groups", "*.falcon.service.ProxyUserService.proxyuser.knox.hosts"));
                if (this.removeConfigurationSpecifications(knoxGatewayKerberosDescriptor, configsToRemove)) {
                    updated = true;
                }
            }
            if (updated) {
                artifactEntity.setArtifactData(kerberosDescriptor.toMap());
                artifactDAO.merge(artifactEntity);
            }
        }
    }

    void fixLivySuperusers() throws OBDPException {
        Map<String, Cluster> clusterMap;
        Clusters clusters = (Clusters)this.injector.getInstance(Clusters.class);
        if (clusters != null && (clusterMap = clusters.getClusters()) != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                String zeppelinPrincipal;
                Map<String, String> zeppelinProperties;
                Config zeppelinEnvProperties = cluster.getDesiredConfigByType("zeppelin-env");
                if (zeppelinEnvProperties == null || (zeppelinProperties = zeppelinEnvProperties.getProperties()) == null || StringUtils.isEmpty((String)(zeppelinPrincipal = zeppelinProperties.get("zeppelin.server.kerberos.principal")))) continue;
                DeconstructedPrincipal deconstructedPrincipal = DeconstructedPrincipal.valueOf(zeppelinPrincipal, "EXAMPLE.COM");
                String newZeppelinPrincipalName = deconstructedPrincipal.getPrincipalName();
                String oldZeppelinPrincipalName = "zeppelin-" + cluster.getClusterName().toLowerCase();
                this.updateListValues(cluster, "livy-conf", "livy.superusers", Collections.singleton(newZeppelinPrincipalName), Collections.singleton(oldZeppelinPrincipalName));
                this.updateListValues(cluster, "livy2-conf", "livy.superusers", Collections.singleton(newZeppelinPrincipalName), Collections.singleton(oldZeppelinPrincipalName));
            }
        }
    }

    private void updateListValues(Cluster cluster, String configType, String propertyName, Set<String> valuesToAdd, Set<String> valuesToRemove) throws OBDPException {
        Map<String, String> properties;
        Config config = cluster.getDesiredConfigByType(configType);
        if (config != null && (properties = config.getProperties()) != null) {
            String existingValue = properties.get(propertyName);
            String newValue = null;
            if (StringUtils.isEmpty((String)existingValue)) {
                if (valuesToAdd != null && !valuesToAdd.isEmpty()) {
                    newValue = StringUtils.join(valuesToAdd, (char)',');
                }
            } else {
                TreeSet<String> valueSet = new TreeSet<String>(Arrays.asList(existingValue.split("\\s*,\\s*")));
                boolean removedValues = false;
                if (valuesToRemove != null) {
                    removedValues = valueSet.removeAll(valuesToRemove);
                }
                boolean addedValues = false;
                if (valuesToAdd != null) {
                    addedValues = valueSet.addAll(valuesToAdd);
                }
                if (removedValues || addedValues) {
                    newValue = StringUtils.join(valueSet, (char)',');
                }
            }
            if (!StringUtils.isEmpty(newValue)) {
                this.updateConfigurationPropertiesForCluster(cluster, configType, Collections.singletonMap(propertyName, newValue), true, true);
            }
        }
    }

    private boolean removeConfigurationSpecifications(AbstractKerberosDescriptorContainer kerberosDescriptorContainer, Map<String, Collection<String>> configurations) {
        boolean updated = false;
        if (kerberosDescriptorContainer != null && !MapUtils.isEmpty(configurations)) {
            for (Map.Entry<String, Collection<String>> entry : configurations.entrySet()) {
                String configType = entry.getKey();
                for (String propertyName : entry.getValue()) {
                    Map<String, String> properties;
                    Map<String, KerberosConfigurationDescriptor> configurationDescriptors = kerberosDescriptorContainer.getConfigurations(false);
                    KerberosConfigurationDescriptor configurationDescriptor = configurationDescriptors == null ? null : configurationDescriptors.get(configType);
                    if (configurationDescriptor == null || (properties = configurationDescriptor.getProperties()) == null || !properties.containsKey(propertyName)) continue;
                    properties.remove(propertyName);
                    LOG.info("Removed {}/{} from the descriptor named {}", new Object[]{configType, propertyName, kerberosDescriptorContainer.getName()});
                    updated = true;
                    if (!properties.isEmpty()) continue;
                    configurationDescriptors.remove(configType);
                    kerberosDescriptorContainer.setConfigurations(configurationDescriptors);
                }
            }
        }
        return updated;
    }
}

