/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class SchemaUpgradeUtil {
    private SchemaUpgradeUtil() {
        throw new UnsupportedOperationException();
    }

    public static String extractProperty(String content, String propertyName, String variableName, String propertyPattern, String defaultValue, Map<String, String> newProperties) {
        if (StringUtils.countOccurrencesOf((String)propertyPattern, (String)"(\\w+)") != 1) {
            throw new IllegalArgumentException("propertyPattern must contain exactly one '(\\w+)': " + propertyPattern);
        }
        Pattern p = Pattern.compile(propertyPattern);
        Matcher m = p.matcher(content);
        String propertyValue = defaultValue;
        if (m.find()) {
            propertyValue = m.group(1);
            String unescapedPattern = propertyPattern.replace("\\{", "{");
            String toReplace = unescapedPattern.replace("(\\w+)", propertyValue);
            String replaceWith = unescapedPattern.replace("(\\w+)", "{{" + variableName + "}}");
            content = content.replace(toReplace, replaceWith);
        }
        newProperties.put(propertyName, propertyValue);
        return content;
    }
}

