/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.persist.PersistService;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.audit.AuditLoggerModule;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ControllerModule;
import id.onyx.obdp.server.ldap.LdapModule;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.GuiceJpaInitializer;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import id.onyx.obdp.server.upgrade.FinalUpgradeCatalog;
import id.onyx.obdp.server.upgrade.UpdateAlertScriptPaths;
import id.onyx.obdp.server.upgrade.UpgradeCatalog;
import id.onyx.obdp.server.upgrade.UpgradeCatalog251;
import id.onyx.obdp.server.upgrade.UpgradeCatalog252;
import id.onyx.obdp.server.upgrade.UpgradeCatalog260;
import id.onyx.obdp.server.upgrade.UpgradeCatalog261;
import id.onyx.obdp.server.upgrade.UpgradeCatalog262;
import id.onyx.obdp.server.upgrade.UpgradeCatalog270;
import id.onyx.obdp.server.upgrade.UpgradeCatalog271;
import id.onyx.obdp.server.upgrade.UpgradeCatalog272;
import id.onyx.obdp.server.upgrade.UpgradeCatalog274;
import id.onyx.obdp.server.upgrade.UpgradeCatalog275;
import id.onyx.obdp.server.upgrade.UpgradeCatalog276;
import id.onyx.obdp.server.upgrade.UpgradeCatalog280;
import id.onyx.obdp.server.utils.EventBusSynchronizer;
import id.onyx.obdp.server.utils.VersionUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.JdbcUtils;

public class SchemaUpgradeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaUpgradeHelper.class);
    private Set<UpgradeCatalog> allUpgradeCatalogs;
    private PersistService persistService;
    private DBAccessor dbAccessor;
    private Configuration configuration;
    private static final String[] rcaTableNames = new String[]{"workflow", "job", "task", "taskAttempt", "hdfsEvent", "mapreduceEvent", "clusterEvent"};
    static final Gson gson = new GsonBuilder().create();

    @Inject
    public SchemaUpgradeHelper(Set<UpgradeCatalog> allUpgradeCatalogs, PersistService persistService, DBAccessor dbAccessor, Configuration configuration) {
        this.allUpgradeCatalogs = allUpgradeCatalogs;
        this.persistService = persistService;
        this.dbAccessor = dbAccessor;
        this.configuration = configuration;
    }

    public void startPersistenceService() {
        this.persistService.start();
    }

    public void stopPersistenceService() {
        this.persistService.stop();
    }

    public Set<UpgradeCatalog> getAllUpgradeCatalogs() {
        return this.allUpgradeCatalogs;
    }

    public String readSourceVersion() {
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.dbAccessor.getConnection().createStatement();
            if (statement != null && (rs = statement.executeQuery("SELECT " + this.dbAccessor.quoteObjectName("metainfo_value") + " from metainfo WHERE " + this.dbAccessor.quoteObjectName("metainfo_key") + "='version'")) != null && rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to read database version", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException("Cannot close result set");
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException("Cannot close statement");
                }
            }
        }
        return "1.2.0";
    }

    protected String getAmbariServerVersion() {
        return this.configuration.getServerVersion();
    }

    protected List<UpgradeCatalog> getUpgradePath(String sourceVersion, String targetVersion) throws OBDPException {
        ArrayList<UpgradeCatalog> upgradeCatalogs = new ArrayList<UpgradeCatalog>();
        ArrayList<UpgradeCatalog> candidateCatalogs = new ArrayList<UpgradeCatalog>(this.allUpgradeCatalogs);
        Collections.sort(candidateCatalogs, new AbstractUpgradeCatalog.VersionComparator());
        for (UpgradeCatalog upgradeCatalog : candidateCatalogs) {
            if (sourceVersion != null && VersionUtils.compareVersions((String)sourceVersion, (String)upgradeCatalog.getTargetVersion(), (int)4) >= 0 || VersionUtils.compareVersions((String)upgradeCatalog.getTargetVersion(), (String)targetVersion, (int)4) > 0) continue;
            upgradeCatalogs.add(upgradeCatalog);
        }
        LOG.info("Upgrade path: " + upgradeCatalogs);
        return upgradeCatalogs;
    }

    public void executeUpgrade(List<UpgradeCatalog> upgradeCatalogs) throws OBDPException {
        LOG.info("Executing DDL upgrade...");
        if (upgradeCatalogs != null && !upgradeCatalogs.isEmpty()) {
            for (UpgradeCatalog upgradeCatalog : upgradeCatalogs) {
                try {
                    upgradeCatalog.upgradeSchema();
                }
                catch (Exception e) {
                    LOG.error("Upgrade failed. ", (Throwable)e);
                    throw new OBDPException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void executePreDMLUpdates(List<UpgradeCatalog> upgradeCatalogs) throws OBDPException {
        LOG.info("Executing Pre-DML changes.");
        if (upgradeCatalogs != null && !upgradeCatalogs.isEmpty()) {
            for (UpgradeCatalog upgradeCatalog : upgradeCatalogs) {
                try {
                    upgradeCatalog.preUpgradeData();
                }
                catch (Exception e) {
                    LOG.error("Upgrade failed. ", (Throwable)e);
                    throw new OBDPException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void executeDMLUpdates(List<UpgradeCatalog> upgradeCatalogs, String ambariUpgradeConfigUpdatesFileName) throws OBDPException {
        LOG.info("Executing DML changes.");
        if (upgradeCatalogs != null && !upgradeCatalogs.isEmpty()) {
            for (UpgradeCatalog upgradeCatalog : upgradeCatalogs) {
                try {
                    upgradeCatalog.setConfigUpdatesFileName(ambariUpgradeConfigUpdatesFileName);
                    upgradeCatalog.upgradeData();
                }
                catch (Exception e) {
                    LOG.error("Upgrade failed. ", (Throwable)e);
                    throw new OBDPException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void executeOnPostUpgrade(List<UpgradeCatalog> upgradeCatalogs) throws OBDPException {
        LOG.info("Finalizing catalog upgrade.");
        if (upgradeCatalogs != null && !upgradeCatalogs.isEmpty()) {
            for (UpgradeCatalog upgradeCatalog : upgradeCatalogs) {
                try {
                    upgradeCatalog.onPostUpgrade();
                    upgradeCatalog.updateDatabaseSchemaVersion();
                }
                catch (Exception e) {
                    LOG.error("Upgrade failed. ", (Throwable)e);
                    throw new OBDPException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void outputUpgradeJsonOutput(List<UpgradeCatalog> upgradeCatalogs) throws OBDPException {
        LOG.info("Combining upgrade json output.");
        HashMap<String, String> combinedUpgradeJsonOutput = new HashMap<String, String>();
        if (upgradeCatalogs != null && !upgradeCatalogs.isEmpty()) {
            for (UpgradeCatalog upgradeCatalog : upgradeCatalogs) {
                try {
                    combinedUpgradeJsonOutput.putAll(upgradeCatalog.getUpgradeJsonOutput());
                }
                catch (Exception e) {
                    LOG.error("Upgrade failed. ", (Throwable)e);
                    throw new OBDPException(e.getMessage(), (Throwable)e);
                }
            }
        }
        String content = gson.toJson(combinedUpgradeJsonOutput);
        System.out.println(content);
    }

    public void resetUIState() throws OBDPException {
        LOG.info("Resetting UI state.");
        try {
            this.dbAccessor.updateTable("key_value_store", this.dbAccessor.quoteObjectName("value"), "{\"clusterState\":\"CLUSTER_STARTED_5\"}", "where " + this.dbAccessor.quoteObjectName("key") + "='CLUSTER_CURRENT_STATUS'");
        }
        catch (SQLException e) {
            throw new OBDPException("Unable to reset UI state", (Throwable)e);
        }
    }

    public void cleanUpRCATables() {
        LOG.info("Cleaning up RCA tables.");
        for (String tableName : rcaTableNames) {
            try {
                if (!this.dbAccessor.tableExists(tableName)) continue;
                this.dbAccessor.truncateTable(tableName);
            }
            catch (Exception e) {
                LOG.warn("Error cleaning rca table " + tableName, (Throwable)e);
            }
        }
        try {
            this.cleanUpTablesFromRCADatabase();
        }
        catch (Exception e) {
            LOG.warn("Error cleaning rca tables from ambarirca db", (Throwable)e);
        }
    }

    private void cleanUpTablesFromRCADatabase() throws ClassNotFoundException, SQLException {
        String driverName = this.configuration.getRcaDatabaseDriver();
        String connectionURL = this.configuration.getRcaDatabaseUrl();
        if (connectionURL.contains("{hostname}")) {
            connectionURL = connectionURL.replace("{hostname}", "localhost");
        }
        String username = this.configuration.getRcaDatabaseUser();
        String password = this.configuration.getRcaDatabasePassword();
        Class.forName(driverName);
        try (Connection connection = DriverManager.getConnection(connectionURL, username, password);){
            connection.setAutoCommit(true);
            for (String tableName : rcaTableNames) {
                String query = "DELETE FROM " + tableName;
                try (Statement statement = connection.createStatement();){
                    statement.execute(query);
                }
                catch (Exception e) {
                    LOG.warn("Error while executing query: " + query, (Throwable)e);
                }
            }
        }
    }

    private String getMinimalUpgradeCatalogVersion() {
        ArrayList<UpgradeCatalog> candidateCatalogs = new ArrayList<UpgradeCatalog>(this.allUpgradeCatalogs);
        Collections.sort(candidateCatalogs, new AbstractUpgradeCatalog.VersionComparator());
        if (candidateCatalogs.isEmpty()) {
            return null;
        }
        return ((UpgradeCatalog)candidateCatalogs.iterator().next()).getTargetVersion();
    }

    private boolean verifyUpgradePath(String minUpgradeVersion, String sourceVersion) {
        if (null == minUpgradeVersion) {
            return false;
        }
        return VersionUtils.compareVersions((String)sourceVersion, (String)minUpgradeVersion) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getMyISAMTables() throws SQLException {
        if (!this.configuration.getDatabaseType().equals((Object)Configuration.DatabaseType.MYSQL)) {
            return Collections.emptyList();
        }
        ArrayList<String> myISAMTables = new ArrayList<String>();
        String query = String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s' AND engine = 'MyISAM' AND table_type = 'BASE TABLE'", this.configuration.getServerDBName());
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.dbAccessor.getConnection().createStatement();
            rs = statement.executeQuery(query);
            if (rs != null) {
                while (rs.next()) {
                    myISAMTables.add(rs.getString("table_name"));
                }
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement((Statement)statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)statement);
        return myISAMTables;
    }

    public static void main(String[] args) throws Exception {
        try {
            String[] splittedJavaVersion = System.getProperty("java.version").split("\\.");
            float javaVersion = Float.parseFloat(splittedJavaVersion[0] + "." + splittedJavaVersion[1]);
            if (javaVersion < 1.7f) {
                LOG.error(String.format("Oracle JDK version is lower than %.1f It can cause problems during upgrade process. Please, use 'obdp-server setup' command to upgrade JDK!", Float.valueOf(1.7f)));
                System.exit(1);
            }
            Injector injector = Guice.createInjector((Module[])new Module[]{new UpgradeHelperModule(), new AuditLoggerModule(), new LdapModule()});
            GuiceJpaInitializer jpaInitializer = (GuiceJpaInitializer)injector.getInstance(GuiceJpaInitializer.class);
            SchemaUpgradeHelper schemaUpgradeHelper = (SchemaUpgradeHelper)injector.getInstance(SchemaUpgradeHelper.class);
            List<String> myISAMTables = schemaUpgradeHelper.getMyISAMTables();
            if (!myISAMTables.isEmpty()) {
                String errorMessage = String.format("Unsupported MyISAM table %s detected. For correct upgrade database should be migrated to InnoDB engine.", myISAMTables.get(0));
                LOG.error(errorMessage);
                throw new OBDPException(errorMessage);
            }
            String targetVersion = schemaUpgradeHelper.getAmbariServerVersion();
            LOG.info("Upgrading schema to target version = " + targetVersion);
            UpgradeCatalog targetUpgradeCatalog = AbstractUpgradeCatalog.getUpgradeCatalog(targetVersion);
            LOG.debug("Target upgrade catalog. {}", (Object)targetUpgradeCatalog);
            String sourceVersion = schemaUpgradeHelper.readSourceVersion();
            LOG.info("Upgrading schema from source version = " + sourceVersion);
            String minimalRequiredUpgradeVersion = schemaUpgradeHelper.getMinimalUpgradeCatalogVersion();
            if (!schemaUpgradeHelper.verifyUpgradePath(minimalRequiredUpgradeVersion, sourceVersion)) {
                throw new OBDPException(String.format("Database version does not meet minimal upgrade requirements. Expected version should be not less than %s, current version is %s", minimalRequiredUpgradeVersion, sourceVersion));
            }
            List<UpgradeCatalog> upgradeCatalogs = schemaUpgradeHelper.getUpgradePath(sourceVersion, targetVersion);
            String date = new SimpleDateFormat("MM-dd-yyyy_HH:mm:ss").format(new Date());
            String ambariUpgradeConfigUpdatesFileName = "ambari_upgrade_config_changes_" + date + ".json";
            schemaUpgradeHelper.executeUpgrade(upgradeCatalogs);
            jpaInitializer.setInitialized();
            schemaUpgradeHelper.executePreDMLUpdates(upgradeCatalogs);
            schemaUpgradeHelper.executeDMLUpdates(upgradeCatalogs, ambariUpgradeConfigUpdatesFileName);
            schemaUpgradeHelper.executeOnPostUpgrade(upgradeCatalogs);
            schemaUpgradeHelper.outputUpgradeJsonOutput(upgradeCatalogs);
            schemaUpgradeHelper.resetUIState();
            LOG.info("Upgrade successful.");
            schemaUpgradeHelper.cleanUpRCATables();
            schemaUpgradeHelper.stopPersistenceService();
            System.exit(0);
        }
        catch (Throwable e) {
            if (e instanceof OBDPException) {
                LOG.error("Exception occurred during upgrade, failed", e);
                throw (OBDPException)e;
            }
            LOG.error("Unexpected error, upgrade failed", e);
            throw new Exception("Unexpected error, upgrade failed", e);
        }
    }

    public static class UpgradeHelperModule
    extends ControllerModule {
        public UpgradeHelperModule() throws Exception {
        }

        public UpgradeHelperModule(Properties properties) throws Exception {
            super(properties);
        }

        @Override
        protected void configure() {
            super.configure();
            Multibinder catalogBinder = Multibinder.newSetBinder((Binder)this.binder(), UpgradeCatalog.class);
            catalogBinder.addBinding().to(UpgradeCatalog251.class);
            catalogBinder.addBinding().to(UpgradeCatalog252.class);
            catalogBinder.addBinding().to(UpgradeCatalog260.class);
            catalogBinder.addBinding().to(UpgradeCatalog261.class);
            catalogBinder.addBinding().to(UpgradeCatalog262.class);
            catalogBinder.addBinding().to(UpgradeCatalog270.class);
            catalogBinder.addBinding().to(UpgradeCatalog271.class);
            catalogBinder.addBinding().to(UpgradeCatalog272.class);
            catalogBinder.addBinding().to(UpgradeCatalog274.class);
            catalogBinder.addBinding().to(UpgradeCatalog275.class);
            catalogBinder.addBinding().to(UpgradeCatalog276.class);
            catalogBinder.addBinding().to(UpgradeCatalog280.class);
            catalogBinder.addBinding().to(UpdateAlertScriptPaths.class);
            catalogBinder.addBinding().to(FinalUpgradeCatalog.class);
            EventBusSynchronizer.synchronizeAmbariEventPublisher(this.binder());
        }
    }
}

