/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.upgrade.AbstractFinalUpgradeCatalog;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalUpgradeCatalog
extends AbstractFinalUpgradeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(FinalUpgradeCatalog.class);

    @Inject
    public FinalUpgradeCatalog(Injector injector) {
        super(injector);
    }

    @Override
    protected void executeDMLUpdates() throws OBDPException, SQLException {
        this.updateClusterEnv();
    }

    protected void updateClusterEnv() throws OBDPException {
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        OBDPMetaInfo obdpMetaInfo = (OBDPMetaInfo)this.injector.getInstance(OBDPMetaInfo.class);
        LOG.info("Updating stack_features and stack_tools config properties.");
        Clusters clusters = ambariManagementController.getClusters();
        Map<String, Cluster> clusterMap = this.getCheckedClusterMap(clusters);
        for (Cluster cluster : clusterMap.values()) {
            HashSet<StackId> stackIds = new HashSet<StackId>();
            for (Service service : cluster.getServices().values()) {
                stackIds.add(service.getDesiredStackId());
            }
            for (StackId stackId : stackIds) {
                HashMap<String, String> propertyMap = new HashMap<String, String>();
                StackInfo stackInfo = obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
                List<PropertyInfo> properties = stackInfo.getProperties();
                for (PropertyInfo property : properties) {
                    if (!property.getName().equals("stack_features") && !property.getName().equals("stack_tools") && !property.getName().equals("stack_packages")) continue;
                    propertyMap.put(property.getName(), property.getValue());
                }
                this.updateConfigurationPropertiesForCluster(cluster, "cluster-env", propertyMap, true, true);
            }
        }
    }
}

