/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.upgrade;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPManagementControllerImpl;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.dao.ArtifactDAO;
import id.onyx.obdp.server.orm.dao.MetainfoDAO;
import id.onyx.obdp.server.orm.dao.PermissionDAO;
import id.onyx.obdp.server.orm.dao.ResourceTypeDAO;
import id.onyx.obdp.server.orm.dao.RoleAuthorizationDAO;
import id.onyx.obdp.server.orm.dao.WidgetDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.ArtifactEntity;
import id.onyx.obdp.server.orm.entities.MetainfoEntity;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.RoleAuthorizationEntity;
import id.onyx.obdp.server.orm.entities.WidgetEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.PropertyUpgradeBehavior;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.alert.SourceType;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.state.stack.WidgetLayout;
import id.onyx.obdp.server.state.stack.WidgetLayoutInfo;
import id.onyx.obdp.server.upgrade.UpgradeCatalog;
import id.onyx.obdp.server.utils.VersionUtils;
import jakarta.persistence.EntityManager;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class AbstractUpgradeCatalog
implements UpgradeCatalog {
    @Inject
    protected DBAccessor dbAccessor;
    @Inject
    protected Configuration configuration;
    @Inject
    protected OBDPManagementControllerImpl ambariManagementController;
    protected Injector injector;
    protected String ambariSequencesTable = "ambari_sequences";
    protected static final String AUTHENTICATED_USER_NAME = "ambari-upgrade";
    private static final String CONFIGURATION_TYPE_HDFS_SITE = "hdfs-site";
    public static final String CONFIGURATION_TYPE_RANGER_HBASE_PLUGIN_PROPERTIES = "ranger-hbase-plugin-properties";
    public static final String CONFIGURATION_TYPE_RANGER_KNOX_PLUGIN_PROPERTIES = "ranger-knox-plugin-properties";
    public static final String CONFIGURATION_TYPE_RANGER_HIVE_PLUGIN_PROPERTIES = "ranger-hive-plugin-properties";
    private static final String PROPERTY_DFS_NAMESERVICES = "dfs.nameservices";
    public static final String PROPERTY_RANGER_HBASE_PLUGIN_ENABLED = "ranger-hbase-plugin-enabled";
    public static final String PROPERTY_RANGER_KNOX_PLUGIN_ENABLED = "ranger-knox-plugin-enabled";
    public static final String PROPERTY_RANGER_HIVE_PLUGIN_ENABLED = "ranger-hive-plugin-enabled";
    public static final String YARN_SCHEDULER_CAPACITY_ROOT_QUEUE = "yarn.scheduler.capacity.root";
    public static final String YARN_SCHEDULER_CAPACITY_ROOT_QUEUES = "yarn.scheduler.capacity.root.queues";
    public static final String QUEUES = "queues";
    public static final String ALERT_URL_PROPERTY_CONNECTION_TIMEOUT = "connection_timeout";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUpgradeCatalog.class);
    private static final Map<String, UpgradeCatalog> upgradeCatalogMap = new HashMap<String, UpgradeCatalog>();
    protected String ambariUpgradeConfigUpdatesFileName;
    private Map<String, String> upgradeJsonOutput = new HashMap<String, String>();

    @Inject
    public AbstractUpgradeCatalog(Injector injector) {
        this.injector = injector;
        injector.injectMembers((Object)this);
        this.registerCatalog(this);
    }

    protected void registerCatalog(UpgradeCatalog upgradeCatalog) {
        upgradeCatalogMap.put(upgradeCatalog.getTargetVersion(), upgradeCatalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addSequence(String seqName, Long seqDefaultValue, boolean ignoreFailure) throws SQLException {
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.dbAccessor.getConnection().createStatement();
            if (statement != null && (rs = statement.executeQuery(String.format("SELECT COUNT(*) from %s where sequence_name='%s'", this.ambariSequencesTable, seqName))) != null) {
                if (rs.next() && rs.getInt(1) == 0) {
                    this.dbAccessor.executeQuery(String.format("INSERT INTO %s(sequence_name, sequence_value) VALUES('%s', %d)", this.ambariSequencesTable, seqName, seqDefaultValue), ignoreFailure);
                } else {
                    LOG.warn("Sequence {} already exists, skipping", (Object)seqName);
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    protected final void addSequences(List<String> seqNames, Long seqDefaultValue, boolean ignoreFailure) throws SQLException {
        for (String seqName : seqNames) {
            this.addSequence(seqName, seqDefaultValue, ignoreFailure);
        }
    }

    protected final long fetchMaxId(String tableName, String idColumnName) throws SQLException {
        try (Statement stmt = this.dbAccessor.getConnection().createStatement();){
            long l;
            block16: {
                ResultSet rs;
                block14: {
                    long l2;
                    block15: {
                        rs = stmt.executeQuery(String.format("SELECT MAX(%s) FROM %s", idColumnName, tableName));
                        try {
                            if (!rs.next()) break block14;
                            l2 = rs.getLong(1);
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return l2;
                }
                l = 0L;
                if (rs == null) break block16;
                rs.close();
            }
            return l;
        }
    }

    @Override
    public String getSourceVersion() {
        return null;
    }

    protected static UpgradeCatalog getUpgradeCatalog(String version) {
        return upgradeCatalogMap.get(version);
    }

    protected static Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(xmlStr)));
        }
        catch (Exception e) {
            LOG.error("Error during convertation from String \"" + xmlStr + "\" to Xml!", (Throwable)e);
        }
        return doc;
    }

    protected static boolean isConfigEnabled(Cluster cluster, String configType, String propertyName) {
        String rangerPluginEnabled;
        Config rangerPluginProperties;
        boolean isRangerPluginEnabled = false;
        if (cluster != null && (rangerPluginProperties = cluster.getDesiredConfigByType(configType)) != null && StringUtils.isNotEmpty((String)(rangerPluginEnabled = rangerPluginProperties.getProperties().get(propertyName)))) {
            isRangerPluginEnabled = "yes".equalsIgnoreCase(rangerPluginEnabled);
        }
        return isRangerPluginEnabled;
    }

    @Override
    public Map<String, String> getUpgradeJsonOutput() {
        return this.upgradeJsonOutput;
    }

    @Transactional
    public int updateMetaInfoVersion(String version) {
        int rows = 0;
        if (version != null) {
            MetainfoDAO metainfoDAO = (MetainfoDAO)this.injector.getInstance(MetainfoDAO.class);
            MetainfoEntity versionEntity = metainfoDAO.findByKey("version");
            if (versionEntity != null) {
                versionEntity.setMetainfoValue(version);
                metainfoDAO.merge(versionEntity);
            } else {
                versionEntity = new MetainfoEntity();
                versionEntity.setMetainfoName("version");
                versionEntity.setMetainfoValue(version);
                metainfoDAO.create(versionEntity);
            }
        }
        return rows;
    }

    public void addConnectionTimeoutParamForWebAndMetricAlerts() {
        LOG.info("Updating alert definitions.");
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        AlertDefinitionDAO alertDefinitionDAO = (AlertDefinitionDAO)this.injector.getInstance(AlertDefinitionDAO.class);
        Clusters clusters = ambariManagementController.getClusters();
        JsonParser jsonParser = new JsonParser();
        for (Cluster cluster : this.getCheckedClusterMap(clusters).values()) {
            long clusterID = cluster.getClusterId();
            List<AlertDefinitionEntity> alertDefinitionList = alertDefinitionDAO.findAll(clusterID);
            for (AlertDefinitionEntity alertDefinitionEntity : alertDefinitionList) {
                String source;
                JsonObject rootJson;
                JsonObject uriJson;
                SourceType sourceType = alertDefinitionEntity.getSourceType();
                if (sourceType != SourceType.METRIC && sourceType != SourceType.WEB || (uriJson = (rootJson = jsonParser.parse(source = alertDefinitionEntity.getSource()).getAsJsonObject()).get("uri").getAsJsonObject()).has(ALERT_URL_PROPERTY_CONNECTION_TIMEOUT)) continue;
                uriJson.addProperty(ALERT_URL_PROPERTY_CONNECTION_TIMEOUT, (Number)5.0);
                alertDefinitionEntity.setSource(rootJson.toString());
                alertDefinitionDAO.merge(alertDefinitionEntity);
            }
        }
    }

    protected Provider<EntityManager> getEntityManagerProvider() {
        return this.injector.getProvider(EntityManager.class);
    }

    protected void executeInTransaction(Runnable func) {
        EntityManager entityManager = (EntityManager)this.getEntityManagerProvider().get();
        if (entityManager.getTransaction().isActive()) {
            func.run();
        } else {
            entityManager.getTransaction().begin();
            try {
                func.run();
                entityManager.getTransaction().commit();
                entityManager.getEntityManagerFactory().getCache().evictAll();
            }
            catch (Exception e) {
                LOG.error("Error in transaction ", (Throwable)e);
                if (entityManager.getTransaction().isActive()) {
                    entityManager.getTransaction().rollback();
                }
                throw new RuntimeException(e);
            }
        }
    }

    protected void changePostgresSearchPath() throws SQLException {
        String dbUser = this.configuration.getDatabaseUser();
        String schemaName = this.configuration.getServerJDBCPostgresSchemaName();
        if (null != dbUser && !dbUser.equals("") && null != schemaName && !schemaName.equals("")) {
            if (!dbUser.contains("\"")) {
                dbUser = String.format("\"%s\"", dbUser);
            }
            this.dbAccessor.executeQuery(String.format("ALTER SCHEMA %s OWNER TO %s;", schemaName, dbUser));
            this.dbAccessor.executeQuery(String.format("ALTER ROLE %s SET search_path to '%s';", dbUser, schemaName));
        }
    }

    public void addNewConfigurationsFromXml() throws OBDPException {
        Clusters clusters = (Clusters)this.injector.getInstance(Clusters.class);
        if (clusters == null) {
            return;
        }
        ConfigHelper configHelper = (ConfigHelper)this.injector.getInstance(ConfigHelper.class);
        Map<String, Cluster> clusterMap = clusters.getClusters();
        if (clusterMap != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                String newPropertyKey;
                HashMap toAddProperties = new HashMap();
                HashMap toUpdateProperties = new HashMap();
                HashMap toRemoveProperties = new HashMap();
                Set<PropertyInfo> stackProperties = configHelper.getStackProperties(cluster);
                for (String string : cluster.getServices().keySet()) {
                    Set<PropertyInfo> properties = configHelper.getServiceProperties(cluster, string);
                    if (properties == null) continue;
                    properties.addAll(stackProperties);
                    for (PropertyInfo property : properties) {
                        String configType = ConfigHelper.fileNameToConfigType(property.getFilename());
                        PropertyUpgradeBehavior upgradeBehavior = property.getPropertyAmbariUpgradeBehavior();
                        LOG.debug("Property: {}, Config Type: {}", (Object)property, (Object)configType);
                        if (property.isDeleted()) continue;
                        if (upgradeBehavior.isDelete()) {
                            if (!toRemoveProperties.containsKey(configType)) {
                                toRemoveProperties.put(configType, new HashSet());
                            }
                            ((Set)toRemoveProperties.get(configType)).add(property.getName());
                            continue;
                        }
                        if (upgradeBehavior.isUpdate()) {
                            if (!toUpdateProperties.containsKey(configType)) {
                                toUpdateProperties.put(configType, new HashSet());
                            }
                            ((Set)toUpdateProperties.get(configType)).add(property.getName());
                            continue;
                        }
                        if (!upgradeBehavior.isAdd()) continue;
                        if (!toAddProperties.containsKey(configType)) {
                            toAddProperties.put(configType, new HashSet());
                        }
                        ((Set)toAddProperties.get(configType)).add(property.getName());
                    }
                }
                for (Map.Entry entry : toAddProperties.entrySet()) {
                    newPropertyKey = (String)entry.getKey();
                    this.updateConfigurationPropertiesWithValuesFromXml(newPropertyKey, (Set)entry.getValue(), false, true);
                }
                for (Map.Entry entry : toUpdateProperties.entrySet()) {
                    newPropertyKey = (String)entry.getKey();
                    this.updateConfigurationPropertiesWithValuesFromXml(newPropertyKey, (Set)entry.getValue(), true, false);
                }
                for (Map.Entry entry : toRemoveProperties.entrySet()) {
                    newPropertyKey = (String)entry.getKey();
                    this.updateConfigurationPropertiesWithValuesFromXml(newPropertyKey, Collections.emptySet(), (Set)entry.getValue(), false, true);
                }
            }
        }
    }

    protected boolean isNNHAEnabled(Cluster cluster) {
        Config hdfsSiteConfig = cluster.getDesiredConfigByType(CONFIGURATION_TYPE_HDFS_SITE);
        if (hdfsSiteConfig != null) {
            Map<String, String> properties = hdfsSiteConfig.getProperties();
            if (properties.containsKey("dfs.internal.nameservices")) {
                return true;
            }
            String nameServices = properties.get(PROPERTY_DFS_NAMESERVICES);
            if (!StringUtils.isEmpty((String)nameServices)) {
                for (String nameService : nameServices.split(",")) {
                    String namenodes = properties.get(String.format("dfs.ha.namenodes.%s", nameService));
                    if (StringUtils.isEmpty((String)namenodes)) continue;
                    return namenodes.split(",").length > 1;
                }
            }
        }
        return false;
    }

    protected Map<String, Cluster> getCheckedClusterMap(Clusters clusters) {
        Map<String, Cluster> clusterMap;
        if (clusters != null && (clusterMap = clusters.getClusters()) != null) {
            return clusterMap;
        }
        return new HashMap<String, Cluster>();
    }

    protected void updateConfigurationPropertiesWithValuesFromXml(String configType, Set<String> propertyNames, boolean updateIfExists, boolean createNewConfigType) throws OBDPException {
        this.updateConfigurationPropertiesWithValuesFromXml(configType, propertyNames, null, updateIfExists, createNewConfigType);
    }

    protected void updateConfigurationPropertiesWithValuesFromXml(String configType, Set<String> propertyNames, Set<String> toRemove, boolean updateIfExists, boolean createNewConfigType) throws OBDPException {
        Clusters clusters = (Clusters)this.injector.getInstance(Clusters.class);
        ConfigHelper configHelper = (ConfigHelper)this.injector.getInstance(ConfigHelper.class);
        if (clusters == null) {
            return;
        }
        Map<String, Cluster> clusterMap = clusters.getClusters();
        if (clusterMap != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (String propertyName : propertyNames) {
                    String propertyValue = configHelper.getPropertyValueFromStackDefinitions(cluster, configType, propertyName);
                    if (propertyValue == null) {
                        LOG.info("Config " + propertyName + " from " + configType + " is not found in xml definitions.Skipping configuration property update");
                        continue;
                    }
                    ServiceInfo propertyService = configHelper.getPropertyOwnerService(cluster, configType, propertyName);
                    if (propertyService != null && !cluster.getServices().containsKey(propertyService.getName())) {
                        LOG.info("Config " + propertyName + " from " + configType + " with value = " + propertyValue + " Is not added due to service " + propertyService.getName() + " is not in the cluster.");
                        continue;
                    }
                    properties.put(propertyName, propertyValue);
                }
                this.updateConfigurationPropertiesForCluster(cluster, configType, properties, toRemove, updateIfExists, createNewConfigType);
            }
        }
    }

    protected void updateConfigurationPropertiesForCluster(Cluster cluster, String configType, Map<String, String> properties, Set<String> removePropertiesList, boolean updateIfExists, boolean createNewConfigType) throws OBDPException {
        Map<String, Config> all;
        OBDPManagementController controller = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        String newTag = "version" + System.currentTimeMillis();
        if (!(properties == null || (all = cluster.getConfigsByType(configType)) != null && all.containsKey(newTag) && properties.size() <= 0)) {
            Config oldConfig = cluster.getDesiredConfigByType(configType);
            if (oldConfig == null && !createNewConfigType) {
                LOG.info("Config " + configType + " not found. Assuming service not installed. Skipping configuration properties update");
                return;
            }
            Map<String, String> oldConfigProperties = oldConfig == null ? new HashMap<String, String>() : oldConfig.getProperties();
            ArrayListMultimap propertiesToLog = ArrayListMultimap.create();
            String serviceName = cluster.getServiceByConfigType(configType);
            Map<String, String> mergedProperties = this.mergeProperties(oldConfigProperties, properties, updateIfExists, (Multimap<ConfigUpdateType, Map.Entry<String, String>>)propertiesToLog);
            if (removePropertiesList != null) {
                mergedProperties = this.removeProperties(mergedProperties, removePropertiesList, (Multimap<ConfigUpdateType, Map.Entry<String, String>>)propertiesToLog);
            }
            if (propertiesToLog.size() > 0) {
                try {
                    this.configuration.writeToAmbariUpgradeConfigUpdatesFile((Multimap<ConfigUpdateType, Map.Entry<String, String>>)propertiesToLog, configType, serviceName, this.ambariUpgradeConfigUpdatesFileName);
                }
                catch (Exception e) {
                    LOG.error("Write to config updates file failed:", (Throwable)e);
                }
            }
            if (!Maps.difference(oldConfigProperties, mergedProperties).areEqual()) {
                LOG.info("Applying configuration with tag '{}' and configType '{}' to cluster '{}'", new Object[]{newTag, configType, cluster.getClusterName()});
                Map<String, Map<String, String>> propertiesAttributes = null;
                if (oldConfig != null) {
                    propertiesAttributes = oldConfig.getPropertiesAttributes();
                }
                if (null == propertiesAttributes) {
                    propertiesAttributes = Collections.emptyMap();
                }
                controller.createConfig(cluster, cluster.getDesiredStackVersion(), configType, mergedProperties, newTag, propertiesAttributes);
                Config baseConfig = cluster.getConfig(configType, newTag);
                if (baseConfig != null) {
                    String authName = AUTHENTICATED_USER_NAME;
                    String configVersionNote = String.format("Updated %s during Ambari Upgrade from %s to %s.", configType, this.getSourceVersion(), this.getTargetVersion());
                    if (cluster.addDesiredConfig(authName, Collections.singleton(baseConfig), configVersionNote) != null) {
                        String oldConfigString = oldConfig != null ? " from='" + oldConfig.getTag() + "'" : "";
                        LOG.info("cluster '" + cluster.getClusterName() + "' changed by: '" + authName + "'; type='" + baseConfig.getType() + "' tag='" + baseConfig.getTag() + "'" + oldConfigString);
                    }
                    ConfigHelper configHelper = (ConfigHelper)this.injector.getInstance(ConfigHelper.class);
                    configHelper.updateAgentConfigs(Collections.singleton(cluster.getClusterName()));
                }
            } else {
                LOG.info("No changes detected to config " + configType + ". Skipping configuration properties update");
            }
        }
    }

    protected void updateConfigurationPropertiesForCluster(Cluster cluster, String configType, Map<String, String> properties, boolean updateIfExists, boolean createNewConfigType) throws OBDPException {
        this.updateConfigurationPropertiesForCluster(cluster, configType, properties, null, updateIfExists, createNewConfigType);
    }

    protected void removeConfigurationPropertiesFromCluster(Cluster cluster, String configType, Set<String> removePropertiesList) throws OBDPException {
        this.updateConfigurationPropertiesForCluster(cluster, configType, new HashMap<String, String>(), removePropertiesList, false, true);
    }

    protected void updateConfigurationProperties(String configType, Map<String, String> properties, boolean updateIfExists, boolean createNewConfigType) throws OBDPException {
        OBDPManagementController controller = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = controller.getClusters();
        if (clusters == null) {
            return;
        }
        Map<String, Cluster> clusterMap = clusters.getClusters();
        if (clusterMap != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                this.updateConfigurationPropertiesForCluster(cluster, configType, properties, updateIfExists, createNewConfigType);
            }
        }
    }

    private Map<String, String> mergeProperties(Map<String, String> originalProperties, Map<String, String> newProperties, boolean updateIfExists, Multimap<ConfigUpdateType, Map.Entry<String, String>> propertiesToLog) {
        HashMap<String, String> properties = new HashMap<String, String>(originalProperties);
        for (Map.Entry<String, String> entry : newProperties.entrySet()) {
            if (!properties.containsKey(entry.getKey())) {
                properties.put(entry.getKey(), entry.getValue());
                propertiesToLog.put((Object)ConfigUpdateType.ADDED, entry);
            }
            if (!updateIfExists) continue;
            properties.put(entry.getKey(), entry.getValue());
            propertiesToLog.put((Object)ConfigUpdateType.UPDATED, entry);
        }
        return properties;
    }

    private Map<String, String> removeProperties(Map<String, String> originalProperties, Set<String> removeList, Multimap<ConfigUpdateType, Map.Entry<String, String>> propertiesToLog) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(originalProperties);
        for (String removeProperty : removeList) {
            if (!originalProperties.containsKey(removeProperty)) continue;
            properties.remove(removeProperty);
            propertiesToLog.put((Object)ConfigUpdateType.REMOVED, new AbstractMap.SimpleEntry<String, String>(removeProperty, ""));
        }
        return properties;
    }

    protected void updateKerberosDescriptorIdentityReferences(Map<String, ? extends AbstractKerberosDescriptorContainer> descriptorMap, String referenceName, String newReferenceName) {
        if (descriptorMap != null) {
            for (AbstractKerberosDescriptorContainer abstractKerberosDescriptorContainer : descriptorMap.values()) {
                this.updateKerberosDescriptorIdentityReferences(abstractKerberosDescriptorContainer, referenceName, newReferenceName);
                if (!(abstractKerberosDescriptorContainer instanceof KerberosServiceDescriptor)) continue;
                this.updateKerberosDescriptorIdentityReferences(((KerberosServiceDescriptor)abstractKerberosDescriptorContainer).getComponents(), referenceName, newReferenceName);
            }
        }
    }

    protected void updateKerberosDescriptorIdentityReferences(AbstractKerberosDescriptorContainer descriptorContainer, String referenceName, String newReferenceName) {
        KerberosIdentityDescriptor identity;
        if (descriptorContainer != null && (identity = descriptorContainer.getIdentity(referenceName)) != null) {
            identity.setName(newReferenceName);
        }
    }

    protected void updateKerberosDescriptorArtifacts() throws OBDPException {
        ArtifactDAO artifactDAO = (ArtifactDAO)this.injector.getInstance(ArtifactDAO.class);
        List<ArtifactEntity> artifactEntities = artifactDAO.findByName("kerberos_descriptor");
        if (artifactEntities != null) {
            for (ArtifactEntity artifactEntity : artifactEntities) {
                this.updateKerberosDescriptorArtifact(artifactDAO, artifactEntity);
            }
        }
    }

    protected KerberosDescriptor getKerberosDescriptor(Cluster cluster) throws OBDPException {
        Map<String, Object> data;
        OBDPMetaInfo obdpMetaInfo = (OBDPMetaInfo)this.injector.getInstance(OBDPMetaInfo.class);
        StackId stackId = this.getStackId(cluster);
        KerberosDescriptor defaultDescriptor = obdpMetaInfo.getKerberosDescriptor(stackId.getStackName(), stackId.getStackVersion(), false);
        ArtifactDAO artifactDAO = (ArtifactDAO)this.injector.getInstance(ArtifactDAO.class);
        KerberosDescriptor artifactDescriptor = null;
        ArtifactEntity artifactEntity = artifactDAO.findByNameAndForeignKeys("kerberos_descriptor", new TreeMap<String, String>(Collections.singletonMap("cluster", String.valueOf(cluster.getClusterId()))));
        if (artifactEntity != null && (data = artifactEntity.getArtifactData()) != null) {
            artifactDescriptor = new KerberosDescriptorFactory().createInstance(data);
        }
        if (defaultDescriptor == null) {
            return artifactDescriptor;
        }
        if (artifactDescriptor == null) {
            return defaultDescriptor;
        }
        defaultDescriptor.update(artifactDescriptor);
        return defaultDescriptor;
    }

    protected void addRoleAuthorization(String roleAuthorizationID, String roleAuthorizationName, Collection<String> applicableRoles) throws SQLException {
        if (!StringUtils.isEmpty((String)roleAuthorizationID)) {
            RoleAuthorizationDAO roleAuthorizationDAO = (RoleAuthorizationDAO)this.injector.getInstance(RoleAuthorizationDAO.class);
            RoleAuthorizationEntity roleAuthorization = roleAuthorizationDAO.findById(roleAuthorizationID);
            if (roleAuthorization == null) {
                roleAuthorization = new RoleAuthorizationEntity();
                roleAuthorization.setAuthorizationId(roleAuthorizationID);
                roleAuthorization.setAuthorizationName(roleAuthorizationName);
                roleAuthorizationDAO.create(roleAuthorization);
            }
            if (applicableRoles != null && !applicableRoles.isEmpty()) {
                for (String role : applicableRoles) {
                    String[] parts = role.split("\\:");
                    this.addAuthorizationToRole(parts[0], parts[1], roleAuthorization);
                }
            }
        }
    }

    protected void addAuthorizationToRole(String roleName, String resourceType, String roleAuthorizationID) {
        RoleAuthorizationDAO roleAuthorizationDAO;
        RoleAuthorizationEntity roleAuthorization;
        if (!StringUtils.isEmpty((String)roleAuthorizationID) && (roleAuthorization = (roleAuthorizationDAO = (RoleAuthorizationDAO)this.injector.getInstance(RoleAuthorizationDAO.class)).findById(roleAuthorizationID)) != null) {
            this.addAuthorizationToRole(roleName, resourceType, roleAuthorization);
        }
    }

    protected void addAuthorizationToRole(String roleName, String resourceType, RoleAuthorizationEntity roleAuthorization) {
        ResourceTypeDAO resourceTypeDAO;
        PermissionDAO permissionDAO;
        PermissionEntity role;
        if (roleAuthorization != null && !StringUtils.isEmpty((String)roleName) && !StringUtils.isEmpty((String)resourceType) && (role = (permissionDAO = (PermissionDAO)this.injector.getInstance(PermissionDAO.class)).findPermissionByNameAndType(roleName, (resourceTypeDAO = (ResourceTypeDAO)this.injector.getInstance(ResourceTypeDAO.class)).findByName(resourceType))) != null) {
            role.addAuthorization(roleAuthorization);
            permissionDAO.merge(role);
        }
    }

    protected void addAuthorizationToRole(PermissionEntity role, String roleAuthorizationID) {
        RoleAuthorizationDAO roleAuthorizationDAO;
        RoleAuthorizationEntity roleAuthorization;
        if (role != null && !StringUtils.isEmpty((String)roleAuthorizationID) && (roleAuthorization = (roleAuthorizationDAO = (RoleAuthorizationDAO)this.injector.getInstance(RoleAuthorizationDAO.class)).findById(roleAuthorizationID)) != null) {
            PermissionDAO permissionDAO = (PermissionDAO)this.injector.getInstance(PermissionDAO.class);
            role.getAuthorizations().add(roleAuthorization);
            permissionDAO.merge(role);
        }
    }

    protected void updateKerberosDescriptorArtifact(ArtifactDAO artifactDAO, ArtifactEntity artifactEntity) throws OBDPException {
    }

    @Override
    public void upgradeSchema() throws OBDPException, SQLException {
        Configuration.DatabaseType databaseType = this.configuration.getDatabaseType();
        if (databaseType == Configuration.DatabaseType.POSTGRES) {
            this.changePostgresSearchPath();
        }
        this.executeDDLUpdates();
    }

    @Override
    public void preUpgradeData() throws OBDPException, SQLException {
        this.executePreDMLUpdates();
    }

    @Override
    public void setConfigUpdatesFileName(String ambariUpgradeConfigUpdatesFileName) {
        this.ambariUpgradeConfigUpdatesFileName = ambariUpgradeConfigUpdatesFileName;
    }

    @Override
    public void upgradeData() throws OBDPException, SQLException {
        this.executeDMLUpdates();
    }

    @Override
    public final void updateDatabaseSchemaVersion() {
        this.updateMetaInfoVersion(this.getTargetVersion());
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    protected abstract void executeDDLUpdates() throws OBDPException, SQLException;

    protected abstract void executePreDMLUpdates() throws OBDPException, SQLException;

    protected abstract void executeDMLUpdates() throws OBDPException, SQLException;

    public String toString() {
        return "{ upgradeCatalog: sourceVersion = " + this.getSourceVersion() + ", targetVersion = " + this.getTargetVersion() + " }";
    }

    @Override
    public void onPostUpgrade() throws OBDPException, SQLException {
    }

    protected boolean isQueueNameValid(Cluster cluster, Set<String> validLeafQueues, String queueNameProperty, String configType) {
        boolean result;
        Config site = cluster.getDesiredConfigByType(configType);
        Map<String, String> properties = site.getProperties();
        boolean bl = result = properties.containsKey(queueNameProperty) && validLeafQueues.contains(properties.get(queueNameProperty));
        if (!result) {
            LOG.info("Queue name " + queueNameProperty + " in " + configType + " not defined or not corresponds to valid capacity-scheduler queue");
        }
        return result;
    }

    protected void updateQueueName(Cluster cluster, Set<String> validLeafQueues, String queueNameProperty, String configType) throws OBDPException {
        String recommendQueue = validLeafQueues.iterator().next();
        LOG.info("Update " + queueNameProperty + " in " + configType + " set to " + recommendQueue);
        Map<String, String> updates = Collections.singletonMap(queueNameProperty, recommendQueue);
        this.updateConfigurationPropertiesForCluster(cluster, configType, updates, true, true);
    }

    protected Set<String> getCapacitySchedulerLeafQueues(Map<String, String> capacitySchedulerMap) {
        HashSet<String> leafQueues = new HashSet<String>();
        Stack<Object> toProcessQueues = new Stack<Object>();
        if (capacitySchedulerMap.containsKey(YARN_SCHEDULER_CAPACITY_ROOT_QUEUES)) {
            StringTokenizer queueTokenizer = new StringTokenizer(capacitySchedulerMap.get(YARN_SCHEDULER_CAPACITY_ROOT_QUEUES), ",");
            while (queueTokenizer.hasMoreTokens()) {
                toProcessQueues.push(queueTokenizer.nextToken());
            }
        }
        while (!toProcessQueues.empty()) {
            String queue = (String)toProcessQueues.pop();
            String queueKey = "yarn.scheduler.capacity.root." + queue + ".queues";
            if (capacitySchedulerMap.containsKey(queueKey)) {
                StringTokenizer queueTokenizer = new StringTokenizer(capacitySchedulerMap.get(queueKey), ",");
                while (queueTokenizer.hasMoreTokens()) {
                    toProcessQueues.push(queue + "." + queueTokenizer.nextToken());
                }
                continue;
            }
            if (!queue.endsWith(".")) {
                String queueName = queue.substring(queue.lastIndexOf(46) + 1);
                leafQueues.add(queueName);
                continue;
            }
            LOG.warn("Queue " + queue + " is not valid");
        }
        return leafQueues;
    }

    protected void updateWidgetDefinitionsForService(String serviceName, Map<String, List<String>> widgetMap, Map<String, String> sectionLayoutMap) throws OBDPException {
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        OBDPMetaInfo obdpMetaInfo = (OBDPMetaInfo)this.injector.getInstance(OBDPMetaInfo.class);
        Type widgetLayoutType = new TypeToken<Map<String, List<WidgetLayout>>>(){}.getType();
        Gson gson = (Gson)this.injector.getInstance(Gson.class);
        WidgetDAO widgetDAO = (WidgetDAO)this.injector.getInstance(WidgetDAO.class);
        Clusters clusters = ambariManagementController.getClusters();
        Map<String, Cluster> clusterMap = this.getCheckedClusterMap(clusters);
        for (Cluster cluster : clusterMap.values()) {
            long clusterID = cluster.getClusterId();
            Service service = cluster.getServices().get(serviceName);
            if (null == service) continue;
            StackId stackId = service.getDesiredStackId();
            Map widgetDescriptor = null;
            StackInfo stackInfo = obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
            ServiceInfo serviceInfo = stackInfo.getService(serviceName);
            if (serviceInfo == null) {
                LOG.info("Skipping updating widget definition, because " + serviceName + " service is not present in cluster cluster_name= " + cluster.getClusterName());
                continue;
            }
            for (String section : widgetMap.keySet()) {
                List<String> widgets = widgetMap.get(section);
                for (String widgetName : widgets) {
                    List<WidgetEntity> widgetEntities = widgetDAO.findByName(clusterID, widgetName, "ambari", section);
                    if (widgetEntities == null || widgetEntities.size() <= 0) continue;
                    WidgetEntity entityToUpdate = null;
                    if (widgetEntities.size() > 1) {
                        LOG.info("Found more that 1 entity with name = " + widgetName + " for cluster = " + cluster.getClusterName() + ", skipping update.");
                    } else {
                        entityToUpdate = widgetEntities.iterator().next();
                    }
                    if (entityToUpdate == null) continue;
                    LOG.info("Updating widget: " + entityToUpdate.getWidgetName());
                    WidgetLayoutInfo targetWidgetLayoutInfo = null;
                    File widgetDescriptorFile = serviceInfo.getWidgetsDescriptorFile();
                    if (widgetDescriptorFile != null && widgetDescriptorFile.exists()) {
                        try {
                            widgetDescriptor = (Map)gson.fromJson((Reader)new FileReader(widgetDescriptorFile), widgetLayoutType);
                        }
                        catch (Exception ex) {
                            String msg = "Error loading widgets from file: " + widgetDescriptorFile;
                            LOG.error(msg, (Throwable)ex);
                            widgetDescriptor = null;
                        }
                    }
                    if (widgetDescriptor != null) {
                        LOG.debug("Loaded widget descriptor: {}", widgetDescriptor);
                        for (Object artifact : widgetDescriptor.values()) {
                            List widgetLayouts = (List)artifact;
                            for (WidgetLayout widgetLayout : widgetLayouts) {
                                if (!widgetLayout.getLayoutName().equals(sectionLayoutMap.get(section))) continue;
                                for (WidgetLayoutInfo layoutInfo : widgetLayout.getWidgetLayoutInfoList()) {
                                    if (!layoutInfo.getWidgetName().equals(widgetName)) continue;
                                    targetWidgetLayoutInfo = layoutInfo;
                                }
                            }
                        }
                    }
                    if (targetWidgetLayoutInfo != null) {
                        entityToUpdate.setMetrics(gson.toJson(targetWidgetLayoutInfo.getMetricsInfo()));
                        entityToUpdate.setWidgetValues(gson.toJson(targetWidgetLayoutInfo.getValues()));
                        entityToUpdate.setDescription(targetWidgetLayoutInfo.getDescription());
                        widgetDAO.merge(entityToUpdate);
                        continue;
                    }
                    LOG.warn("Unable to find widget layout info for " + widgetName + " in the stack: " + stackId);
                }
            }
        }
    }

    private StackId getStackId(Cluster cluster) throws OBDPException {
        return cluster.getServices().values().iterator().next().getDesiredStackId();
    }

    public static enum ConfigUpdateType {
        ADDED("Added"),
        UPDATED("Updated"),
        REMOVED("Removed");

        private final String description;

        private ConfigUpdateType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    protected static class VersionComparator
    implements Comparator<UpgradeCatalog> {
        protected VersionComparator() {
        }

        @Override
        public int compare(UpgradeCatalog upgradeCatalog1, UpgradeCatalog upgradeCatalog2) {
            if (upgradeCatalog1.isFinal() ^ upgradeCatalog2.isFinal()) {
                return Boolean.compare(upgradeCatalog1.isFinal(), upgradeCatalog2.isFinal());
            }
            return VersionUtils.compareVersions((String)upgradeCatalog1.getTargetVersion(), (String)upgradeCatalog2.getTargetVersion(), (int)4);
        }
    }
}

