/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.update;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.PersistService;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.AgentConfigsHolder;
import id.onyx.obdp.server.audit.AuditLoggerModule;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ControllerModule;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.ldap.LdapModule;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.TopologyHostGroupDAO;
import id.onyx.obdp.server.orm.dao.TopologyHostRequestDAO;
import id.onyx.obdp.server.orm.dao.TopologyRequestDAO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostGroupEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostInfoEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostRequestEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalRequestEntity;
import id.onyx.obdp.server.orm.entities.TopologyRequestEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigFactory;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.utils.EventBusSynchronizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostUpdateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HostUpdateHelper.class);
    private static final String AUTHENTICATED_USER_NAME = "ambari-host-update";
    public static final String TMP_PREFIX = "tmpvalue";
    private PersistService persistService;
    private Configuration configuration;
    private Injector injector;
    protected String hostChangesFile;
    protected Map<String, Map<String, String>> hostChangesFileMap;

    @Inject
    public HostUpdateHelper(PersistService persistService, Configuration configuration, Injector injector) {
        this.persistService = persistService;
        this.configuration = configuration;
        this.injector = injector;
    }

    public void startPersistenceService() {
        this.persistService.start();
    }

    public void stopPersistenceService() {
        this.persistService.stop();
    }

    public String getHostChangesFile() {
        return this.hostChangesFile;
    }

    public void setHostChangesFile(String hostChangesFile) {
        this.hostChangesFile = hostChangesFile;
    }

    public Map<String, Map<String, String>> getHostChangesFileMap() {
        return this.hostChangesFileMap;
    }

    public void setHostChangesFileMap(Map<String, Map<String, String>> hostChangesFileMap) {
        this.hostChangesFileMap = hostChangesFileMap;
    }

    void validateHostChanges() throws OBDPException {
        if (this.hostChangesFileMap == null || this.hostChangesFileMap.isEmpty()) {
            throw new OBDPException(String.format("File with host names changes is null or empty", new Object[0]));
        }
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null) {
            for (Map.Entry<String, Map<String, String>> clusterHosts : this.hostChangesFileMap.entrySet()) {
                String clusterName = clusterHosts.getKey();
                Cluster cluster = clusters.getCluster(clusterName);
                if (cluster != null) {
                    Collection<Host> hosts = cluster.getHosts();
                    ArrayList<String> invalidHostNames = new ArrayList<String>();
                    ArrayList<String> hostNames = new ArrayList<String>();
                    for (Host host : hosts) {
                        hostNames.add(host.getHostName());
                    }
                    for (Map.Entry entry : clusterHosts.getValue().entrySet()) {
                        if (hostNames.contains(entry.getKey())) continue;
                        invalidHostNames.add((String)entry.getKey());
                    }
                    if (invalidHostNames.isEmpty()) continue;
                    throw new OBDPException(String.format("Hostname(s): %s was(were) not found.", StringUtils.join(invalidHostNames, (String)", ")));
                }
                throw new OBDPException(String.format("Cluster %s was not found.", clusterName));
            }
        }
    }

    void updateHostsInConfigurations() throws OBDPException {
        ClusterDAO clusterDAO = (ClusterDAO)this.injector.getInstance(ClusterDAO.class);
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null) {
            for (Map.Entry<String, Map<String, String>> clusterHosts : this.hostChangesFileMap.entrySet()) {
                boolean hostConfigsUpdated = false;
                String clusterName = clusterHosts.getKey();
                ClusterEntity clusterEntity = clusterDAO.findByName(clusterName);
                Cluster cluster = clusters.getCluster(clusterName);
                Map<String, String> hostMapping = clusterHosts.getValue();
                ArrayList<String> currentHostNames = new ArrayList<String>();
                for (Map.Entry<String, String> hostPair : hostMapping.entrySet()) {
                    currentHostNames.add(hostPair.getKey());
                }
                if (clusterEntity != null) {
                    Collection<ClusterConfigEntity> clusterConfigEntities = clusterEntity.getClusterConfigEntities();
                    ConfigFactory configFactory = (ConfigFactory)this.injector.getInstance(ConfigFactory.class);
                    for (ClusterConfigEntity clusterConfigEntity : clusterConfigEntities) {
                        Config config = configFactory.createExisting(cluster, clusterConfigEntity);
                        boolean configUpdated = false;
                        for (Map.Entry<String, String> property : config.getProperties().entrySet()) {
                            String updatedPropertyValue = this.replaceHosts(property.getValue(), currentHostNames, hostMapping);
                            if (updatedPropertyValue == null) continue;
                            Map<String, String> propertiesWithUpdates = config.getProperties();
                            propertiesWithUpdates.put(property.getKey(), updatedPropertyValue);
                            config.setProperties(propertiesWithUpdates);
                            configUpdated = true;
                        }
                        if (!configUpdated) continue;
                        hostConfigsUpdated = true;
                        config.save();
                    }
                }
                if (!hostConfigsUpdated) continue;
                AgentConfigsHolder agentConfigsHolder = (AgentConfigsHolder)this.injector.getInstance(AgentConfigsHolder.class);
                agentConfigsHolder.updateData(cluster.getClusterId(), currentHostNames.stream().map(hm -> cluster.getHost((String)hm).getHostId()).collect(Collectors.toList()));
            }
        }
    }

    private String replaceHosts(String propertyValue, List<String> currentHostNames, Map<String, String> hostMapping) {
        String updatedPropertyValue = null;
        List<String> hostListForReplace = this.getHostNamesWhichValueIncludes(currentHostNames, propertyValue);
        if (!hostListForReplace.isEmpty() && hostMapping != null) {
            Collections.sort(hostListForReplace, new StringComparator());
            updatedPropertyValue = propertyValue;
            HashMap<String, String> hostNameCode = new HashMap<String, String>();
            int counter = 0;
            for (String hostName : hostListForReplace) {
                String code = String.format("{replace_code_%d}", counter++);
                hostNameCode.put(hostName, code);
                updatedPropertyValue = updatedPropertyValue.replaceAll("(?i)" + Pattern.quote(hostName), code);
            }
            for (String hostName : hostListForReplace) {
                updatedPropertyValue = updatedPropertyValue.replace((CharSequence)hostNameCode.get(hostName), hostMapping.get(hostName));
            }
        }
        return updatedPropertyValue;
    }

    private List<String> getHostNamesWhichValueIncludes(List<String> hostNames, String value) {
        ArrayList<String> includedHostNames = new ArrayList<String>();
        if (value != null && hostNames != null && !value.isEmpty()) {
            for (String host : hostNames) {
                if (!StringUtils.containsIgnoreCase((String)value, (String)host)) continue;
                includedHostNames.add(host);
            }
        }
        return includedHostNames;
    }

    void checkForSecurity() throws OBDPException {
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Clusters clusters = ambariManagementController.getClusters();
        ArrayList<String> clustersInSecure = new ArrayList<String>();
        if (clusters != null) {
            for (String clusterName : this.hostChangesFileMap.keySet()) {
                String securityEnabled;
                Cluster cluster = clusters.getCluster(clusterName);
                Config clusterEnv = cluster.getDesiredConfigByType("cluster-env");
                if (clusterEnv == null || !(securityEnabled = clusterEnv.getProperties().get("security_enabled")).toLowerCase().equals("true")) continue;
                clustersInSecure.add(clusterName);
            }
            if (!clustersInSecure.isEmpty()) {
                throw new OBDPException(String.format("Cluster(s) %s from file, is(are) in secure mode. Please, turn off security mode.", StringUtils.join(clustersInSecure, (String)", ")));
            }
        }
    }

    protected void initHostChangesFileMap() throws OBDPException {
        JsonObject hostChangesJsonObject = this.configuration.getHostChangesJson(this.hostChangesFile);
        this.hostChangesFileMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry clusterEntry : hostChangesJsonObject.entrySet()) {
            try {
                Gson gson = new Gson();
                this.hostChangesFileMap.put((String)clusterEntry.getKey(), (Map)gson.fromJson((JsonElement)clusterEntry.getValue(), Map.class));
            }
            catch (Exception e) {
                throw new OBDPException("Error occurred during mapping Json to Map structure. Please check json structure in file.", (Throwable)e);
            }
        }
        HashMap<String, Map<String, String>> newHostChangesFileMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> clusterHosts : this.hostChangesFileMap.entrySet()) {
            HashMap<String, String> newHostPairs = new HashMap<String, String>();
            for (Map.Entry<String, String> hostPair : clusterHosts.getValue().entrySet()) {
                newHostPairs.put(hostPair.getKey().toLowerCase(), hostPair.getValue().toLowerCase());
            }
            newHostChangesFileMap.put(clusterHosts.getKey(), newHostPairs);
        }
        this.hostChangesFileMap = newHostChangesFileMap;
    }

    void updateHostsInDB() {
        ClusterDAO clusterDAO = (ClusterDAO)this.injector.getInstance(ClusterDAO.class);
        HostDAO hostDAO = (HostDAO)this.injector.getInstance(HostDAO.class);
        for (Map.Entry<String, Map<String, String>> clusterHosts : this.hostChangesFileMap.entrySet()) {
            String clusterName = clusterHosts.getKey();
            Map<String, String> hostMapping = clusterHosts.getValue();
            HashMap<String, String> toTmpHostMapping = new HashMap<String, String>();
            HashMap<String, String> fromTmpHostMapping = new HashMap<String, String>();
            for (Map.Entry<String, String> hostPair : hostMapping.entrySet()) {
                toTmpHostMapping.put(hostPair.getKey(), TMP_PREFIX + hostPair.getValue());
                fromTmpHostMapping.put(TMP_PREFIX + hostPair.getValue(), hostPair.getValue());
            }
            ClusterEntity clusterEntity = clusterDAO.findByName(clusterName);
            this.renameHostsInDB(hostDAO, toTmpHostMapping, clusterEntity);
            this.renameHostsInDB(hostDAO, fromTmpHostMapping, clusterEntity);
        }
    }

    private void renameHostsInDB(HostDAO hostDAO, Map<String, String> hostMapping, ClusterEntity clusterEntity) {
        ArrayList<String> currentHostNames = new ArrayList<String>();
        for (Map.Entry<String, String> hostPair : hostMapping.entrySet()) {
            currentHostNames.add(hostPair.getKey());
        }
        if (clusterEntity != null) {
            Collection<HostEntity> hostEntities = clusterEntity.getHostEntities();
            for (HostEntity hostEntity : hostEntities) {
                if (!currentHostNames.contains(hostEntity.getHostName())) continue;
                hostEntity.setHostName(hostMapping.get(hostEntity.getHostName()));
                hostDAO.merge(hostEntity);
            }
        }
    }

    void updateHostsForAlertsInDB() {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        AlertsDAO alertsDAO = (AlertsDAO)this.injector.getInstance(AlertsDAO.class);
        AlertDefinitionDAO alertDefinitionDAO = (AlertDefinitionDAO)this.injector.getInstance(AlertDefinitionDAO.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = clusters.getClusters()) != null) {
            for (Map.Entry<String, Map<String, String>> clusterHosts : this.hostChangesFileMap.entrySet()) {
                ArrayList<String> currentHostNames = new ArrayList<String>();
                Map<String, String> hostMapping = clusterHosts.getValue();
                Long clusterId = clusterMap.get(clusterHosts.getKey()).getClusterId();
                for (Map.Entry<String, String> entry : hostMapping.entrySet()) {
                    currentHostNames.add(entry.getKey());
                }
                List<AlertCurrentEntity> currentEntities = alertsDAO.findCurrentByCluster(clusterId);
                for (AlertCurrentEntity alertCurrentEntity : currentEntities) {
                    AlertHistoryEntity alertHistoryEntity = alertCurrentEntity.getAlertHistory();
                    if (!currentHostNames.contains(alertHistoryEntity.getHostName())) continue;
                    alertHistoryEntity.setHostName(hostMapping.get(alertHistoryEntity.getHostName()));
                    alertsDAO.merge(alertHistoryEntity);
                }
                List<AlertDefinitionEntity> list = alertDefinitionDAO.findAll(clusterId);
                for (AlertDefinitionEntity alertDefinitionEntity : list) {
                    alertDefinitionEntity.setHash(UUID.randomUUID().toString());
                    alertDefinitionDAO.merge(alertDefinitionEntity);
                }
            }
        }
    }

    void updateHostsForTopologyRequests() {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        TopologyRequestDAO topologyRequestDAO = (TopologyRequestDAO)this.injector.getInstance(TopologyRequestDAO.class);
        TopologyHostRequestDAO topologyHostRequestDAO = (TopologyHostRequestDAO)this.injector.getInstance(TopologyHostRequestDAO.class);
        TopologyHostGroupDAO topologyHostGroupDAO = (TopologyHostGroupDAO)this.injector.getInstance(TopologyHostGroupDAO.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = clusters.getClusters()) != null) {
            for (Map.Entry<String, Map<String, String>> clusterHosts : this.hostChangesFileMap.entrySet()) {
                Long clusterId = clusterMap.get(clusterHosts.getKey()).getClusterId();
                List<TopologyRequestEntity> topologyRequestEntities = topologyRequestDAO.findByClusterId(clusterId);
                ArrayList<String> currentHostNames = new ArrayList<String>();
                Map<String, String> hostMapping = clusterHosts.getValue();
                for (Map.Entry<String, String> hostPair : hostMapping.entrySet()) {
                    currentHostNames.add(hostPair.getKey());
                }
                for (TopologyRequestEntity topologyRequestEntity : topologyRequestEntities) {
                    Collection<TopologyHostRequestEntity> topologyHostRequestEntities;
                    TopologyLogicalRequestEntity topologyLogicalRequestEntity = topologyRequestEntity.getTopologyLogicalRequestEntity();
                    Collection<TopologyHostGroupEntity> topologyHostGroupEntities = topologyRequestEntity.getTopologyHostGroupEntities();
                    if (topologyHostGroupEntities != null) {
                        for (TopologyHostGroupEntity topologyHostGroupEntity : topologyHostGroupEntities) {
                            Collection<TopologyHostInfoEntity> topologyHostInfoEntities = topologyHostGroupEntity.getTopologyHostInfoEntities();
                            boolean updatesAvailable = false;
                            for (TopologyHostInfoEntity topologyHostInfoEntity : topologyHostInfoEntities) {
                                if (!currentHostNames.contains(topologyHostInfoEntity.getFqdn())) continue;
                                topologyHostInfoEntity.setFqdn(hostMapping.get(topologyHostInfoEntity.getFqdn()));
                                updatesAvailable = true;
                            }
                            if (!updatesAvailable) continue;
                            topologyHostGroupDAO.merge(topologyHostGroupEntity);
                        }
                    }
                    if (topologyLogicalRequestEntity == null || (topologyHostRequestEntities = topologyLogicalRequestEntity.getTopologyHostRequestEntities()) == null) continue;
                    for (TopologyHostRequestEntity topologyHostRequestEntity : topologyHostRequestEntities) {
                        if (!currentHostNames.contains(topologyHostRequestEntity.getHostName())) continue;
                        topologyHostRequestEntity.setHostName(hostMapping.get(topologyHostRequestEntity.getHostName()));
                        topologyHostRequestDAO.merge(topologyHostRequestEntity);
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new UpdateHelperModule(), new CheckHelperAuditModule(), new LdapModule()});
        HostUpdateHelper hostUpdateHelper = (HostUpdateHelper)injector.getInstance(HostUpdateHelper.class);
        try {
            LOG.info("Host names update started.");
            String hostChangesFile = args[0];
            if (hostChangesFile == null || hostChangesFile.isEmpty()) {
                throw new OBDPException("Path to file with host names changes is empty or null.");
            }
            hostUpdateHelper.setHostChangesFile(hostChangesFile);
            hostUpdateHelper.initHostChangesFileMap();
            hostUpdateHelper.startPersistenceService();
            hostUpdateHelper.validateHostChanges();
            hostUpdateHelper.checkForSecurity();
            hostUpdateHelper.updateHostsInDB();
            hostUpdateHelper.updateHostsForTopologyRequests();
            hostUpdateHelper.updateHostsForAlertsInDB();
            hostUpdateHelper.updateHostsInConfigurations();
            LOG.info("Host names update completed successfully.");
        }
        catch (OBDPException e) {
            LOG.error("Exception occurred during host names update, failed", (Throwable)e);
            throw e;
        }
        finally {
            hostUpdateHelper.stopPersistenceService();
        }
    }

    public class StringComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            return s2.length() - s1.length();
        }
    }

    public static class UpdateHelperModule
    extends ControllerModule {
        @Override
        protected void configure() {
            super.configure();
            EventBusSynchronizer.synchronizeAmbariEventPublisher(this.binder());
        }
    }

    public static class CheckHelperAuditModule
    extends AuditLoggerModule {
        @Override
        protected void configure() {
            super.configure();
        }
    }
}

