/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.validators;

import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.controller.internal.UnitUpdater;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.TopologyValidator;
import id.onyx.obdp.server.topology.validators.UnitValidatedProperty;
import java.util.Map;
import java.util.Set;

public class UnitValidator
implements TopologyValidator {
    private final Set<UnitValidatedProperty> relevantProps;

    public UnitValidator(Set<UnitValidatedProperty> propertiesToBeValidated) {
        this.relevantProps = propertiesToBeValidated;
    }

    @Override
    public void validate(ClusterTopology topology) throws InvalidTopologyException {
        Stack stack = topology.getBlueprint().getStack();
        this.validateConfig(topology.getConfiguration().getFullProperties(), stack);
        for (HostGroupInfo hostGroup : topology.getHostGroupInfo().values()) {
            this.validateConfig(hostGroup.getConfiguration().getFullProperties(), stack);
        }
    }

    private void validateConfig(Map<String, Map<String, String>> configuration, Stack stack) {
        for (Map.Entry<String, Map<String, String>> each : configuration.entrySet()) {
            this.validateConfigType(each.getKey(), each.getValue(), stack);
        }
    }

    private void validateConfigType(String configType, Map<String, String> config, Stack stack) {
        for (String propertyName : config.keySet()) {
            this.validateProperty(configType, config, propertyName, stack);
        }
    }

    private void validateProperty(String configType, Map<String, String> config, String propertyName, Stack stack) {
        this.relevantProps.stream().filter(each -> each.hasTypeAndName(configType, propertyName)).findFirst().ifPresent(relevantProperty -> this.checkUnit(config, stack, (UnitValidatedProperty)relevantProperty));
    }

    private void checkUnit(Map<String, String> configToBeValidated, Stack stack, UnitValidatedProperty prop) {
        UnitUpdater.PropertyUnit stackUnit = UnitUpdater.PropertyUnit.of(stack, prop);
        UnitUpdater.PropertyValue value = UnitUpdater.PropertyValue.of(prop.getPropertyName(), configToBeValidated.get(prop.getPropertyName()));
        if (value.hasAnyUnit() && !value.hasUnit(stackUnit)) {
            throw new IllegalArgumentException("Property " + prop.getPropertyName() + "=" + value + " has an unsupported unit. Stack supported unit is: " + stackUnit + " or no unit");
        }
    }
}

