/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.validators;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class UnitValidatedProperty {
    public static final Set<UnitValidatedProperty> ALL = ImmutableSet.builder().add((Object)new UnitValidatedProperty("HDFS", "hadoop-env", "namenode_heapsize")).add((Object)new UnitValidatedProperty("HDFS", "hadoop-env", "namenode_opt_newsize")).add((Object)new UnitValidatedProperty("HDFS", "hadoop-env", "namenode_opt_maxnewsize")).add((Object)new UnitValidatedProperty("HDFS", "hadoop-env", "namenode_opt_permsize")).add((Object)new UnitValidatedProperty("HDFS", "hadoop-env", "namenode_opt_maxpermsize")).add((Object)new UnitValidatedProperty("HDFS", "hadoop-env", "dtnode_heapsize")).add((Object)new UnitValidatedProperty("MAPREDUCE2", "mapred-env", "jtnode_opt_newsize")).add((Object)new UnitValidatedProperty("MAPREDUCE2", "mapred-env", "jtnode_opt_maxnewsize")).add((Object)new UnitValidatedProperty("MAPREDUCE2", "mapred-env", "jtnode_heapsize")).add((Object)new UnitValidatedProperty("HBASE", "hbase-env", "hbase_master_heapsize")).add((Object)new UnitValidatedProperty("HBASE", "hbase-env", "hbase_regionserver_heapsize")).add((Object)new UnitValidatedProperty("OOZIE", "oozie-env", "oozie_heapsize")).add((Object)new UnitValidatedProperty("OOZIE", "oozie-env", "oozie_permsize")).add((Object)new UnitValidatedProperty("ZOOKEEPER", "zookeeper-env", "zk_server_heapsize")).build();
    private final String configType;
    private final String serviceName;
    private final String propertyName;

    public UnitValidatedProperty(String serviceName, String configType, String propertyName) {
        this.configType = configType;
        this.serviceName = serviceName;
        this.propertyName = propertyName;
    }

    public boolean hasTypeAndName(String configType, String propertyName) {
        return configType.equals(this.getConfigType()) && propertyName.equals(this.getPropertyName());
    }

    public String getConfigType() {
        return this.configType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnitValidatedProperty that = (UnitValidatedProperty)o;
        return new EqualsBuilder().append((Object)this.configType, (Object)that.configType).append((Object)this.serviceName, (Object)that.serviceName).append((Object)this.propertyName, (Object)that.propertyName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.configType).append((Object)this.serviceName).append((Object)this.propertyName).toHashCode();
    }
}

