/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.validators;

import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.TopologyValidator;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackConfigTypeValidator
implements TopologyValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StackConfigTypeValidator.class);

    @Override
    public void validate(ClusterTopology topology) throws InvalidTopologyException {
        HashSet<String> incomingConfigTypes = new HashSet<String>(topology.getConfiguration().getAllConfigTypes());
        if (incomingConfigTypes.isEmpty()) {
            LOGGER.debug("No config types to be checked.");
            return;
        }
        HashSet<String> stackConfigTypes = new HashSet<String>(topology.getBlueprint().getStack().getConfiguration().getAllConfigTypes());
        incomingConfigTypes.removeAll(stackConfigTypes);
        if (!incomingConfigTypes.isEmpty()) {
            String message = String.format("The following config types are not defined in the stack: %s ", incomingConfigTypes);
            LOGGER.error(message);
            throw new InvalidTopologyException(message);
        }
    }
}

