/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.validators;

import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.TopologyValidator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RequiredPasswordValidator
implements TopologyValidator {
    private String defaultPassword;

    @Override
    public void validate(ClusterTopology topology) throws InvalidTopologyException {
        this.defaultPassword = topology.getDefaultPassword();
        Map<String, Map<String, Collection<String>>> missingPasswords = this.validateRequiredPasswords(topology);
        if (!missingPasswords.isEmpty()) {
            throw new InvalidTopologyException("Missing required password properties.  Specify a value for these properties in the cluster or host group configurations or include 'default_password' field in request. " + missingPasswords);
        }
    }

    private Map<String, Map<String, Collection<String>>> validateRequiredPasswords(ClusterTopology topology) {
        HashMap<String, Map<String, Collection<String>>> missingProperties = new HashMap<String, Map<String, Collection<String>>>();
        for (Map.Entry<String, HostGroupInfo> groupEntry : topology.getHostGroupInfo().entrySet()) {
            String hostGroupName = groupEntry.getKey();
            Map<String, Map<String, String>> groupProperties = groupEntry.getValue().getConfiguration().getFullProperties(3);
            HashSet<String> processedServices = new HashSet<String>();
            Blueprint blueprint = topology.getBlueprint();
            Stack stack = blueprint.getStack();
            HostGroup hostGroup = blueprint.getHostGroup(hostGroupName);
            for (String component : hostGroup.getComponentNames()) {
                String serviceName;
                if (component.equals(RootComponent.OBDP_SERVER.name()) || !processedServices.add(serviceName = stack.getServiceForComponent(component))) continue;
                Collection<Stack.ConfigProperty> requiredProperties = stack.getRequiredConfigurationProperties(serviceName, PropertyInfo.PropertyType.PASSWORD);
                for (Stack.ConfigProperty property : requiredProperties) {
                    HashSet<String> missingHostGroupTypeProps;
                    String name;
                    String category = property.getType();
                    if (this.propertyExists(topology, groupProperties, category, name = property.getName())) continue;
                    HashMap<String, HashSet<String>> missingHostGroupPropsMap = (HashMap<String, HashSet<String>>)missingProperties.get(hostGroupName);
                    if (missingHostGroupPropsMap == null) {
                        missingHostGroupPropsMap = new HashMap<String, HashSet<String>>();
                        missingProperties.put(hostGroupName, missingHostGroupPropsMap);
                    }
                    if ((missingHostGroupTypeProps = (HashSet<String>)missingHostGroupPropsMap.get(category)) == null) {
                        missingHostGroupTypeProps = new HashSet<String>();
                        missingHostGroupPropsMap.put(category, missingHostGroupTypeProps);
                    }
                    missingHostGroupTypeProps.add(name);
                }
            }
        }
        return missingProperties;
    }

    private boolean propertyExists(ClusterTopology topology, Map<String, Map<String, String>> props, String type, String property) {
        Map<String, String> typeProps = props.get(type);
        return typeProps != null && typeProps.containsKey(property) || this.setDefaultPassword(topology, type, property);
    }

    private boolean setDefaultPassword(ClusterTopology topology, String configType, String property) {
        boolean setDefaultPassword = false;
        if (this.defaultPassword != null && !this.defaultPassword.trim().isEmpty()) {
            topology.getConfiguration().setProperty(configType, property, this.defaultPassword);
            setDefaultPassword = true;
        }
        return setDefaultPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequiredPasswordValidator that = (RequiredPasswordValidator)o;
        return this.defaultPassword == null ? that.defaultPassword == null : this.defaultPassword.equals(that.defaultPassword);
    }

    public int hashCode() {
        return this.defaultPassword != null ? this.defaultPassword.hashCode() : 0;
    }
}

