/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.validators;

import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.TopologyValidator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredConfigPropertiesValidator
implements TopologyValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequiredConfigPropertiesValidator.class);

    @Override
    public void validate(ClusterTopology topology) throws InvalidTopologyException {
        Map<String, Map<String, Collection<String>>> requiredPropertiesByService = this.getRequiredPropertiesByService(topology.getBlueprint());
        Map<String, Collection<String>> missingProperties = new TreeMap<String, Collection<String>>();
        HashMap<String, Map<String, String>> topologyConfiguration = new HashMap<String, Map<String, String>>(topology.getConfiguration().getFullProperties(1));
        for (HostGroup hostGroup : topology.getBlueprint().getHostGroups().values()) {
            LOGGER.debug("Processing hostgroup configurations for hostgroup: {}", (Object)hostGroup.getName());
            HashMap<String, Map<String, String>> operationalConfigurations = new HashMap<String, Map<String, String>>(topologyConfiguration);
            for (Map.Entry<String, Map<String, String>> hostgroupConfigEntry : hostGroup.getConfiguration().getProperties().entrySet()) {
                if (operationalConfigurations.containsKey(hostgroupConfigEntry.getKey())) {
                    ((Map)operationalConfigurations.get(hostgroupConfigEntry.getKey())).putAll(hostgroupConfigEntry.getValue());
                    continue;
                }
                operationalConfigurations.put(hostgroupConfigEntry.getKey(), hostgroupConfigEntry.getValue());
            }
            for (String hostGroupService : hostGroup.getServices()) {
                if (!requiredPropertiesByService.containsKey(hostGroupService)) {
                    LOGGER.debug("There are no required properties found for hostgroup/service: [{}/{}]", (Object)hostGroup.getName(), (Object)hostGroupService);
                    continue;
                }
                Map<String, Collection<String>> requiredPropertiesByType = requiredPropertiesByService.get(hostGroupService);
                for (String configType : requiredPropertiesByType.keySet()) {
                    HashSet<String> requiredPropertiesForType = new HashSet<String>(requiredPropertiesByType.get(configType));
                    if (!operationalConfigurations.containsKey(configType)) {
                        missingProperties = this.addTomissingProperties(missingProperties, hostGroup.getName(), requiredPropertiesForType);
                        continue;
                    }
                    Set operationalConfigsForType = ((Map)operationalConfigurations.get(configType)).keySet();
                    requiredPropertiesForType.removeAll(operationalConfigsForType);
                    if (requiredPropertiesForType.isEmpty()) continue;
                    LOGGER.info("Found missing properties in hostgroup: {}, config type: {}, mising properties: {}", new Object[]{hostGroup.getName(), configType, requiredPropertiesForType});
                    missingProperties = this.addTomissingProperties(missingProperties, hostGroup.getName(), requiredPropertiesForType);
                }
            }
        }
        if (!missingProperties.isEmpty()) {
            throw new InvalidTopologyException("Missing required properties.  Specify a value for these properties in the blueprint or cluster creation template configuration. " + missingProperties);
        }
    }

    private Map<String, Map<String, Collection<String>>> getRequiredPropertiesByService(Blueprint blueprint) {
        HashMap<String, Map<String, Collection<String>>> requiredPropertiesForServiceByType = new HashMap<String, Map<String, Collection<String>>>();
        for (String bpService : blueprint.getServices()) {
            LOGGER.debug("Collecting required properties for the service: {}", (Object)bpService);
            Collection<Stack.ConfigProperty> requiredConfigsForService = blueprint.getStack().getRequiredConfigurationProperties(bpService);
            Map requiredPropertiesByConfigType = new HashMap();
            for (Stack.ConfigProperty configProperty : requiredConfigsForService) {
                if (configProperty.getPropertyTypes() != null && configProperty.getPropertyTypes().contains((Object)PropertyInfo.PropertyType.PASSWORD)) {
                    LOGGER.debug("Skipping required property validation for password type: {}", (Object)configProperty.getName());
                    continue;
                }
                if (requiredPropertiesForServiceByType.containsKey(bpService)) {
                    requiredPropertiesByConfigType = (Map)requiredPropertiesForServiceByType.get(bpService);
                } else {
                    LOGGER.debug("Adding required properties entry for service: {}", (Object)bpService);
                    requiredPropertiesForServiceByType.put(bpService, requiredPropertiesByConfigType);
                }
                Collection<String> requiredPropsForType = new HashSet();
                if (requiredPropertiesByConfigType.containsKey(configProperty.getType())) {
                    requiredPropsForType = (Collection)requiredPropertiesByConfigType.get(configProperty.getType());
                } else {
                    LOGGER.debug("Adding required properties entry for configuration type: {}", (Object)configProperty.getType());
                    requiredPropertiesByConfigType.put(configProperty.getType(), requiredPropsForType);
                }
                requiredPropsForType.add(configProperty.getName());
                LOGGER.debug("Added required property for service; {}, configuration type: {}, property: {}", new Object[]{bpService, configProperty.getType(), configProperty.getName()});
            }
        }
        LOGGER.info("Identified required properties for blueprint services: {}", requiredPropertiesForServiceByType);
        return requiredPropertiesForServiceByType;
    }

    private Map<String, Collection<String>> addTomissingProperties(Map<String, Collection<String>> missingProperties, String hostGroup, Collection<String> values) {
        TreeMap<Object, Object> missing = missingProperties == null ? new TreeMap() : new TreeMap<String, Collection<String>>(missingProperties);
        if (!missing.containsKey(hostGroup)) {
            missing.put(hostGroup, new TreeSet());
        }
        ((Collection)missing.get(hostGroup)).addAll(values);
        return missing;
    }
}

