/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.validators;

import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.TopologyValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveServiceValidator
implements TopologyValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveServiceValidator.class);
    private static final String HIVE_ENV = "hive-env";
    private static final String HIVE_DB_DEFAULT = "New MySQL Database";
    private static final String HIVE_DB_PROPERTY = "hive_database";
    private static final String MYSQL_SERVER_COMPONENT = "MYSQL_SERVER";
    public static final String HIVE_SERVICE = "HIVE";

    @Override
    public void validate(ClusterTopology topology) throws InvalidTopologyException {
        if (!topology.getBlueprint().getServices().contains(HIVE_SERVICE)) {
            LOGGER.info(" [{}] service is not listed in the blueprint, skipping hive service validation.", (Object)HIVE_SERVICE);
            return;
        }
        Configuration clusterConfiguration = topology.getConfiguration();
        if (!clusterConfiguration.getAllConfigTypes().contains(HIVE_ENV)) {
            String errorMessage = String.format(" [ %s ] config type is missing from the service [ %s ]. HIVE service validation failed.", HIVE_ENV, HIVE_SERVICE);
            LOGGER.error(errorMessage);
            throw new InvalidTopologyException(errorMessage);
        }
        if (!HIVE_DB_DEFAULT.equals(clusterConfiguration.getPropertyValue(HIVE_ENV, HIVE_DB_PROPERTY))) {
            LOGGER.info("Custom hive database settings detected. HIVE service validation succeeded.");
            return;
        }
        if (!topology.getBlueprint().getComponents(HIVE_SERVICE).contains(MYSQL_SERVER_COMPONENT)) {
            String errorMessage = String.format("Component [%s] must explicitly be set in the blueprint when hive database is configured with the current settings. HIVE service validation failed.", MYSQL_SERVER_COMPONENT);
            LOGGER.error(errorMessage);
            throw new InvalidTopologyException(errorMessage);
        }
    }
}

