/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.validators;

import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.TopologyValidator;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigTypeValidator
implements TopologyValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfigTypeValidator.class);

    @Override
    public void validate(ClusterTopology topology) throws InvalidTopologyException {
        HashSet<String> topologyClusterConfigTypes = new HashSet<String>(topology.getConfiguration().getAllConfigTypes());
        LOGGER.debug("Cluster config types: {}", topologyClusterConfigTypes);
        if (topologyClusterConfigTypes.isEmpty()) {
            LOGGER.debug("No config types to be checked.");
            return;
        }
        HashSet<String> stackServiceConfigTypes = new HashSet<String>();
        for (String serviceName : topology.getBlueprint().getServices()) {
            stackServiceConfigTypes.addAll(topology.getBlueprint().getStack().getConfigurationTypes(serviceName));
        }
        HashSet<String> configTypeIntersection = new HashSet<String>(topologyClusterConfigTypes);
        if (configTypeIntersection.retainAll(stackServiceConfigTypes)) {
            HashSet<String> invalidConfigTypes = new HashSet<String>(topologyClusterConfigTypes);
            invalidConfigTypes.removeAll(configTypeIntersection);
            LOGGER.error("The following config typess are wrong: {}", invalidConfigTypes);
            throw new InvalidTopologyException("The following configuration types are invalid: " + invalidConfigTypes);
        }
    }
}

