/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.tasks;

import id.onyx.obdp.server.security.authorization.internal.InternalAuthenticationToken;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostRequest;
import id.onyx.obdp.server.topology.tasks.TopologyTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class TopologyHostTask
implements TopologyTask {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyHostTask.class);
    ClusterTopology clusterTopology;
    HostRequest hostRequest;
    boolean skipFailure;

    public TopologyHostTask(ClusterTopology topology, HostRequest hostRequest) {
        this.clusterTopology = topology;
        this.hostRequest = hostRequest;
    }

    public HostRequest getHostRequest() {
        return this.hostRequest;
    }

    @Override
    public void run() {
        Authentication savedAuthContext = SecurityContextHolder.getContext().getAuthentication();
        try {
            InternalAuthenticationToken authenticationToken = new InternalAuthenticationToken("internal_topology_token");
            authenticationToken.setAuthenticated(true);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
            this.runTask();
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(savedAuthContext);
        }
    }

    public abstract void runTask();
}

