/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.tasks;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.ShortTaskStatus;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostRequest;
import id.onyx.obdp.server.topology.tasks.TopologyHostTask;
import id.onyx.obdp.server.topology.tasks.TopologyTask;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartHostTask
extends TopologyHostTask {
    private static final Logger LOG = LoggerFactory.getLogger(StartHostTask.class);

    @AssistedInject
    public StartHostTask(@Assisted ClusterTopology topology, @Assisted HostRequest hostRequest, @Assisted boolean skipFailure) {
        super(topology, hostRequest);
        this.skipFailure = skipFailure;
    }

    @Override
    public TopologyTask.Type getType() {
        return TopologyTask.Type.START;
    }

    @Override
    public void runTask() {
        LOG.info("HostRequest: Executing START task for host: {}", (Object)this.hostRequest.getHostName());
        RequestStatusResponse response = this.clusterTopology.startHost(this.hostRequest.getHostName(), this.skipFailure);
        if (response != null) {
            List<ShortTaskStatus> underlyingTasks = response.getTasks();
            for (ShortTaskStatus task : underlyingTasks) {
                String component = task.getRole();
                Long logicalStartTaskId = this.hostRequest.getLogicalTasksForTopologyTask(this).get(component);
                if (logicalStartTaskId == null) {
                    LOG.info("Skipping physical start task registering, because component {} cannot be found", (Object)task.getRole());
                    continue;
                }
                this.hostRequest.registerPhysicalTaskId(logicalStartTaskId, task.getTaskId());
            }
        }
        LOG.info("HostRequest: Exiting START task for host: {}", (Object)this.hostRequest.getHostName());
    }
}

