/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.tasks;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostRequest;
import id.onyx.obdp.server.topology.tasks.TopologyHostTask;
import id.onyx.obdp.server.topology.tasks.TopologyTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistHostResourcesTask
extends TopologyHostTask {
    private static final Logger LOG = LoggerFactory.getLogger(PersistHostResourcesTask.class);

    @AssistedInject
    public PersistHostResourcesTask(@Assisted ClusterTopology topology, @Assisted HostRequest hostRequest) {
        super(topology, hostRequest);
    }

    @Override
    public TopologyTask.Type getType() {
        return TopologyTask.Type.RESOURCE_CREATION;
    }

    @Override
    public void runTask() {
        LOG.info("HostRequest: Executing RESOURCE_CREATION task for host: {}", (Object)this.hostRequest.getHostName());
        HostGroup group = this.hostRequest.getHostGroup();
        HashMap<String, Collection<String>> serviceComponents = new HashMap<String, Collection<String>>();
        for (String service : group.getServices()) {
            serviceComponents.put(service, new HashSet<String>(group.getComponents(service)));
        }
        this.clusterTopology.getAmbariContext().createAmbariHostResources(this.hostRequest.getClusterId(), this.hostRequest.getHostName(), serviceComponents);
        LOG.info("HostRequest: Exiting RESOURCE_CREATION task for host: {}", (Object)this.hostRequest.getHostName());
    }
}

