/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.tasks;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.ShortTaskStatus;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostRequest;
import id.onyx.obdp.server.topology.tasks.TopologyHostTask;
import id.onyx.obdp.server.topology.tasks.TopologyTask;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallHostTask
extends TopologyHostTask {
    private static final Logger LOG = LoggerFactory.getLogger(InstallHostTask.class);

    @AssistedInject
    public InstallHostTask(@Assisted ClusterTopology topology, @Assisted HostRequest hostRequest, @Assisted boolean skipFailure) {
        super(topology, hostRequest);
        this.skipFailure = skipFailure;
    }

    @Override
    public TopologyTask.Type getType() {
        return TopologyTask.Type.INSTALL;
    }

    @Override
    public void runTask() {
        LOG.info("HostRequest: Executing INSTALL task for host: {}", (Object)this.hostRequest.getHostName());
        boolean skipInstallTaskCreate = this.clusterTopology.getProvisionAction().equals((Object)ProvisionAction.START_ONLY);
        RequestStatusResponse response = this.clusterTopology.installHost(this.hostRequest.getHostName(), skipInstallTaskCreate, this.skipFailure);
        if (response != null) {
            List<ShortTaskStatus> underlyingTasks = response.getTasks();
            for (ShortTaskStatus task : underlyingTasks) {
                String component = task.getRole();
                Long logicalInstallTaskId = this.hostRequest.getLogicalTasksForTopologyTask(this).get(component);
                if (logicalInstallTaskId == null) {
                    LOG.info("Skipping physical install task registering, because component {} cannot be found", (Object)task.getRole());
                    continue;
                }
                long taskId = task.getTaskId();
                this.hostRequest.registerPhysicalTaskId(logicalInstallTaskId, taskId);
            }
        }
        LOG.info("HostRequest: Exiting INSTALL task for host: {}", (Object)this.hostRequest.getHostName());
    }
}

