/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.tasks;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.events.ClusterConfigFinishedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.security.authorization.internal.RunWithInternalSecurityContext;
import id.onyx.obdp.server.topology.AsyncCallableService;
import id.onyx.obdp.server.topology.ClusterConfigurationRequest;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostGroupInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureClusterTask
implements Callable<Boolean> {
    private static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toMillis(30L);
    private static final long REPEAT_DELAY = TimeUnit.SECONDS.toMillis(1L);
    private static final String TIMEOUT_PROPERTY_NAME = "cluster_configure_task_timeout";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigureClusterTask.class);
    private final ClusterConfigurationRequest configRequest;
    private final ClusterTopology topology;
    private final OBDPEventPublisher ambariEventPublisher;
    private final Map<String, Integer> previousHostCounts = Maps.newHashMap();
    private final Set<String> missingHostGroups = Sets.newHashSet();

    @AssistedInject
    public ConfigureClusterTask(@Assisted ClusterTopology topology, @Assisted ClusterConfigurationRequest configRequest, @Assisted OBDPEventPublisher ambariEventPublisher) {
        this.configRequest = configRequest;
        this.topology = topology;
        this.ambariEventPublisher = ambariEventPublisher;
    }

    @Override
    @RunWithInternalSecurityContext(token="internal_topology_token")
    public Boolean call() throws Exception {
        LOG.debug("Entering");
        Collection<String> requiredHostGroups = this.getTopologyRequiredHostGroups();
        if (!this.areHostGroupsResolved(requiredHostGroups)) {
            String msg = "Some host groups require more hosts, cluster configuration cannot begin";
            LOG.info(msg);
            throw new AsyncCallableService.RetryTaskSilently(msg);
        }
        LOG.info("All required host groups are complete, cluster configuration can now begin");
        this.configRequest.process();
        LOG.info("Cluster configuration finished successfully");
        this.notifyListeners();
        LOG.debug("Exiting");
        return true;
    }

    public long getTimeout() {
        long timeout = DEFAULT_TIMEOUT;
        String timeoutStr = this.topology.getConfiguration().getPropertyValue("cluster-env", TIMEOUT_PROPERTY_NAME);
        if (timeoutStr != null) {
            try {
                timeout = Long.parseLong(timeoutStr);
                LOG.info("Using custom timeout: {} ms", (Object)timeout);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public long getRepeatDelay() {
        return REPEAT_DELAY;
    }

    private Collection<String> getTopologyRequiredHostGroups() {
        try {
            return this.configRequest.getRequiredHostGroups();
        }
        catch (RuntimeException e) {
            LOG.error("Could not determine required host groups", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean areHostGroupsResolved(Collection<String> requiredHostGroups) {
        boolean allHostGroupsResolved = true;
        Map<String, HostGroupInfo> hostGroupInfo = this.topology.getHostGroupInfo();
        for (String hostGroup : requiredHostGroups) {
            int requestedHostCount;
            HostGroupInfo groupInfo = hostGroupInfo.get(hostGroup);
            if (groupInfo == null) {
                allHostGroupsResolved = false;
                if (!this.missingHostGroups.add(hostGroup)) continue;
                LOG.warn("Host group '{}' is missing from cluster creation request", (Object)hostGroup);
                continue;
            }
            int actualHostCount = groupInfo.getHostNames().size();
            boolean hostGroupReady = actualHostCount >= (requestedHostCount = groupInfo.getRequestedHostCount());
            allHostGroupsResolved &= hostGroupReady;
            Integer previousHostCount = this.previousHostCounts.put(hostGroup, actualHostCount);
            if (previousHostCount != null && previousHostCount == actualHostCount) continue;
            if (hostGroupReady) {
                LOG.info("Host group '{}' resolved, requires {} hosts and {} are available", new Object[]{groupInfo.getHostGroupName(), requestedHostCount, actualHostCount});
                continue;
            }
            LOG.info("Host group '{}' pending, requires {} hosts, but only {} are available", new Object[]{groupInfo.getHostGroupName(), requestedHostCount, actualHostCount});
        }
        return allHostGroupsResolved;
    }

    private void notifyListeners() throws OBDPException {
        long clusterId = this.topology.getClusterId();
        String clusterName = this.topology.getAmbariContext().getClusterName(clusterId);
        this.ambariEventPublisher.publish(new ClusterConfigFinishedEvent(clusterId, clusterName));
    }
}

