/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.addservice;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.recommendations.RecommendationResponse;
import id.onyx.obdp.server.api.services.stackadvisor.validations.ValidationResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.UnitUpdater;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.topology.ConfigRecommendationStrategy;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.addservice.AddServiceInfo;
import id.onyx.obdp.server.topology.addservice.HostGroupStrategy;
import id.onyx.obdp.server.topology.addservice.LayoutRecommendationInfo;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackAdvisorAdapter {
    @Inject
    private OBDPManagementController managementController;
    @Inject
    private StackAdvisorHelper stackAdvisorHelper;
    @Inject
    private id.onyx.obdp.server.configuration.Configuration serverConfig;
    @Inject
    private Injector injector;
    private static final Logger LOG = LoggerFactory.getLogger(StackAdvisorHelper.class);

    AddServiceInfo recommendLayout(AddServiceInfo info) {
        try {
            Map<String, Map<String, Set<String>>> allServices = this.getAllServices(info);
            Map<String, Set<String>> componentsToHosts = StackAdvisorAdapter.getComponentHostMap(allServices);
            Map<String, Set<String>> hostsToComponents = StackAdvisorAdapter.getHostComponentMap(componentsToHosts);
            ImmutableList hosts = ImmutableList.copyOf(this.getCluster(info).getHostNames());
            hosts.forEach(host -> hostsToComponents.putIfAbsent((String)host, new HashSet()));
            Map<String, Set<String>> hostGroups = this.getHostGroupStrategy().calculateHostGroups(hostsToComponents);
            StackAdvisorRequest request = StackAdvisorRequest.StackAdvisorRequestBuilder.forStack(info.getStack().getStackId()).ofType(StackAdvisorRequest.StackAdvisorRequestType.HOST_GROUPS).forHosts((List<String>)hosts).forServices(allServices.keySet()).forHostComponents(hostsToComponents).forHostsGroupBindings(hostGroups).withComponentHostsMap(componentsToHosts).withConfigurations(info.getConfig()).withGPLLicenseAccepted(this.serverConfig.getGplLicenseAccepted()).build();
            RecommendationResponse response = this.stackAdvisorHelper.recommend(request);
            Map<String, Map<String, Set<String>>> recommendedLayout = StackAdvisorAdapter.getRecommendedLayout(response.getRecommendations().getBlueprintClusterBinding().getHostgroupHostMap(), response.getRecommendations().getBlueprint().getHostgroupComponentMap(), info.getStack()::getServiceForComponent);
            Map<String, Set<String>> recommendedComponentHosts = StackAdvisorAdapter.getComponentHostMap(recommendedLayout);
            StackAdvisorRequest validationRequest = request.builder().forHostsGroupBindings(response.getRecommendations().getBlueprintClusterBinding().getHostgroupHostMap()).withComponentHostsMap(recommendedComponentHosts).forHostComponents(StackAdvisorAdapter.getHostComponentMap(recommendedComponentHosts)).build();
            this.validate(validationRequest);
            Map<String, Map<String, Set<String>>> newServiceRecommendations = StackAdvisorAdapter.keepNewServicesOnly(recommendedLayout, info.newServices());
            LayoutRecommendationInfo recommendationInfo = new LayoutRecommendationInfo(response.getRecommendations().getBlueprintClusterBinding().getHostgroupHostMap(), recommendedLayout);
            return info.withLayoutRecommendation(newServiceRecommendations, recommendationInfo);
        }
        catch (OBDPException | StackAdvisorException ex) {
            throw new IllegalArgumentException("Layout recommendation failed.", ex);
        }
    }

    Map<String, Map<String, Set<String>>> getAllServices(AddServiceInfo info) throws OBDPException {
        Cluster cluster = this.managementController.getClusters().getCluster(info.clusterName());
        Map clusterServices = Maps.transformValues(cluster.getServices(), service -> Maps.transformValues(service.getServiceComponents(), component -> component.getServiceComponentsHosts()));
        return StackAdvisorAdapter.mergeDisjunctMaps(clusterServices, info.newServices());
    }

    private Cluster getCluster(AddServiceInfo info) throws OBDPException {
        return this.managementController.getClusters().getCluster(info.clusterName());
    }

    AddServiceInfo recommendConfigurations(AddServiceInfo info) {
        Configuration config = info.getConfig();
        if (info.getRequest().getRecommendationStrategy().shouldUseStackAdvisor()) {
            RecommendationResponse response;
            LayoutRecommendationInfo layoutInfo = this.getLayoutRecommendationInfo(info);
            Map<String, Set<String>> componentHostMap = StackAdvisorAdapter.getComponentHostMap(layoutInfo.getAllServiceLayouts());
            Map<String, Set<String>> hostComponentMap = StackAdvisorAdapter.getHostComponentMap(componentHostMap);
            StackAdvisorRequest request = StackAdvisorRequest.StackAdvisorRequestBuilder.forStack(info.getStack().getStackId()).ofType(StackAdvisorRequest.StackAdvisorRequestType.CONFIGURATIONS).forHosts(layoutInfo.getHosts()).forServices(layoutInfo.getAllServiceLayouts().keySet()).forHostComponents(hostComponentMap).forHostsGroupBindings(layoutInfo.getHostGroups()).withComponentHostsMap(componentHostMap).withConfigurations(config).withGPLLicenseAccepted(this.serverConfig.getGplLicenseAccepted()).build();
            try {
                response = this.stackAdvisorHelper.recommend(request);
            }
            catch (OBDPException | StackAdvisorException ex) {
                throw new IllegalArgumentException("Configuration recommendation failed.", ex);
            }
            Map<String, RecommendationResponse.BlueprintConfigurations> configRecommendations = response.getRecommendations().getBlueprint().getConfigurations();
            configRecommendations.keySet().removeIf(configType -> !info.newServices().containsKey(info.getStack().getServiceForConfigType((String)configType)));
            if (info.getRequest().getRecommendationStrategy() == ConfigRecommendationStrategy.ONLY_STACK_DEFAULTS_APPLY) {
                StackAdvisorAdapter.removeNonStackConfigRecommendations(info.getConfig().getParentConfiguration().getParentConfiguration(), configRecommendations);
            }
            Configuration recommendedConfig = StackAdvisorAdapter.toConfiguration(configRecommendations);
            Configuration userConfig = config;
            Configuration clusterAndStackConfig = userConfig.getParentConfiguration();
            if (info.getRequest().getRecommendationStrategy().shouldOverrideCustomValues()) {
                config = recommendedConfig;
                config.setParentConfiguration(userConfig);
            } else {
                config.setParentConfiguration(recommendedConfig);
                recommendedConfig.setParentConfiguration(clusterAndStackConfig);
            }
            StackAdvisorRequest validationRequest = request.builder().withConfigurations(config).build();
            this.validate(validationRequest);
        }
        UnitUpdater.updateUnits(config, info.getStack());
        return info.withConfig(config);
    }

    LayoutRecommendationInfo getLayoutRecommendationInfo(AddServiceInfo info) {
        if (info.getRecommendationInfo().isPresent()) {
            return info.getRecommendationInfo().get();
        }
        try {
            Map<String, Map<String, Set<String>>> allServices = this.getAllServices(info);
            Map<String, Set<String>> hostGroups = this.getHostGroupStrategy().calculateHostGroups(StackAdvisorAdapter.getHostComponentMap(StackAdvisorAdapter.getComponentHostMap(allServices)));
            return new LayoutRecommendationInfo(hostGroups, allServices);
        }
        catch (OBDPException ex) {
            throw new IllegalArgumentException("Error gathering host groups and services", ex);
        }
    }

    static void removeNonStackConfigRecommendations(Configuration stackConfig, Map<String, RecommendationResponse.BlueprintConfigurations> configRecommendations) {
        configRecommendations.keySet().removeIf(configType -> !stackConfig.containsConfigType((String)configType));
        configRecommendations.entrySet().forEach(e -> {
            String cfgType = (String)e.getKey();
            RecommendationResponse.BlueprintConfigurations cfg = (RecommendationResponse.BlueprintConfigurations)e.getValue();
            cfg.getProperties().keySet().removeIf(propName -> !stackConfig.containsConfig(cfgType, (String)propName));
            if (null != cfg.getPropertyAttributes()) {
                cfg.getPropertyAttributes().keySet().removeIf(propName -> !stackConfig.containsConfig(cfgType, (String)propName));
            }
        });
        configRecommendations.values().removeIf(cfg -> cfg.getProperties().isEmpty() && cfg.getPropertyAttributes().isEmpty());
    }

    private void validate(StackAdvisorRequest request) {
        try {
            Set<ValidationResponse.ValidationItem> items = this.stackAdvisorHelper.validate(request).getItems();
            if (!items.isEmpty()) {
                LOG.warn("Issues found during recommended {} validation:\n{}", (Object)request.getRequestType(), (Object)Joiner.on((char)'\n').join(items));
            }
        }
        catch (StackAdvisorException ex) {
            LOG.error(request.getRequestType() + " validation failed", (Throwable)ex);
        }
    }

    static Configuration toConfiguration(Map<String, RecommendationResponse.BlueprintConfigurations> configs) {
        Map<String, Map<String, String>> properties = configs.entrySet().stream().filter(e -> ((RecommendationResponse.BlueprintConfigurations)e.getValue()).getProperties() != null && !((RecommendationResponse.BlueprintConfigurations)e.getValue()).getProperties().isEmpty()).map(e -> Pair.of((Object)((String)e.getKey()), ((RecommendationResponse.BlueprintConfigurations)e.getValue()).getProperties())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        Map<String, Map<String, Map<String, String>>> propertyAttributes = configs.entrySet().stream().filter(e -> ((RecommendationResponse.BlueprintConfigurations)e.getValue()).getPropertyAttributes() != null && !((RecommendationResponse.BlueprintConfigurations)e.getValue()).getPropertyAttributes().isEmpty()).map(e -> Pair.of((Object)((String)e.getKey()), ((RecommendationResponse.BlueprintConfigurations)e.getValue()).getPropertyAttributesAsMap())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return new Configuration(properties, propertyAttributes);
    }

    static Map<String, Map<String, Set<String>>> keepNewServicesOnly(Map<String, Map<String, Set<String>>> recommendedLayout, Map<String, Map<String, Set<String>>> newServices) {
        HashMap<String, Map<String, Set<String>>> newServiceRecommendations = new HashMap<String, Map<String, Set<String>>>(recommendedLayout);
        newServiceRecommendations.keySet().retainAll(newServices.keySet());
        return newServiceRecommendations;
    }

    static Map<String, Map<String, Set<String>>> getRecommendedLayout(Map<String, Set<String>> hostGroupHosts, Map<String, Set<String>> hostGroupComponents, Function<String, String> componentToService) {
        Map componentHostMap = hostGroupComponents.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(comp -> Pair.of((Object)comp, (Object)((String)entry.getKey())))).flatMap(cmpHg -> ((Set)hostGroupHosts.get(cmpHg.getValue())).stream().map(host -> Pair.of((Object)((String)cmpHg.getKey()), (Object)host))).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
        return componentHostMap.entrySet().stream().collect(Collectors.groupingBy(cmpHost -> (String)componentToService.apply((String)cmpHost.getKey()), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    static Map<String, Set<String>> getHostComponentMap(Map<String, Set<String>> componentHostMap) {
        return componentHostMap.entrySet().stream().flatMap(compHosts -> ((Set)compHosts.getValue()).stream().map(host -> Pair.of((Object)host, (Object)((String)compHosts.getKey())))).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
    }

    static Map<String, Set<String>> getComponentHostMap(Map<String, Map<String, Set<String>>> serviceComponentHostMap) {
        return serviceComponentHostMap.values().stream().reduce(StackAdvisorAdapter::mergeDisjunctMaps).orElse(new HashMap());
    }

    static <S, T> Map<S, T> mergeDisjunctMaps(Map<? extends S, ? extends T> map1, Map<? extends S, ? extends T> map2) {
        Sets.SetView commonKeys = Sets.intersection(map1.keySet(), map2.keySet());
        Preconditions.checkArgument((boolean)commonKeys.isEmpty(), (String)"Maps must be disjunct. Common keys: %s", (Object)commonKeys);
        HashMap<S, T> merged = new HashMap<S, T>(map1);
        merged.putAll(map2);
        return merged;
    }

    HostGroupStrategy getHostGroupStrategy() {
        try {
            return (HostGroupStrategy)this.injector.getInstance(this.serverConfig.getAddServiceHostGroupStrategyClass());
        }
        catch (ConfigurationException | ProvisionException | ClassCastException | ClassNotFoundException ex) {
            throw new IllegalStateException("Cannot load host group strategy", ex);
        }
    }
}

