/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.addservice;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.ClusterRequest;
import id.onyx.obdp.server.controller.ConfigurationRequest;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.ArtifactResourceProvider;
import id.onyx.obdp.server.controller.internal.CredentialResourceProvider;
import id.onyx.obdp.server.controller.internal.HostComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.ServiceResourceProvider;
import id.onyx.obdp.server.controller.predicate.AndPredicate;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.predicate.OrPredicate;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.topology.Credential;
import id.onyx.obdp.server.topology.ProvisionStep;
import id.onyx.obdp.server.topology.addservice.AddServiceInfo;
import id.onyx.obdp.server.utils.LoggingPreconditions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ResourceProviderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceProviderAdapter.class);
    private static final LoggingPreconditions CHECK = new LoggingPreconditions(LOG);
    private final KerberosDescriptorFactory descriptorFactory = new KerberosDescriptorFactory();
    @Inject
    private OBDPManagementController controller;

    public void createServices(AddServiceInfo request) {
        LOG.info("Creating service resources for {}", (Object)request);
        Set<Map<String, Object>> properties = request.newServices().keySet().stream().map(service -> ResourceProviderAdapter.createServiceRequestProperties(request, service)).collect(Collectors.toSet());
        ResourceProviderAdapter.createResources(request, Resource.Type.Service, properties, null, false);
    }

    public void createComponents(AddServiceInfo request) {
        LOG.info("Creating component resources for {}", (Object)request);
        Set<Map<String, Object>> properties = request.newServices().entrySet().stream().flatMap(componentsOfService -> ((Map)componentsOfService.getValue()).keySet().stream().map(component -> ResourceProviderAdapter.createComponentRequestProperties(request, (String)componentsOfService.getKey(), component))).collect(Collectors.toSet());
        ResourceProviderAdapter.createResources(request, Resource.Type.Component, properties, null, false);
    }

    public void createHostComponents(AddServiceInfo request) {
        LOG.info("Creating host component resources for {}", (Object)request);
        Set<Map<String, Object>> properties = request.newServices().entrySet().stream().flatMap(componentsOfService -> ((Map)componentsOfService.getValue()).entrySet().stream().flatMap(hostsOfComponent -> ((Set)hostsOfComponent.getValue()).stream().map(host -> ResourceProviderAdapter.createHostComponentRequestProperties(request, (String)componentsOfService.getKey(), (String)hostsOfComponent.getKey(), host)))).collect(Collectors.toSet());
        ResourceProviderAdapter.createResources(request, Resource.Type.HostComponent, properties, null, false);
    }

    public void createConfigs(AddServiceInfo request) {
        LOG.info("Creating configurations for {}", (Object)request);
        Set<ClusterRequest> requests = ResourceProviderAdapter.createConfigRequestsForNewServices(request);
        this.updateCluster(request, requests, "Error creating configurations for %s");
    }

    public void createCredentials(AddServiceInfo request) {
        if (!request.getRequest().getCredentials().isEmpty()) {
            LOG.info("Creating {} credential(s) for {}", (Object)request.getRequest().getCredentials().size(), (Object)request);
            request.getRequest().getCredentials().values().stream().peek(credential -> LOG.debug("Creating credential {}", credential)).map(credential -> ResourceProviderAdapter.createCredentialRequestProperties(request.clusterName(), credential)).forEach(properties -> ResourceProviderAdapter.createResources(request, Resource.Type.Credential, (Set<Map<String, Object>>)ImmutableSet.of((Object)properties), null, true));
        }
    }

    public Optional<KerberosDescriptor> getKerberosDescriptor(AddServiceInfo request) {
        Predicate predicate;
        ImmutableSet propertyIds = ImmutableSet.of((Object)"artifact_data");
        Set<Resource> resources = ResourceProviderAdapter.getResources(request, (Set<String>)propertyIds, Resource.Type.Artifact, predicate = ResourceProviderAdapter.predicateForKerberosDescriptorArtifact(request.clusterName()));
        if (resources == null || resources.isEmpty()) {
            return Optional.empty();
        }
        CHECK.checkArgument(resources.size() == 1, "Expected only one artifact of type %s, but got %d", "kerberos_descriptor", resources.size());
        return Optional.of(this.descriptorFactory.createInstance(resources.iterator().next().getPropertiesMap().get("artifact_data")));
    }

    public void createKerberosDescriptor(AddServiceInfo request, KerberosDescriptor descriptor) {
        LOG.info("Creating Kerberos descriptor for {}", (Object)request);
        Map<String, Object> properties = ResourceProviderAdapter.createKerberosDescriptorRequestProperties(request.clusterName());
        Map<String, String> requestInfo = ResourceProviderAdapter.requestInfoForKerberosDescriptor(descriptor);
        ResourceProviderAdapter.createResources(request, Resource.Type.Artifact, (Set<Map<String, Object>>)ImmutableSet.of(properties), requestInfo, false);
    }

    public void updateKerberosDescriptor(AddServiceInfo request, KerberosDescriptor descriptor) {
        LOG.info("Updating Kerberos descriptor from {}", (Object)request);
        Map<String, Object> properties = ResourceProviderAdapter.createKerberosDescriptorRequestProperties(request.clusterName());
        Map<String, String> requestInfo = ResourceProviderAdapter.requestInfoForKerberosDescriptor(descriptor);
        Predicate predicate = ResourceProviderAdapter.predicateForKerberosDescriptorArtifact(request.clusterName());
        ResourceProviderAdapter.updateResources(request, (Set<Map<String, Object>>)ImmutableSet.of(properties), Resource.Type.Artifact, predicate, requestInfo);
    }

    public void updateExistingConfigs(AddServiceInfo request, Set<String> existingServices) {
        LOG.info("Updating existing configurations for {}", (Object)request);
        Set<ClusterRequest> requests = this.createConfigRequestsForExistingServices(request, existingServices);
        this.updateCluster(request, requests, "Error updating configurations for %s");
    }

    public void updateServiceDesiredState(AddServiceInfo request, State desiredState) {
        LOG.info("Updating service desired state to {} for {}", (Object)desiredState, (Object)request);
        ImmutableSet properties = ImmutableSet.of((Object)ImmutableMap.of((Object)ServiceResourceProvider.SERVICE_SERVICE_STATE_PROPERTY_ID, (Object)desiredState.name()));
        Map<String, String> requestInfo = RequestOperationLevel.propertiesFor(Resource.Type.Service, request.clusterName());
        Predicate predicate = ResourceProviderAdapter.predicateForNewServices(request);
        ResourceProviderAdapter.updateResources(request, (Set<Map<String, Object>>)properties, Resource.Type.Service, predicate, requestInfo);
    }

    public void updateHostComponentDesiredState(AddServiceInfo request, Predicate predicate, ProvisionStep step) {
        State desiredState = step.getDesiredStateToSet();
        LOG.info("Updating host component desired state to {} per {} for {}", new Object[]{desiredState, step, request});
        LOG.debug("Using predicate {}", (Object)predicate);
        ImmutableSet properties = ImmutableSet.of((Object)ImmutableMap.of((Object)HostComponentResourceProvider.STATE, (Object)desiredState.name(), (Object)"context", (Object)String.format("Put new components to %s state", new Object[]{desiredState})));
        ImmutableMap requestInfo = new ImmutableMap.Builder().putAll(RequestOperationLevel.propertiesFor(Resource.Type.HostComponent, request.clusterName())).putAll(step.getProvisionProperties()).build();
        HostComponentResourceProvider rp = (HostComponentResourceProvider)ResourceProviderAdapter.getClusterController().ensureResourceProvider(Resource.Type.HostComponent);
        Request internalRequest = ResourceProviderAdapter.createRequest((Set<Map<String, Object>>)properties, (Map<String, String>)requestInfo, null);
        try {
            rp.doUpdateResources(request.getStages(), internalRequest, predicate, false, false, false);
        }
        catch (NoSuchParentResourceException | NoSuchResourceException | SystemException | UnsupportedPropertyException e) {
            CHECK.wrapInUnchecked(e, RuntimeException::new, "Error updating host component desired state for %s", request);
        }
    }

    private static Set<Resource> getResources(AddServiceInfo request, Set<String> propertyIds, Resource.Type resourceType, Predicate predicate) {
        Request internalRequest = ResourceProviderAdapter.createRequest(null, null, propertyIds);
        ResourceProvider rp = ResourceProviderAdapter.getClusterController().ensureResourceProvider(resourceType);
        try {
            return rp.getResources(internalRequest, predicate);
        }
        catch (NoSuchResourceException e) {
            return ImmutableSet.of();
        }
        catch (NoSuchParentResourceException | SystemException | UnsupportedPropertyException e) {
            return (Set)CHECK.wrapInUnchecked(e, RuntimeException::new, "Error getting resources %s for %s", resourceType, request);
        }
    }

    private static void createResources(AddServiceInfo request, Resource.Type resourceType, Set<Map<String, Object>> properties, Map<String, String> requestInfo, boolean okIfExists) {
        Request internalRequest = ResourceProviderAdapter.createRequest(properties, requestInfo, null);
        ResourceProvider rp = ResourceProviderAdapter.getClusterController().ensureResourceProvider(resourceType);
        try {
            rp.createResources(internalRequest);
        }
        catch (NoSuchParentResourceException | ResourceAlreadyExistsException | SystemException | UnsupportedPropertyException e) {
            if (okIfExists && e instanceof ResourceAlreadyExistsException) {
                LOG.info("Resource already exists: {}, no need to create", (Object)e.getMessage());
            }
            CHECK.wrapInUnchecked(e, RuntimeException::new, "Error creating resources %s for %s", resourceType, request);
        }
    }

    private static void updateResources(AddServiceInfo request, Set<Map<String, Object>> properties, Resource.Type resourceType, Predicate predicate, Map<String, String> requestInfo) {
        Request internalRequest = ResourceProviderAdapter.createRequest(properties, requestInfo, null);
        ResourceProvider rp = ResourceProviderAdapter.getClusterController().ensureResourceProvider(resourceType);
        try {
            rp.updateResources(internalRequest, predicate);
        }
        catch (NoSuchParentResourceException | NoSuchResourceException | SystemException | UnsupportedPropertyException e) {
            CHECK.wrapInUnchecked(e, RuntimeException::new, "Error updating resources %s for %s", resourceType, request);
        }
    }

    private void updateCluster(AddServiceInfo addServiceRequest, Set<ClusterRequest> requests, String errorMessageFormat) {
        try {
            this.controller.updateClusters(requests, null);
        }
        catch (OBDPException | AuthorizationException e) {
            CHECK.wrapInUnchecked((Exception)e, RuntimeException::new, errorMessageFormat, addServiceRequest);
        }
    }

    private static Request createRequest(Set<Map<String, Object>> properties, Map<String, String> requestInfoProperties, Set<String> propertyIds) {
        return new RequestImpl(propertyIds, properties, requestInfoProperties, null);
    }

    public static Map<String, String> requestInfoForKerberosDescriptor(KerberosDescriptor descriptor) {
        return ImmutableMap.of((Object)"RAW_REQUEST_BODY", (Object)ArtifactResourceProvider.toArtifactDataJson(descriptor.toMap()));
    }

    private static Map<String, Object> createServiceRequestProperties(AddServiceInfo request, String service) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)ServiceResourceProvider.SERVICE_CLUSTER_NAME_PROPERTY_ID, (Object)request.clusterName());
        properties.put((Object)ServiceResourceProvider.SERVICE_SERVICE_NAME_PROPERTY_ID, (Object)service);
        properties.put((Object)ServiceResourceProvider.SERVICE_SERVICE_STATE_PROPERTY_ID, (Object)State.INIT.name());
        return properties.build();
    }

    private static Map<String, Object> createComponentRequestProperties(AddServiceInfo request, String service, String component) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"ServiceComponentInfo/cluster_name", (Object)request.clusterName());
        properties.put((Object)"ServiceComponentInfo/service_name", (Object)service);
        properties.put((Object)"ServiceComponentInfo/component_name", (Object)component);
        properties.put((Object)"ServiceComponentInfo/state", (Object)State.INIT.name());
        return properties.build();
    }

    private static Map<String, Object> createHostComponentRequestProperties(AddServiceInfo request, String service, String component, String host) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)HostComponentResourceProvider.CLUSTER_NAME, (Object)request.clusterName());
        properties.put((Object)HostComponentResourceProvider.SERVICE_NAME, (Object)service);
        properties.put((Object)HostComponentResourceProvider.COMPONENT_NAME, (Object)component);
        properties.put((Object)HostComponentResourceProvider.HOST_NAME, (Object)host);
        properties.put((Object)HostComponentResourceProvider.STATE, (Object)State.INIT.name());
        return properties.build();
    }

    public static Map<String, Object> createCredentialRequestProperties(String clusterName, Credential credential) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)CredentialResourceProvider.CREDENTIAL_CLUSTER_NAME_PROPERTY_ID, (Object)clusterName);
        properties.put((Object)CredentialResourceProvider.CREDENTIAL_ALIAS_PROPERTY_ID, (Object)credential.getAlias());
        properties.put((Object)CredentialResourceProvider.CREDENTIAL_PRINCIPAL_PROPERTY_ID, (Object)credential.getPrincipal());
        properties.put((Object)CredentialResourceProvider.CREDENTIAL_KEY_PROPERTY_ID, (Object)credential.getKey());
        properties.put((Object)CredentialResourceProvider.CREDENTIAL_TYPE_PROPERTY_ID, (Object)credential.getType().name());
        return properties.build();
    }

    public static Map<String, Object> createKerberosDescriptorRequestProperties(String clusterName) {
        return ImmutableMap.of((Object)"Artifacts/cluster_name", (Object)clusterName, (Object)"Artifacts/artifact_name", (Object)"kerberos_descriptor");
    }

    private static Set<ClusterRequest> createConfigRequestsForNewServices(AddServiceInfo request) {
        Map<String, Map<String, String>> fullProperties = request.getConfig().getFullProperties();
        Map<String, Map<String, Map<String, String>>> fullAttributes = request.getConfig().getFullAttributes();
        return ResourceProviderAdapter.createConfigRequestsForServices(request.newServices().keySet(), configType -> !Objects.equals(configType, "cluster-env"), request, fullProperties, fullAttributes);
    }

    private Set<ClusterRequest> createConfigRequestsForExistingServices(AddServiceInfo request, Set<String> existingServices) {
        ImmutableSet configTypesInRequest = ImmutableSet.copyOf((Collection)Sets.difference((Set)Sets.union(request.getConfig().getProperties().keySet(), request.getConfig().getAttributes().keySet()), (Set)ImmutableSet.of((Object)"cluster-env")));
        Map<String, Map<String, String>> fullProperties = request.getConfig().getFullProperties();
        Map<String, Map<String, Map<String, String>>> fullAttributes = request.getConfig().getFullAttributes();
        Set<ClusterRequest> clusterRequests = ResourceProviderAdapter.createConfigRequestsForServices(existingServices, ((Set)configTypesInRequest)::contains, request, fullProperties, fullAttributes);
        if (request.getConfig().getProperties().containsKey("cluster-env")) {
            Optional<ClusterRequest> clusterEnvRequest = ResourceProviderAdapter.createConfigRequestForConfigTypes(Stream.of("cluster-env"), request, fullProperties, fullAttributes);
            clusterEnvRequest.ifPresent(clusterRequests::add);
        }
        return clusterRequests;
    }

    private static Set<ClusterRequest> createConfigRequestsForServices(Set<String> services, java.util.function.Predicate<String> predicate, AddServiceInfo request, Map<String, Map<String, String>> fullProperties, Map<String, Map<String, Map<String, String>>> fullAttributes) {
        return services.stream().map(service -> ResourceProviderAdapter.createConfigRequestForConfigTypes(request.getStack().getConfigurationTypes((String)service).stream().filter(predicate), request, fullProperties, fullAttributes)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static Optional<ClusterRequest> createConfigRequestForConfigTypes(Stream<String> configTypes, AddServiceInfo addServiceRequest, Map<String, Map<String, String>> fullProperties, Map<String, Map<String, Map<String, String>>> fullAttributes) {
        List<ConfigurationRequest> configRequests = configTypes.peek(configType -> LOG.info("Creating request for config type {} for {}", configType, (Object)addServiceRequest)).map(configType -> new ConfigurationRequest(addServiceRequest.clusterName(), (String)configType, "ADD_SERVICE_" + System.currentTimeMillis(), (Map)fullProperties.getOrDefault(configType, (Map<String, String>)ImmutableMap.of()), (Map)fullAttributes.getOrDefault(configType, (Map<String, Map<String, String>>)ImmutableMap.of()))).collect(Collectors.toList());
        if (configRequests.isEmpty()) {
            return Optional.empty();
        }
        ClusterRequest clusterRequest = new ClusterRequest(null, addServiceRequest.clusterName(), null, null);
        clusterRequest.setDesiredConfig(configRequests);
        return Optional.of(clusterRequest);
    }

    public static Predicate predicateForKerberosDescriptorArtifact(String clusterName) {
        return new PredicateBuilder().begin().property("Artifacts/cluster_name").equals(clusterName).and().property("Artifacts/artifact_name").equals("kerberos_descriptor").end().toPredicate();
    }

    private static Predicate predicateForNewServices(AddServiceInfo request) {
        return new AndPredicate(new EqualsPredicate(ServiceResourceProvider.SERVICE_CLUSTER_NAME_PROPERTY_ID, request.clusterName()), OrPredicate.of(request.newServices().keySet().stream().map(service -> new EqualsPredicate(ServiceResourceProvider.SERVICE_SERVICE_NAME_PROPERTY_ID, service)).collect(Collectors.toList())));
    }

    private static ClusterController getClusterController() {
        return ClusterControllerHelper.getClusterController();
    }
}

