/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.addservice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.controller.internal.UnitUpdater;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.SecurityConfigurationFactory;
import id.onyx.obdp.server.topology.StackFactory;
import id.onyx.obdp.server.topology.addservice.AddServiceInfo;
import id.onyx.obdp.server.topology.addservice.AddServiceRequest;
import id.onyx.obdp.server.topology.addservice.Component;
import id.onyx.obdp.server.topology.addservice.Host;
import id.onyx.obdp.server.topology.addservice.Service;
import id.onyx.obdp.server.utils.LoggingPreconditions;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(RequestValidator.class);
    private static final LoggingPreconditions CHECK = new LoggingPreconditions(LOG);
    private static final Set<String> NOT_ALLOWED_CONFIG_TYPES = ImmutableSet.of((Object)"kerberos-env", (Object)"krb5-conf");
    private final AddServiceRequest request;
    private final Cluster cluster;
    private final OBDPManagementController controller;
    private final ConfigHelper configHelper;
    private final StackFactory stackFactory;
    private final KerberosDescriptorFactory kerberosDescriptorFactory;
    private final AtomicBoolean serviceInfoCreated = new AtomicBoolean();
    private final SecurityConfigurationFactory securityConfigurationFactory;
    private State state = State.INITIAL;

    @Inject
    public RequestValidator(@Assisted AddServiceRequest request, @Assisted Cluster cluster, OBDPManagementController controller, ConfigHelper configHelper, StackFactory stackFactory, KerberosDescriptorFactory kerberosDescriptorFactory, SecurityConfigurationFactory securityConfigurationFactory) {
        this.request = request;
        this.cluster = cluster;
        this.controller = controller;
        this.configHelper = configHelper;
        this.stackFactory = stackFactory;
        this.kerberosDescriptorFactory = kerberosDescriptorFactory;
        this.securityConfigurationFactory = securityConfigurationFactory;
    }

    void validate() {
        this.validateStack();
        this.validateServicesAndComponents();
        this.validateSecurity();
        this.validateHosts();
        this.validateConfiguration();
    }

    AddServiceInfo createValidServiceInfo(ActionManager actionManager, RequestFactory requestFactory) {
        State state = this.state;
        CHECK.checkState(state.isValid(), "The request needs to be validated first", new Object[0]);
        CHECK.checkState(!this.serviceInfoCreated.getAndSet(true), "Can create only one instance for each validated add service request", new Object[0]);
        RequestStageContainer stages = new RequestStageContainer(actionManager.getNextRequestId(), null, requestFactory, actionManager);
        AddServiceInfo validatedRequest = new AddServiceInfo.Builder().setRequest(this.request).setClusterName(this.cluster.getClusterName()).setStages(stages).setStack(state.getStack()).setConfig(state.getConfig()).setNewServices(state.getNewServices()).setKerberosDescriptor(state.getKerberosDescriptor()).build();
        stages.setRequestContext(validatedRequest.describe());
        return validatedRequest;
    }

    @VisibleForTesting
    State getState() {
        return this.state;
    }

    @VisibleForTesting
    void setState(State state) {
        this.state = state;
    }

    @VisibleForTesting
    void validateSecurity() {
        this.request.getSecurity().ifPresent(requestSecurity -> {
            CHECK.checkArgument(!this.strictValidation() || requestSecurity.getType() == this.cluster.getSecurityType(), "Security type in the request (%s), if specified, should match cluster's security type (%s)", new Object[]{requestSecurity.getType(), this.cluster.getSecurityType()});
            boolean hasDescriptor = requestSecurity.getDescriptor().isPresent();
            boolean hasDescriptorReference = requestSecurity.getDescriptorReference() != null;
            boolean secureCluster = this.cluster.getSecurityType() == SecurityType.KERBEROS;
            CHECK.checkArgument(secureCluster || !hasDescriptor, "Kerberos descriptor cannot be set for security type %s", new Object[]{this.cluster.getSecurityType()});
            CHECK.checkArgument(secureCluster || !hasDescriptorReference, "Kerberos descriptor reference cannot be set for security type %s", new Object[]{this.cluster.getSecurityType()});
            CHECK.checkArgument(!hasDescriptor || !hasDescriptorReference, "Kerberos descriptor and reference cannot be both set", new Object[0]);
            Optional<Map<Object, Object>> kerberosDescriptor = hasDescriptor ? requestSecurity.getDescriptor() : (hasDescriptorReference ? this.loadKerberosDescriptor(requestSecurity.getDescriptorReference()) : Optional.empty());
            kerberosDescriptor.ifPresent(descriptorMap -> {
                CHECK.checkState(this.state.getNewServices() != null, "Services need to be validated before security settings", new Object[0]);
                KerberosDescriptor descriptor = this.kerberosDescriptorFactory.createInstance((Map<?, ?>)descriptorMap);
                if (this.strictValidation()) {
                    Map<String, KerberosServiceDescriptor> descriptorServices = descriptor.getServices();
                    Object servicesWithNewDescriptor = descriptorServices != null ? descriptorServices.keySet() : ImmutableSet.of();
                    Set<String> newServices = this.state.getNewServices().keySet();
                    ImmutableSet nonNewServices = ImmutableSet.copyOf((Collection)Sets.difference((Set)servicesWithNewDescriptor, newServices));
                    CHECK.checkArgument(nonNewServices.isEmpty(), "Kerberos descriptor should be provided only for new services, but found other services: %s", nonNewServices);
                }
                try {
                    descriptor.toMap();
                }
                catch (Exception e) {
                    CHECK.wrapInUnchecked(e, IllegalArgumentException::new, "Error validating Kerberos descriptor: %s", e);
                }
                this.state = this.state.with(descriptor);
            });
        });
    }

    @VisibleForTesting
    void validateStack() {
        Optional<StackId> requestStackId = this.request.getStackId();
        StackId stackId = requestStackId.orElseGet(this.cluster::getCurrentStackVersion);
        try {
            Stack stack = this.stackFactory.createStack(stackId.getStackName(), stackId.getStackVersion(), this.controller);
            this.state = this.state.with(stack);
        }
        catch (OBDPException e) {
            CHECK.wrapInUnchecked((Exception)((Object)e), requestStackId.isPresent() ? IllegalArgumentException::new : IllegalStateException::new, "Stack %s not found", stackId);
        }
    }

    @VisibleForTesting
    void validateServicesAndComponents() {
        Stack stack = this.state.getStack();
        LinkedHashMap<String, Map<String, Set<String>>> newServices = new LinkedHashMap<String, Map<String, Set<String>>>();
        LinkedHashMap<String, Map> withAllHosts = new LinkedHashMap<String, Map>();
        Set<String> existingServices = this.cluster.getServices().keySet();
        for (Service service2 : this.request.getServices()) {
            String serviceName = service2.getName();
            CHECK.checkArgument(stack.getServices().contains(serviceName), "Unknown service %s in %s", service2, stack);
            CHECK.checkArgument(!existingServices.contains(serviceName), "Service %s already exists in cluster %s", serviceName, this.cluster.getClusterName());
            newServices.computeIfAbsent(serviceName, __ -> new HashMap());
        }
        for (Component requestedComponent : this.request.getComponents()) {
            String componentName = requestedComponent.getName();
            String serviceName = stack.getServiceForComponent(componentName);
            CHECK.checkArgument(serviceName != null, "No service found for component %s in %s", componentName, stack);
            CHECK.checkArgument(!existingServices.contains(serviceName), "Service %s (for component %s) already exists in cluster %s", serviceName, componentName, this.cluster.getClusterName());
            List hosts = requestedComponent.getHosts().stream().map(Host::getFqdn).collect(Collectors.toList());
            newServices.computeIfAbsent(serviceName, __ -> new HashMap()).computeIfAbsent(componentName, __ -> new HashSet()).addAll(hosts);
            withAllHosts.computeIfAbsent(serviceName, __ -> new HashMap()).computeIfAbsent(componentName, __ -> HashMultiset.create()).addAll(hosts);
        }
        CHECK.checkArgument(!newServices.isEmpty(), "Request should have at least one new service or component to be added", new Object[0]);
        newServices.forEach((service, components) -> components.forEach((component, hosts) -> {
            Multiset allHosts = (Multiset)((Map)withAllHosts.get(service)).get(component);
            Multisets.removeOccurrences((Multiset)allHosts, (Iterable)hosts);
            CHECK.checkArgument(allHosts.isEmpty(), "Some hosts appear multiple times for the same component (%s) in the request: %s", component, allHosts);
        }));
        this.state = this.state.withNewServices(newServices);
    }

    @VisibleForTesting
    void validateConfiguration() {
        Configuration config = this.request.getConfiguration();
        if (this.strictValidation()) {
            for (String type : NOT_ALLOWED_CONFIG_TYPES) {
                CHECK.checkArgument(!config.getProperties().containsKey(type), "Cannot change '%s' configuration in Add Service request", type);
            }
        }
        Configuration clusterConfig = this.getClusterDesiredConfigs();
        clusterConfig.setParentConfiguration(this.state.getStack().getDefaultConfig());
        config.setParentConfiguration(clusterConfig);
        UnitUpdater.removeUnits(config, this.state.getStack());
        this.state = this.state.with(config);
    }

    @VisibleForTesting
    void validateHosts() {
        Set<String> clusterHosts = this.cluster.getHostNames();
        Set requestHosts = this.state.getNewServices().values().stream().flatMap(componentHosts -> componentHosts.values().stream()).flatMap(Collection::stream).collect(Collectors.toSet());
        TreeSet unknownHosts = new TreeSet(Sets.difference(requestHosts, clusterHosts));
        CHECK.checkArgument(unknownHosts.isEmpty(), "Requested host not associated with cluster %s: %s", this.cluster.getClusterName(), unknownHosts);
    }

    private boolean strictValidation() {
        return this.request.getValidationType().strictValidation();
    }

    private Configuration getClusterDesiredConfigs() {
        try {
            return Configuration.of(this.configHelper.calculateExistingConfigs(this.cluster));
        }
        catch (OBDPException e) {
            return (Configuration)CHECK.wrapInUnchecked((Exception)((Object)e), IllegalStateException::new, "Error getting effective configuration of cluster %s", this.cluster.getClusterName());
        }
    }

    private Optional<Map<?, ?>> loadKerberosDescriptor(String descriptorReference) {
        return this.securityConfigurationFactory.loadSecurityConfigurationByReference(descriptorReference).getDescriptor();
    }

    @VisibleForTesting
    static class State {
        static final State INITIAL = new State(null, null, null, null);
        private final Stack stack;
        private final Map<String, Map<String, Set<String>>> newServices;
        private final Configuration config;
        private final KerberosDescriptor kerberosDescriptor;

        State(Stack stack, Map<String, Map<String, Set<String>>> newServices, Configuration config, KerberosDescriptor kerberosDescriptor) {
            this.stack = stack;
            this.newServices = newServices;
            this.config = config;
            this.kerberosDescriptor = kerberosDescriptor;
        }

        boolean isValid() {
            return this.stack != null && this.newServices != null && this.config != null;
        }

        State with(Stack stack) {
            return new State(stack, this.newServices, this.config, this.kerberosDescriptor);
        }

        State withNewServices(Map<String, Map<String, Set<String>>> newServices) {
            return new State(this.stack, newServices, this.config, this.kerberosDescriptor);
        }

        State with(Configuration config) {
            return new State(this.stack, this.newServices, config, this.kerberosDescriptor);
        }

        State with(KerberosDescriptor kerberosDescriptor) {
            return new State(this.stack, this.newServices, this.config, kerberosDescriptor);
        }

        Stack getStack() {
            return this.stack;
        }

        Map<String, Map<String, Set<String>>> getNewServices() {
            return this.newServices;
        }

        Configuration getConfig() {
            return this.config;
        }

        KerberosDescriptor getKerberosDescriptor() {
            return this.kerberosDescriptor;
        }
    }
}

