/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.addservice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.internal.HostComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.predicate.Predicates;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.topology.ProvisionStep;
import id.onyx.obdp.server.topology.addservice.AddServiceInfo;
import id.onyx.obdp.server.topology.addservice.Component;
import id.onyx.obdp.server.topology.addservice.Host;
import id.onyx.obdp.server.topology.addservice.Service;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ProvisionActionPredicateBuilder {
    private final Map<ProvisionStep, Predicate> predicates = new EnumMap<ProvisionStep, Predicate>(ProvisionStep.class);
    private final AddServiceInfo request;
    private final Map<String, ProvisionAction> customServiceActions;
    private final Map<String, Map<String, Map<ProvisionAction, Set<String>>>> customComponentActions;
    private final Map<ProvisionStep, List<Predicate>> servicePredicatesByStep;

    public ProvisionActionPredicateBuilder(AddServiceInfo request) {
        this.request = request;
        this.customServiceActions = this.findServicesWithCustomAction();
        this.customComponentActions = this.findComponentsWithCustomAction();
        this.servicePredicatesByStep = this.createServicePredicates();
        this.createGlobalPredicates();
    }

    public Optional<Predicate> getPredicate(ProvisionStep action) {
        return Optional.ofNullable(this.predicates.get((Object)action));
    }

    private void createGlobalPredicates() {
        Preconditions.checkState((this.servicePredicatesByStep != null ? 1 : 0) != 0);
        Function<Predicate, Predicate> andClusterNameMatches = Predicates.and(ProvisionActionPredicateBuilder.clusterNameIs(this.request.clusterName()));
        for (Map.Entry<ProvisionStep, List<Predicate>> entry : this.servicePredicatesByStep.entrySet()) {
            ProvisionStep step = entry.getKey();
            List<Predicate> servicePredicates = entry.getValue();
            Predicates.anyOf(servicePredicates).map(andClusterNameMatches).ifPresent(predicate -> this.predicates.put(step, (Predicate)predicate));
        }
    }

    private Map<ProvisionStep, List<Predicate>> createServicePredicates() {
        Preconditions.checkState((this.customServiceActions != null ? 1 : 0) != 0);
        Preconditions.checkState((this.customComponentActions != null ? 1 : 0) != 0);
        ProvisionAction requestAction = this.request.getRequest().getProvisionAction();
        EnumMap<ProvisionStep, List<Predicate>> servicePredicatesByStep = new EnumMap<ProvisionStep, List<Predicate>>(ProvisionStep.class);
        for (Map.Entry<String, Map<String, Set<String>>> serviceEntry : this.request.newServices().entrySet()) {
            String serviceName = serviceEntry.getKey();
            Map<String, Set<String>> hostsByComponent = serviceEntry.getValue();
            ProvisionAction serviceAction = this.customServiceActions.getOrDefault(serviceName, requestAction);
            Predicate serviceNamePredicate = ProvisionActionPredicateBuilder.serviceNameIs(serviceName);
            Map<String, Map<ProvisionAction, Set<String>>> customActionByComponent = this.customComponentActions.get(serviceName);
            if (customActionByComponent == null) {
                ProvisionActionPredicateBuilder.classifyItem(serviceAction, serviceNamePredicate, servicePredicatesByStep);
                continue;
            }
            Map<ProvisionStep, List<Predicate>> componentPredicatesByStep = ProvisionActionPredicateBuilder.createComponentPredicates(serviceAction, hostsByComponent, customActionByComponent);
            ProvisionActionPredicateBuilder.applyComponentOverrides(servicePredicatesByStep, serviceNamePredicate, componentPredicatesByStep);
        }
        return servicePredicatesByStep;
    }

    private static void applyComponentOverrides(Map<ProvisionStep, List<Predicate>> servicePredicatesByStep, Predicate serviceNamePredicate, Map<ProvisionStep, List<Predicate>> componentPredicatesByStep) {
        Function<Predicate, Predicate> andServiceNameMatches = Predicates.and(serviceNamePredicate);
        for (Map.Entry<ProvisionStep, List<Predicate>> entry : componentPredicatesByStep.entrySet()) {
            ProvisionStep step = entry.getKey();
            List<Predicate> componentPredicates = entry.getValue();
            Predicates.anyOf(componentPredicates).map(andServiceNameMatches).ifPresent(predicate -> servicePredicatesByStep.computeIfAbsent(step, __ -> new LinkedList()).add(predicate));
        }
    }

    private static Map<ProvisionStep, List<Predicate>> createComponentPredicates(ProvisionAction serviceAction, Map<String, Set<String>> hostsByComponent, Map<String, Map<ProvisionAction, Set<String>>> customActionByComponent) {
        EnumMap componentPredicatesByStep = new EnumMap(ProvisionStep.class);
        for (Map.Entry<String, Set<String>> componentEntry : hostsByComponent.entrySet()) {
            String componentName = componentEntry.getKey();
            Set<String> allHosts = componentEntry.getValue();
            Map<ProvisionAction, Set<String>> hostsByAction = customActionByComponent.getOrDefault(componentName, (Map<ProvisionAction, Set<String>>)ImmutableMap.of());
            if (!hostsByAction.isEmpty()) {
                HashSet<String> customActionHosts = new HashSet<String>();
                for (Map.Entry<ProvisionAction, Set<String>> e : hostsByAction.entrySet()) {
                    ProvisionAction componentAction = e.getKey();
                    Set<String> hosts = e.getValue();
                    Predicate componentPredicate = ProvisionActionPredicateBuilder.predicateForComponentHosts(componentName, hosts);
                    ProvisionActionPredicateBuilder.classifyItem(componentAction, componentPredicate, componentPredicatesByStep);
                    customActionHosts.addAll(hosts);
                }
                ImmutableSet leftoverHosts = ImmutableSet.copyOf((Collection)Sets.difference(allHosts, customActionHosts));
                if (leftoverHosts.isEmpty()) continue;
                Predicate componentPredicate = ProvisionActionPredicateBuilder.predicateForComponentHosts(componentName, (Set<String>)leftoverHosts);
                ProvisionActionPredicateBuilder.classifyItem(serviceAction, componentPredicate, componentPredicatesByStep);
                continue;
            }
            Predicate componentPredicate = ProvisionActionPredicateBuilder.componentNameIs(componentName);
            ProvisionActionPredicateBuilder.classifyItem(serviceAction, componentPredicate, componentPredicatesByStep);
        }
        return componentPredicatesByStep;
    }

    private Map<String, String> mapServicesByComponent() {
        HashMap<String, String> serviceByComponent = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, Set<String>>> e : this.request.newServices().entrySet()) {
            String service = e.getKey();
            for (String component : e.getValue().keySet()) {
                serviceByComponent.put(component, service);
            }
        }
        return serviceByComponent;
    }

    private Map<String, ProvisionAction> findServicesWithCustomAction() {
        ProvisionAction requestAction = this.request.getRequest().getProvisionAction();
        return this.request.getRequest().getServices().stream().filter(service -> service.getProvisionAction().isPresent()).filter(service -> !Objects.equals((Object)requestAction, (Object)service.getProvisionAction().get())).collect(Collectors.toMap(Service::getName, service -> service.getProvisionAction().get()));
    }

    private Map<String, Map<String, Map<ProvisionAction, Set<String>>>> findComponentsWithCustomAction() {
        Preconditions.checkState((this.customServiceActions != null ? 1 : 0) != 0);
        Map<String, String> serviceByComponent = this.mapServicesByComponent();
        HashMap<String, Map<String, Map<ProvisionAction, Set<String>>>> result = new HashMap<String, Map<String, Map<ProvisionAction, Set<String>>>>();
        for (Component component : this.request.getRequest().getComponents()) {
            component.getProvisionAction().ifPresent(componentAction -> {
                String componentName = component.getName();
                String serviceName = (String)serviceByComponent.get(componentName);
                ProvisionAction serviceAction = this.customServiceActions.getOrDefault(serviceName, this.request.getRequest().getProvisionAction());
                if (!Objects.equals((Object)serviceAction, componentAction)) {
                    result.computeIfAbsent(serviceName, __ -> new HashMap()).computeIfAbsent(componentName, __ -> new EnumMap(ProvisionAction.class)).computeIfAbsent(componentAction, __ -> new HashSet()).addAll(component.getHosts().stream().map(Host::getFqdn).collect(Collectors.toSet()));
                }
            });
        }
        return result;
    }

    private static <T> void classifyItem(ProvisionAction action, T item, Map<ProvisionStep, List<T>> itemsByStep) {
        for (ProvisionStep step : action.getSteps()) {
            itemsByStep.computeIfAbsent(step, __ -> new LinkedList()).add(item);
        }
    }

    private static Predicate predicateForComponentHosts(String componentName, Set<String> hosts) {
        Preconditions.checkNotNull(hosts);
        Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0);
        Set hostPredicates = hosts.stream().map(ProvisionActionPredicateBuilder::hostnameIs).collect(Collectors.toSet());
        return Predicates.anyOf(hostPredicates).map(Predicates.and(ProvisionActionPredicateBuilder.componentNameIs(componentName))).get();
    }

    private static Predicate clusterNameIs(String clusterName) {
        return new EqualsPredicate(HostComponentResourceProvider.CLUSTER_NAME, clusterName);
    }

    private static Predicate serviceNameIs(String serviceName) {
        return new EqualsPredicate(HostComponentResourceProvider.SERVICE_NAME, serviceName);
    }

    private static Predicate componentNameIs(String componentName) {
        return new EqualsPredicate(HostComponentResourceProvider.COMPONENT_NAME, componentName);
    }

    private static Predicate hostnameIs(String hostname) {
        return new EqualsPredicate(HostComponentResourceProvider.HOST_NAME, hostname);
    }
}

