/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.addservice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.topology.addservice.Host;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class Component {
    private static final String COMPONENT_NAME = "name";
    private static final String HOSTS = "hosts";
    private final String name;
    private final Set<Host> hosts;
    private final ProvisionAction provisionAction;

    @JsonCreator
    public Component(@JsonProperty(value="name") String name, @JsonProperty(value="provision_action") ProvisionAction provisionAction, @JsonProperty(value="hosts") Set<Host> hosts) {
        this.name = name;
        this.provisionAction = provisionAction;
        this.hosts = hosts != null ? ImmutableSet.copyOf(hosts) : ImmutableSet.of();
    }

    public static Component of(String name, String ... hosts) {
        return Component.of(name, null, hosts);
    }

    public static Component of(String name, ProvisionAction provisionAction, String ... hosts) {
        return new Component(name, provisionAction, Arrays.stream(hosts).map(Host::new).collect(Collectors.toSet()));
    }

    @JsonProperty(value="name")
    @ApiModelProperty(name="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="hosts")
    @ApiModelProperty(name="hosts")
    public Set<Host> getHosts() {
        return this.hosts;
    }

    @JsonProperty(value="provision_action")
    @ApiModelProperty(name="provision_action")
    public ProvisionAction _getProvisionAction() {
        return this.provisionAction;
    }

    @JsonIgnore
    public Optional<ProvisionAction> getProvisionAction() {
        return Optional.ofNullable(this.provisionAction);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component other = (Component)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.hosts, other.hosts) && Objects.equals((Object)this.provisionAction, (Object)other.provisionAction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.hosts, this.provisionAction});
    }

    public String toString() {
        return this.name;
    }
}

