/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.addservice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.topology.ConfigRecommendationStrategy;
import id.onyx.obdp.server.topology.ConfigurableHelper;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.Credential;
import id.onyx.obdp.server.topology.SecurityConfiguration;
import id.onyx.obdp.server.topology.addservice.Component;
import id.onyx.obdp.server.topology.addservice.Service;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@ApiModel
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class AddServiceRequest {
    private static final String STACK_NAME = "stack_name";
    private static final String STACK_VERSION = "stack_version";
    private static final String SERVICES = "services";
    private static final String COMPONENTS = "components";
    private static final String VALIDATION = "validation";
    public static final Set<String> TOP_LEVEL_PROPERTIES = ImmutableSet.of((Object)"operation_type", (Object)"config_recommendation_strategy", (Object)"provision_action", (Object)"validation", (Object)"stack_name", (Object)"stack_version", (Object[])new String[]{"services", "components", "configurations"});
    private final OperationType operationType;
    private final ConfigRecommendationStrategy recommendationStrategy;
    private final ProvisionAction provisionAction;
    private final ValidationType validationType;
    private final String stackName;
    private final String stackVersion;
    private final Set<Service> services;
    private final Set<Component> components;
    private final SecurityConfiguration security;
    private final Map<String, Credential> credentials;
    private final Configuration configuration;

    @JsonCreator
    public AddServiceRequest(@JsonProperty(value="operation_type") OperationType operationType, @JsonProperty(value="config_recommendation_strategy") ConfigRecommendationStrategy recommendationStrategy, @JsonProperty(value="provision_action") ProvisionAction provisionAction, @JsonProperty(value="validation") ValidationType validationType, @JsonProperty(value="stack_name") String stackName, @JsonProperty(value="stack_version") String stackVersion, @JsonProperty(value="services") Set<Service> services, @JsonProperty(value="components") Set<Component> components, @JsonProperty(value="security") SecurityConfiguration security, @JsonProperty(value="credentials") Set<Credential> credentials, @JsonProperty(value="configurations") Collection<? extends Map<String, ?>> configs) {
        this.operationType = null != operationType ? operationType : OperationType.ADD_SERVICE;
        this.recommendationStrategy = null != recommendationStrategy ? recommendationStrategy : ConfigRecommendationStrategy.defaultForAddService();
        this.provisionAction = null != provisionAction ? provisionAction : ProvisionAction.INSTALL_AND_START;
        this.validationType = validationType != null ? validationType : ValidationType.DEFAULT;
        this.stackName = stackName;
        this.stackVersion = stackVersion;
        this.services = null != services ? services : Collections.emptySet();
        this.components = null != components ? components : Collections.emptySet();
        this.security = security;
        this.configuration = null != configs ? ConfigurableHelper.parseConfigs(configs) : Configuration.newEmpty();
        this.credentials = null != credentials ? credentials.stream().collect(Collectors.toMap(Credential::getAlias, Function.identity())) : ImmutableMap.of();
    }

    public static AddServiceRequest of(String json) {
        try {
            return (AddServiceRequest)new ObjectMapper().readValue(json, AddServiceRequest.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @JsonProperty(value="operation_type")
    @ApiModelProperty(name="operation_type")
    public OperationType getOperationType() {
        return this.operationType;
    }

    @JsonProperty(value="config_recommendation_strategy")
    @ApiModelProperty(name="config_recommendation_strategy")
    public ConfigRecommendationStrategy getRecommendationStrategy() {
        return this.recommendationStrategy;
    }

    @JsonProperty(value="provision_action")
    @ApiModelProperty(name="provision_action")
    public ProvisionAction getProvisionAction() {
        return this.provisionAction;
    }

    @JsonProperty(value="validation")
    @ApiModelProperty(name="validation")
    public ValidationType getValidationType() {
        return this.validationType;
    }

    @JsonProperty(value="stack_name")
    @ApiModelProperty(name="stack_name")
    public String getStackName() {
        return this.stackName;
    }

    @JsonProperty(value="stack_version")
    @ApiModelProperty(name="stack_version")
    public String getStackVersion() {
        return this.stackVersion;
    }

    @JsonIgnore
    public Optional<StackId> getStackId() {
        return null != this.stackName && null != this.stackVersion ? Optional.of(new StackId(this.stackName, this.stackVersion)) : Optional.empty();
    }

    @JsonProperty(value="services")
    @ApiModelProperty(name="services")
    public Set<Service> getServices() {
        return this.services;
    }

    @JsonProperty(value="components")
    @ApiModelProperty(name="components")
    public Set<Component> getComponents() {
        return this.components;
    }

    @JsonIgnore
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @JsonProperty(value="configurations")
    @ApiModelProperty(name="configurations")
    public Collection<Map<String, Map<String, ?>>> getConfigurationContents() {
        return ConfigurableHelper.convertConfigToMap(this.configuration);
    }

    @JsonIgnore
    public Map<String, Credential> getCredentials() {
        return this.credentials;
    }

    @JsonIgnore
    public Optional<SecurityConfiguration> getSecurity() {
        return Optional.ofNullable(this.security);
    }

    @JsonProperty(value="security")
    @ApiModelProperty(name="security")
    public SecurityConfiguration _getSecurity() {
        return this.security;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddServiceRequest other = (AddServiceRequest)obj;
        return Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.validationType, (Object)other.validationType) && Objects.equals((Object)this.recommendationStrategy, (Object)other.recommendationStrategy) && Objects.equals((Object)this.provisionAction, (Object)other.provisionAction) && Objects.equals(this.stackName, other.stackName) && Objects.equals(this.stackVersion, other.stackVersion) && Objects.equals(this.services, other.services) && Objects.equals(this.components, other.components) && Objects.equals(this.security, other.security) && Objects.equals(this.configuration, other.configuration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationType, this.validationType, this.recommendationStrategy, this.provisionAction, this.stackName, this.stackVersion, this.services, this.components, this.configuration, this.security});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operation_type", (Object)this.operationType).add(VALIDATION, (Object)this.validationType).add("config_recommendation_strategy", (Object)this.recommendationStrategy).add("provision_action", (Object)this.provisionAction).add(STACK_NAME, (Object)this.stackName).add(STACK_VERSION, (Object)this.stackVersion).add(SERVICES, this.services).add(COMPONENTS, this.components).add("configurations", (Object)this.configuration).add("security", (Object)this.security).toString();
    }

    public static enum OperationType {
        ADD_SERVICE,
        DELETE_SERVICE,
        MOVE_SERVICE;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ValidationType {
        STRICT{

            @Override
            public boolean strictValidation() {
                return true;
            }
        }
        ,
        PERMISSIVE{

            @Override
            public boolean strictValidation() {
                return false;
            }
        };

        public static final ValidationType DEFAULT;

        public abstract boolean strictValidation();

        static {
            DEFAULT = STRICT;
        }
    }
}

