/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.addservice;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.serveraction.kerberos.KerberosAdminAuthenticationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosInvalidConfigurationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosMissingAdminCredentialsException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.ProvisionStep;
import id.onyx.obdp.server.topology.addservice.AddServiceInfo;
import id.onyx.obdp.server.topology.addservice.AddServiceRequest;
import id.onyx.obdp.server.topology.addservice.ProvisionActionPredicateBuilder;
import id.onyx.obdp.server.topology.addservice.RequestValidator;
import id.onyx.obdp.server.topology.addservice.RequestValidatorFactory;
import id.onyx.obdp.server.topology.addservice.ResourceProviderAdapter;
import id.onyx.obdp.server.topology.addservice.StackAdvisorAdapter;
import id.onyx.obdp.server.utils.LoggingPreconditions;
import id.onyx.obdp.server.utils.StageUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AddServiceOrchestrator {
    private static final Logger LOG = LoggerFactory.getLogger(AddServiceOrchestrator.class);
    private static final LoggingPreconditions CHECK = new LoggingPreconditions(LOG);
    @Inject
    private ResourceProviderAdapter resourceProviders;
    @Inject
    private OBDPManagementController controller;
    @Inject
    private ActionManager actionManager;
    @Inject
    private RequestFactory requestFactory;
    @Inject
    private RequestValidatorFactory requestValidatorFactory;
    @Inject
    private StackAdvisorAdapter stackAdvisorAdapter;

    public RequestStatusResponse processAddServiceRequest(Cluster cluster, AddServiceRequest request) {
        LOG.info("Received {} request for {}: {}", new Object[]{request.getOperationType(), cluster.getClusterName(), request});
        AddServiceInfo validatedRequest = this.validate(cluster, request);
        this.ensureCredentials(cluster, validatedRequest);
        AddServiceInfo requestWithLayout = this.recommendLayout(validatedRequest);
        AddServiceInfo requestWithConfig = this.recommendConfiguration(requestWithLayout);
        this.createResources(cluster, requestWithConfig);
        this.createHostTasks(requestWithConfig);
        return requestWithConfig.getStages().getRequestStatusResponse();
    }

    private AddServiceInfo validate(Cluster cluster, AddServiceRequest request) {
        LOG.info("Validating {}", (Object)request);
        RequestValidator validator = this.requestValidatorFactory.create(request, cluster);
        validator.validate();
        return validator.createValidServiceInfo(this.actionManager, this.requestFactory);
    }

    private void ensureCredentials(Cluster cluster, AddServiceInfo validatedRequest) {
        this.resourceProviders.createCredentials(validatedRequest);
        if (cluster.getSecurityType() == SecurityType.KERBEROS) {
            try {
                this.controller.getKerberosHelper().validateKDCCredentials(cluster);
            }
            catch (KerberosAdminAuthenticationException | KerberosInvalidConfigurationException | KerberosMissingAdminCredentialsException e) {
                CHECK.wrapInUnchecked(e, IllegalArgumentException::new, "KDC credentials validation failed: %s", e);
            }
            catch (OBDPException e) {
                CHECK.wrapInUnchecked((Exception)((Object)e), IllegalStateException::new, "Error occurred while validating KDC credentials: %s", new Object[]{e});
            }
        }
    }

    private AddServiceInfo recommendLayout(AddServiceInfo request) {
        if (!request.requiresLayoutRecommendation()) {
            LOG.info("Using layout specified in request for {}", (Object)request);
            return request;
        }
        LOG.info("Recommending layout for {}", (Object)request);
        return this.stackAdvisorAdapter.recommendLayout(request);
    }

    private AddServiceInfo recommendConfiguration(AddServiceInfo request) {
        LOG.info("Recommending configuration for {}", (Object)request);
        return this.stackAdvisorAdapter.recommendConfigurations(request);
    }

    private void createResources(Cluster cluster, AddServiceInfo request) {
        LOG.info("Creating resources for {}", (Object)request);
        Set<String> existingServices = cluster.getServices().keySet();
        this.updateKerberosDescriptor(request);
        this.resourceProviders.createServices(request);
        this.resourceProviders.createComponents(request);
        this.resourceProviders.updateServiceDesiredState(request, State.INSTALLED);
        this.resourceProviders.updateServiceDesiredState(request, State.STARTED);
        this.resourceProviders.createHostComponents(request);
        this.configureKerberos(request, cluster, existingServices);
        this.resourceProviders.updateExistingConfigs(request, existingServices);
        this.resourceProviders.createConfigs(request);
    }

    private void configureKerberos(AddServiceInfo request, Cluster cluster, Set<String> existingServices) {
        if (cluster.getSecurityType() == SecurityType.KERBEROS) {
            LOG.info("Configuring Kerberos for {}", (Object)request);
            Configuration stackDefaultConfig = request.getStack().getValidDefaultConfig();
            Set<String> newServices = request.newServices().keySet();
            ImmutableSet services = ImmutableSet.copyOf((Collection)Sets.union(newServices, existingServices));
            Map<String, Map<String, String>> existingConfigurations = request.getConfig().getFullProperties();
            existingConfigurations.put("clusterHostInfo", AddServiceOrchestrator.createComponentHostMap(cluster));
            try {
                KerberosHelper kerberosHelper = this.controller.getKerberosHelper();
                kerberosHelper.ensureHeadlessIdentities(cluster, existingConfigurations, (Set<String>)services);
                request.getConfig().applyUpdatesToStackDefaultProperties(stackDefaultConfig, existingConfigurations, kerberosHelper.getServiceConfigurationUpdates(cluster, existingConfigurations, AddServiceOrchestrator.createServiceComponentMap(cluster), null, existingServices, true, true));
            }
            catch (OBDPException | KerberosInvalidConfigurationException e) {
                CHECK.wrapInUnchecked((Exception)e, RuntimeException::new, "Error configuring Kerberos for %s: %s", request, e);
            }
        }
    }

    private void createHostTasks(AddServiceInfo request) {
        LOG.info("Creating host tasks for {}", (Object)request);
        ProvisionActionPredicateBuilder predicates = new ProvisionActionPredicateBuilder(request);
        for (ProvisionStep step : ProvisionStep.values()) {
            predicates.getPredicate(step).ifPresent(predicate -> this.resourceProviders.updateHostComponentDesiredState(request, (Predicate)predicate, step));
        }
        try {
            request.getStages().persist();
        }
        catch (OBDPException e) {
            CHECK.wrapInUnchecked((Exception)((Object)e), IllegalStateException::new, "Error creating host tasks for %s", request);
        }
    }

    private void updateKerberosDescriptor(AddServiceInfo request) {
        request.getKerberosDescriptor().ifPresent(descriptorInRequest -> {
            Optional<KerberosDescriptor> existingDescriptor = this.resourceProviders.getKerberosDescriptor(request);
            if (existingDescriptor.isPresent()) {
                KerberosDescriptor newDescriptor = existingDescriptor.get().update((KerberosDescriptor)descriptorInRequest);
                this.resourceProviders.updateKerberosDescriptor(request, newDescriptor);
            } else {
                this.resourceProviders.createKerberosDescriptor(request, (KerberosDescriptor)descriptorInRequest);
            }
        });
    }

    private static Map<String, String> createComponentHostMap(Cluster cluster) {
        return StageUtils.createComponentHostMap(cluster.getServices().keySet(), service -> AddServiceOrchestrator.getComponentsForService(cluster, service), (service, component) -> AddServiceOrchestrator.getHostsForServiceComponent(cluster, service, component));
    }

    private static Set<String> getHostsForServiceComponent(Cluster cluster, String service, String component) {
        try {
            return cluster.getService(service).getServiceComponent(component).getServiceComponentsHosts();
        }
        catch (OBDPException e) {
            return (Set)CHECK.wrapInUnchecked((Exception)((Object)e), IllegalStateException::new, "Error getting hosts for service %s component %: %s", new Object[]{service, component, e, e});
        }
    }

    private static Set<String> getComponentsForService(Cluster cluster, String service) {
        try {
            return cluster.getService(service).getServiceComponents().keySet();
        }
        catch (OBDPException e) {
            return (Set)CHECK.wrapInUnchecked((Exception)((Object)e), IllegalStateException::new, "Error getting components of service %s: %s", new Object[]{service, e, e});
        }
    }

    private static Map<String, Set<String>> createServiceComponentMap(Cluster cluster) {
        HashMap<String, Set<String>> serviceComponentMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Service> e : cluster.getServices().entrySet()) {
            serviceComponentMap.put(e.getKey(), (Set<String>)ImmutableSet.copyOf(e.getValue().getServiceComponents().keySet()));
        }
        return serviceComponentMap;
    }
}

