/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology.addservice;

import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.addservice.AddServiceRequest;
import id.onyx.obdp.server.topology.addservice.LayoutRecommendationInfo;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class AddServiceInfo {
    private final AddServiceRequest request;
    private final String clusterName;
    private final Stack stack;
    private final KerberosDescriptor kerberosDescriptor;
    private final Map<String, Map<String, Set<String>>> newServices;
    private final RequestStageContainer stages;
    private final Configuration config;
    private final LayoutRecommendationInfo recommendationInfo;

    private AddServiceInfo(AddServiceRequest request, String clusterName, RequestStageContainer stages, Stack stack, Configuration config, Map<String, Map<String, Set<String>>> newServices, KerberosDescriptor kerberosDescriptor, LayoutRecommendationInfo recommendationInfo) {
        this.request = request;
        this.clusterName = clusterName;
        this.stack = stack;
        this.kerberosDescriptor = kerberosDescriptor;
        this.newServices = newServices;
        this.stages = stages;
        this.config = config;
        this.recommendationInfo = recommendationInfo;
    }

    public Builder toBuilder() {
        return new Builder().setRequest(this.request).setClusterName(this.clusterName).setStack(this.stack).setKerberosDescriptor(this.kerberosDescriptor).setNewServices(this.newServices).setStages(this.stages).setConfig(this.config).setRecommendationInfo(this.recommendationInfo);
    }

    public AddServiceInfo withLayoutRecommendation(Map<String, Map<String, Set<String>>> services, LayoutRecommendationInfo recommendation) {
        return this.toBuilder().setNewServices(services).setRecommendationInfo(recommendation).build();
    }

    public AddServiceInfo withConfig(Configuration newConfig) {
        return this.toBuilder().setConfig(newConfig).build();
    }

    public String toString() {
        return "AddServiceRequest(" + this.stages.getId() + ")";
    }

    public AddServiceRequest getRequest() {
        return this.request;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public RequestStageContainer getStages() {
        return this.stages;
    }

    public Map<String, Map<String, Set<String>>> newServices() {
        return this.newServices;
    }

    public Stack getStack() {
        return this.stack;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Optional<LayoutRecommendationInfo> getRecommendationInfo() {
        return Optional.ofNullable(this.recommendationInfo);
    }

    public Optional<KerberosDescriptor> getKerberosDescriptor() {
        return Optional.ofNullable(this.kerberosDescriptor);
    }

    public String describe() {
        int maxServicesToShow = 3;
        StringBuilder sb = new StringBuilder("Add Services: ").append(this.newServices.keySet().stream().sorted().limit(maxServicesToShow).collect(Collectors.joining(", ")));
        if (this.newServices.size() > maxServicesToShow) {
            sb.append(" and ").append(this.newServices.size() - maxServicesToShow).append(" more");
        }
        sb.append(" to cluster ").append(this.clusterName);
        return sb.toString();
    }

    public boolean requiresLayoutRecommendation() {
        return !this.request.getServices().isEmpty();
    }

    public static class Builder {
        private AddServiceRequest request;
        private String clusterName;
        private Stack stack;
        private KerberosDescriptor kerberosDescriptor;
        private Map<String, Map<String, Set<String>>> newServices;
        private RequestStageContainer stages;
        private Configuration config;
        private LayoutRecommendationInfo recommendationInfo;

        public AddServiceInfo build() {
            return new AddServiceInfo(this.request, this.clusterName, this.stages, this.stack, this.config, this.newServices, this.kerberosDescriptor, this.recommendationInfo);
        }

        public Builder setRequest(AddServiceRequest request) {
            this.request = request;
            return this;
        }

        public Builder setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder setStages(RequestStageContainer stages) {
            this.stages = stages;
            return this;
        }

        public Builder setStack(Stack stack) {
            this.stack = stack;
            return this;
        }

        public Builder setConfig(Configuration config) {
            this.config = config;
            return this;
        }

        public Builder setNewServices(Map<String, Map<String, Set<String>>> newServices) {
            this.newServices = newServices;
            return this;
        }

        public Builder setKerberosDescriptor(KerberosDescriptor kerberosDescriptor) {
            this.kerberosDescriptor = kerberosDescriptor;
            return this;
        }

        public Builder setRecommendationInfo(LayoutRecommendationInfo recommendationInfo) {
            this.recommendationInfo = recommendationInfo;
            return this;
        }
    }
}

