/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.inject.Singleton;
import id.onyx.obdp.server.topology.Setting;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Singleton
public class SettingFactory {
    public static Setting getSetting(Collection<Map<String, Object>> blueprintSetting) {
        HashMap<String, Set<HashMap<String, String>>> properties = new HashMap<String, Set<HashMap<String, String>>>();
        Setting setting = new Setting(properties);
        if (blueprintSetting != null) {
            for (Map<String, Object> settingMap : blueprintSetting) {
                for (Map.Entry<String, Object> entry : settingMap.entrySet()) {
                    Set<HashMap<String, String>> settingValue;
                    String[] propertyNames = entry.getKey().split("/");
                    if (entry.getValue() instanceof Set) {
                        settingValue = (HashSet)entry.getValue();
                    } else if (propertyNames.length > 1) {
                        HashMap<String, String> property = new HashMap<String, String>();
                        property.put(propertyNames[1], String.valueOf(entry.getValue()));
                        settingValue = (Set)properties.get(propertyNames[0]);
                        if (settingValue == null) {
                            settingValue = new HashSet();
                        }
                        settingValue.add(property);
                    } else {
                        throw new IllegalArgumentException("Invalid setting schema: " + String.valueOf(entry.getValue()));
                    }
                    properties.put(propertyNames[0], settingValue);
                }
            }
        }
        return setting;
    }
}

