/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.inject.Inject;
import id.onyx.obdp.server.orm.dao.KerberosDescriptorDAO;
import id.onyx.obdp.server.orm.entities.KerberosDescriptorEntity;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.topology.KerberosDescriptor;
import id.onyx.obdp.server.topology.KerberosDescriptorFactory;
import id.onyx.obdp.server.topology.SecurityConfiguration;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfigurationFactory.class);
    public static final String SECURITY_PROPERTY_ID = "security";
    public static final String TYPE_PROPERTY_ID = "type";
    public static final String KERBEROS_DESCRIPTOR_PROPERTY_ID = "kerberos_descriptor";
    public static final String KERBEROS_DESCRIPTOR_REFERENCE_PROPERTY_ID = "kerberos_descriptor_reference";
    @Inject
    protected Gson jsonSerializer;
    @Inject
    private KerberosDescriptorDAO kerberosDescriptorDAO;
    @Inject
    private KerberosDescriptorFactory kerberosDescriptorFactory;

    public SecurityConfigurationFactory() {
    }

    protected SecurityConfigurationFactory(Gson jsonSerializer, KerberosDescriptorDAO kerberosDescriptorDAO, KerberosDescriptorFactory kerberosDescriptorFactory) {
        this.jsonSerializer = jsonSerializer;
        this.kerberosDescriptorDAO = kerberosDescriptorDAO;
        this.kerberosDescriptorFactory = kerberosDescriptorFactory;
    }

    public SecurityConfiguration createSecurityConfigurationFromRequest(Map<String, Object> properties, boolean persistEmbeddedDescriptor) {
        SecurityConfiguration securityConfiguration;
        LOGGER.debug("Creating security configuration from properties: {}", properties);
        Map securityProperties = (Map)properties.get(SECURITY_PROPERTY_ID);
        if (securityProperties == null) {
            LOGGER.debug("No security information properties provided, returning null");
            return null;
        }
        String securityTypeString = Strings.emptyToNull((String)((String)securityProperties.get(TYPE_PROPERTY_ID)));
        if (securityTypeString == null) {
            LOGGER.error("Type is missing from security block.");
            throw new IllegalArgumentException("Type missing from security block.");
        }
        SecurityType securityType = (SecurityType)((Object)Enums.getIfPresent(SecurityType.class, (String)securityTypeString).orNull());
        if (securityType == null) {
            LOGGER.error("Unsupported security type specified: {}", (Object)securityType);
            throw new IllegalArgumentException("Invalid security type specified: " + securityTypeString);
        }
        if (securityType == SecurityType.KERBEROS) {
            String descriptorReference = Strings.emptyToNull((String)((String)securityProperties.get(KERBEROS_DESCRIPTOR_REFERENCE_PROPERTY_ID)));
            Object descriptorJsonMap = securityProperties.get(KERBEROS_DESCRIPTOR_PROPERTY_ID);
            if (descriptorReference != null && descriptorJsonMap != null) {
                LOGGER.error("Both kerberos descriptor and kerberos descriptor reference are set in the security configuration!");
                throw new IllegalArgumentException("Usage of properties : kerberos_descriptor and kerberos_descriptor_reference at the same time, is not allowed.");
            }
            if (descriptorJsonMap != null) {
                LOGGER.debug("Found embedded descriptor: {}", descriptorJsonMap);
                String descriptorText = this.jsonSerializer.toJson(descriptorJsonMap, Map.class);
                if (persistEmbeddedDescriptor) {
                    descriptorReference = this.persistKerberosDescriptor(descriptorText);
                }
                Map descriptorMap = (Map)descriptorJsonMap;
                securityConfiguration = persistEmbeddedDescriptor ? SecurityConfiguration.withReference(descriptorReference) : SecurityConfiguration.withDescriptor(descriptorMap);
            } else if (descriptorReference != null) {
                LOGGER.debug("Found descriptor reference: {}", (Object)descriptorReference);
                securityConfiguration = this.loadSecurityConfigurationByReference(descriptorReference);
            } else {
                LOGGER.debug("There is no security descriptor found in the request");
                securityConfiguration = SecurityConfiguration.KERBEROS;
            }
        } else {
            LOGGER.debug("There is no security configuration found in the request");
            securityConfiguration = SecurityConfiguration.NONE;
        }
        return securityConfiguration;
    }

    public SecurityConfiguration loadSecurityConfigurationByReference(String reference) {
        LOGGER.debug("Loading security configuration by reference: {}", (Object)reference);
        if (reference == null) {
            LOGGER.error("No security configuration reference provided!");
            throw new IllegalArgumentException("No security configuration reference provided!");
        }
        KerberosDescriptorEntity descriptorEntity = this.kerberosDescriptorDAO.findByName(reference);
        if (descriptorEntity == null) {
            LOGGER.error("No security configuration found for the reference: {}", (Object)reference);
            throw new IllegalArgumentException("No security configuration found for the reference: " + reference);
        }
        String descriptorText = descriptorEntity.getKerberosDescriptorText();
        Map descriptorMap = (Map)this.jsonSerializer.fromJson(descriptorText, Map.class);
        SecurityConfiguration securityConfiguration = SecurityConfiguration.withDescriptor(descriptorMap);
        return securityConfiguration;
    }

    private String persistKerberosDescriptor(String descriptor) {
        LOGGER.debug("Generating new kerberos descriptor reference ...");
        String kdReference = this.generateKerberosDescriptorReference();
        KerberosDescriptor kerberosDescriptor = this.kerberosDescriptorFactory.createKerberosDescriptor(kdReference, descriptor);
        LOGGER.debug("Persisting kerberos descriptor ...");
        this.kerberosDescriptorDAO.create(kerberosDescriptor.toEntity());
        return kdReference;
    }

    private String generateKerberosDescriptorReference() {
        String kdReference = UUID.randomUUID().toString();
        LOGGER.debug("Generated new kerberos descriptor reference: {}", (Object)kdReference);
        return kdReference;
    }
}

