/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import id.onyx.obdp.server.state.SecurityType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@ApiModel
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class SecurityConfiguration {
    public static final SecurityConfiguration NONE = new SecurityConfiguration(SecurityType.NONE, null, null);
    public static final SecurityConfiguration KERBEROS = new SecurityConfiguration(SecurityType.KERBEROS, null, null);
    private final SecurityType type;
    private final String descriptorReference;
    private final Map<?, ?> descriptor;

    public static SecurityConfiguration of(SecurityType type, String reference, Map<?, ?> descriptorMap) {
        if (type == SecurityType.NONE) {
            return NONE;
        }
        if (type != SecurityType.KERBEROS) {
            throw new IllegalArgumentException("Unexpected SecurityType: " + type);
        }
        if (reference == null && descriptorMap == null) {
            return KERBEROS;
        }
        if (reference != null && descriptorMap != null) {
            throw new IllegalArgumentException("Cannot set both descriptor and reference");
        }
        return reference != null ? SecurityConfiguration.withReference(reference) : SecurityConfiguration.withDescriptor(descriptorMap);
    }

    public static SecurityConfiguration withReference(String reference) {
        return new SecurityConfiguration(SecurityType.KERBEROS, reference, null);
    }

    public static SecurityConfiguration withDescriptor(Map<?, ?> descriptorMap) {
        return new SecurityConfiguration(SecurityType.KERBEROS, null, descriptorMap);
    }

    public static SecurityConfiguration forTest(SecurityType type, String reference, Map<?, ?> descriptorMap) {
        return new SecurityConfiguration(type, reference, descriptorMap);
    }

    @JsonCreator
    SecurityConfiguration(@JsonProperty(value="type") SecurityType type, @JsonProperty(value="kerberos_descriptor_reference") String descriptorReference, @JsonProperty(value="kerberos_descriptor") Map<?, ?> descriptorMap) {
        this.type = type;
        this.descriptorReference = descriptorReference;
        this.descriptor = descriptorMap != null ? ImmutableMap.copyOf(descriptorMap) : null;
    }

    @JsonProperty(value="type")
    @ApiModelProperty(name="type")
    public SecurityType getType() {
        return this.type;
    }

    @JsonProperty(value="kerberos_descriptor")
    @ApiModelProperty(name="kerberos_descriptor")
    public Map<?, ?> _getDescriptor() {
        return this.getDescriptor().isPresent() ? this.descriptor : ImmutableMap.of();
    }

    @JsonIgnore
    public Optional<Map<?, ?>> getDescriptor() {
        return Optional.ofNullable(this.descriptor);
    }

    @JsonProperty(value="kerberos_descriptor_reference")
    @ApiModelProperty(name="kerberos_descriptor_reference")
    public String getDescriptorReference() {
        return this.descriptorReference;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SecurityConfiguration other = (SecurityConfiguration)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.descriptor, other.descriptor) && Objects.equals(this.descriptorReference, other.descriptorReference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.descriptor, this.descriptorReference});
    }
}

