/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.AgentConfigsHolder;
import id.onyx.obdp.server.agent.stomp.AlertDefinitionsHolder;
import id.onyx.obdp.server.agent.stomp.HostLevelParamsHolder;
import id.onyx.obdp.server.agent.stomp.MetadataHolder;
import id.onyx.obdp.server.agent.stomp.TopologyHolder;
import id.onyx.obdp.server.agent.stomp.dto.TopologyCluster;
import id.onyx.obdp.server.agent.stomp.dto.TopologyComponent;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.events.TopologyUpdateEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.state.Clusters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

@Singleton
public class STOMPComponentsDeleteHandler {
    @Inject
    private Provider<TopologyHolder> m_topologyHolder;
    @Inject
    private Provider<AgentConfigsHolder> agentConfigsHolder;
    @Inject
    private Provider<MetadataHolder> metadataHolder;
    @Inject
    private Provider<HostLevelParamsHolder> hostLevelParamsHolder;
    @Inject
    private Provider<AlertDefinitionsHolder> alertDefinitionsHolder;
    @Inject
    private Clusters clusters;

    public void processDeleteByMetaDataException(DeleteHostComponentStatusMetaData metaData) throws OBDPException {
        if (metaData.getAmbariException() != null) {
            this.processDeleteByMetaData(metaData);
            throw metaData.getAmbariException();
        }
    }

    public void processDeleteByMetaData(DeleteHostComponentStatusMetaData metaData) throws OBDPException {
        TopologyUpdateEvent topologyUpdateEvent = new TopologyUpdateEvent(this.createUpdateFromDeleteByMetaData(metaData), UpdateEventType.DELETE);
        ((TopologyHolder)this.m_topologyHolder.get()).updateData(topologyUpdateEvent);
        this.updateNonTopologyAgentInfo(metaData.getRemovedHostComponents().stream().map(hc -> hc.getHostId()).collect(Collectors.toSet()), null);
    }

    public void processDeleteCluster(Long clusterId) throws OBDPException {
        TreeMap<String, TopologyCluster> topologyUpdates = new TreeMap<String, TopologyCluster>();
        topologyUpdates.put(Long.toString(clusterId), new TopologyCluster(null, null));
        TopologyUpdateEvent topologyUpdateEvent = new TopologyUpdateEvent(topologyUpdates, UpdateEventType.DELETE);
        ((TopologyHolder)this.m_topologyHolder.get()).updateData(topologyUpdateEvent);
        this.updateNonTopologyAgentInfo(this.clusters.getCluster(clusterId).getHosts().stream().map(h -> h.getHostId()).collect(Collectors.toSet()), clusterId);
    }

    private void updateNonTopologyAgentInfo(Set<Long> changedHosts, Long clusterId) throws OBDPException {
        for (Long hostId : changedHosts) {
            if (clusterId != null) {
                ((AlertDefinitionsHolder)this.alertDefinitionsHolder.get()).updateData(((AlertDefinitionsHolder)this.alertDefinitionsHolder.get()).getDeleteCluster(clusterId, hostId));
                ((AgentConfigsHolder)this.agentConfigsHolder.get()).updateData(((AgentConfigsHolder)this.agentConfigsHolder.get()).getCurrentDataExcludeCluster(hostId, clusterId));
                ((HostLevelParamsHolder)this.hostLevelParamsHolder.get()).updateData(((HostLevelParamsHolder)this.hostLevelParamsHolder.get()).getCurrentDataExcludeCluster(hostId, clusterId));
                continue;
            }
            ((AgentConfigsHolder)this.agentConfigsHolder.get()).updateData(((AgentConfigsHolder)this.agentConfigsHolder.get()).getCurrentData(hostId));
            ((HostLevelParamsHolder)this.hostLevelParamsHolder.get()).updateData(((HostLevelParamsHolder)this.hostLevelParamsHolder.get()).getCurrentData(hostId));
        }
        if (clusterId != null) {
            ((MetadataHolder)this.metadataHolder.get()).updateData(((MetadataHolder)this.metadataHolder.get()).getDeleteMetadata(clusterId));
        } else {
            ((MetadataHolder)this.metadataHolder.get()).updateData(((MetadataHolder)this.metadataHolder.get()).getCurrentData());
        }
    }

    public TreeMap<String, TopologyCluster> createUpdateFromDeleteByMetaData(DeleteHostComponentStatusMetaData metaData) {
        TreeMap<String, TopologyCluster> topologyUpdates = new TreeMap<String, TopologyCluster>();
        for (DeleteHostComponentStatusMetaData.HostComponent hostComponent : metaData.getRemovedHostComponents()) {
            TopologyComponent deletedComponent = TopologyComponent.newBuilder().setComponentName(hostComponent.getComponentName()).setServiceName(hostComponent.getServiceName()).setVersion(hostComponent.getVersion()).setHostIdentifiers(new HashSet<Long>(Arrays.asList(hostComponent.getHostId())), new HashSet<String>(Arrays.asList(hostComponent.getHostName()))).setLastComponentState(hostComponent.getLastComponentState()).build();
            String clusterId = hostComponent.getClusterId();
            if (!topologyUpdates.containsKey(clusterId)) {
                topologyUpdates.put(clusterId, new TopologyCluster());
            }
            if (!topologyUpdates.get(clusterId).getTopologyComponents().contains(deletedComponent)) {
                topologyUpdates.get(clusterId).addTopologyComponent(deletedComponent);
                continue;
            }
            topologyUpdates.get(clusterId).getTopologyComponents().stream().filter(t -> t.equals(deletedComponent)).forEach(t -> t.addHostName(hostComponent.getHostName()));
            topologyUpdates.get(clusterId).getTopologyComponents().stream().filter(t -> t.equals(deletedComponent)).forEach(t -> t.addHostId(hostComponent.getHostId()));
        }
        return topologyUpdates;
    }
}

