/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.controller.internal.BaseClusterRequest;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.TopologyHostGroupDAO;
import id.onyx.obdp.server.orm.dao.TopologyHostInfoDAO;
import id.onyx.obdp.server.orm.dao.TopologyHostRequestDAO;
import id.onyx.obdp.server.orm.dao.TopologyLogicalRequestDAO;
import id.onyx.obdp.server.orm.dao.TopologyLogicalTaskDAO;
import id.onyx.obdp.server.orm.dao.TopologyRequestDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostGroupEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostInfoEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostRequestEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostTaskEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalRequestEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalTaskEntity;
import id.onyx.obdp.server.orm.entities.TopologyRequestEntity;
import id.onyx.obdp.server.stack.NoSuchStackException;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.topology.AmbariContext;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.BlueprintFactory;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.ClusterTopologyImpl;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.HostRequest;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.LogicalRequest;
import id.onyx.obdp.server.topology.LogicalRequestFactory;
import id.onyx.obdp.server.topology.PersistedState;
import id.onyx.obdp.server.topology.PersistedTopologyRequest;
import id.onyx.obdp.server.topology.TopologyRequest;
import id.onyx.obdp.server.topology.tasks.TopologyTask;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PersistedStateImpl
implements PersistedState {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedState.class);
    @Inject
    private TopologyRequestDAO topologyRequestDAO;
    @Inject
    private TopologyHostInfoDAO topologyHostInfoDAO;
    @Inject
    private HostDAO hostDAO;
    @Inject
    private TopologyHostGroupDAO hostGroupDAO;
    @Inject
    private TopologyHostRequestDAO hostRequestDAO;
    @Inject
    private TopologyLogicalRequestDAO topologyLogicalRequestDAO;
    @Inject
    private TopologyLogicalTaskDAO topologyLogicalTaskDAO;
    @Inject
    private HostRoleCommandDAO hostRoleCommandDAO;
    @Inject
    private HostRoleCommandDAO physicalTaskDAO;
    @Inject
    private BlueprintFactory blueprintFactory;
    @Inject
    private LogicalRequestFactory logicalRequestFactory;
    @Inject
    private AmbariContext ambariContext;
    private static Gson jsonSerializer = new Gson();

    @Override
    public PersistedTopologyRequest persistTopologyRequest(BaseClusterRequest request) {
        TopologyRequestEntity requestEntity = this.toEntity(request);
        this.topologyRequestDAO.create(requestEntity);
        return new PersistedTopologyRequest(requestEntity.getId(), request);
    }

    @Override
    public void persistLogicalRequest(LogicalRequest logicalRequest, long topologyRequestId) {
        TopologyRequestEntity topologyRequestEntity = this.topologyRequestDAO.findById(topologyRequestId);
        TopologyLogicalRequestEntity entity = this.toEntity(logicalRequest, topologyRequestEntity);
        topologyRequestEntity.setTopologyLogicalRequestEntity(entity);
        this.topologyRequestDAO.merge(topologyRequestEntity);
    }

    @Override
    @Transactional
    public void removeHostRequests(long logicalRequestId, Collection<HostRequest> hostRequests) {
        TopologyLogicalRequestEntity logicalRequest = this.topologyLogicalRequestDAO.findById(logicalRequestId);
        for (HostRequest hostRequest : hostRequests) {
            TopologyHostRequestEntity hostRequestEntity = this.hostRequestDAO.findById(hostRequest.getId());
            if (logicalRequest != null) {
                logicalRequest.getTopologyHostRequestEntities().remove(hostRequestEntity);
            }
            this.hostRequestDAO.remove(hostRequestEntity);
        }
        if (logicalRequest != null && logicalRequest.getTopologyHostRequestEntities().isEmpty()) {
            Long topologyRequestId = logicalRequest.getTopologyRequestId();
            this.topologyLogicalRequestDAO.remove(logicalRequest);
            this.topologyRequestDAO.removeByPK(topologyRequestId);
        }
    }

    @Override
    public void setHostRequestStatus(long hostRequestId, HostRoleStatus status, String message) {
        TopologyHostRequestEntity hostRequestEntity = this.hostRequestDAO.findById(hostRequestId);
        if (hostRequestEntity != null) {
            hostRequestEntity.setStatus(status);
            hostRequestEntity.setStatusMessage(message);
            this.hostRequestDAO.merge(hostRequestEntity);
        }
    }

    @Override
    public void registerPhysicalTask(long logicalTaskId, long physicalTaskId) {
        TopologyLogicalTaskEntity entity = this.topologyLogicalTaskDAO.findById(logicalTaskId);
        HostRoleCommandEntity physicalEntity = this.hostRoleCommandDAO.findByPK(physicalTaskId);
        entity.setHostRoleCommandEntity(physicalEntity);
        this.topologyLogicalTaskDAO.merge(entity);
    }

    @Override
    public void registerHostName(long hostRequestId, String hostName) {
        TopologyHostRequestEntity entity = this.hostRequestDAO.findById(hostRequestId);
        if (entity.getHostName() == null) {
            entity.setHostName(hostName);
            this.hostRequestDAO.merge(entity);
        }
    }

    @Override
    public void registerInTopologyHostInfo(Host host) {
        TopologyHostInfoEntity entity = this.topologyHostInfoDAO.findByHostname(host.getHostName());
        if (entity != null && entity.getHostEntity() == null) {
            entity.setHostEntity(this.hostDAO.findById(host.getHostId()));
            this.topologyHostInfoDAO.merge(entity);
        }
    }

    @Override
    public LogicalRequest getProvisionRequest(long clusterId) {
        List<TopologyRequestEntity> entities = this.topologyRequestDAO.findByClusterId(clusterId);
        for (TopologyRequestEntity entity : entities) {
            if (TopologyRequest.Type.PROVISION != TopologyRequest.Type.valueOf(entity.getAction())) continue;
            TopologyLogicalRequestEntity logicalRequestEntity = entity.getTopologyLogicalRequestEntity();
            ReplayedTopologyRequest replayedRequest = new ReplayedTopologyRequest(entity, this.blueprintFactory);
            try {
                ClusterTopologyImpl clusterTopology = new ClusterTopologyImpl(this.ambariContext, replayedRequest);
                Long logicalId = logicalRequestEntity.getId();
                return this.logicalRequestFactory.createRequest(logicalId, replayedRequest, clusterTopology, logicalRequestEntity);
            }
            catch (InvalidTopologyException e) {
                throw new RuntimeException("Failed to construct cluster topology while replaying request: " + e, e);
            }
            catch (OBDPException e) {
                throw new RuntimeException("Failed to construct logical request during replay: " + e, e);
            }
        }
        return null;
    }

    @Override
    public Map<ClusterTopology, List<LogicalRequest>> getAllRequests() {
        HashMap<ClusterTopology, List<LogicalRequest>> allRequests = new HashMap<ClusterTopology, List<LogicalRequest>>();
        List<TopologyRequestEntity> entities = this.topologyRequestDAO.findAll();
        HashMap<Long, ClusterTopology> topologyRequests = new HashMap<Long, ClusterTopology>();
        for (TopologyRequestEntity entity : entities) {
            TopologyLogicalRequestEntity logicalRequestEntity;
            ReplayedTopologyRequest replayedRequest = new ReplayedTopologyRequest(entity, this.blueprintFactory);
            ClusterTopology clusterTopology = (ClusterTopology)topologyRequests.get(replayedRequest.getClusterId());
            if (clusterTopology == null) {
                try {
                    clusterTopology = new ClusterTopologyImpl(this.ambariContext, replayedRequest);
                    if (entity.getProvisionAction() != null) {
                        clusterTopology.setProvisionAction(entity.getProvisionAction());
                    }
                    topologyRequests.put(replayedRequest.getClusterId(), clusterTopology);
                    allRequests.put(clusterTopology, new ArrayList());
                }
                catch (InvalidTopologyException e) {
                    throw new RuntimeException("Failed to construct cluster topology while replaying request: " + e, e);
                }
            } else {
                for (Map.Entry<String, HostGroupInfo> groupInfoEntry : replayedRequest.getHostGroupInfo().entrySet()) {
                    String name = groupInfoEntry.getKey();
                    if (clusterTopology.getHostGroupInfo().containsKey(name)) continue;
                    clusterTopology.getHostGroupInfo().put(name, groupInfoEntry.getValue());
                }
            }
            if ((logicalRequestEntity = entity.getTopologyLogicalRequestEntity()) == null) continue;
            try {
                Long logicalId = logicalRequestEntity.getId();
                this.ambariContext.getNextRequestId();
                ((List)allRequests.get(clusterTopology)).add(this.logicalRequestFactory.createRequest(logicalId, replayedRequest, clusterTopology, logicalRequestEntity));
            }
            catch (OBDPException e) {
                throw new RuntimeException("Failed to construct logical request during replay: " + e, e);
            }
        }
        return allRequests;
    }

    private TopologyRequestEntity toEntity(BaseClusterRequest request) {
        TopologyRequestEntity entity = new TopologyRequestEntity();
        entity.setAction(request.getType().name());
        if (request.getBlueprint() != null) {
            entity.setBlueprintName(request.getBlueprint().getName());
        }
        entity.setClusterAttributes(PersistedStateImpl.attributesAsString(request.getConfiguration().getAttributes()));
        entity.setClusterId(request.getClusterId());
        entity.setClusterProperties(PersistedStateImpl.propertiesAsString(request.getConfiguration().getProperties()));
        entity.setDescription(request.getDescription());
        if (request.getProvisionAction() != null) {
            entity.setProvisionAction(request.getProvisionAction());
        }
        ArrayList<TopologyHostGroupEntity> hostGroupEntities = new ArrayList<TopologyHostGroupEntity>();
        for (HostGroupInfo groupInfo : request.getHostGroupInfo().values()) {
            hostGroupEntities.add(this.toEntity(groupInfo, entity));
        }
        entity.setTopologyHostGroupEntities(hostGroupEntities);
        return entity;
    }

    private TopologyLogicalRequestEntity toEntity(LogicalRequest request, TopologyRequestEntity topologyRequestEntity) {
        TopologyLogicalRequestEntity entity = new TopologyLogicalRequestEntity();
        entity.setDescription(request.getRequestContext());
        entity.setId(request.getRequestId());
        entity.setTopologyRequestEntity(topologyRequestEntity);
        entity.setTopologyRequestId(topologyRequestEntity.getId());
        ArrayList<TopologyHostRequestEntity> hostRequests = new ArrayList<TopologyHostRequestEntity>();
        entity.setTopologyHostRequestEntities(hostRequests);
        for (HostRequest hostRequest : request.getHostRequests()) {
            hostRequests.add(this.toEntity(hostRequest, entity));
        }
        return entity;
    }

    private TopologyHostRequestEntity toEntity(HostRequest request, TopologyLogicalRequestEntity logicalRequestEntity) {
        TopologyHostRequestEntity entity = new TopologyHostRequestEntity();
        entity.setHostName(request.getHostName());
        entity.setId(request.getId());
        entity.setStageId(request.getStageId());
        entity.setTopologyLogicalRequestEntity(logicalRequestEntity);
        entity.setTopologyHostGroupEntity(this.hostGroupDAO.findByRequestIdAndName(logicalRequestEntity.getTopologyRequestId(), request.getHostgroupName()));
        ArrayList<TopologyHostTaskEntity> hostRequestTaskEntities = new ArrayList<TopologyHostTaskEntity>();
        entity.setTopologyHostTaskEntities(hostRequestTaskEntities);
        for (TopologyTask topologyTask : request.getTopologyTasks()) {
            if (topologyTask.getType() != TopologyTask.Type.INSTALL && topologyTask.getType() != TopologyTask.Type.START) continue;
            TopologyHostTaskEntity topologyTaskEntity = new TopologyHostTaskEntity();
            hostRequestTaskEntities.add(topologyTaskEntity);
            topologyTaskEntity.setType(topologyTask.getType().name());
            topologyTaskEntity.setTopologyHostRequestEntity(entity);
            ArrayList<TopologyLogicalTaskEntity> logicalTaskEntities = new ArrayList<TopologyLogicalTaskEntity>();
            topologyTaskEntity.setTopologyLogicalTaskEntities(logicalTaskEntities);
            for (Long logicalTaskId : request.getLogicalTasksForTopologyTask(topologyTask).values()) {
                TopologyLogicalTaskEntity logicalTaskEntity = new TopologyLogicalTaskEntity();
                logicalTaskEntities.add(logicalTaskEntity);
                HostRoleCommand logicalTask = request.getLogicalTask(logicalTaskId);
                logicalTaskEntity.setId(logicalTaskId);
                logicalTaskEntity.setComponentName(logicalTask.getRole().name());
                logicalTaskEntity.setTopologyHostTaskEntity(topologyTaskEntity);
                Long physicalId = request.getPhysicalTaskId(logicalTaskId);
                if (physicalId != null) {
                    logicalTaskEntity.setHostRoleCommandEntity(this.physicalTaskDAO.findByPK(physicalId));
                }
                logicalTaskEntity.setTopologyHostTaskEntity(topologyTaskEntity);
            }
        }
        return entity;
    }

    private TopologyHostGroupEntity toEntity(HostGroupInfo groupInfo, TopologyRequestEntity topologyRequestEntity) {
        TopologyHostGroupEntity entity = new TopologyHostGroupEntity();
        entity.setGroupAttributes(PersistedStateImpl.attributesAsString(groupInfo.getConfiguration().getAttributes()));
        entity.setGroupProperties(PersistedStateImpl.propertiesAsString(groupInfo.getConfiguration().getProperties()));
        entity.setName(groupInfo.getHostGroupName());
        entity.setTopologyRequestEntity(topologyRequestEntity);
        ArrayList<TopologyHostInfoEntity> hostInfoEntities = new ArrayList<TopologyHostInfoEntity>();
        entity.setTopologyHostInfoEntities(hostInfoEntities);
        Collection<String> hosts = groupInfo.getHostNames();
        if (hosts.isEmpty()) {
            TopologyHostInfoEntity hostInfoEntity = new TopologyHostInfoEntity();
            hostInfoEntity.setTopologyHostGroupEntity(entity);
            hostInfoEntity.setHostCount(groupInfo.getRequestedHostCount());
            if (groupInfo.getPredicate() != null) {
                hostInfoEntity.setPredicate(groupInfo.getPredicateString());
            }
            hostInfoEntities.add(hostInfoEntity);
        } else {
            for (String hostName : hosts) {
                TopologyHostInfoEntity hostInfoEntity = new TopologyHostInfoEntity();
                hostInfoEntity.setTopologyHostGroupEntity(entity);
                if (groupInfo.getPredicate() != null) {
                    hostInfoEntity.setPredicate(groupInfo.getPredicateString());
                }
                hostInfoEntity.setFqdn(hostName);
                hostInfoEntity.setRackInfo(groupInfo.getHostRackInfo().get(hostName));
                hostInfoEntity.setHostCount(0);
                hostInfoEntities.add(hostInfoEntity);
            }
        }
        return entity;
    }

    private static String propertiesAsString(Map<String, Map<String, String>> configurationProperties) {
        return jsonSerializer.toJson(configurationProperties);
    }

    private static String attributesAsString(Map<String, Map<String, Map<String, String>>> configurationAttributes) {
        return jsonSerializer.toJson(configurationAttributes);
    }

    private static class ReplayedTopologyRequest
    implements TopologyRequest {
        private final Long clusterId;
        private final TopologyRequest.Type type;
        private final String description;
        private final Blueprint blueprint;
        private final Configuration configuration;
        private final Map<String, HostGroupInfo> hostGroupInfoMap = new HashMap<String, HostGroupInfo>();

        public ReplayedTopologyRequest(TopologyRequestEntity entity, BlueprintFactory blueprintFactory) {
            this.clusterId = entity.getClusterId();
            this.type = TopologyRequest.Type.valueOf(entity.getAction());
            this.description = entity.getDescription();
            try {
                this.blueprint = blueprintFactory.getBlueprint(entity.getBlueprintName());
            }
            catch (NoSuchStackException e) {
                throw new RuntimeException("Unable to load blueprint while replaying topology request: " + e, e);
            }
            this.configuration = this.createConfiguration(entity.getClusterProperties(), entity.getClusterAttributes());
            this.configuration.setParentConfiguration(this.blueprint.getConfiguration());
            this.parseHostGroupInfo(entity);
        }

        @Override
        public Long getClusterId() {
            return this.clusterId;
        }

        @Override
        public TopologyRequest.Type getType() {
            return this.type;
        }

        @Override
        public Blueprint getBlueprint() {
            return this.blueprint;
        }

        @Override
        public Configuration getConfiguration() {
            return this.configuration;
        }

        @Override
        public Map<String, HostGroupInfo> getHostGroupInfo() {
            return this.hostGroupInfoMap;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        private Configuration createConfiguration(String propString, String attributeString) {
            Map properties = (Map)jsonSerializer.fromJson(propString, Map.class);
            Map attributes = (Map)jsonSerializer.fromJson(attributeString, Map.class);
            return new Configuration(properties, attributes);
        }

        private void parseHostGroupInfo(TopologyRequestEntity entity) {
            for (TopologyHostGroupEntity hostGroupEntity : entity.getTopologyHostGroupEntities()) {
                for (TopologyHostInfoEntity hostInfoEntity : hostGroupEntity.getTopologyHostInfoEntities()) {
                    String hostname;
                    String groupName = hostGroupEntity.getName();
                    HostGroupInfo groupInfo = this.hostGroupInfoMap.get(groupName);
                    if (groupInfo == null) {
                        groupInfo = new HostGroupInfo(groupName);
                        this.hostGroupInfoMap.put(groupName, groupInfo);
                    }
                    if ((hostname = hostInfoEntity.getFqdn()) != null && !hostname.isEmpty()) {
                        groupInfo.addHost(hostname);
                        groupInfo.addHostRackInfo(hostname, hostInfoEntity.getRackInfo());
                    } else {
                        groupInfo.setRequestedCount(hostInfoEntity.getHostCount());
                        String hostPredicate = hostInfoEntity.getPredicate();
                        if (hostPredicate != null) {
                            try {
                                groupInfo.setPredicate(hostPredicate);
                            }
                            catch (InvalidQueryException e) {
                                LOG.error(String.format("Failed to compile predicate '%s' during request replay: %s", hostPredicate, e), (Throwable)e);
                            }
                        }
                    }
                    String groupConfigProperties = hostGroupEntity.getGroupProperties();
                    String groupConfigAttributes = hostGroupEntity.getGroupAttributes();
                    groupInfo.setConfiguration(this.createConfiguration(groupConfigProperties, groupConfigAttributes));
                }
            }
        }
    }
}

