/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.Request;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.ShortTaskStatus;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.orm.dao.HostRoleCommandStatusSummaryDTO;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostGroupEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostInfoEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostRequestEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalRequestEntity;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.HostOfferResponse;
import id.onyx.obdp.server.topology.HostRequest;
import id.onyx.obdp.server.topology.TopologyRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalRequest
extends Request {
    private final Collection<HostRequest> allHostRequests = new ArrayList<HostRequest>();
    private final Collection<HostRequest> outstandingHostRequests = new TreeSet<HostRequest>();
    private final Map<String, HostRequest> requestsWithReservedHosts = new HashMap<String, HostRequest>();
    private final ClusterTopology topology;
    private static OBDPManagementController controller;
    private static final AtomicLong hostIdCounter;
    private static final Logger LOG;

    public LogicalRequest(Long id, TopologyRequest request, ClusterTopology topology) throws OBDPException {
        super(id, topology.getClusterId(), LogicalRequest.getController().getClusters());
        this.setRequestContext(String.format("Logical Request: %s", request.getDescription()));
        this.topology = topology;
        this.createHostRequests(request, topology);
    }

    public LogicalRequest(Long id, TopologyRequest request, ClusterTopology topology, TopologyLogicalRequestEntity requestEntity) throws OBDPException {
        super(id, topology.getClusterId(), LogicalRequest.getController().getClusters());
        this.setRequestContext(String.format("Logical Request: %s", request.getDescription()));
        this.topology = topology;
        this.createHostRequests(topology, requestEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostOfferResponse offer(Host host) {
        Map<String, HostRequest> map = this.requestsWithReservedHosts;
        synchronized (map) {
            LOG.info("LogicalRequest.offer: attempting to match a request to a request for a reserved host to hostname = {}", (Object)host.getHostName());
            HostRequest hostRequest = this.requestsWithReservedHosts.remove(host.getHostName());
            if (hostRequest != null) {
                HostOfferResponse response = hostRequest.offer(host);
                if (response.getAnswer() != HostOfferResponse.Answer.ACCEPTED) {
                    throw new RuntimeException("LogicalRequest declined host offer of explicitly requested host: " + host.getHostName());
                }
                LOG.info("LogicalRequest.offer: request mapping ACCEPTED for host = {}", (Object)host.getHostName());
                LOG.info("LogicalRequest.offer returning response, reservedHost list size = {}", (Object)this.requestsWithReservedHosts.size());
                return response;
            }
        }
        boolean predicateRejected = false;
        Collection<HostRequest> collection = this.outstandingHostRequests;
        synchronized (collection) {
            Iterator<HostRequest> hostRequestIterator = this.outstandingHostRequests.iterator();
            while (hostRequestIterator.hasNext()) {
                LOG.info("LogicalRequest.offer: attempting to match a request to a request for a non-reserved host to hostname = {}", (Object)host.getHostName());
                HostOfferResponse response = hostRequestIterator.next().offer(host);
                switch (response.getAnswer()) {
                    case ACCEPTED: {
                        hostRequestIterator.remove();
                        LOG.info("LogicalRequest.offer: host request matched to non-reserved host, hostname = {}, host request has been removed from list", (Object)host.getHostName());
                        return response;
                    }
                    case DECLINED_DONE: {
                        hostRequestIterator.remove();
                        LOG.info("LogicalRequest.offer: host request returned DECLINED_DONE for hostname = {}, host request has been removed from list", (Object)host.getHostName());
                        break;
                    }
                    case DECLINED_PREDICATE: {
                        LOG.info("LogicalRequest.offer: host request returned DECLINED_PREDICATE for hostname = {}", (Object)host.getHostName());
                        predicateRejected = true;
                    }
                }
            }
            LOG.info("LogicalRequest.offer: outstandingHost request list size = " + this.outstandingHostRequests.size());
        }
        return predicateRejected || !this.requestsWithReservedHosts.isEmpty() ? HostOfferResponse.DECLINED_DUE_TO_PREDICATE : HostOfferResponse.DECLINED_DUE_TO_DONE;
    }

    @Override
    public List<HostRoleCommand> getCommands() {
        ArrayList<HostRoleCommand> commands = new ArrayList<HostRoleCommand>();
        for (HostRequest hostRequest : this.allHostRequests) {
            commands.addAll(new ArrayList<HostRoleCommand>(hostRequest.getLogicalTasks()));
        }
        return commands;
    }

    public Collection<String> getReservedHosts() {
        return this.requestsWithReservedHosts.keySet();
    }

    public boolean hasPendingHostRequests() {
        return !this.requestsWithReservedHosts.isEmpty() || !this.outstandingHostRequests.isEmpty();
    }

    public Collection<HostRequest> getCompletedHostRequests() {
        ArrayList<HostRequest> completedHostRequests = new ArrayList<HostRequest>(this.allHostRequests);
        completedHostRequests.removeAll(this.outstandingHostRequests);
        completedHostRequests.removeAll(this.requestsWithReservedHosts.values());
        return completedHostRequests;
    }

    public int getPendingHostRequestCount() {
        return this.outstandingHostRequests.size() + this.requestsWithReservedHosts.size();
    }

    public Collection<HostRequest> getHostRequests() {
        return new ArrayList<HostRequest>(this.allHostRequests);
    }

    public Collection<HostRequest> removePendingHostRequests(String hostGroupName) {
        ArrayList<HostRequest> pendingHostRequests = new ArrayList<HostRequest>();
        for (HostRequest hostRequest : this.outstandingHostRequests) {
            if (hostGroupName != null && !hostRequest.getHostgroupName().equals(hostGroupName)) continue;
            pendingHostRequests.add(hostRequest);
        }
        if (hostGroupName == null) {
            this.outstandingHostRequests.clear();
        } else {
            this.outstandingHostRequests.removeAll(pendingHostRequests);
        }
        ArrayList<String> pendingReservedHostNames = new ArrayList<String>();
        for (String reservedHostName : this.requestsWithReservedHosts.keySet()) {
            HostRequest hostRequest = this.requestsWithReservedHosts.get(reservedHostName);
            if (hostGroupName != null && !hostRequest.getHostgroupName().equals(hostGroupName)) continue;
            pendingHostRequests.add(hostRequest);
            pendingReservedHostNames.add(reservedHostName);
        }
        this.requestsWithReservedHosts.keySet().removeAll(pendingReservedHostNames);
        this.allHostRequests.removeAll(pendingHostRequests);
        return pendingHostRequests;
    }

    public Map<String, Collection<String>> getProjectedTopology() {
        HashMap<String, Collection<String>> hostComponentMap = new HashMap<String, Collection<String>>();
        for (HostRequest hostRequest : this.allHostRequests) {
            HostGroup hostGroup = hostRequest.getHostGroup();
            for (String host : this.topology.getHostGroupInfo().get(hostGroup.getName()).getHostNames()) {
                HashSet<String> hostComponents = (HashSet<String>)hostComponentMap.get(host);
                if (hostComponents == null) {
                    hostComponents = new HashSet<String>();
                    hostComponentMap.put(host, hostComponents);
                }
                hostComponents.addAll(hostGroup.getComponentNames());
            }
        }
        return hostComponentMap;
    }

    public Collection<StageEntity> getStageEntities() {
        ArrayList<StageEntity> stages = new ArrayList<StageEntity>();
        for (HostRequest hostRequest : this.allHostRequests) {
            StageEntity stage = new StageEntity();
            stage.setStageId(hostRequest.getStageId());
            stage.setRequestContext(this.getRequestContext());
            stage.setRequestId(this.getRequestId());
            stage.setClusterId(this.getClusterId());
            boolean skipFailure = hostRequest.shouldSkipFailure();
            stage.setSkippable(skipFailure);
            stage.setAutoSkipFailureSupported(skipFailure);
            stage.setHostRoleCommands(hostRequest.getTaskEntities());
            stages.add(stage);
        }
        return stages;
    }

    public RequestStatusResponse getRequestStatus() {
        RequestStatusResponse requestStatus = new RequestStatusResponse(this.getRequestId());
        requestStatus.setRequestContext(this.getRequestContext());
        ArrayList<ShortTaskStatus> shortTasks = new ArrayList<ShortTaskStatus>();
        for (HostRoleCommand task : this.getCommands()) {
            shortTasks.add(new ShortTaskStatus(task));
        }
        requestStatus.setTasks(shortTasks);
        return requestStatus;
    }

    public Map<Long, HostRoleCommandStatusSummaryDTO> getStageSummaries() {
        HashMap<Long, HostRoleCommandStatusSummaryDTO> summaryMap = new HashMap<Long, HostRoleCommandStatusSummaryDTO>();
        HashMap<Long, ArrayList<HostRoleCommand>> stageTasksMap = new HashMap<Long, ArrayList<HostRoleCommand>>();
        HashMap<Long, Long> taskToStageMap = new HashMap<Long, Long>();
        for (HostRequest hostRequest : this.getHostRequests()) {
            Map<Long, Long> physicalTaskMapping = hostRequest.getPhysicalTaskMapping();
            Collection<Long> stageTasks = physicalTaskMapping.values();
            for (Long stageTask : stageTasks) {
                taskToStageMap.put(stageTask, hostRequest.getStageId());
            }
        }
        Collection<HostRoleCommand> physicalTasks = this.topology.getAmbariContext().getPhysicalTasks(taskToStageMap.keySet());
        for (HostRoleCommand physicalTask : physicalTasks) {
            Long stageId = (Long)taskToStageMap.get(physicalTask.getTaskId());
            ArrayList<HostRoleCommand> stageTasks = (ArrayList<HostRoleCommand>)stageTasksMap.get(stageId);
            if (stageTasks == null) {
                stageTasks = new ArrayList<HostRoleCommand>();
                stageTasksMap.put(stageId, stageTasks);
            }
            stageTasks.add(physicalTask);
        }
        for (Long stageId : stageTasksMap.keySet()) {
            int aborted = 0;
            int completed = 0;
            int failed = 0;
            int holding = 0;
            int holdingFailed = 0;
            int holdingTimedout = 0;
            int inProgress = 0;
            int pending = 0;
            int queued = 0;
            int timedout = 0;
            int skippedFailed = 0;
            block17: for (HostRoleCommand task : (Collection)stageTasksMap.get(stageId)) {
                HostRoleStatus taskStatus = task.getStatus();
                switch (taskStatus) {
                    case ABORTED: {
                        ++aborted;
                        continue block17;
                    }
                    case COMPLETED: {
                        ++completed;
                        continue block17;
                    }
                    case FAILED: {
                        ++failed;
                        continue block17;
                    }
                    case HOLDING: {
                        ++holding;
                        continue block17;
                    }
                    case HOLDING_FAILED: {
                        ++holdingFailed;
                        continue block17;
                    }
                    case HOLDING_TIMEDOUT: {
                        ++holdingTimedout;
                        continue block17;
                    }
                    case IN_PROGRESS: {
                        ++inProgress;
                        continue block17;
                    }
                    case PENDING: {
                        ++pending;
                        continue block17;
                    }
                    case QUEUED: {
                        ++queued;
                        continue block17;
                    }
                    case TIMEDOUT: {
                        ++timedout;
                        continue block17;
                    }
                    case SKIPPED_FAILED: {
                        ++skippedFailed;
                        continue block17;
                    }
                }
                System.out.println("Unexpected status when creating stage summaries: " + taskStatus);
            }
            HostRoleCommandStatusSummaryDTO stageSummary = new HostRoleCommandStatusSummaryDTO(0, 0, 0, stageId, aborted, completed, failed, holding, holdingFailed, holdingTimedout, inProgress, pending, queued, timedout, skippedFailed);
            summaryMap.put(stageId, stageSummary);
        }
        return summaryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<HostRequest> removeHostRequestByHostName(String hostName) {
        HashSet<HostRequest> removed = new HashSet<HostRequest>();
        Map<String, HostRequest> map = this.requestsWithReservedHosts;
        synchronized (map) {
            Collection<HostRequest> collection = this.outstandingHostRequests;
            synchronized (collection) {
                this.requestsWithReservedHosts.remove(hostName);
                Iterator<HostRequest> hostRequestIterator = this.outstandingHostRequests.iterator();
                while (hostRequestIterator.hasNext()) {
                    HostRequest hostRequest = hostRequestIterator.next();
                    if (!Objects.equals(hostRequest.getHostName(), hostName)) continue;
                    hostRequestIterator.remove();
                    removed.add(hostRequest);
                    break;
                }
                Iterator<HostRequest> allHostRequestIterator = this.allHostRequests.iterator();
                while (allHostRequestIterator.hasNext()) {
                    HostRequest hostRequest = allHostRequestIterator.next();
                    if (!Objects.equals(hostRequest.getHostName(), hostName)) continue;
                    allHostRequestIterator.remove();
                    removed.add(hostRequest);
                    break;
                }
            }
        }
        return removed;
    }

    public boolean isFinished() {
        for (ShortTaskStatus ts : this.getRequestStatus().getTasks()) {
            if (HostRoleStatus.valueOf(ts.getStatus()).isCompletedState()) continue;
            return false;
        }
        return true;
    }

    public boolean isSuccessful() {
        for (ShortTaskStatus ts : this.getRequestStatus().getTasks()) {
            if (HostRoleStatus.valueOf(ts.getStatus()) == HostRoleStatus.COMPLETED) continue;
            return false;
        }
        return true;
    }

    public Optional<String> getFailureReason() {
        for (HostRequest request : this.getHostRequests()) {
            Optional<String> failureReason = request.getStatusMessage();
            if (!failureReason.isPresent()) continue;
            return failureReason;
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHostRequests(TopologyRequest request, ClusterTopology topology) {
        Map<String, HostGroupInfo> hostGroupInfoMap = request.getHostGroupInfo();
        Blueprint blueprint = topology.getBlueprint();
        boolean skipFailure = topology.getBlueprint().shouldSkipFailure();
        for (HostGroupInfo hostGroupInfo : hostGroupInfoMap.values()) {
            String groupName = hostGroupInfo.getHostGroupName();
            int hostCardinality = hostGroupInfo.getRequestedHostCount();
            ArrayList<String> hostnames = new ArrayList<String>(hostGroupInfo.getHostNames());
            for (int i = 0; i < hostCardinality; ++i) {
                if (!hostnames.isEmpty()) {
                    String hostname = (String)hostnames.get(i);
                    HostRequest hostRequest = new HostRequest(this.getRequestId(), hostIdCounter.getAndIncrement(), this.getClusterId(), hostname, blueprint.getName(), blueprint.getHostGroup(groupName), null, topology, skipFailure);
                    Map<String, HostRequest> map = this.requestsWithReservedHosts;
                    synchronized (map) {
                        this.requestsWithReservedHosts.put(hostname, hostRequest);
                        continue;
                    }
                }
                HostRequest hostRequest = new HostRequest(this.getRequestId(), hostIdCounter.getAndIncrement(), this.getClusterId(), null, blueprint.getName(), blueprint.getHostGroup(groupName), hostGroupInfo.getPredicate(), topology, skipFailure);
                this.outstandingHostRequests.add(hostRequest);
            }
        }
        this.allHostRequests.addAll(this.outstandingHostRequests);
        this.allHostRequests.addAll(this.requestsWithReservedHosts.values());
        LOG.info("LogicalRequest.createHostRequests: all host requests size {} , outstanding requests size = {}", (Object)this.allHostRequests.size(), (Object)this.outstandingHostRequests.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHostRequests(ClusterTopology topology, TopologyLogicalRequestEntity requestEntity) {
        Object hostName;
        Collection<TopologyHostGroupEntity> hostGroupEntities = requestEntity.getTopologyRequestEntity().getTopologyHostGroupEntities();
        Map<String, Set<String>> allReservedHostNamesByHostGroups = this.getReservedHostNamesByHostGroupName(hostGroupEntities);
        HashMap<String, Set<String>> pendingReservedHostNamesByHostGroups = new HashMap<String, Set<String>>(allReservedHostNamesByHostGroups);
        for (TopologyHostRequestEntity hostRequestEntity : requestEntity.getTopologyHostRequestEntities()) {
            Set pendingReservedHostNamesInHostGroup;
            TopologyHostGroupEntity hostGroupEntity = hostRequestEntity.getTopologyHostGroupEntity();
            String hostGroupName = hostGroupEntity.getName();
            hostName = hostRequestEntity.getHostName();
            if (hostName == null || !pendingReservedHostNamesByHostGroups.containsKey(hostGroupName) || (pendingReservedHostNamesInHostGroup = (Set)pendingReservedHostNamesByHostGroups.get(hostGroupName)) == null) continue;
            pendingReservedHostNamesInHostGroup.remove(hostName);
        }
        boolean skipFailure = topology.getBlueprint().shouldSkipFailure();
        for (TopologyHostRequestEntity hostRequestEntity : requestEntity.getTopologyHostRequestEntities()) {
            Long hostRequestId = hostRequestEntity.getId();
            hostName = hostIdCounter;
            synchronized (hostName) {
                if (hostIdCounter.get() <= hostRequestId) {
                    hostIdCounter.set(hostRequestId + 1L);
                }
            }
            TopologyHostGroupEntity hostGroupEntity = hostRequestEntity.getTopologyHostGroupEntity();
            Set pendingReservedHostsInGroup = (Set)pendingReservedHostNamesByHostGroups.get(hostGroupEntity.getName());
            String reservedHostName = (String)Iterables.getFirst((Iterable)pendingReservedHostsInGroup, null);
            HostRequest hostRequest = new HostRequest(this.getRequestId(), hostRequestId, reservedHostName, topology, hostRequestEntity, skipFailure);
            this.allHostRequests.add(hostRequest);
            if (hostRequest.isCompleted()) continue;
            if (reservedHostName != null) {
                this.requestsWithReservedHosts.put(reservedHostName, hostRequest);
                pendingReservedHostsInGroup.remove(reservedHostName);
                LOG.info("LogicalRequest.createHostRequests: created new request for a reserved request ID = {} for host name = {}", (Object)hostRequest.getId(), (Object)reservedHostName);
                continue;
            }
            this.outstandingHostRequests.add(hostRequest);
            LOG.info("LogicalRequest.createHostRequests: created new outstanding host request ID = {}", (Object)hostRequest.getId());
        }
    }

    private Map<String, Set<String>> getReservedHostNamesByHostGroupName(Collection<TopologyHostGroupEntity> hostGroups) {
        HashMap<String, Set<String>> reservedHostNamesByHostGroups = new HashMap<String, Set<String>>();
        for (TopologyHostGroupEntity hostGroupEntity : hostGroups) {
            String hostGroupName = hostGroupEntity.getName();
            if (!reservedHostNamesByHostGroups.containsKey(hostGroupName)) {
                reservedHostNamesByHostGroups.put(hostGroupName, new HashSet());
            }
            for (TopologyHostInfoEntity hostInfoEntity : hostGroupEntity.getTopologyHostInfoEntities()) {
                if (!StringUtils.isNotEmpty((String)hostInfoEntity.getFqdn())) continue;
                ((Set)reservedHostNamesByHostGroups.get(hostGroupName)).add(hostInfoEntity.getFqdn());
            }
        }
        return reservedHostNamesByHostGroups;
    }

    private static synchronized OBDPManagementController getController() {
        if (controller == null) {
            controller = OBDPServer.getController();
        }
        return controller;
    }

    public CalculatedStatus calculateStatus() {
        return !this.isFinished() ? CalculatedStatus.PENDING : (this.isSuccessful() ? CalculatedStatus.COMPLETED : CalculatedStatus.ABORTED);
    }

    static {
        hostIdCounter = new AtomicLong(1L);
        LOG = LoggerFactory.getLogger(LogicalRequest.class);
    }
}

