/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.api.predicate.PredicateCompiler;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostRequestEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostTaskEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalTaskEntity;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.topology.AmbariContext;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostOfferResponse;
import id.onyx.obdp.server.topology.PersistedState;
import id.onyx.obdp.server.topology.tasks.InstallHostTask;
import id.onyx.obdp.server.topology.tasks.PersistHostResourcesTask;
import id.onyx.obdp.server.topology.tasks.RegisterWithConfigGroupTask;
import id.onyx.obdp.server.topology.tasks.StartHostTask;
import id.onyx.obdp.server.topology.tasks.TopologyHostTask;
import id.onyx.obdp.server.topology.tasks.TopologyTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostRequest
implements Comparable<HostRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(HostRequest.class);
    private long requestId;
    private String blueprint;
    private HostGroup hostGroup;
    private String hostgroupName;
    private Predicate predicate;
    private String hostname = null;
    private long clusterId;
    private boolean containsMaster;
    private final long id;
    private boolean isOutstanding = true;
    private final boolean skipFailure;
    private HostRoleStatus status = HostRoleStatus.PENDING;
    private String statusMessage;
    private Map<TopologyTask, Map<String, Long>> logicalTaskMap = new HashMap<TopologyTask, Map<String, Long>>();
    Map<Long, HostRoleCommand> logicalTasks = new HashMap<Long, HostRoleCommand>();
    private Map<Long, Long> physicalTasks = new ConcurrentHashMap<Long, Long>();
    private List<TopologyHostTask> topologyTasks = new ArrayList<TopologyHostTask>();
    private ClusterTopology topology;
    private static PredicateCompiler predicateCompiler = new PredicateCompiler();

    public HostRequest(long requestId, long id, long clusterId, String hostname, String blueprintName, HostGroup hostGroup, Predicate predicate, ClusterTopology topology, boolean skipFailure) {
        this.requestId = requestId;
        this.id = id;
        this.clusterId = clusterId;
        this.blueprint = blueprintName;
        this.hostGroup = hostGroup;
        this.hostgroupName = hostGroup.getName();
        this.predicate = predicate;
        this.containsMaster = hostGroup.containsMasterComponent();
        this.topology = topology;
        this.skipFailure = skipFailure;
        this.createTasks(this.skipFailure);
        LOG.info("HostRequest: Created request for host: " + (hostname == null ? "Host Assignment Pending" : hostname));
    }

    public HostRequest(long requestId, long id, String predicate, ClusterTopology topology, TopologyHostRequestEntity entity, boolean skipFailure) {
        this.requestId = requestId;
        this.id = id;
        this.clusterId = topology.getClusterId();
        this.blueprint = topology.getBlueprint().getName();
        this.hostgroupName = entity.getTopologyHostGroupEntity().getName();
        this.hostGroup = topology.getBlueprint().getHostGroup(this.hostgroupName);
        this.hostname = entity.getHostName();
        this.setStatus(entity.getStatus());
        this.statusMessage = entity.getStatusMessage();
        this.predicate = this.toPredicate(predicate);
        this.containsMaster = this.hostGroup.containsMasterComponent();
        this.topology = topology;
        this.skipFailure = skipFailure;
        this.createTasksForReplay(entity);
        this.isOutstanding = this.hostname == null || !topology.getAmbariContext().isHostRegisteredWithCluster(this.clusterId, this.hostname);
        LOG.info("HostRequest: Successfully recovered host request for host: " + (this.hostname == null ? "Host Assignment Pending" : this.hostname));
    }

    void markHostRequestFailed(HostRoleStatus status, Throwable cause, PersistedState persistedState) {
        String errorMessage = StringUtils.substringBefore((String)Throwables.getRootCause((Throwable)cause).getMessage(), (String)"\n");
        LOG.info("HostRequest: marking host request {} for {} as {} due to {}", new Object[]{this.id, this.hostname, status, errorMessage});
        this.abortPendingTasks();
        this.setStatus(status);
        this.setStatusMessage(errorMessage);
        persistedState.setHostRequestStatus(this.id, status, errorMessage);
    }

    public synchronized HostOfferResponse offer(Host host) {
        if (!this.isOutstanding) {
            return HostOfferResponse.DECLINED_DUE_TO_DONE;
        }
        if (this.matchesHost(host)) {
            this.isOutstanding = false;
            this.hostname = host.getHostName();
            this.setHostOnTasks(host);
            return HostOfferResponse.createAcceptedResponse(this.id, this.hostGroup.getName(), this.topologyTasks);
        }
        return HostOfferResponse.DECLINED_DUE_TO_PREDICATE;
    }

    public HostRoleStatus getStatus() {
        return this.status;
    }

    public void setStatus(HostRoleStatus status) {
        if (status != null) {
            this.status = status;
        }
    }

    public void setStatusMessage(String errorMessage) {
        this.statusMessage = errorMessage;
    }

    public Optional<String> getStatusMessage() {
        return Optional.fromNullable((Object)this.statusMessage);
    }

    public void setHostName(String hostName) {
        this.hostname = hostName;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public String getBlueprint() {
        return this.blueprint;
    }

    public HostGroup getHostGroup() {
        return this.hostGroup;
    }

    public String getHostgroupName() {
        return this.hostgroupName;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean isCompleted() {
        return !this.isOutstanding;
    }

    public boolean shouldSkipFailure() {
        return this.skipFailure;
    }

    private void createTasks(boolean skipFailure) {
        this.topologyTasks.add(new PersistHostResourcesTask(this.topology, this));
        this.topologyTasks.add(new RegisterWithConfigGroupTask(this.topology, this));
        InstallHostTask installTask = new InstallHostTask(this.topology, this, skipFailure);
        this.topologyTasks.add(installTask);
        this.logicalTaskMap.put(installTask, new HashMap());
        boolean skipStartTaskCreate = this.topology.getProvisionAction().equals((Object)ProvisionAction.INSTALL_ONLY);
        boolean skipInstallTaskCreate = this.topology.getProvisionAction().equals((Object)ProvisionAction.START_ONLY);
        StartHostTask startTask = null;
        if (!skipStartTaskCreate) {
            startTask = new StartHostTask(this.topology, this, skipFailure);
            this.topologyTasks.add(startTask);
            this.logicalTaskMap.put(startTask, new HashMap());
        } else {
            LOG.info("Skipping Start task creation since provision action = " + this.topology.getProvisionAction());
        }
        HostGroup hostGroup = this.getHostGroup();
        Collection<String> startOnlyComponents = hostGroup.getComponentNames(ProvisionAction.START_ONLY);
        Collection<String> installOnlyComponents = hostGroup.getComponentNames(ProvisionAction.INSTALL_ONLY);
        Collection<String> installAndStartComponents = hostGroup.getComponentNames(ProvisionAction.INSTALL_AND_START);
        for (String component : hostGroup.getComponentNames()) {
            if (component == null || component.equals("OBDP_SERVER")) {
                LOG.info("Skipping component {} when creating request\n", (Object)component);
                continue;
            }
            Object hostName = this.getHostName() != null ? this.getHostName() : "PENDING HOST ASSIGNMENT : HOSTGROUP=" + this.getHostgroupName();
            AmbariContext context = this.topology.getAmbariContext();
            Stack stack = hostGroup.getStack();
            if (startOnlyComponents.contains(component) || skipInstallTaskCreate && !installOnlyComponents.contains(component) && !installAndStartComponents.contains(component) && stack != null && !stack.getComponentInfo(component).isClient()) {
                LOG.info("Skipping create of INSTALL task for {} on {}.", (Object)component, hostName);
            } else {
                HostRoleCommand logicalInstallTask = context.createAmbariTask(this.getRequestId(), this.id, component, (String)hostName, AmbariContext.TaskType.INSTALL, skipFailure);
                this.logicalTasks.put(logicalInstallTask.getTaskId(), logicalInstallTask);
                this.logicalTaskMap.get(installTask).put(component, logicalInstallTask.getTaskId());
            }
            if (installOnlyComponents.contains(component) || skipStartTaskCreate || stack != null && stack.getComponentInfo(component).isClient()) {
                LOG.info("Skipping create of START task for {} on {}.", (Object)component, hostName);
                continue;
            }
            HostRoleCommand logicalStartTask = context.createAmbariTask(this.getRequestId(), this.id, component, (String)hostName, AmbariContext.TaskType.START, skipFailure);
            this.logicalTasks.put(logicalStartTask.getTaskId(), logicalStartTask);
            this.logicalTaskMap.get(startTask).put(component, logicalStartTask.getTaskId());
        }
    }

    private void createTasksForReplay(TopologyHostRequestEntity entity) {
        this.topologyTasks.add(new PersistHostResourcesTask(this.topology, this));
        this.topologyTasks.add(new RegisterWithConfigGroupTask(this.topology, this));
        InstallHostTask installTask = new InstallHostTask(this.topology, this, this.skipFailure);
        this.topologyTasks.add(installTask);
        this.logicalTaskMap.put(installTask, new HashMap());
        boolean skipStartTaskCreate = this.topology.getProvisionAction().equals((Object)ProvisionAction.INSTALL_ONLY);
        if (!skipStartTaskCreate) {
            StartHostTask startTask = new StartHostTask(this.topology, this, this.skipFailure);
            this.topologyTasks.add(startTask);
            this.logicalTaskMap.put(startTask, new HashMap());
        }
        AmbariContext ambariContext = this.topology.getAmbariContext();
        for (TopologyHostTaskEntity topologyTaskEntity : entity.getTopologyHostTaskEntities()) {
            TopologyTask.Type taskType = TopologyTask.Type.valueOf(topologyTaskEntity.getType());
            for (TopologyLogicalTaskEntity logicalTaskEntity : topologyTaskEntity.getTopologyLogicalTaskEntities()) {
                Long logicalTaskId = logicalTaskEntity.getId();
                String component = logicalTaskEntity.getComponentName();
                AmbariContext.TaskType logicalTaskType = HostRequest.getLogicalTaskType(taskType);
                HostRoleCommand task = ambariContext.createAmbariTask(logicalTaskId, this.getRequestId(), this.id, component, entity.getHostName(), logicalTaskType, this.skipFailure);
                this.logicalTasks.put(logicalTaskId, task);
                Long physicalTaskId = logicalTaskEntity.getPhysicalTaskId();
                if (physicalTaskId != null) {
                    this.registerPhysicalTaskId(logicalTaskId, physicalTaskId);
                }
                for (TopologyTask topologyTask : this.topologyTasks) {
                    if (taskType != topologyTask.getType()) continue;
                    this.logicalTaskMap.get(topologyTask).put(component, logicalTaskId);
                }
            }
        }
    }

    private static AmbariContext.TaskType getLogicalTaskType(TopologyTask.Type topologyTaskType) {
        return topologyTaskType == TopologyTask.Type.INSTALL ? AmbariContext.TaskType.INSTALL : AmbariContext.TaskType.START;
    }

    private void setHostOnTasks(Host host) {
        for (HostRoleCommand task : this.getLogicalTasks()) {
            task.setHost(host.getHostId(), host.getHostName());
        }
    }

    public List<TopologyHostTask> getTopologyTasks() {
        return this.topologyTasks;
    }

    public Collection<HostRoleCommand> getLogicalTasks() {
        for (HostRoleCommand logicalTask : this.logicalTasks.values()) {
            HostRoleCommand physicalTask;
            Long physicalTaskId;
            String commandDetail = logicalTask.getCommandDetail();
            if (commandDetail != null && commandDetail.contains("null") && this.hostname != null) {
                logicalTask.setCommandDetail(commandDetail.replace("null", this.hostname));
            }
            if ((physicalTaskId = this.physicalTasks.get(logicalTask.getTaskId())) != null && (physicalTask = this.topology.getAmbariContext().getPhysicalTask(physicalTaskId)) != null) {
                logicalTask.setStatus(physicalTask.getStatus());
                logicalTask.setCommandDetail(physicalTask.getCommandDetail());
                logicalTask.setCustomCommandName(physicalTask.getCustomCommandName());
                logicalTask.setStartTime(physicalTask.getStartTime());
                logicalTask.setOriginalStartTime(physicalTask.getOriginalStartTime());
                logicalTask.setEndTime(physicalTask.getEndTime());
                logicalTask.setErrorLog(physicalTask.getErrorLog());
                logicalTask.setExitCode(physicalTask.getExitCode());
                logicalTask.setExecutionCommandWrapper(physicalTask.getExecutionCommandWrapper());
                logicalTask.setLastAttemptTime(physicalTask.getLastAttemptTime());
                logicalTask.setOutputLog(physicalTask.getOutputLog());
                logicalTask.setStderr(physicalTask.getStderr());
                logicalTask.setStdout(physicalTask.getStdout());
                logicalTask.setStructuredOut(physicalTask.getStructuredOut());
            }
            if (logicalTask.getStatus() != HostRoleStatus.PENDING || this.status == HostRoleStatus.PENDING) continue;
            logicalTask.setStatus(this.status);
        }
        return this.logicalTasks.values();
    }

    public Map<String, Long> getLogicalTasksForTopologyTask(TopologyTask topologyTask) {
        return new HashMap<String, Long>(this.logicalTaskMap.get(topologyTask));
    }

    public HostRoleCommand getLogicalTask(long logicalTaskId) {
        return this.logicalTasks.get(logicalTaskId);
    }

    public Collection<HostRoleCommandEntity> getTaskEntities() {
        ArrayList<HostRoleCommandEntity> taskEntities = new ArrayList<HostRoleCommandEntity>();
        for (HostRoleCommand task : this.logicalTasks.values()) {
            HostRoleCommand physicalTask;
            HostRoleCommandEntity entity = task.constructNewPersistenceEntity();
            entity.setOutputLog(task.getOutputLog());
            entity.setErrorLog(task.errorLog);
            Long physicalTaskId = this.physicalTasks.get(task.getTaskId());
            if (physicalTaskId != null && (physicalTask = this.topology.getAmbariContext().getPhysicalTask(physicalTaskId)) != null) {
                entity.setStatus(physicalTask.getStatus());
                entity.setCommandDetail(physicalTask.getCommandDetail());
                entity.setCustomCommandName(physicalTask.getCustomCommandName());
                entity.setStartTime(physicalTask.getStartTime());
                entity.setOriginalStartTime(physicalTask.getOriginalStartTime());
                entity.setEndTime(physicalTask.getEndTime());
                entity.setErrorLog(physicalTask.getErrorLog());
                entity.setExitcode(physicalTask.getExitCode());
                entity.setLastAttemptTime(physicalTask.getLastAttemptTime());
                entity.setOutputLog(physicalTask.getOutputLog());
                entity.setStdError(physicalTask.getStderr().getBytes());
                entity.setStdOut(physicalTask.getStdout().getBytes());
                entity.setStructuredOut(physicalTask.getStructuredOut().getBytes());
            }
            taskEntities.add(entity);
        }
        return taskEntities;
    }

    public boolean containsMaster() {
        return this.containsMaster;
    }

    public boolean matchesHost(Host host) {
        return this.hostname != null ? host.getHostName().equals(this.hostname) : this.predicate == null || this.predicate.evaluate(new HostResourceAdapter(host));
    }

    public String getHostName() {
        return this.hostname;
    }

    public long getId() {
        return this.id;
    }

    public long getStageId() {
        return this.getId();
    }

    public Long getPhysicalTaskId(long logicalTaskId) {
        return this.physicalTasks.get(logicalTaskId);
    }

    public Map<Long, Long> getPhysicalTaskMapping() {
        return new ConcurrentHashMap<Long, Long>(this.physicalTasks);
    }

    @Override
    public int compareTo(HostRequest other) {
        if (this.containsMaster()) {
            return other.containsMaster() ? this.hashCode() - other.hashCode() : -1;
        }
        if (other.containsMaster()) {
            return 1;
        }
        return this.hashCode() - other.hashCode();
    }

    public void registerPhysicalTaskId(long logicalTaskId, long physicalTaskId) {
        this.physicalTasks.put(logicalTaskId, physicalTaskId);
        this.topology.getAmbariContext().getPersistedTopologyState().registerPhysicalTask(logicalTaskId, physicalTaskId);
        this.getLogicalTask(logicalTaskId).incrementAttemptCount();
    }

    public void abortPendingTasks() {
        for (HostRoleCommand command : this.getLogicalTasks()) {
            if (command.getStatus() != HostRoleStatus.PENDING) continue;
            command.setStatus(HostRoleStatus.ABORTED);
        }
    }

    private Predicate toPredicate(String predicate) {
        Predicate compiledPredicate = null;
        try {
            if (predicate != null && !predicate.isEmpty()) {
                compiledPredicate = predicateCompiler.compile(predicate);
            }
        }
        catch (InvalidQueryException e) {
            LOG.error("Unable to compile predicate for host request: " + e, (Throwable)e);
        }
        return compiledPredicate;
    }

    private class HostResourceAdapter
    implements Resource {
        Resource hostResource;

        public HostResourceAdapter(Host host) {
            this.buildPropertyMap(host);
        }

        @Override
        public Object getPropertyValue(String id) {
            return this.hostResource.getPropertyValue(id);
        }

        @Override
        public Map<String, Map<String, Object>> getPropertiesMap() {
            return this.hostResource.getPropertiesMap();
        }

        @Override
        public Resource.Type getType() {
            return Resource.Type.Host;
        }

        @Override
        public void addCategory(String id) {
        }

        @Override
        public void setProperty(String id, Object value) {
        }

        private void buildPropertyMap(Host host) {
            this.hostResource = new ResourceImpl(Resource.Type.Host);
            this.hostResource.setProperty("Hosts/host_name", host.getHostName());
            this.hostResource.setProperty("Hosts/public_host_name", host.getPublicHostName());
            this.hostResource.setProperty("Hosts/ip", host.getIPv4());
            this.hostResource.setProperty("Hosts/total_mem", host.getTotalMemBytes());
            this.hostResource.setProperty("Hosts/cpu_count", host.getCpuCount());
            this.hostResource.setProperty("Hosts/ph_cpu_count", host.getPhCpuCount());
            this.hostResource.setProperty("Hosts/os_arch", host.getOsArch());
            this.hostResource.setProperty("Hosts/os_type", host.getOsType());
            this.hostResource.setProperty("Hosts/os_family", host.getOsFamily());
            this.hostResource.setProperty("Hosts/rack_info", host.getRackInfo());
            this.hostResource.setProperty("Hosts/last_heartbeat_time", host.getLastHeartbeatTime());
            this.hostResource.setProperty("Hosts/last_agent_env", host.getLastAgentEnv());
            this.hostResource.setProperty("Hosts/last_registration_time", host.getLastRegistrationTime());
            this.hostResource.setProperty("Hosts/host_status", host.getStatus());
            this.hostResource.setProperty("Hosts/host_health_report", host.getHealthStatus().getHealthReport());
            this.hostResource.setProperty("Hosts/disk_info", host.getDisksInfo());
            this.hostResource.setProperty("Hosts/host_state", (Object)host.getState());
        }
    }
}

