/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.topology.AmbariContext;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.HostRequest;
import id.onyx.obdp.server.topology.tasks.TopologyHostTask;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HostOfferResponse {
    private static final Logger LOG = LoggerFactory.getLogger(HostOfferResponse.class);
    static final HostOfferResponse DECLINED_DUE_TO_PREDICATE = new HostOfferResponse(Answer.DECLINED_PREDICATE);
    static final HostOfferResponse DECLINED_DUE_TO_DONE = new HostOfferResponse(Answer.DECLINED_DONE);
    private final Answer answer;
    private final String hostGroupName;
    private final long hostRequestId;
    private final List<TopologyHostTask> tasks;

    static HostOfferResponse createAcceptedResponse(long hostRequestId, String hostGroupName, List<TopologyHostTask> tasks) {
        return new HostOfferResponse(Answer.ACCEPTED, hostRequestId, hostGroupName, tasks);
    }

    private HostOfferResponse(Answer answer) {
        this(answer, -1L, null, null);
    }

    private HostOfferResponse(Answer answer, long hostRequestId, String hostGroupName, List<TopologyHostTask> tasks) {
        this.answer = answer;
        this.hostRequestId = hostRequestId;
        this.hostGroupName = hostGroupName;
        this.tasks = tasks;
    }

    public Answer getAnswer() {
        return this.answer;
    }

    public long getHostRequestId() {
        return this.hostRequestId;
    }

    public String getHostGroupName() {
        return this.hostGroupName;
    }

    void executeTasks(Executor executor, final String hostName, ClusterTopology topology, final AmbariContext ambariContext) {
        if (this.answer != Answer.ACCEPTED) {
            LOG.warn("Attempted to execute tasks for declined host offer", (Object)this.answer);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (TopologyHostTask task : HostOfferResponse.this.tasks) {
                        try {
                            LOG.info("Running task for accepted host offer for hostname = {}, task = {}", (Object)hostName, (Object)task.getType());
                            task.run();
                        }
                        catch (Exception e) {
                            HostRequest hostRequest = task.getHostRequest();
                            LOG.error("{} task for host {} failed due to", new Object[]{task.getType(), hostRequest.getHostName(), e});
                            hostRequest.markHostRequestFailed(HostRoleStatus.ABORTED, e, ambariContext.getPersistedTopologyState());
                            break;
                        }
                    }
                }
            });
        }
    }

    public static enum Answer {
        ACCEPTED,
        DECLINED_PREDICATE,
        DECLINED_DONE;

    }
}

