/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.api.predicate.PredicateCompiler;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.topology.Configuration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostGroupInfo {
    private static final Logger LOG = LoggerFactory.getLogger(HostGroupInfo.class);
    private static PredicateCompiler predicateCompiler = new PredicateCompiler();
    private String hostGroupName;
    private final Collection<String> hostNames = new HashSet<String>();
    private final Map<String, String> hostRackInfo = new HashMap<String, String>();
    private int requested_count = 0;
    Configuration configuration;
    String predicateString;
    Predicate predicate;

    public HostGroupInfo(String hostGroupName) {
        this.hostGroupName = hostGroupName;
    }

    public String getHostGroupName() {
        return this.hostGroupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getHostNames() {
        Collection<String> collection = this.hostNames;
        synchronized (collection) {
            return new HashSet<String>(this.hostNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestedHostCount() {
        Collection<String> collection = this.hostNames;
        synchronized (collection) {
            return this.requested_count == 0 ? this.hostNames.size() : this.requested_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHost(String hostName) {
        Collection<String> collection = this.hostNames;
        synchronized (collection) {
            String lowerHostName = hostName.toLowerCase();
            if (!hostName.equals(lowerHostName)) {
                LOG.warn("Host name {} contains upper case letters, will be converted to lowercase!", (Object)hostName);
            }
            this.hostNames.add(lowerHostName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHosts(Collection<String> hosts) {
        Collection<String> collection = this.hostNames;
        synchronized (collection) {
            for (String host : hosts) {
                this.addHost(host);
            }
        }
    }

    public void setRequestedCount(int num) {
        this.requested_count = num;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setPredicate(String predicateString) throws InvalidQueryException {
        this.predicate = predicateCompiler.compile(predicateString);
        this.predicateString = predicateString;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public String getPredicateString() {
        return this.predicateString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostRackInfo(String host, String rackInfo) {
        Map<String, String> map = this.hostRackInfo;
        synchronized (map) {
            this.hostRackInfo.put(host, rackInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getHostRackInfo() {
        Map<String, String> map = this.hostRackInfo;
        synchronized (map) {
            return new HashMap<String, String>(this.hostRackInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHost(String hostname) {
        Collection<String> collection = this.hostNames;
        synchronized (collection) {
            this.hostNames.remove(hostname);
        }
    }
}

