/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.gson.Gson;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.orm.entities.HostGroupComponentEntity;
import id.onyx.obdp.server.orm.entities.HostGroupConfigEntity;
import id.onyx.obdp.server.orm.entities.HostGroupEntity;
import id.onyx.obdp.server.topology.Component;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.HostGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HostGroupImpl
implements HostGroup {
    private String name;
    private String blueprintName;
    private Map<String, Component> components = new HashMap<String, Component>();
    private Map<String, Set<String>> componentsForService = new HashMap<String, Set<String>>();
    private Configuration configuration = null;
    private boolean containsMasterComponent = false;
    private Stack stack;
    private String cardinality = "NOT SPECIFIED";

    public HostGroupImpl(HostGroupEntity entity, String blueprintName, Stack stack) {
        this.name = entity.getName();
        this.cardinality = entity.getCardinality();
        this.blueprintName = blueprintName;
        this.stack = stack;
        this.parseComponents(entity);
        this.parseConfigurations(entity);
    }

    public HostGroupImpl(String name, String bpName, Stack stack, Collection<Component> components, Configuration configuration, String cardinality) {
        this.name = name;
        this.blueprintName = bpName;
        this.stack = stack;
        for (Component component : components) {
            this.addComponent(component.getName(), component.getProvisionAction());
        }
        this.configuration = configuration;
        if (cardinality != null && !cardinality.equals("null")) {
            this.cardinality = cardinality;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName() {
        return String.format("%s:%s", this.blueprintName, this.getName());
    }

    public static String formatAbsoluteName(String bpName, String hgName) {
        return String.format("%s:%s", bpName, hgName);
    }

    @Override
    public Collection<Component> getComponents() {
        return this.components.values();
    }

    @Override
    public Collection<String> getComponentNames() {
        return this.components.keySet();
    }

    @Override
    public Collection<String> getComponentNames(ProvisionAction provisionAction) {
        HashSet<String> setOfComponentNames = new HashSet<String>();
        for (String componentName : this.components.keySet()) {
            Component component = this.components.get(componentName);
            if (component.getProvisionAction() == null || component.getProvisionAction() != provisionAction) continue;
            setOfComponentNames.add(componentName);
        }
        return setOfComponentNames;
    }

    @Override
    public Collection<String> getServices() {
        return this.componentsForService.keySet();
    }

    @Override
    public boolean addComponent(String component) {
        return this.addComponent(component, null);
    }

    @Override
    public boolean addComponent(String component, ProvisionAction provisionAction) {
        String service;
        boolean added;
        if (!this.components.containsKey(component)) {
            this.components.put(component, new Component(component, provisionAction));
            added = true;
        } else {
            added = false;
        }
        if (this.stack.isMasterComponent(component)) {
            this.containsMasterComponent = true;
        }
        if (added && (service = this.stack.getServiceForComponent(component)) != null) {
            Set<String> serviceComponents = this.componentsForService.get(service);
            if (serviceComponents == null) {
                serviceComponents = new HashSet<String>();
                this.componentsForService.put(service, serviceComponents);
            }
            serviceComponents.add(component);
        }
        return added;
    }

    @Override
    public Collection<String> getComponents(String service) {
        return this.componentsForService.containsKey(service) ? new HashSet(this.componentsForService.get(service)) : Collections.emptySet();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getBlueprintName() {
        return this.blueprintName;
    }

    @Override
    public boolean containsMasterComponent() {
        return this.containsMasterComponent;
    }

    @Override
    public Stack getStack() {
        return this.stack;
    }

    @Override
    public String getCardinality() {
        return this.cardinality;
    }

    private void parseComponents(HostGroupEntity entity) {
        for (HostGroupComponentEntity componentEntity : entity.getComponents()) {
            if (componentEntity.getProvisionAction() != null) {
                this.addComponent(componentEntity.getName(), ProvisionAction.valueOf(componentEntity.getProvisionAction()));
                continue;
            }
            this.addComponent(componentEntity.getName());
        }
    }

    private void parseConfigurations(HostGroupEntity entity) {
        HashMap<String, Map<String, String>> config = new HashMap<String, Map<String, String>>();
        Gson jsonSerializer = new Gson();
        for (HostGroupConfigEntity configEntity : entity.getConfigurations()) {
            Map propertyMap;
            String type = configEntity.getType();
            HashMap typeProperties = (HashMap)config.get(type);
            if (typeProperties == null) {
                typeProperties = new HashMap();
                config.put(type, typeProperties);
            }
            if ((propertyMap = (Map)jsonSerializer.fromJson(configEntity.getConfigData(), Map.class)) == null) continue;
            typeProperties.putAll(propertyMap);
        }
        HashMap<String, Map<String, Map<String, String>>> attributes = new HashMap<String, Map<String, Map<String, String>>>();
        this.configuration = new Configuration(config, attributes);
    }

    public String toString() {
        return this.name;
    }
}

